/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
import * as coreClient from "@azure/core-client";
import * as Mappers from "../models/mappers.js";
import * as Parameters from "../models/parameters.js";
/** Class containing Service operations. */
export class ServiceImpl {
    client;
    /**
     * Initialize a new instance of the class Service class.
     * @param client Reference to the service client
     */
    constructor(client) {
        this.client = client;
    }
    /**
     * Sets properties for a storage account's File service endpoint, including properties for Storage
     * Analytics metrics and CORS (Cross-Origin Resource Sharing) rules.
     * @param properties The StorageService properties.
     * @param options The options parameters.
     */
    setProperties(properties, options) {
        return this.client.sendOperationRequest({ properties, options }, setPropertiesOperationSpec);
    }
    /**
     * Gets the properties of a storage account's File service, including properties for Storage Analytics
     * metrics and CORS (Cross-Origin Resource Sharing) rules.
     * @param options The options parameters.
     */
    getProperties(options) {
        return this.client.sendOperationRequest({ options }, getPropertiesOperationSpec);
    }
    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the
     * specified account.
     * @param options The options parameters.
     */
    listSharesSegment(options) {
        return this.client.sendOperationRequest({ options }, listSharesSegmentOperationSpec);
    }
    /**
     * Retrieves a user delegation key for the File service. This is only a valid operation when using
     * bearer token authentication.
     * @param keyInfo Key information
     * @param options The options parameters.
     */
    getUserDelegationKey(keyInfo, options) {
        return this.client.sendOperationRequest({ keyInfo, options }, getUserDelegationKeyOperationSpec);
    }
}
// Operation Specifications
const xmlSerializer = coreClient.createSerializer(Mappers, /* isXml */ true);
const setPropertiesOperationSpec = {
    path: "/",
    httpMethod: "PUT",
    responses: {
        202: {
            headersMapper: Mappers.ServiceSetPropertiesHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.ServiceSetPropertiesExceptionHeaders,
        },
    },
    requestBody: Parameters.properties,
    queryParameters: [
        Parameters.restype,
        Parameters.comp,
        Parameters.timeoutInSeconds,
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.contentType,
        Parameters.accept,
        Parameters.version,
        Parameters.fileRequestIntent,
    ],
    isXML: true,
    contentType: "application/xml; charset=utf-8",
    mediaType: "xml",
    serializer: xmlSerializer,
};
const getPropertiesOperationSpec = {
    path: "/",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.FileServiceProperties,
            headersMapper: Mappers.ServiceGetPropertiesHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.ServiceGetPropertiesExceptionHeaders,
        },
    },
    queryParameters: [
        Parameters.restype,
        Parameters.comp,
        Parameters.timeoutInSeconds,
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.fileRequestIntent,
        Parameters.accept1,
    ],
    isXML: true,
    serializer: xmlSerializer,
};
const listSharesSegmentOperationSpec = {
    path: "/",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: Mappers.ListSharesResponse,
            headersMapper: Mappers.ServiceListSharesSegmentHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.ServiceListSharesSegmentExceptionHeaders,
        },
    },
    queryParameters: [
        Parameters.timeoutInSeconds,
        Parameters.comp1,
        Parameters.prefix,
        Parameters.marker,
        Parameters.maxResults,
        Parameters.include,
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.fileRequestIntent,
        Parameters.accept1,
    ],
    isXML: true,
    serializer: xmlSerializer,
};
const getUserDelegationKeyOperationSpec = {
    path: "/",
    httpMethod: "POST",
    responses: {
        200: {
            bodyMapper: Mappers.UserDelegationKey,
            headersMapper: Mappers.ServiceGetUserDelegationKeyHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.ServiceGetUserDelegationKeyExceptionHeaders,
        },
    },
    requestBody: Parameters.keyInfo,
    queryParameters: [
        Parameters.restype,
        Parameters.timeoutInSeconds,
        Parameters.comp2,
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.contentType,
        Parameters.accept,
        Parameters.version,
        Parameters.requestId,
    ],
    isXML: true,
    contentType: "application/xml; charset=utf-8",
    mediaType: "xml",
    serializer: xmlSerializer,
};
//# sourceMappingURL=service.js.map