import { FileServiceProperties, ServiceSetPropertiesOptionalParams, ServiceSetPropertiesResponse, ServiceGetPropertiesOptionalParams, ServiceGetPropertiesResponse, ServiceListSharesSegmentOptionalParams, ServiceListSharesSegmentResponse, KeyInfo, ServiceGetUserDelegationKeyOptionalParams, ServiceGetUserDelegationKeyResponse } from "../models/index.js";
/** Interface representing a Service. */
export interface Service {
    /**
     * Sets properties for a storage account's File service endpoint, including properties for Storage
     * Analytics metrics and CORS (Cross-Origin Resource Sharing) rules.
     * @param properties The StorageService properties.
     * @param options The options parameters.
     */
    setProperties(properties: FileServiceProperties, options?: ServiceSetPropertiesOptionalParams): Promise<ServiceSetPropertiesResponse>;
    /**
     * Gets the properties of a storage account's File service, including properties for Storage Analytics
     * metrics and CORS (Cross-Origin Resource Sharing) rules.
     * @param options The options parameters.
     */
    getProperties(options?: ServiceGetPropertiesOptionalParams): Promise<ServiceGetPropertiesResponse>;
    /**
     * The List Shares Segment operation returns a list of the shares and share snapshots under the
     * specified account.
     * @param options The options parameters.
     */
    listSharesSegment(options?: ServiceListSharesSegmentOptionalParams): Promise<ServiceListSharesSegmentResponse>;
    /**
     * Retrieves a user delegation key for the File service. This is only a valid operation when using
     * bearer token authentication.
     * @param keyInfo Key information
     * @param options The options parameters.
     */
    getUserDelegationKey(keyInfo: KeyInfo, options?: ServiceGetUserDelegationKeyOptionalParams): Promise<ServiceGetUserDelegationKeyResponse>;
}
//# sourceMappingURL=service.d.ts.map