"use strict";
/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagesImpl = void 0;
const tslib_1 = require("tslib");
const coreClient = tslib_1.__importStar(require("@azure/core-client"));
const Mappers = tslib_1.__importStar(require("../models/mappers.js"));
const Parameters = tslib_1.__importStar(require("../models/parameters.js"));
/** Class containing Messages operations. */
class MessagesImpl {
    client;
    /**
     * Initialize a new instance of the class Messages class.
     * @param client Reference to the service client
     */
    constructor(client) {
        this.client = client;
    }
    /**
     * The Dequeue operation retrieves one or more messages from the front of the queue.
     * @param options The options parameters.
     */
    dequeue(options) {
        return this.client.sendOperationRequest({ options }, dequeueOperationSpec);
    }
    /**
     * The Clear operation deletes all messages from the specified queue.
     * @param options The options parameters.
     */
    clear(options) {
        return this.client.sendOperationRequest({ options }, clearOperationSpec);
    }
    /**
     * The Enqueue operation adds a new message to the back of the message queue. A visibility timeout can
     * also be specified to make the message invisible until the visibility timeout expires. A message must
     * be in a format that can be included in an XML request with UTF-8 encoding. The encoded message can
     * be up to 64 KB in size for versions 2011-08-18 and newer, or 8 KB in size for previous versions.
     * @param queueMessage A Message object which can be stored in a Queue
     * @param options The options parameters.
     */
    enqueue(queueMessage, options) {
        return this.client.sendOperationRequest({ queueMessage, options }, enqueueOperationSpec);
    }
    /**
     * The Peek operation retrieves one or more messages from the front of the queue, but does not alter
     * the visibility of the message.
     * @param options The options parameters.
     */
    peek(options) {
        return this.client.sendOperationRequest({ options }, peekOperationSpec);
    }
}
exports.MessagesImpl = MessagesImpl;
// Operation Specifications
const xmlSerializer = coreClient.createSerializer(Mappers, /* isXml */ true);
const dequeueOperationSpec = {
    path: "/{queueName}/messages",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: {
                type: {
                    name: "Sequence",
                    element: {
                        type: { name: "Composite", className: "DequeuedMessageItem" },
                    },
                },
                serializedName: "DequeuedMessagesList",
                xmlName: "QueueMessagesList",
                xmlIsWrapped: true,
                xmlElementName: "QueueMessage",
            },
            headersMapper: Mappers.MessagesDequeueHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.MessagesDequeueExceptionHeaders,
        },
    },
    queryParameters: [
        Parameters.timeoutInSeconds,
        Parameters.numberOfMessages,
        Parameters.visibilityTimeout,
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.accept1,
    ],
    isXML: true,
    serializer: xmlSerializer,
};
const clearOperationSpec = {
    path: "/{queueName}/messages",
    httpMethod: "DELETE",
    responses: {
        204: {
            headersMapper: Mappers.MessagesClearHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.MessagesClearExceptionHeaders,
        },
    },
    queryParameters: [Parameters.timeoutInSeconds],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.accept1,
    ],
    isXML: true,
    serializer: xmlSerializer,
};
const enqueueOperationSpec = {
    path: "/{queueName}/messages",
    httpMethod: "POST",
    responses: {
        201: {
            bodyMapper: {
                type: {
                    name: "Sequence",
                    element: {
                        type: { name: "Composite", className: "EnqueuedMessage" },
                    },
                },
                serializedName: "EnqueuedMessageList",
                xmlName: "QueueMessagesList",
                xmlIsWrapped: true,
                xmlElementName: "QueueMessage",
            },
            headersMapper: Mappers.MessagesEnqueueHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.MessagesEnqueueExceptionHeaders,
        },
    },
    requestBody: Parameters.queueMessage,
    queryParameters: [
        Parameters.timeoutInSeconds,
        Parameters.visibilityTimeout,
        Parameters.messageTimeToLive,
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.contentType,
        Parameters.accept,
        Parameters.version,
        Parameters.requestId,
    ],
    isXML: true,
    contentType: "application/xml; charset=utf-8",
    mediaType: "xml",
    serializer: xmlSerializer,
};
const peekOperationSpec = {
    path: "/{queueName}/messages",
    httpMethod: "GET",
    responses: {
        200: {
            bodyMapper: {
                type: {
                    name: "Sequence",
                    element: {
                        type: { name: "Composite", className: "PeekedMessageItem" },
                    },
                },
                serializedName: "PeekedMessagesList",
                xmlName: "QueueMessagesList",
                xmlIsWrapped: true,
                xmlElementName: "QueueMessage",
            },
            headersMapper: Mappers.MessagesPeekHeaders,
        },
        default: {
            bodyMapper: Mappers.StorageError,
            headersMapper: Mappers.MessagesPeekExceptionHeaders,
        },
    },
    queryParameters: [
        Parameters.timeoutInSeconds,
        Parameters.numberOfMessages,
        Parameters.peekonly,
    ],
    urlParameters: [Parameters.url],
    headerParameters: [
        Parameters.version,
        Parameters.requestId,
        Parameters.accept1,
    ],
    isXML: true,
    serializer: xmlSerializer,
};
//# sourceMappingURL=messages.js.map