module.exports = {
    "env": {
        "commonjs": true,
        "es6": true,
        "node": true
    },
    "extends": "eslint:recommended",
    "globals": {
        "Atomics": "readonly",
        "SharedArrayBuffer": "readonly"
    },
    "parserOptions": {
        "ecmaVersion": 2018
    },
    "rules": {
        "indent": [
            "error",
            2,
          {
            "SwitchCase": 1
          }
        ],
        "linebreak-style": [
            "error",
            "unix"
        ],
        "quotes": [
            "error",
            "double"
        ],
        "semi": [
            "error",
            "never"
        ],
        "brace-style": "error",
        "space-before-blocks": "error",
        "no-case-declarations": "off",
        "no-trailing-spaces": "error",
        "key-spacing": ["error", {
          "beforeColon": false,
          "afterColon": true
        }],
        "prefer-template": "error",
        "semi-spacing": ["error", {"before": false, "after": true}],
        "no-fallthrough": ["error", { "commentPattern": "caution: falls through" }]
    }
}
