/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

'use strict';

/**
 * @class
 * Initializes a new instance of the TenantListResult class.
 * @constructor
 * Tenant Ids information.
 *
 * @member {string} nextLink The URL to use for getting the next set of
 * results.
 *
 */
class TenantListResult extends Array {
  constructor() {
    super();
  }

  /**
   * Defines the metadata of TenantListResult
   *
   * @returns {object} metadata of TenantListResult
   *
   */
  mapper() {
    return {
      required: false,
      serializedName: 'TenantListResult',
      type: {
        name: 'Composite',
        className: 'TenantListResult',
        modelProperties: {
          value: {
            required: false,
            serializedName: '',
            type: {
              name: 'Sequence',
              element: {
                  required: false,
                  serializedName: 'TenantIdDescriptionElementType',
                  type: {
                    name: 'Composite',
                    className: 'TenantIdDescription'
                  }
              }
            }
          },
          nextLink: {
            required: true,
            serializedName: 'nextLink',
            type: {
              name: 'String'
            }
          }
        }
      }
    };
  }
}

module.exports = TenantListResult;
