module.exports = {
  "env": {
    "commonjs": true,
    "es6": true,
    "node": true
  },
  "extends": "eslint:recommended",
  "globals": {
    "Atomics": "readonly",
    "SharedArrayBuffer": "readonly"
  },
  "parserOptions": {
    "ecmaVersion": 2018
  },
  "rules": {
    "brace-style": "error",
    
    "comma-spacing": ["error", {"before": false, "after": true}],
   
    "indent": [
      "error",
      2,
      {
        "SwitchCase": 1
      }
    ],

    "linebreak-style": [
      "error",
      "unix"
    ],

    "key-spacing": ["error", {
      "beforeColon": false,
      "afterColon": true
    }],

    "no-case-declarations": "off",

    "no-trailing-spaces": "error",

    "prefer-template": "error",

    "semi": [
      "error",
      "never"
    ],

    "semi-spacing": ["error", {"before": false, "after": true}],

    "space-before-blocks": "error",

    "spaced-comment": ["error", "always", { "exceptions": ["-", "+"] }],

    "quotes": [
      "error",
      "double"
    ]
  }
}
