import os
import sys

from flask import Flask
from werkzeug.middleware.dispatcher import DispatcherMiddleware

_runPath = os.path.dirname(os.path.realpath(__file__))
sys.path.append(os.path.join(_runPath, ".."))

from lib.Config import Configuration
from web.run import create_app
from web.set_version import _version

__version__ = _version()

config = Configuration()

app = Flask(__name__)
cveapp = create_app(__version__, _runPath)

app.wsgi_app = DispatcherMiddleware(Flask("FRAME"), {config.getMountPath(): cveapp})


if __name__ == "__main__":
    app.run(host="0.0.0.0")
