/* Copyright (C)
* 2024,2025 - Heiko Amft, DL1BZ (Project deskHPSDR)
*
*   This program is free software: you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation, either version 3 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program.  If not, see <https://www.gnu.org/licenses/>.
*
*/
//--------------------------------------------------------------------------------------------
// using the xxd tool (c) 1990-1997 by Juergen Weigert <jnweiger@informatik.uni-erlangen.de>
//
// generate this xxx.h file: xxd -i xxx.png > xxx.h
//--------------------------------------------------------------------------------------------
static unsigned char hpsdr_logo[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x96, 0x00, 0x00, 0x00, 0x96,
  0x08, 0x04, 0x00, 0x00, 0x00, 0x96, 0x08, 0xb9, 0x69, 0x00, 0x00, 0x00,
  0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0d, 0xd7, 0x00, 0x00, 0x0d,
  0xd7, 0x01, 0x42, 0x28, 0x9b, 0x78, 0x00, 0x00, 0x00, 0x44, 0x74, 0x45,
  0x58, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x00, 0x74, 0x49,
  0x4d, 0x45, 0x20, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x6c, 0x65, 0x6e, 0x20,
  0x37, 0x20, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x64, 0x3a, 0x0d, 0x41,
  0x53, 0x43, 0x49, 0x49, 0x3a, 0x20, 0x2e, 0xc3, 0x9b, 0x2e, 0x2e, 0x2e,
  0x2e, 0x28, 0x0d, 0x48, 0x45, 0x58, 0x3a, 0x20, 0x30, 0x37, 0x44, 0x42,
  0x30, 0x35, 0x31, 0x43, 0x30, 0x45, 0x31, 0x36, 0x32, 0x38, 0x32, 0xbd,
  0x98, 0x16, 0x00, 0x00, 0x0e, 0xfe, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c,
  0xec, 0x9d, 0x09, 0x98, 0x14, 0xc5, 0x15, 0xc7, 0xd7, 0x18, 0xf3, 0x61,
  0x62, 0x8c, 0xc6, 0x2b, 0x1a, 0x0f, 0x14, 0xd0, 0xa8, 0x08, 0x08, 0xca,
  0x61, 0xc0, 0x03, 0x23, 0x20, 0x09, 0x0a, 0x92, 0x8f, 0xc4, 0x08, 0x8a,
  0x11, 0x2f, 0x7c, 0x26, 0x06, 0x35, 0x62, 0x54, 0x34, 0x06, 0x8d, 0x07,
  0x2a, 0x11, 0x14, 0x25, 0xb0, 0x8a, 0x20, 0x22, 0xa8, 0x78, 0x00, 0xa2,
  0xa2, 0x88, 0x44, 0x44, 0x40, 0x0e, 0x45, 0xf1, 0x04, 0x16, 0x91, 0x65,
  0x61, 0x61, 0xd9, 0x03, 0x16, 0x81, 0xdd, 0x49, 0x77, 0xbd, 0xaa, 0x9e,
  0xaa, 0xea, 0xaa, 0xa9, 0xaa, 0xa6, 0x67, 0x7a, 0x96, 0x5d, 0x7e, 0xdf,
  0xce, 0x56, 0xd5, 0xfb, 0xd7, 0xeb, 0xd7, 0xff, 0xe9, 0xd9, 0xe9, 0x19,
  0x7a, 0x6a, 0x0a, 0xa0, 0xa0, 0x01, 0x5b, 0x12, 0x2f, 0xa0, 0x2e, 0xa1,
  0x0f, 0x75, 0x86, 0xbe, 0x70, 0x05, 0xc7, 0x8d, 0x02, 0x43, 0x05, 0x46,
  0x0a, 0x3c, 0x2b, 0x30, 0x9d, 0xe3, 0x2d, 0x98, 0x27, 0xf0, 0x19, 0x47,
  0x11, 0x14, 0x73, 0x54, 0x27, 0xcc, 0x77, 0xd0, 0xc8, 0xce, 0xac, 0x8a,
  0xc4, 0x4b, 0xcd, 0x17, 0x7a, 0x9a, 0xcc, 0x4a, 0xba, 0xc0, 0xfc, 0xe2,
  0x00, 0xbd, 0x59, 0xc7, 0x27, 0x5e, 0x5c, 0xfe, 0xa1, 0x35, 0x2b, 0x2d,
  0xa9, 0x82, 0x2d, 0x75, 0x92, 0xb2, 0xd8, 0x50, 0xd8, 0xc5, 0x5b, 0x35,
  0x22, 0x08, 0x97, 0xc7, 0xb4, 0xc1, 0xcd, 0x75, 0x1a, 0xe6, 0xc6, 0x1b,
  0x2a, 0xb3, 0x58, 0x70, 0x53, 0x04, 0x4a, 0xf7, 0x48, 0xa4, 0x63, 0x2b,
  0x6c, 0x56, 0x05, 0x6c, 0xcc, 0xc0, 0x86, 0x7a, 0x45, 0xb9, 0xce, 0xac,
  0xa3, 0x69, 0xa0, 0x64, 0x8f, 0x63, 0x7d, 0x64, 0x36, 0xe8, 0xcc, 0xea,
  0x4d, 0x03, 0xd1, 0x53, 0x27, 0x4f, 0x71, 0xec, 0x68, 0xcc, 0xba, 0x88,
  0x06, 0xd6, 0xd5, 0x01, 0xbe, 0xcb, 0x19, 0x1a, 0xb3, 0x7a, 0xd2, 0x40,
  0x94, 0x94, 0x6b, 0xf7, 0x58, 0x34, 0x66, 0xf5, 0xa0, 0x81, 0x6f, 0x33,
  0xb0, 0xa6, 0xde, 0xa1, 0x31, 0xab, 0x3b, 0x0d, 0x14, 0x11, 0x56, 0x37,
  0x40, 0x40, 0x4f, 0xf6, 0x92, 0xcd, 0xea, 0x46, 0x03, 0xab, 0x22, 0xe0,
  0x9f, 0x93, 0x84, 0x9f, 0x78, 0x55, 0x7f, 0x80, 0xc3, 0x0f, 0x61, 0xd5,
  0x11, 0x5c, 0xa4, 0x60, 0xb5, 0xb1, 0x8a, 0x95, 0x59, 0x00, 0x3d, 0xd9,
  0x5b, 0x36, 0xeb, 0x3c, 0x1a, 0xf8, 0x26, 0x02, 0xa9, 0x1c, 0xb0, 0x81,
  0xdb, 0xde, 0xd7, 0x39, 0x03, 0x3d, 0xf9, 0x91, 0x6c, 0xd6, 0x39, 0x34,
  0xf0, 0x55, 0x04, 0x72, 0x61, 0x56, 0x09, 0x7c, 0x99, 0x00, 0xe8, 0xc9,
  0xbe, 0xb2, 0x59, 0x67, 0xd1, 0x40, 0xa6, 0xa9, 0x5f, 0x68, 0xc8, 0x8d,
  0x59, 0xba, 0xad, 0x67, 0x13, 0xf4, 0x64, 0x3f, 0xd9, 0xac, 0x8e, 0x34,
  0xf0, 0xb9, 0xc7, 0x0a, 0x47, 0xd8, 0x0e, 0xb9, 0xce, 0x73, 0xc9, 0x5e,
  0x92, 0xa5, 0xec, 0x99, 0x41, 0x4f, 0x7e, 0x26, 0x9b, 0xd5, 0x9e, 0x06,
  0x3e, 0x8d, 0x00, 0x33, 0x2b, 0xca, 0x5c, 0xdb, 0xec, 0x25, 0x59, 0xca,
  0x9e, 0x19, 0xf4, 0xe4, 0x40, 0xd9, 0xac, 0xb6, 0x34, 0xb0, 0x3c, 0x02,
  0xcc, 0xac, 0x28, 0x73, 0x6d, 0xb3, 0x97, 0x04, 0xfd, 0x4f, 0x72, 0x08,
  0x7a, 0x72, 0xb0, 0x6c, 0x56, 0x1b, 0x1a, 0xf8, 0x38, 0x02, 0xcc, 0xac,
  0x28, 0x73, 0xf5, 0x2c, 0xa3, 0x30, 0xb3, 0x96, 0x25, 0x00, 0x7a, 0x72,
  0x98, 0x6c, 0x56, 0x4b, 0x1a, 0x58, 0x1a, 0x01, 0x66, 0x96, 0x9d, 0xda,
  0x7f, 0xf2, 0x0f, 0xff, 0x29, 0x0d, 0x3f, 0x04, 0xc4, 0xbb, 0x62, 0x83,
  0x57, 0xfa, 0x92, 0x9c, 0x83, 0x9e, 0x1c, 0x21, 0x9b, 0xd5, 0x82, 0x06,
  0x96, 0xc0, 0x62, 0x67, 0x98, 0x59, 0x6e, 0xea, 0x6c, 0xe1, 0x5e, 0xbf,
  0x1e, 0xf4, 0xe4, 0x48, 0xd9, 0xac, 0x93, 0x69, 0x60, 0x51, 0x04, 0x58,
  0x99, 0x6e, 0xea, 0x6c, 0x11, 0x65, 0x0f, 0x74, 0xa0, 0x27, 0x8d, 0x65,
  0xb3, 0x4e, 0xa0, 0x81, 0x05, 0x11, 0x60, 0x65, 0xba, 0xa9, 0xb3, 0x45,
  0x94, 0x3d, 0xf0, 0xf9, 0x50, 0x01, 0x7a, 0xd2, 0x44, 0x36, 0xab, 0x19,
  0x0d, 0xa8, 0xa6, 0x98, 0x60, 0x65, 0xba, 0xa8, 0xb7, 0x71, 0xcf, 0x77,
  0xf2, 0xd9, 0x8d, 0xea, 0xf5, 0x41, 0x25, 0x7d, 0x05, 0x58, 0x24, 0xbd,
  0x2f, 0x90, 0x7e, 0x97, 0xcb, 0xad, 0x0a, 0x3b, 0xd0, 0x93, 0x66, 0xb2,
  0x59, 0xc7, 0xd1, 0xc0, 0xfc, 0x08, 0xb0, 0x32, 0x5d, 0xd4, 0x15, 0x41,
  0xff, 0x03, 0x03, 0xa8, 0xdf, 0x68, 0xa9, 0x4b, 0x19, 0x75, 0x2e, 0xa0,
  0x27, 0x27, 0xca, 0x66, 0x1d, 0x43, 0x03, 0xf3, 0x22, 0xc0, 0xca, 0xcc,
  0xac, 0x7a, 0x9f, 0x82, 0xda, 0x2d, 0x41, 0xdf, 0x04, 0xea, 0x4b, 0x2d,
  0x75, 0x29, 0xeb, 0xbc, 0x36, 0xa0, 0x27, 0xcd, 0x65, 0xb3, 0x8e, 0xa4,
  0x81, 0xff, 0x45, 0x80, 0x95, 0xe9, 0xa2, 0x2e, 0x73, 0xcc, 0xbe, 0x29,
  0xe6, 0x2a, 0xec, 0x40, 0x4f, 0x5a, 0xc8, 0x66, 0x1d, 0x4e, 0x03, 0xef,
  0x45, 0x80, 0x95, 0xe9, 0xa2, 0xde, 0xec, 0x98, 0xdd, 0xac, 0x77, 0xab,
  0x42, 0x66, 0x8e, 0x12, 0xf4, 0xa4, 0x95, 0x6c, 0xd6, 0xa1, 0x34, 0xf0,
  0x6e, 0x04, 0x58, 0x99, 0x2e, 0xea, 0x8d, 0x8e, 0xd9, 0xcb, 0x62, 0xab,
  0x62, 0xb6, 0x03, 0xe8, 0xc9, 0x69, 0xb2, 0x59, 0x07, 0xd1, 0x80, 0x4b,
  0x2a, 0x06, 0x2b, 0xd3, 0x45, 0xbd, 0x81, 0xf6, 0xde, 0x31, 0xc2, 0xcc,
  0xb2, 0xd3, 0xa5, 0x2c, 0x32, 0xda, 0x83, 0x9e, 0xb4, 0x95, 0xcd, 0x3a,
  0x80, 0x06, 0xde, 0x8e, 0x00, 0x2b, 0x33, 0xb3, 0x6a, 0x16, 0x05, 0xb5,
  0xeb, 0x83, 0xbe, 0x09, 0xf6, 0x84, 0x60, 0xa7, 0x4b, 0x59, 0xe7, 0xb5,
  0x01, 0x3d, 0xe9, 0x20, 0x9b, 0xb5, 0x3f, 0x0d, 0xbc, 0x15, 0x01, 0x56,
  0x26, 0xf6, 0xde, 0x34, 0x80, 0xda, 0x75, 0x46, 0x9d, 0xa8, 0xaf, 0xb0,
  0xd4, 0xa5, 0xac, 0xf3, 0xda, 0x80, 0x9e, 0x74, 0x92, 0xcd, 0xda, 0x0f,
  0xd8, 0x35, 0x23, 0xee, 0xb0, 0x32, 0x5d, 0xd4, 0x6b, 0x1d, 0xb3, 0x57,
  0xc6, 0x5c, 0x85, 0xc8, 0x4c, 0x0d, 0xe8, 0xc9, 0x59, 0xb2, 0x59, 0x8d,
  0x68, 0xe0, 0xf5, 0x08, 0xb0, 0x32, 0x5d, 0xd4, 0x6b, 0x1c, 0xb3, 0x57,
  0xc5, 0x54, 0xc5, 0x0c, 0x27, 0xd0, 0x93, 0xce, 0xb2, 0x59, 0xfb, 0xd0,
  0xc0, 0xf4, 0x08, 0xb0, 0x32, 0x5d, 0xd4, 0xab, 0x1c, 0xb3, 0x6f, 0x75,
  0xac, 0x62, 0x5a, 0x2c, 0xa0, 0x27, 0x5d, 0x64, 0xb3, 0xf6, 0xa6, 0x81,
  0x28, 0x29, 0x59, 0x99, 0x7a, 0xc5, 0x6b, 0x1c, 0xa8, 0xfd, 0x46, 0x18,
  0xcb, 0x04, 0xea, 0xab, 0x2d, 0x75, 0x29, 0xeb, 0xbc, 0x36, 0xa0, 0x27,
  0xdd, 0x64, 0xb3, 0xd8, 0xf5, 0x59, 0xaf, 0x46, 0x80, 0x95, 0xe9, 0xb7,
  0x5f, 0x31, 0x82, 0xda, 0xaf, 0x2c, 0x94, 0xbc, 0x7e, 0xbb, 0xa5, 0x2e,
  0x65, 0x9d, 0xd7, 0x06, 0xf4, 0xe4, 0xb7, 0x3a, 0xb3, 0x5e, 0xb6, 0x66,
  0x6a, 0x00, 0x2b, 0x73, 0xaa, 0x15, 0xa8, 0xfd, 0xdc, 0x52, 0xcd, 0xf4,
  0x3b, 0x2c, 0x75, 0xb6, 0x55, 0xd8, 0x81, 0x9e, 0xf4, 0xd0, 0x99, 0xf5,
  0x52, 0x04, 0x58, 0x99, 0x2e, 0xea, 0xcf, 0x1c, 0xb3, 0xef, 0x8a, 0xa5,
  0x8a, 0x17, 0x1d, 0x41, 0x4f, 0x7a, 0xea, 0xcc, 0x7a, 0x21, 0x02, 0xac,
  0x4c, 0x17, 0xf5, 0x27, 0x8e, 0xd9, 0x6b, 0x1c, 0xab, 0x98, 0x12, 0x0b,
  0xe8, 0x49, 0x6f, 0x9d, 0x59, 0x93, 0x23, 0xc0, 0xca, 0x74, 0x51, 0x2f,
  0x8b, 0x3d, 0xbb, 0x5b, 0x15, 0x76, 0xa0, 0x27, 0x7d, 0xb2, 0x63, 0xd6,
  0xf3, 0x16, 0xa0, 0x76, 0x89, 0x95, 0x36, 0xad, 0x4f, 0xc5, 0xa6, 0x73,
  0x01, 0x3d, 0xb9, 0x58, 0x67, 0xd6, 0x24, 0x4b, 0x9e, 0xe3, 0x60, 0x65,
  0x3e, 0x67, 0x05, 0x6a, 0x17, 0x59, 0xaa, 0xed, 0xb3, 0xbb, 0x55, 0x61,
  0x07, 0x7a, 0xd2, 0x57, 0x67, 0xd6, 0xc4, 0x10, 0xcf, 0x1a, 0x61, 0x65,
  0x9a, 0x95, 0x69, 0xf5, 0x7c, 0x4b, 0xb5, 0x7d, 0xf6, 0x5a, 0xa7, 0x2a,
  0xec, 0x40, 0x4f, 0x2e, 0xd3, 0x99, 0x35, 0x21, 0x02, 0x6c, 0x77, 0x5c,
  0xd4, 0xf3, 0x62, 0xcf, 0x5e, 0xcb, 0xe9, 0xc6, 0xc7, 0x04, 0x7a, 0x72,
  0xb9, 0xce, 0xac, 0x67, 0x22, 0xc0, 0x76, 0xc7, 0x45, 0x3d, 0x37, 0x96,
  0xec, 0xe3, 0x38, 0x76, 0x51, 0xdd, 0xb8, 0x18, 0x41, 0x4f, 0xae, 0xd4,
  0x99, 0x35, 0x0e, 0x9e, 0x76, 0x06, 0x8b, 0xac, 0x75, 0x52, 0xbf, 0xeb,
  0x98, 0x3d, 0x05, 0x4f, 0x19, 0xd8, 0x65, 0xa9, 0x73, 0x01, 0x3d, 0xb9,
  0x46, 0x6f, 0x96, 0x4d, 0x92, 0x42, 0x01, 0x76, 0x26, 0x54, 0x68, 0x05,
  0xaa, 0xdf, 0xb6, 0x54, 0x17, 0x06, 0x66, 0x99, 0x74, 0x3b, 0x2d, 0x75,
  0x2e, 0xa0, 0x27, 0x03, 0x75, 0x66, 0x3d, 0x0d, 0x63, 0x39, 0xc6, 0x58,
  0xc1, 0xce, 0xb1, 0x5d, 0xd4, 0x6f, 0x58, 0xaa, 0xc7, 0x04, 0x66, 0x99,
  0x74, 0x3b, 0x2c, 0x75, 0x2e, 0xa0, 0x27, 0xd7, 0xeb, 0xcc, 0x7a, 0x0a,
  0x46, 0x3b, 0x83, 0x45, 0xee, 0x74, 0x52, 0x4f, 0x77, 0xcc, 0x9e, 0x32,
  0xea, 0xbe, 0xb7, 0xd4, 0xb9, 0x80, 0x9e, 0xdc, 0xa0, 0x37, 0xeb, 0x49,
  0x67, 0xd8, 0x4b, 0x5d, 0x17, 0xf5, 0x6b, 0x8e, 0xd9, 0x53, 0xca, 0xd8,
  0x13, 0x1c, 0xdb, 0xa9, 0xee, 0x89, 0x18, 0x41, 0x4f, 0x06, 0xe9, 0xcc,
  0x2a, 0x84, 0x51, 0xce, 0x60, 0x91, 0xdf, 0x3b, 0xa9, 0xa7, 0x3a, 0x66,
  0x4f, 0xc1, 0xe3, 0x06, 0xb6, 0x59, 0xea, 0x5c, 0x40, 0x4f, 0x6e, 0xd6,
  0x9b, 0xf5, 0x98, 0x33, 0x58, 0xe4, 0x76, 0x27, 0xf5, 0x14, 0x4d, 0x74,
  0x64, 0x08, 0x66, 0x56, 0x38, 0x22, 0xb2, 0xd5, 0x52, 0xe7, 0x02, 0x7a,
  0x72, 0xab, 0xde, 0x2c, 0x5e, 0x3c, 0xc2, 0x0a, 0x2c, 0xb2, 0xda, 0x49,
  0x3d, 0xc9, 0x52, 0x3d, 0x22, 0x30, 0xcb, 0xa4, 0xab, 0xb2, 0xd4, 0xb9,
  0x80, 0x9e, 0xdc, 0xa6, 0x33, 0x6b, 0x0c, 0xfc, 0xc7, 0x19, 0x2c, 0x72,
  0x9b, 0x93, 0x7a, 0x82, 0x63, 0xf6, 0x94, 0x51, 0x57, 0x69, 0xa9, 0x73,
  0x01, 0x3d, 0x19, 0xa2, 0x37, 0xeb, 0x11, 0x67, 0xb0, 0xc8, 0x2a, 0x27,
  0xf5, 0xd3, 0x8e, 0xd9, 0x53, 0x46, 0x5d, 0x85, 0xa5, 0xce, 0xcc, 0xc3,
  0x01, 0xe8, 0xc9, 0xdd, 0x7a, 0xb3, 0x1e, 0x76, 0x06, 0x8b, 0xac, 0x74,
  0x52, 0x17, 0x3a, 0x66, 0x4f, 0xc1, 0x43, 0x06, 0xca, 0x2d, 0x75, 0x2e,
  0xa0, 0x27, 0x43, 0xf5, 0x66, 0x0d, 0x73, 0x06, 0x8b, 0xac, 0x70, 0x52,
  0x3f, 0xa9, 0x8c, 0x3d, 0xa8, 0x80, 0x99, 0xa5, 0x8a, 0xf1, 0x6c, 0xb1,
  0xd4, 0xb9, 0x80, 0x9e, 0xfc, 0x5b, 0x67, 0xd6, 0x7f, 0x23, 0xa4, 0xc4,
  0x22, 0xb7, 0x38, 0xa9, 0x1f, 0x83, 0x07, 0x2c, 0x61, 0x66, 0x99, 0x74,
  0x9b, 0x2d, 0x75, 0x2e, 0xa0, 0x27, 0x0f, 0xe8, 0xcd, 0xba, 0xdf, 0x19,
  0x2c, 0xb2, 0xcc, 0x49, 0xfd, 0xa8, 0x63, 0xf6, 0x94, 0x51, 0xb7, 0xc9,
  0x52, 0xe7, 0x02, 0x7a, 0x32, 0x4c, 0x67, 0xd6, 0x68, 0xef, 0xa0, 0x73,
  0x05, 0x8b, 0xdc, 0xec, 0xa4, 0x7e, 0xc8, 0x31, 0x7b, 0xca, 0xa8, 0x2b,
  0xb5, 0xd4, 0x99, 0xb8, 0x97, 0x03, 0x3d, 0x79, 0x44, 0x6f, 0xd6, 0x3d,
  0xce, 0x60, 0x91, 0xa5, 0x4e, 0xea, 0xfb, 0x1d, 0xb3, 0xa7, 0x8c, 0xba,
  0x0d, 0x96, 0xba, 0x34, 0x43, 0x8d, 0xa0, 0x27, 0x8f, 0xea, 0x1f, 0x86,
  0xe6, 0x14, 0x32, 0x58, 0xe4, 0x46, 0x27, 0xf5, 0xbd, 0xa1, 0xf1, 0x7f,
  0x69, 0x60, 0x66, 0xe9, 0xe2, 0x8c, 0x12, 0x4b, 0x9d, 0x0b, 0xe8, 0xc9,
  0x63, 0x7a, 0xb3, 0xee, 0x76, 0x06, 0x8b, 0x2c, 0x71, 0x52, 0xff, 0xd3,
  0x9a, 0x94, 0xe5, 0x8c, 0x62, 0xe7, 0xcc, 0x66, 0xd0, 0x93, 0x27, 0xf4,
  0x0f, 0xc3, 0xbb, 0x9c, 0xc1, 0x22, 0xd7, 0x87, 0xc6, 0xef, 0x54, 0x82,
  0x6a, 0x75, 0x4c, 0x45, 0xad, 0xe5, 0x8c, 0xef, 0x9c, 0x33, 0x9b, 0x61,
  0x07, 0x90, 0xd6, 0xac, 0x21, 0xce, 0x60, 0x91, 0xeb, 0x9c, 0xd4, 0xf6,
  0xd9, 0x77, 0x59, 0xce, 0x58, 0xeb, 0x9c, 0x59, 0xcd, 0x1d, 0x1c, 0xe8,
  0xc9, 0x58, 0xb5, 0x59, 0x35, 0xc1, 0x41, 0xef, 0xbf, 0xd6, 0x63, 0x54,
  0x72, 0xab, 0x4a, 0xf1, 0xcb, 0x0c, 0xb0, 0xcf, 0xa8, 0xa3, 0x7e, 0x2d,
  0xdc, 0x6e, 0x05, 0xaa, 0xed, 0xb4, 0x3e, 0xdf, 0x73, 0x35, 0xa9, 0xd9,
  0x49, 0xaa, 0xac, 0x09, 0xd5, 0xcd, 0x50, 0xaf, 0x8f, 0xc5, 0x96, 0xb3,
  0xca, 0xb4, 0x16, 0x4a, 0x0d, 0x7d, 0xab, 0xdd, 0x68, 0x96, 0x2b, 0x6b,
  0xe0, 0x1f, 0x56, 0xa0, 0xda, 0x4e, 0xeb, 0xb3, 0x75, 0x37, 0x6a, 0xda,
  0x7d, 0xf0, 0xbf, 0x07, 0x63, 0x37, 0xab, 0x08, 0x6e, 0xb5, 0x02, 0xd5,
  0x83, 0xad, 0xa9, 0xdc, 0x8d, 0x9a, 0xe2, 0x31, 0x6b, 0x62, 0xfc, 0x66,
  0xad, 0x86, 0x5b, 0x24, 0xfe, 0xae, 0x04, 0xd5, 0xea, 0x98, 0x8a, 0xb2,
  0xc4, 0xcd, 0x9a, 0xac, 0x3f, 0x75, 0xb8, 0xd9, 0x99, 0x9b, 0x9c, 0xc0,
  0x22, 0xdc, 0xe6, 0xd8, 0xf0, 0x75, 0x16, 0x32, 0xb3, 0xcb, 0xb0, 0xb4,
  0x66, 0xdd, 0x98, 0x65, 0x70, 0x97, 0xe2, 0xcf, 0xfb, 0x95, 0x53, 0xe6,
  0x41, 0x56, 0xb0, 0x0b, 0xfc, 0xb4, 0x6f, 0xd1, 0xfc, 0x2d, 0xcb, 0xe0,
  0x2e, 0xc5, 0x9f, 0xf7, 0x0b, 0x4d, 0xe6, 0x1b, 0x76, 0x03, 0xf4, 0xe4,
  0x15, 0xbd, 0x59, 0x7f, 0xcd, 0x32, 0xb8, 0x4b, 0xf1, 0xe7, 0x65, 0x6b,
  0x8b, 0xfc, 0x25, 0x46, 0xd0, 0x93, 0xe9, 0x3a, 0xb3, 0xc6, 0xc6, 0xb6,
  0xa1, 0xeb, 0x35, 0xe0, 0x2e, 0xe9, 0xa2, 0xd1, 0xf9, 0x34, 0x0b, 0x99,
  0xd1, 0x93, 0xd7, 0xf5, 0x66, 0x65, 0xfb, 0x1f, 0xee, 0x52, 0xfc, 0xff,
  0x3e, 0xc9, 0x42, 0x66, 0xf4, 0xe4, 0x4d, 0x9d, 0x59, 0x85, 0x70, 0x9d,
  0x96, 0x81, 0xb1, 0x80, 0xbb, 0x14, 0x4f, 0x2e, 0x9e, 0x65, 0x59, 0xc8,
  0x8c, 0x9e, 0xbc, 0xa3, 0x33, 0x2b, 0x57, 0xe7, 0x2f, 0xd7, 0xc6, 0x0e,
  0x5b, 0xb9, 0x64, 0x6e, 0xc0, 0x47, 0x02, 0xfc, 0xe7, 0xfb, 0xc5, 0x55,
  0xdf, 0xc4, 0x85, 0x6b, 0xb7, 0x72, 0xe0, 0xcb, 0x9d, 0x77, 0x93, 0x36,
  0xeb, 0xea, 0xd8, 0xf9, 0x28, 0x0b, 0x55, 0xd6, 0x12, 0x4f, 0xe6, 0x26,
  0x6d, 0xd6, 0x95, 0x91, 0x19, 0xa0, 0x61, 0x61, 0xd6, 0xcc, 0xfa, 0x20,
  0x69, 0xb3, 0xae, 0x88, 0x9d, 0x6c, 0xac, 0x45, 0x82, 0x66, 0x7d, 0xa8,
  0x33, 0x6b, 0x1c, 0xfc, 0x59, 0xc3, 0xe5, 0xf5, 0x10, 0xf4, 0x64, 0xa1,
  0xce, 0xac, 0x67, 0xa0, 0x3f, 0x5c, 0xd6, 0x00, 0x05, 0x3d, 0x59, 0xac,
  0x37, 0xeb, 0xd2, 0x3a, 0x48, 0xbf, 0x2c, 0x81, 0x9e, 0x2c, 0xd3, 0x99,
  0x35, 0x1e, 0xfa, 0xe6, 0x35, 0x97, 0xe4, 0x14, 0xf4, 0x64, 0xb9, 0xce,
  0xac, 0x09, 0xf0, 0xa7, 0x3c, 0xe1, 0xe2, 0x3c, 0x00, 0x3d, 0x59, 0xa1,
  0x33, 0xeb, 0x59, 0xcd, 0xb4, 0x3f, 0xd6, 0x4b, 0xd0, 0x93, 0x2f, 0x75,
  0x66, 0x4d, 0x84, 0x3e, 0x0d, 0x04, 0xa0, 0x27, 0xdf, 0xe8, 0xcd, 0xfa,
  0x7d, 0x03, 0x01, 0xe8, 0xc9, 0x6a, 0x9d, 0x59, 0x93, 0xa0, 0x77, 0x1e,
  0x73, 0x51, 0x8e, 0x41, 0x4f, 0xd6, 0xe8, 0xcc, 0x7a, 0x1e, 0x7a, 0xe5,
  0x05, 0x3d, 0xf3, 0x02, 0xf4, 0x64, 0x9d, 0xce, 0xac, 0xc9, 0x70, 0x61,
  0x4e, 0xb9, 0x20, 0xaf, 0x41, 0x4f, 0xd6, 0xeb, 0xcd, 0xea, 0xd1, 0x40,
  0x00, 0x7a, 0xb2, 0x41, 0x67, 0xd6, 0x14, 0xf8, 0x5d, 0x03, 0x01, 0xe8,
  0xc9, 0x66, 0x9d, 0x59, 0x2f, 0x40, 0xf7, 0x7a, 0xc9, 0xf9, 0x4a, 0xd0,
  0x93, 0x72, 0x9d, 0x59, 0x2f, 0x6a, 0xa6, 0xe5, 0x96, 0x6e, 0x79, 0x02,
  0x7a, 0x52, 0xa9, 0x33, 0x6b, 0x2a, 0x74, 0xcd, 0x21, 0x5d, 0xf2, 0x1c,
  0xf4, 0x64, 0x9b, 0xce, 0xac, 0x57, 0xe0, 0xbc, 0xac, 0xf0, 0x9b, 0x3a,
  0x49, 0x35, 0x45, 0x63, 0xd6, 0xab, 0x70, 0x6e, 0x03, 0x94, 0xce, 0x26,
  0xb3, 0xa6, 0xc1, 0x39, 0xf5, 0x90, 0xb3, 0x35, 0x18, 0xcc, 0x9a, 0x0e,
  0x67, 0xe5, 0x1c, 0x7c, 0xbf, 0x5b, 0x3f, 0x26, 0xbf, 0x33, 0x7e, 0x9b,
  0xa4, 0xbd, 0x47, 0x88, 0x86, 0xb3, 0xa4, 0x39, 0x1f, 0xce, 0x14, 0x08,
  0xbf, 0xeb, 0x5e, 0x2e, 0xc4, 0x0d, 0x66, 0xcd, 0x90, 0xd2, 0x65, 0x93,
  0x4e, 0x14, 0x2c, 0xb3, 0x93, 0x00, 0x3f, 0x16, 0xde, 0xa5, 0xad, 0x9c,
  0x72, 0x5a, 0x28, 0x3a, 0x40, 0xca, 0xc2, 0x73, 0xa5, 0x62, 0x2b, 0xf2,
  0x7f, 0x52, 0xa4, 0xe3, 0x06, 0xb3, 0x66, 0x42, 0xc7, 0x2c, 0xf0, 0xeb,
  0x8c, 0x60, 0x91, 0xfc, 0x48, 0x57, 0x32, 0x52, 0x43, 0xda, 0xd7, 0x29,
  0x77, 0x69, 0x16, 0x55, 0x6e, 0x09, 0x46, 0x96, 0x72, 0x51, 0x31, 0xb3,
  0xc8, 0x8e, 0x20, 0x7a, 0x95, 0xe6, 0xff, 0x74, 0x9e, 0x0b, 0x14, 0x06,
  0xb3, 0xde, 0x84, 0x33, 0x76, 0x83, 0x0e, 0x91, 0xc0, 0x12, 0xf9, 0x91,
  0xf1, 0x64, 0x64, 0x3c, 0x69, 0xe3, 0x0a, 0xf2, 0xef, 0x04, 0xb1, 0x85,
  0x82, 0x5e, 0x9e, 0x8b, 0xfd, 0xd9, 0xca, 0xe8, 0x6a, 0xda, 0xef, 0x46,
  0xfb, 0x73, 0x05, 0xad, 0xcf, 0x4a, 0x69, 0x86, 0xc1, 0xac, 0xb7, 0xa0,
  0xbd, 0xc4, 0x55, 0x30, 0xcc, 0x3b, 0xf1, 0x97, 0x47, 0x19, 0xfd, 0xe0,
  0x41, 0xef, 0x70, 0x95, 0x47, 0xfb, 0xc2, 0x08, 0xed, 0x8c, 0xf6, 0x70,
  0x29, 0x0c, 0xe6, 0x7a, 0xe7, 0xd0, 0x02, 0x79, 0x45, 0x11, 0x7d, 0x38,
  0xf9, 0x6d, 0xbc, 0x0e, 0xfe, 0x4e, 0x2e, 0xca, 0xeb, 0xe5, 0xb9, 0xb8,
  0xb8, 0xeb, 0x7d, 0xa4, 0xdd, 0x29, 0x14, 0xc5, 0xfe, 0x26, 0xda, 0xc3,
  0x8b, 0x42, 0xef, 0x86, 0x76, 0x1c, 0xa8, 0xb8, 0x86, 0xf6, 0x0c, 0x66,
  0xbd, 0x0d, 0x6d, 0x03, 0x3a, 0x0a, 0x07, 0xe7, 0x2a, 0x2e, 0x82, 0x23,
  0x83, 0xb8, 0x68, 0x3a, 0xb6, 0x83, 0x1b, 0x9d, 0x12, 0x8c, 0xe2, 0xca,
  0x1f, 0xfd, 0x82, 0xfb, 0x2e, 0x3d, 0x67, 0x2c, 0x69, 0x17, 0x73, 0x19,
  0xda, 0x0a, 0x71, 0x39, 0xbf, 0x29, 0x9a, 0x06, 0x97, 0x39, 0x58, 0xc7,
  0x8d, 0x9c, 0x4e, 0xf5, 0xa7, 0x13, 0xf8, 0x36, 0x03, 0x3f, 0x5b, 0xf6,
  0x32, 0xed, 0x19, 0xcc, 0x9a, 0x0d, 0xa7, 0x51, 0x54, 0xcf, 0x15, 0x2c,
  0xe6, 0xb7, 0xc5, 0xeb, 0xd3, 0xc7, 0x73, 0x11, 0x1f, 0xb6, 0x8a, 0x76,
  0x3b, 0x3a, 0x8e, 0x9f, 0x06, 0x1c, 0xa9, 0xc8, 0x86, 0xe6, 0xde, 0x1b,
  0xe4, 0x4e, 0x67, 0x09, 0xb7, 0x75, 0xd1, 0x4a, 0xef, 0x69, 0x9e, 0x57,
  0xb4, 0x21, 0xe0, 0x4a, 0x0f, 0x43, 0x69, 0x0f, 0x41, 0x7d, 0xb8, 0x2d,
  0xc6, 0x2f, 0xa0, 0x3d, 0x83, 0x59, 0x73, 0x82, 0x69, 0xb5, 0xf4, 0x7e,
  0xf1, 0xdb, 0xbd, 0x84, 0xc4, 0xfd, 0x68, 0x6f, 0x19, 0xe9, 0xd5, 0x70,
  0xb1, 0x39, 0xa4, 0x55, 0x45, 0xda, 0x78, 0xd0, 0xaf, 0xf7, 0x5a, 0xad,
  0x3d, 0x98, 0x41, 0xeb, 0xbc, 0x76, 0x57, 0xda, 0x6e, 0xcd, 0x45, 0x46,
  0x29, 0x3e, 0x63, 0xc8, 0xc7, 0x5b, 0x73, 0x84, 0xa3, 0x3e, 0x2b, 0x04,
  0x4d, 0x3a, 0xd6, 0xd9, 0x30, 0x97, 0x8f, 0xf6, 0x92, 0xc6, 0x0c, 0x66,
  0xcd, 0x85, 0x53, 0x09, 0xab, 0xc8, 0xa4, 0x05, 0xb4, 0x77, 0x2a, 0x4d,
  0x72, 0x29, 0x69, 0xb3, 0xe5, 0xc4, 0x31, 0xd2, 0x86, 0xeb, 0x61, 0xab,
  0x15, 0x65, 0x11, 0xd7, 0x63, 0x0f, 0x65, 0xec, 0xe1, 0x1d, 0xd1, 0x81,
  0x8b, 0xa8, 0xe0, 0x67, 0xb6, 0x0a, 0xa8, 0x95, 0x46, 0xc4, 0x39, 0xf7,
  0x71, 0x4a, 0x79, 0xa6, 0x3c, 0x26, 0xc6, 0xcf, 0x0d, 0x16, 0x86, 0x1d,
  0x1a, 0x8c, 0x19, 0xcc, 0x7a, 0x1f, 0x5a, 0x12, 0x70, 0x5a, 0xcb, 0x00,
  0x7c, 0x62, 0x9e, 0xc1, 0xc5, 0x5a, 0x41, 0x0b, 0x0a, 0xf6, 0x5b, 0x78,
  0xaf, 0xa5, 0x58, 0x0b, 0x99, 0x1c, 0xf4, 0xfa, 0x48, 0x11, 0xbe, 0xa7,
  0xb3, 0x6a, 0x27, 0x89, 0x5e, 0xa1, 0x89, 0xb6, 0xe0, 0x18, 0x28, 0x44,
  0x96, 0x2b, 0xb7, 0x12, 0x1e, 0xeb, 0xaf, 0xc9, 0x5c, 0xc6, 0xa9, 0x0d,
  0x66, 0xcd, 0xd3, 0x6c, 0x08, 0xaf, 0x51, 0x99, 0xa0, 0x8c, 0xb1, 0xfe,
  0x93, 0xca, 0x8d, 0xfb, 0x8a, 0xd1, 0xd4, 0x6a, 0x17, 0xb3, 0x66, 0x91,
  0xe8, 0x44, 0x65, 0xac, 0x4a, 0xb2, 0xa0, 0x45, 0x70, 0x15, 0xb4, 0x4f,
  0x57, 0xe5, 0x3e, 0x9c, 0x42, 0xc0, 0x31, 0xbf, 0xf5, 0x8c, 0x32, 0xf3,
  0x4e, 0xaa, 0x43, 0x0c, 0x66, 0xcd, 0x87, 0xe6, 0x04, 0x9c, 0xda, 0x3c,
  0x00, 0x0f, 0xfe, 0x5b, 0x15, 0xb1, 0x0b, 0x82, 0xbe, 0xfa, 0x82, 0x25,
  0x5f, 0x83, 0x9f, 0xec, 0x3a, 0x2d, 0x98, 0x93, 0x8e, 0xb4, 0x0d, 0x6d,
  0xa9, 0x39, 0xfd, 0x7c, 0x57, 0x1f, 0x6e, 0xbb, 0x3c, 0xa5, 0x82, 0x96,
  0xa7, 0x65, 0xa0, 0x39, 0xd9, 0xa3, 0x0d, 0xd7, 0x66, 0x34, 0xe7, 0xc6,
  0x6a, 0xa9, 0xed, 0x65, 0x84, 0xb0, 0xf6, 0xe4, 0xe0, 0x5b, 0xae, 0xb4,
  0x66, 0x2d, 0x80, 0x93, 0x3c, 0xba, 0xd0, 0xc9, 0x27, 0x05, 0xf0, 0x7d,
  0x31, 0x36, 0x93, 0xf4, 0xa6, 0x07, 0xe3, 0xed, 0xb8, 0x59, 0xaa, 0xd9,
  0x62, 0x1f, 0x8f, 0xc6, 0x22, 0xad, 0x5a, 0x9e, 0x29, 0x72, 0x62, 0x08,
  0xd4, 0xfb, 0xad, 0xc7, 0x49, 0x6b, 0x8d, 0x10, 0xc5, 0x3b, 0xad, 0x8b,
  0xa4, 0xf4, 0x59, 0x4f, 0x7a, 0x6b, 0xa5, 0x6c, 0x06, 0xb3, 0x16, 0x11,
  0x51, 0x7b, 0x29, 0x95, 0x98, 0x5a, 0x8c, 0x61, 0xaf, 0x1f, 0x37, 0xfe,
  0xab, 0x10, 0x18, 0x51, 0xf5, 0xf1, 0x43, 0x24, 0x63, 0xb4, 0x6a, 0x79,
  0x26, 0x4f, 0x37, 0xf2, 0x14, 0xa2, 0xdb, 0xd2, 0x97, 0xa4, 0x55, 0x68,
  0x99, 0xb9, 0x87, 0x72, 0x4b, 0x06, 0xb3, 0x16, 0xc3, 0x09, 0x04, 0x9c,
  0x7a, 0x02, 0xa5, 0x2f, 0xe9, 0xd5, 0x90, 0xf6, 0x1f, 0x68, 0xec, 0x78,
  0x4a, 0xba, 0x87, 0xdf, 0x23, 0x71, 0x4d, 0x30, 0x5e, 0xee, 0xa9, 0x65,
  0x8d, 0xcf, 0xe5, 0xa4, 0xf7, 0x12, 0x17, 0x69, 0x13, 0xc4, 0x64, 0xb5,
  0x38, 0xf3, 0x78, 0x85, 0xee, 0x66, 0x6e, 0x64, 0x0c, 0xa7, 0xc7, 0xd6,
  0xe9, 0x41, 0x6c, 0x38, 0x1d, 0x99, 0xab, 0xc9, 0x8c, 0x47, 0xdd, 0x4a,
  0x61, 0x0b, 0x06, 0xb3, 0x96, 0x42, 0x33, 0x42, 0x8a, 0xde, 0xe3, 0x4d,
  0x3d, 0xc6, 0xd1, 0x5e, 0x53, 0xc2, 0x6c, 0xda, 0x7b, 0x95, 0xf4, 0x76,
  0x72, 0xb1, 0x36, 0x5c, 0xfb, 0x32, 0x61, 0x0e, 0xdf, 0x6e, 0x4a, 0x2f,
  0x95, 0xed, 0xac, 0x88, 0x84, 0xd5, 0xaa, 0x38, 0x83, 0x7d, 0x2a, 0x7a,
  0xa5, 0x77, 0x4a, 0xd3, 0x93, 0x5b, 0x88, 0xe5, 0x0c, 0x6e, 0xa6, 0x7f,
  0x35, 0x72, 0x71, 0x10, 0xf1, 0x97, 0xcf, 0x53, 0x6d, 0xc5, 0xe7, 0x14,
  0xc5, 0xb6, 0x0c, 0x66, 0x7d, 0x0c, 0x4d, 0x08, 0xe1, 0x2b, 0x34, 0xcf,
  0xa5, 0x91, 0x1a, 0x7a, 0xff, 0xf0, 0xb1, 0xee, 0x34, 0x26, 0xcf, 0x19,
  0x42, 0x46, 0xf1, 0xd5, 0x7f, 0x29, 0xd5, 0x30, 0x95, 0xdf, 0xea, 0xc0,
  0xb5, 0x9b, 0x58, 0xc7, 0x65, 0xa5, 0xc8, 0xe7, 0x70, 0x9c, 0x47, 0x7b,
  0x65, 0xac, 0x96, 0xc4, 0xf8, 0xf8, 0x71, 0x1c, 0xe1, 0x11, 0x83, 0x59,
  0xcb, 0xe1, 0x58, 0xca, 0xd5, 0xc2, 0x66, 0x5a, 0x07, 0xe3, 0xd8, 0x3f,
  0x96, 0x8b, 0xbd, 0x17, 0xc4, 0x9a, 0x0a, 0x9f, 0x58, 0x2c, 0xa2, 0xa3,
  0xb8, 0x8a, 0xed, 0x9d, 0xa1, 0x0c, 0xc7, 0xd2, 0x63, 0x76, 0x69, 0x10,
  0xf1, 0xb9, 0x83, 0x8c, 0x4d, 0xe3, 0xe2, 0x1f, 0x0b, 0xf1, 0x34, 0x8d,
  0x83, 0xbf, 0x34, 0x69, 0x46, 0x7a, 0xa3, 0x3e, 0xe3, 0x42, 0x91, 0x14,
  0xdc, 0x40, 0x63, 0xe9, 0xf8, 0xa7, 0xdc, 0x48, 0x63, 0xaa, 0xda, 0xca,
  0x8d, 0x18, 0xcc, 0x5a, 0x01, 0xc7, 0x70, 0x34, 0xf3, 0x5e, 0x2c, 0x5f,
  0x2c, 0x8c, 0xe0, 0xae, 0x6e, 0x26, 0xed, 0xae, 0xde, 0xb9, 0x6e, 0x4f,
  0x21, 0x8a, 0x0c, 0x86, 0x5b, 0xbc, 0x7b, 0x3d, 0x3c, 0x1e, 0x9d, 0xa3,
  0x33, 0xd2, 0x1c, 0xee, 0x82, 0xdb, 0xe1, 0x42, 0x83, 0x2a, 0x0a, 0x06,
  0xb3, 0xbe, 0x30, 0x4c, 0xc7, 0xf3, 0xde, 0x49, 0x70, 0x54, 0xbd, 0xc0,
  0x60, 0xd6, 0xd7, 0x70, 0x64, 0xc0, 0x2f, 0x15, 0xe0, 0x5b, 0x6f, 0x67,
  0x2a, 0x63, 0x7b, 0x1e, 0x06, 0xb3, 0x56, 0xc2, 0xe1, 0x19, 0xc1, 0xc7,
  0x75, 0x66, 0xcd, 0x9e, 0x83, 0xc1, 0xac, 0xd5, 0xf0, 0x8b, 0x8c, 0xa0,
  0x59, 0x99, 0x35, 0xb9, 0xe1, 0xb0, 0x1c, 0x60, 0x30, 0xeb, 0x5b, 0x38,
  0x34, 0x23, 0x68, 0x56, 0x66, 0x4d, 0xbc, 0x1c, 0x92, 0x20, 0x06, 0xb3,
  0xd6, 0xc1, 0xc1, 0x89, 0x71, 0x50, 0xde, 0x61, 0x30, 0xab, 0x38, 0x10,
  0xfe, 0xbc, 0x01, 0x93, 0x59, 0x25, 0x70, 0x40, 0x03, 0x01, 0x06, 0xb3,
  0xb6, 0xc1, 0xcf, 0xea, 0x39, 0xfb, 0x73, 0x18, 0xcc, 0xaa, 0x16, 0xc4,
  0xf9, 0xc0, 0x4f, 0x13, 0x04, 0x1d, 0xd9, 0xa8, 0x37, 0x6b, 0xbf, 0x84,
  0xf8, 0x49, 0xde, 0xc1, 0x56, 0xc0, 0x0d, 0x7d, 0xcd, 0x68, 0x41, 0xf0,
  0xf6, 0x7c, 0x05, 0xfc, 0x38, 0xab, 0xec, 0x5b, 0x47, 0x58, 0x2a, 0x3e,
  0x08, 0x45, 0xb3, 0xd2, 0xc7, 0x56, 0x29, 0x34, 0xaa, 0xf7, 0x0c, 0x0f,
  0xdc, 0x58, 0xa3, 0x36, 0x0b, 0x02, 0x41, 0x35, 0x2c, 0x81, 0x41, 0xd2,
  0xa7, 0xdb, 0xf9, 0x65, 0x9a, 0x06, 0x4b, 0x6b, 0x7b, 0xf2, 0x0b, 0xce,
  0x17, 0x0a, 0xdf, 0x89, 0x24, 0x7e, 0xc9, 0xe7, 0x5c, 0xe1, 0x9b, 0xe5,
  0x57, 0x08, 0x14, 0x0b, 0x54, 0xe7, 0x09, 0x8b, 0xd2, 0xfe, 0x88, 0x66,
  0x15, 0x78, 0xcf, 0x05, 0x49, 0x17, 0x97, 0x5f, 0x2c, 0xe6, 0xdd, 0x91,
  0xcd, 0x2a, 0x80, 0x61, 0x89, 0x17, 0x98, 0x3f, 0xac, 0x12, 0xbd, 0x09,
  0x9b, 0xe5, 0x33, 0x24, 0xf1, 0x32, 0x93, 0x66, 0x33, 0x9c, 0x11, 0xf6,
  0x45, 0x6d, 0x56, 0x03, 0x4a, 0x12, 0x2f, 0x20, 0x51, 0xd2, 0xef, 0xce,
  0x17, 0x90, 0x9f, 0x02, 0xee, 0xb7, 0x82, 0xcc, 0xc9, 0x66, 0x40, 0x3b,
  0xf2, 0xfb, 0x07, 0xf0, 0x19, 0xf8, 0x5f, 0xe2, 0x7a, 0x0f, 0xf9, 0xba,
  0x1e, 0xbc, 0x9d, 0x0d, 0x97, 0x50, 0xd5, 0x51, 0xde, 0xcf, 0x7c, 0x48,
  0xd1, 0xab, 0x3b, 0x0b, 0xbc, 0xe8, 0x11, 0x30, 0x8a, 0xce, 0xc3, 0x4f,
  0xbd, 0xac, 0x25, 0xb7, 0xfe, 0xf9, 0x4a, 0x7f, 0xb6, 0x08, 0x8e, 0xc7,
  0x11, 0x30, 0x8b, 0xfc, 0x6e, 0xe7, 0xc5, 0xfd, 0x8c, 0x2b, 0x60, 0x41,
  0x22, 0x86, 0xe1, 0x6f, 0x80, 0xe7, 0xbd, 0xdb, 0x8f, 0xd8, 0x77, 0xec,
  0xb8, 0x9a, 0x35, 0x1a, 0x5a, 0xc3, 0x5e, 0xec, 0xdb, 0x8c, 0xe0, 0x7d,
  0xef, 0xe4, 0xff, 0x7c, 0x18, 0x40, 0x6f, 0xb7, 0x78, 0xf6, 0x34, 0x22,
  0xe3, 0x93, 0xbd, 0xb6, 0x6f, 0x96, 0xdf, 0x2e, 0x83, 0xb6, 0xde, 0xed,
  0x5d, 0xf0, 0x43, 0x2e, 0xcb, 0x60, 0x6f, 0x86, 0x1f, 0x29, 0x80, 0x9b,
  0x48, 0x9f, 0x99, 0xb5, 0x98, 0xaa, 0x0e, 0x25, 0xf1, 0x01, 0x9e, 0xb1,
  0x7b, 0x27, 0x60, 0x55, 0xda, 0xac, 0x8e, 0xb0, 0xc3, 0xbb, 0x2d, 0xf6,
  0xee, 0xce, 0x48, 0x66, 0x5d, 0x4b, 0x6e, 0x47, 0xd1, 0x5e, 0x5f, 0x68,
  0x0a, 0x8d, 0xbd, 0x13, 0x7f, 0xbc, 0x4d, 0x91, 0xdd, 0xf5, 0xc7, 0xdf,
  0x23, 0xdf, 0xdf, 0x3d, 0x1f, 0x5a, 0x79, 0x91, 0x02, 0xb2, 0xc4, 0xcd,
  0x4c, 0x2e, 0x47, 0x53, 0xfa, 0x93, 0x0a, 0x99, 0xb5, 0x83, 0xdc, 0x9e,
  0x0d, 0x73, 0x48, 0xdc, 0x7f, 0x41, 0xd1, 0x1b, 0xb6, 0x27, 0x6a, 0x56,
  0x2f, 0xef, 0xb6, 0x79, 0x54, 0xb3, 0x0e, 0xf4, 0x7e, 0x70, 0x55, 0xe1,
  0x7d, 0x60, 0xa1, 0x67, 0x46, 0x01, 0x54, 0x91, 0x5d, 0xf4, 0x6f, 0x2f,
  0x81, 0xab, 0xd8, 0x57, 0xf7, 0x78, 0xac, 0x24, 0x66, 0xb5, 0x82, 0xee,
  0x50, 0x03, 0xfe, 0xc3, 0x70, 0x38, 0x34, 0x81, 0x0b, 0xc9, 0xbc, 0xd6,
  0x70, 0x8c, 0xf7, 0x7b, 0x20, 0xf9, 0xbe, 0xdc, 0x87, 0x3d, 0x5b, 0x0e,
  0xe1, 0x4e, 0xf2, 0x86, 0x7b, 0x3f, 0xe5, 0xc4, 0xc2, 0x81, 0x5e, 0xc6,
  0x26, 0xe4, 0xe2, 0xb7, 0x24, 0xcd, 0xc2, 0x76, 0x44, 0xb3, 0x76, 0x8f,
  0x7d, 0x13, 0xd8, 0xf1, 0x28, 0xf0, 0x66, 0xf9, 0xf4, 0xd7, 0x6b, 0x93,
  0x2e, 0xb5, 0x4e, 0x91, 0x78, 0x01, 0x75, 0x89, 0xff, 0x03, 0x00, 0x00,
  0xff, 0xff, 0x03, 0x00, 0x37, 0x3d, 0x4f, 0x65, 0x3f, 0x46, 0x49, 0x0e,
  0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
static unsigned int hpsdr_logo_len = 3996;
