"""PolicyViolationVulnerabilityAssociation FK ondelete action

Revision ID: 5cf9660bba80
Revises: 7dea3a6caf51
Create Date: 2021-12-01 16:09:40.318964+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '5cf9660bba80'
down_revision = '7dea3a6caf51'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('policy_violation_vulnerability_associatio_vulnerability_id_fkey', 'policy_violation_vulnerability_association', type_='foreignkey')
    op.create_foreign_key(None, 'policy_violation_vulnerability_association', 'vulnerability', ['vulnerability_id'], ['id'], ondelete='CASCADE')
    op.alter_column('vulnerability', 'risk',
               existing_type=sa.REAL(),
               type_=sa.Float(precision=3, asdecimal=1),
               existing_nullable=True)
    op.alter_column('vulnerability_template', 'risk',
               existing_type=sa.REAL(),
               type_=sa.Float(precision=3, asdecimal=1),
               existing_nullable=True)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('vulnerability_template', 'risk',
               existing_type=sa.Float(precision=3, asdecimal=1),
               type_=sa.REAL(),
               existing_nullable=True)
    op.alter_column('vulnerability', 'risk',
               existing_type=sa.Float(precision=3, asdecimal=1),
               type_=sa.REAL(),
               existing_nullable=True)
    op.drop_constraint('policy_violation_vulnerability_associatio_vulnerability_id_fkey', 'policy_violation_vulnerability_association', type_='foreignkey')
    op.create_foreign_key(None, 'policy_violation_vulnerability_association', 'vulnerability', ['vulnerability_id'], ['id'])
    # ### end Alembic commands ###
