/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.requesthandler;

import ddb.dsz.plugin.requesthandler.RequestHandler;
import ddb.dsz.plugin.requesthandler.model.RequestStatus;
import ddb.dsz.plugin.requesthandler.requests.RequestedOperation;
import ddb.dsz.plugin.requesthandler.tranformers.CommandTransformer;
import ddb.dsz.plugin.requesthandler.tranformers.DisplayTransformer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class RequestInformation
extends JDialog {
    RequestHandler handler;
    RequestedOperation reqOp;
    private JButton approveButton;
    private JButton closeButton;
    private JTextArea commandLineField;
    private JPanel commandLinePanel;
    private JButton denyButton;
    private JTextArea descriptionField;
    private JPanel descriptionPanel;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField sourceField;
    private JLabel sourceLabel;

    public RequestInformation(RequestedOperation requestedOperation, RequestHandler requestHandler, boolean bl, RequestStatus requestStatus) {
        super((Frame)null, true);
        this.handler = requestHandler;
        this.reqOp = requestedOperation;
        this.initComponents();
        if (!bl) {
            this.approveButton.setVisible(false);
            this.denyButton.setText("Cancel");
            this.denyButton.setToolTipText("Cancel this operation");
        }
        try {
            this.sourceField.setText(requestedOperation.getSource());
            this.descriptionField.setText(DisplayTransformer.getInstance().transform(requestedOperation).toString());
            this.commandLineField.setText(CommandTransformer.getInstance().transform(requestedOperation).toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (requestStatus) {
            case ALLOWED: {
                this.approveButton.setVisible(false);
                break;
            }
            case CANCELLED: 
            case EXECUTED: 
            case DENIED: {
                this.approveButton.setVisible(false);
                this.denyButton.setVisible(false);
                break;
            }
        }
    }

    private void initComponents() {
        this.sourceLabel = new JLabel();
        this.sourceField = new JTextField();
        this.descriptionPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionField = new JTextArea();
        this.commandLinePanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.commandLineField = new JTextArea();
        this.closeButton = new JButton();
        this.denyButton = new JButton();
        this.approveButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Request Information");
        this.sourceLabel.setText("Source:");
        this.sourceField.setEditable(false);
        this.descriptionPanel.setBorder(BorderFactory.createTitledBorder("Description"));
        this.descriptionField.setColumns(20);
        this.descriptionField.setEditable(false);
        this.descriptionField.setRows(1);
        this.jScrollPane1.setViewportView(this.descriptionField);
        GroupLayout groupLayout = new GroupLayout((Container)this.descriptionPanel);
        this.descriptionPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 542, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1).addContainerGap()));
        this.commandLinePanel.setBorder(BorderFactory.createTitledBorder("Expected Command Line"));
        this.commandLineField.setColumns(20);
        this.commandLineField.setEditable(false);
        this.commandLineField.setRows(1);
        this.jScrollPane2.setViewportView(this.commandLineField);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.commandLinePanel);
        this.commandLinePanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -1, 542, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.jScrollPane2).addContainerGap()));
        this.closeButton.setText("Close");
        this.closeButton.setToolTipText("Close without changing the state");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestInformation.this.closeButtonActionPerformed(actionEvent);
            }
        });
        this.denyButton.setText("Deny");
        this.denyButton.setToolTipText("Deny this operation");
        this.denyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestInformation.this.denyButtonActionPerformed(actionEvent);
            }
        });
        this.approveButton.setText("Approve");
        this.approveButton.setToolTipText("Approve this operation");
        this.approveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestInformation.this.approveButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.sourceLabel).addPreferredGap(0).add((Component)this.sourceField, -1, 533, Short.MAX_VALUE)).add((Component)this.descriptionPanel, -1, -1, Short.MAX_VALUE).add((Component)this.commandLinePanel, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.approveButton).addPreferredGap(0).add((Component)this.denyButton).addPreferredGap(0).add((Component)this.closeButton))).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.sourceLabel).add((Component)this.sourceField, -2, -1, -2)).addPreferredGap(0).add((Component)this.descriptionPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.commandLinePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.closeButton).add((Component)this.denyButton).add((Component)this.approveButton)).addContainerGap()));
        this.pack();
    }

    private void approveButtonActionPerformed(ActionEvent actionEvent) {
        if (this.handler != null) {
            this.handler.approve(this.reqOp.getId());
        }
        this.setVisible(false);
        this.dispose();
    }

    private void denyButtonActionPerformed(ActionEvent actionEvent) {
        if (this.handler != null) {
            this.handler.cancel(this.reqOp.getId());
        }
        this.setVisible(false);
        this.dispose();
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

