/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.requesthandler.model;

import ddb.detach.TabbableStatus;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.requesthandler.RequestHandler;
import ddb.dsz.plugin.requesthandler.model.RequestStatus;
import ddb.dsz.plugin.requesthandler.model.RequestTableColumns;
import ddb.dsz.plugin.requesthandler.requests.RequestedOperation;
import ddb.dsz.plugin.requesthandler.tranformers.CommandTransformer;
import ddb.dsz.plugin.requesthandler.tranformers.DisplayTransformer;
import ddb.util.AbstractEnumeratedTableModel;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.BoundedRangeModel;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestTableModel
extends AbstractEnumeratedTableModel<RequestTableColumns> {
    private static final List<Set<RequestStatus>> ORDER = new Vector<Set<RequestStatus>>();
    private final List<RecordEntry> dataQueue = new ArrayList<RecordEntry>();
    RequestHandler handler;
    Closure execution;
    final Object editLock = new Object();
    int nextIndex = 0;
    int running = 0;
    int maxRunning = 5;
    int maximumShown = 0;
    TabbableStatus status = null;
    Set<TaskId> currentTasks = Collections.synchronizedSet(new HashSet());
    Executor EventLogger = Executors.newSingleThreadExecutor();
    File logFile;

    public RequestTableModel(RequestHandler requestHandler, Closure closure) {
        super(RequestTableColumns.class);
        CoreController coreController = requestHandler.getCoreController();
        Calendar calendar = Calendar.getInstance();
        this.logFile = new File(String.format("%s/GuiRequestLog/Requests_%04d-%02d-%02dT%02d-%02d-%02d.%03d.txt", coreController.isLiveOperation() ? coreController.getLogDirectory() : coreController.getUserConfigDirectory(), calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14)));
        this.logFile.getParentFile().mkdirs();
        this.handler = requestHandler;
        this.execution = closure;
    }

    public int getRowCount() {
        return this.dataQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, RequestTableColumns requestTableColumns) {
        if (n < 0) {
            return null;
        }
        RecordEntry recordEntry = null;
        List<RecordEntry> list = this.dataQueue;
        synchronized (list) {
            Iterator<RecordEntry> iterator = this.dataQueue.iterator();
            while (n >= 0) {
                if (!iterator.hasNext()) {
                    return null;
                }
                recordEntry = iterator.next();
                --n;
            }
        }
        if (recordEntry == null) {
            return null;
        }
        switch (requestTableColumns) {
            case DESCRIPTION: {
                return recordEntry.operation;
            }
            case STATUS: {
                return recordEntry.status;
            }
            case SOURCE: {
                return recordEntry.source;
            }
            case SCOPE: {
                return recordEntry.operation;
            }
            case HOST: {
                return recordEntry.operation.getData("host");
            }
        }
        return null;
    }

    public String getColumnName(RequestTableColumns requestTableColumns) {
        return requestTableColumns.getName();
    }

    public Class<?> getColumnClass(RequestTableColumns requestTableColumns) {
        return requestTableColumns.getType();
    }

    public void setStatus(TabbableStatus tabbableStatus) {
        this.status = tabbableStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void startNextCommand(boolean bl) {
        RecordEntry recordEntry;
        RequestedOperation requestedOperation;
        block11: {
            if (this.currentTasks.size() >= this.maxRunning) {
                return;
            }
            requestedOperation = null;
            List<RecordEntry> list = this.dataQueue;
            // MONITORENTER : list
            if (this.dataQueue.size() == 0) {
                // MONITOREXIT : list
                this.updateStatus();
                return;
            }
            recordEntry = this.dataQueue.get(0);
            if (recordEntry != null) break block11;
            this.updateStatus();
            return;
        }
        try {
            if (recordEntry.status.equals((Object)RequestStatus.ALLOWED)) {
                this.EventLogger.execute(new StartRequest(recordEntry.operation));
                recordEntry.status = RequestStatus.EXECUTED;
                requestedOperation = recordEntry.operation;
                Collections.sort(this.dataQueue);
                EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableDataChanged((AbstractEnumeratedTableModel)this));
            }
            // MONITOREXIT : list
            if (requestedOperation == null) return;
            this.handler.executeRequest(requestedOperation);
            this.execution.execute(requestedOperation);
            return;
        }
        finally {
            this.updateStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger requestForTask(Task task) {
        Object object = this.editLock;
        synchronized (object) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                RequestedOperation requestedOperation = (RequestedOperation)RequestedOperation.class.cast(this.getValueAt(i, RequestTableColumns.DESCRIPTION));
                if (!task.getId().equals((Object)requestedOperation.getTaskId())) continue;
                return requestedOperation.getId();
            }
        }
        return RequestedOperation.NO_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<RecordEntry> list = this.dataQueue;
        synchronized (list) {
            this.dataQueue.clear();
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableDataChanged((AbstractEnumeratedTableModel)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(RequestedOperation requestedOperation) {
        List<RecordEntry> list = this.dataQueue;
        synchronized (list) {
            RecordEntry recordEntry = new RecordEntry();
            recordEntry.operation = requestedOperation;
            recordEntry.source = requestedOperation.getSource();
            this.dataQueue.add(recordEntry);
            Collections.sort(this.dataQueue);
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableDataChanged((AbstractEnumeratedTableModel)this));
            this.EventLogger.execute(new NewRequest(requestedOperation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(RecordEntry recordEntry) {
        List<RecordEntry> list = this.dataQueue;
        synchronized (list) {
            int n = this.dataQueue.indexOf(recordEntry);
            if (n < 0) {
                return;
            }
            this.dataQueue.remove(n);
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsDeleted((AbstractEnumeratedTableModel)this, n, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doAction(BigInteger bigInteger, Predicate predicate, Closure closure) {
        boolean bl;
        RecordEntry recordEntry;
        block8: {
            recordEntry = null;
            try {
                List<RecordEntry> list = this.dataQueue;
                synchronized (list) {
                    for (RecordEntry recordEntry2 : this.dataQueue) {
                        if (!recordEntry2.operation.getId().equals(bigInteger)) continue;
                        recordEntry = recordEntry2;
                        boolean bl2 = true;
                        if (predicate != null) {
                            bl2 = predicate.evaluate((Object)recordEntry);
                        }
                        Collections.sort(this.dataQueue);
                        EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableDataChanged((AbstractEnumeratedTableModel)this));
                        bl = bl2;
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl16 : MonitorExitStatement: MONITOREXIT : var5_5
                        if (closure == null) return bl;
                        break block8;
                    }
                }
                if (closure == null) return false;
            }
            catch (Throwable throwable) {
                if (closure == null) throw throwable;
                closure.execute(recordEntry);
                throw throwable;
            }
            closure.execute(recordEntry);
            return false;
        }
        closure.execute((Object)recordEntry);
        return bl;
    }

    public boolean cancelledRequest(BigInteger bigInteger, final Object object) {
        return this.doAction(bigInteger, new Predicate(){

            public boolean evaluate(Object object2) {
                RecordEntry recordEntry = (RecordEntry)object2;
                if ((recordEntry.status.equals((Object)RequestStatus.PENDING) || recordEntry.status.equals((Object)RequestStatus.ALLOWED)) && (object == null || recordEntry.operation.getTag() == null || recordEntry.operation.getTag().equals(object))) {
                    RequestTableModel.this.EventLogger.execute(new CancelledRequest(recordEntry.operation));
                    recordEntry.allow = Boolean.FALSE;
                    recordEntry.status = RequestStatus.CANCELLED;
                    return true;
                }
                return false;
            }
        }, null);
    }

    public boolean enable(BigInteger bigInteger) {
        return this.doAction(bigInteger, new Predicate(){

            public boolean evaluate(Object object) {
                RecordEntry recordEntry = (RecordEntry)object;
                if (recordEntry.status.equals((Object)RequestStatus.PENDING)) {
                    RequestTableModel.this.EventLogger.execute(new EnabledRequest(recordEntry.operation));
                    recordEntry.allow = Boolean.TRUE;
                    recordEntry.status = RequestStatus.ALLOWED;
                    return true;
                }
                return false;
            }
        }, null);
    }

    public boolean force(BigInteger bigInteger) {
        return this.doAction(bigInteger, new Predicate(){

            public boolean evaluate(Object object) {
                RecordEntry recordEntry = (RecordEntry)object;
                if (recordEntry.status.equals((Object)RequestStatus.PENDING)) {
                    RequestTableModel.this.EventLogger.execute(new StartRequest(recordEntry.operation));
                    recordEntry.status = RequestStatus.EXECUTED;
                    return true;
                }
                return false;
            }
        }, new Closure(){

            public void execute(Object object) {
                if (object != null) {
                    RequestTableModel.this.handler.executeRequest(((RecordEntry)RecordEntry.class.cast((Object)object)).operation);
                    RequestTableModel.this.execution.execute((Object)((RecordEntry)RecordEntry.class.cast((Object)object)).operation);
                }
            }
        });
    }

    public boolean deniedRequest(BigInteger bigInteger) {
        return this.doAction(bigInteger, new Predicate(){

            public boolean evaluate(Object object) {
                RecordEntry recordEntry = (RecordEntry)object;
                if (recordEntry.status.equals((Object)RequestStatus.PENDING) || recordEntry.status.equals((Object)RequestStatus.ALLOWED)) {
                    RequestTableModel.this.EventLogger.execute(new DeniedRequest(recordEntry.operation));
                    recordEntry.allow = Boolean.FALSE;
                    recordEntry.status = RequestStatus.DENIED;
                    RequestTableModel.this.handler.fireDeniedRequest();
                    return true;
                }
                return false;
            }
        }, null);
    }

    public boolean executedRequest(BigInteger bigInteger) {
        return this.doAction(bigInteger, new Predicate(){

            public boolean evaluate(Object object) {
                RecordEntry recordEntry = (RecordEntry)object;
                if (recordEntry.status.equals((Object)RequestStatus.PENDING) || recordEntry.status.equals((Object)RequestStatus.ALLOWED)) {
                    RequestTableModel.this.EventLogger.execute(new ExecutedRequest(recordEntry.operation));
                    recordEntry.status = RequestStatus.EXECUTED;
                    RequestTableModel.this.handler.fireExecutedRequest();
                    return true;
                }
                return false;
            }
        }, null);
    }

    public void setMaximum(int n) {
        this.maximumShown = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecordEntry> getPending() {
        Vector<RecordEntry> vector = new Vector<RecordEntry>();
        List<RecordEntry> list = this.dataQueue;
        synchronized (list) {
            for (RecordEntry recordEntry : this.dataQueue) {
                if (!recordEntry.status.equals((Object)RequestStatus.PENDING)) continue;
                vector.add(recordEntry);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        List<RecordEntry> list = this.dataQueue;
        synchronized (list) {
            for (RecordEntry recordEntry : this.dataQueue) {
                if (!recordEntry.status.equals((Object)RequestStatus.PENDING) && !recordEntry.status.equals((Object)RequestStatus.ALLOWED)) continue;
                this.dataQueue.remove(recordEntry);
            }
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableDataChanged((AbstractEnumeratedTableModel)this));
        }
    }

    public void removeTask(TaskId taskId) {
        if (this.currentTasks.remove(taskId)) {
            this.updateStatus();
        }
    }

    public void addTask(TaskId taskId) {
        if (this.currentTasks.add(taskId)) {
            this.updateStatus();
        }
    }

    private void updateStatus() {
        if (this.status == null) {
            return;
        }
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    RequestTableModel.this.updateStatus();
                }
            });
            return;
        }
        BoundedRangeModel boundedRangeModel = this.status.getProgressModel();
        boundedRangeModel.setMinimum(0);
        boundedRangeModel.setMaximum(this.maxRunning);
        if (this.currentTasks.size() > this.maxRunning) {
            boundedRangeModel.setValue(this.maxRunning);
        } else {
            boundedRangeModel.setValue(this.currentTasks.size());
        }
    }

    public void setMaximumRunning(int n) {
        this.maxRunning = n;
    }

    static {
        HashSet<RequestStatus> hashSet = new HashSet<RequestStatus>();
        hashSet.add(RequestStatus.ALLOWED);
        ORDER.add(hashSet);
        hashSet = new HashSet();
        hashSet.add(RequestStatus.PENDING);
        ORDER.add(hashSet);
        hashSet = new HashSet();
        hashSet.add(RequestStatus.CANCELLED);
        hashSet.add(RequestStatus.DENIED);
        hashSet.add(RequestStatus.EXECUTED);
        ORDER.add(hashSet);
    }

    private class DeniedRequest
    extends RecordAction {
        RequestedOperation op;

        public DeniedRequest(RequestedOperation requestedOperation) {
            this.op = requestedOperation;
        }

        protected void recordItem(FileWriter fileWriter) throws IOException {
            fileWriter.write(String.format("Denied request: %d\n", this.op.getId()));
        }
    }

    private class ExecutedRequest
    extends RecordAction {
        RequestedOperation op;

        public ExecutedRequest(RequestedOperation requestedOperation) {
            this.op = requestedOperation;
        }

        protected void recordItem(FileWriter fileWriter) throws IOException {
            fileWriter.write(String.format("Executed request: %d\n", this.op.getId()));
        }
    }

    private class EnabledRequest
    extends RecordAction {
        RequestedOperation op;

        public EnabledRequest(RequestedOperation requestedOperation) {
            this.op = requestedOperation;
        }

        protected void recordItem(FileWriter fileWriter) throws IOException {
            fileWriter.write(String.format("Enabled request: %d\n", this.op.getId()));
        }
    }

    private class CancelledRequest
    extends RecordAction {
        RequestedOperation op;

        public CancelledRequest(RequestedOperation requestedOperation) {
            this.op = requestedOperation;
        }

        protected void recordItem(FileWriter fileWriter) throws IOException {
            fileWriter.write(String.format("Cancelled request: %d\n", this.op.getId()));
        }
    }

    private class NewRequest
    extends RecordAction {
        RequestedOperation op;

        public NewRequest(RequestedOperation requestedOperation) {
            this.op = requestedOperation;
        }

        protected void recordItem(FileWriter fileWriter) throws IOException {
            fileWriter.write(String.format("New Request:\n", this.op.getId()));
            Set<String> set = this.op.getDataKeys();
            int n = 10;
            for (String object : set) {
                n = Math.max(n, object.length());
            }
            String string = String.format("%%%ds : %%s\n", n + 4);
            fileWriter.write(String.format(string, "Id", this.op.getId().toString()));
            fileWriter.write(String.format(string, "Key", this.op.getKey()));
            for (String string2 : set) {
                fileWriter.write(String.format(string, string2, this.op.getData(string2)));
            }
            fileWriter.write(String.format(string, "Source", this.op.getSource()));
            fileWriter.write(String.format(string, "Display", DisplayTransformer.INSTANCE.transform(this.op)));
            fileWriter.write(String.format(string, "Command", CommandTransformer.INSTANCE.transform(this.op)));
        }
    }

    private class StartRequest
    extends RecordAction {
        RequestedOperation op;

        public StartRequest(RequestedOperation requestedOperation) {
            this.op = requestedOperation;
        }

        protected void recordItem(FileWriter fileWriter) throws IOException {
            fileWriter.write(String.format("Start request: %d\n", this.op.getId()));
        }
    }

    private abstract class RecordAction
    implements Runnable {
        private RecordAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                FileWriter fileWriter = new FileWriter(RequestTableModel.this.logFile, true);
                try {
                    this.recordItem(fileWriter);
                }
                finally {
                    fileWriter.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected abstract void recordItem(FileWriter var1) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RecordEntry
    implements Comparable<RecordEntry> {
        public Boolean allow = Boolean.FALSE;
        public RequestedOperation operation;
        public RequestStatus status = RequestStatus.PENDING;
        public String source = "";
        private Calendar created = Calendar.getInstance();

        @Override
        public int compareTo(RecordEntry recordEntry) {
            if (recordEntry.status != this.status) {
                for (Set set : ORDER) {
                    if (set.contains((Object)this.status) && !set.contains((Object)recordEntry.status)) {
                        return -1;
                    }
                    if (set.contains((Object)this.status) || !set.contains((Object)recordEntry.status)) continue;
                    return 1;
                }
            }
            return this.created.compareTo(recordEntry.created);
        }
    }
}

