/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.scripteditor;

import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.command.IdCallback;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.controller.DispatcherException;
import ddb.dsz.core.data.ClosureFactory;
import ddb.dsz.core.data.ClosureOrder;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.DataTransformer;
import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskDataAccess;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.core.task.TaskState;
import ddb.dsz.plugin.NoHostAbstractPlugin;
import ddb.dsz.plugin.scripteditor.Commands;
import ddb.dsz.plugin.scripteditor.DssDocument;
import ddb.dsz.plugin.scripteditor.ErrorEntry;
import ddb.dsz.plugin.scripteditor.ErrorTableColumns;
import ddb.dsz.plugin.scripteditor.ErrorTableModel;
import ddb.dsz.plugin.scripteditor.FocusOnTextArea;
import ddb.dsz.plugin.scripteditor.LineFocusMouseListener;
import ddb.dsz.plugin.scripteditor.NoAcceleratorMenuItem;
import ddb.dsz.plugin.scripteditor.jaxb.filelist.FileEntry;
import ddb.dsz.plugin.scripteditor.jaxb.filelist.FileList;
import ddb.dsz.plugin.scripteditor.jaxb.keywords.Keyword;
import ddb.dsz.plugin.scripteditor.jaxb.keywords.Keywords;
import ddb.dsz.plugin.scripteditor.jaxb.keywords.ObjectFactory;
import ddb.dsz.plugin.scripteditor.jaxb.styles.Style;
import ddb.dsz.plugin.scripteditor.jaxb.styles.Styles;
import ddb.gui.swing.DszTableCellRenderer;
import ddb.imagemanager.ImageManager;
import ddb.util.JaxbCache;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.undo.UndoableEdit;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.collections.Closure;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.SyntaxStyle;
import org.syntax.jedit.TextAreaDefaults;
import org.syntax.jedit.tokenmarker.DssTokenMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DszLive(live=true, replay=true)
@DszLogo(value="images/abiword_48.png")
@DszName(value="Script Editor")
@DszDescription(value="Provides a GUI interface for editing scripts")
public class ScriptEditor
extends NoHostAbstractPlugin {
    public static final String SyntaxStyle = "/ScriptEditor/styles.xml";
    public static final String DssKeywords = "/ScriptEditor/dssKeywords.xml";
    public static final String MRU = "ScriptEditor_mru.xml";
    public static final String OPEN_FILES = "ScriptEditor_open.xml";
    public static final String JAXB = "ddb.dsz.plugin.scripteditor.jaxb";
    public int MRU_MAX = 5;
    CaretListener caretListener = new CaretListener(){

        public void caretUpdate(CaretEvent caretEvent) {
            EditorPane editorPane = ScriptEditor.this.currentPane;
            if (editorPane != null) {
                int n = editorPane.textArea.getSelectionStart();
                int n2 = editorPane.textArea.getSelectionEnd();
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                n5 = editorPane.textArea.getLineOfOffset(n);
                n3 = n - editorPane.textArea.getLineStartOffset(n5);
                String string = editorPane.textArea.getLineText(n5);
                block3: for (int i = 0; i < n3 && i < string.length(); ++i) {
                    switch (string.charAt(i)) {
                        case '\t': {
                            n6 += 4;
                            continue block3;
                        }
                        default: {
                            ++n6;
                        }
                    }
                }
                if (n != n2) {
                    n4 = n2 - n;
                }
                if (n4 > 0) {
                    ScriptEditor.this.setStatus(String.format("Ln %-10d Col %-10d Ch %-10d Length %-10d", n5, n6, n3, n4));
                } else {
                    ScriptEditor.this.setStatus(String.format("Ln %-10d Col %-10d Ch %-10d", n5, n6, n3));
                }
            }
        }
    };
    private Commands[][] buildCommands = new Commands[][]{{Commands.Compile}};
    private Commands[][] editCommands = new Commands[][]{{Commands.Cut, Commands.Copy, Commands.Paste}, {Commands.Undo, Commands.Redo, Commands.Reload}};
    private Commands[][] fileCommands = new Commands[][]{{Commands.New, Commands.Open}, {Commands.Save, Commands.SaveAs, Commands.SaveAll}, {Commands.Close, Commands.CloseAll}, {Commands.RecentFiles}};
    private Commands[][] testCommands = new Commands[0][];
    private Commands[][] toolbarCommands = new Commands[][]{{Commands.New, Commands.Open, Commands.Save, Commands.SaveAs, Commands.Close}, {Commands.Cut, Commands.Copy, Commands.Paste, Commands.Undo, Commands.Redo, Commands.Reload}, {Commands.Compile}};
    JFileChooser chooser = null;
    File listenFile = null;
    ErrorTableModel model;
    JSplitPane splitPane;
    JToolBar toolBar;
    JTabbedPane tabbedFiles;
    List<EditorPane> fileList;
    EditorPane currentPane = null;
    int fileCounter = 0;
    String pendingRun = null;
    boolean compileRunning = false;
    private TextAreaDefaults textAreaDefaults;
    private Map<Object, Commands> buttonToCommand;
    ActionListener buttonClicked;
    List<FileEntry> mrulist = new Vector<FileEntry>();
    List<FileEntry> persistFiles = null;
    DataTransformer transformer = DataTransformer.newInstance();
    Task lastRun = null;
    int line = -1;
    File loadFile;

    public ErrorTableModel getModel() {
        return this.model;
    }

    public ScriptEditor() {
        super.setName("Script Editor");
    }

    protected int init2() {
        super.setCareAboutLocalEvents(true);
        if (this.transformer == null) {
            return -1;
        }
        this.transformer.addClosure(ClosureFactory.newVariableClosure((CoreController)this.core, (String)"script", (String)"Dsz", (Closure)new Closure(){

            public void execute(Object object) {
                ErrorEntry errorEntry;
                if (object == null || !(object instanceof DataEvent)) {
                    return;
                }
                DataEvent dataEvent = (DataEvent)object;
                for (ObjectValue objectValue : dataEvent.getData().getObjects("syntaxerror")) {
                    errorEntry = new ErrorEntry();
                    errorEntry.setLine(objectValue.getInteger("line"));
                    errorEntry.setText(objectValue.getString("error"));
                    ScriptEditor.this.model.addError(errorEntry);
                }
                for (ObjectValue objectValue : dataEvent.getData().getObjects("Error")) {
                    errorEntry = new ErrorEntry();
                    errorEntry.setText(objectValue.getString("error"));
                    ScriptEditor.this.model.addError(errorEntry);
                }
            }
        }));
        this.transformer.addClosure(new Closure(){

            public void execute(Object object) {
                if (object == null || !(object instanceof TaskDataAccess)) {
                    return;
                }
                TaskDataAccess taskDataAccess = (TaskDataAccess)object;
                Task task = taskDataAccess.getTask();
                if (task != null) {
                    if (TaskState.SUCCEEDED.equals((Object)task.getState())) {
                        ScriptEditor.this.model.setState(ErrorTableModel.EvaluationState.SUCCESS);
                    } else if (TaskState.FAILED.equals((Object)task.getState())) {
                        ScriptEditor.this.model.setState(ErrorTableModel.EvaluationState.FAILURE);
                    }
                    ScriptEditor.this.compileRunning = false;
                    ScriptEditor.this.updateToolbar();
                }
            }
        }, ClosureOrder.MIDDLE, TaskDataAccess.DataType.STATE);
        this.fileList = new ArrayList<EditorPane>();
        this.buttonClicked = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Commands commands = (Commands)((Object)ScriptEditor.this.buttonToCommand.get(actionEvent.getSource()));
                if (commands != null) {
                    ScriptEditor.this.performCommand(commands);
                }
            }
        };
        this.buttonToCommand = new Hashtable<Object, Commands>();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.tabbedFiles = new JTabbedPane();
        this.menuBar = new JMenuBar();
        this.toolBar = new JToolBar();
        this.buildMenu(this.fileCommands, "File");
        this.buildMenu(this.editCommands, "Edit");
        this.buildMenu(this.buildCommands, "Build");
        this.buildMenu(this.testCommands, "Test");
        this.buildToolBar(this.toolbarCommands);
        this.tabbedFiles.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ScriptEditor.this.currentPane = ScriptEditor.this.getEditorPaneByComponent(ScriptEditor.this.tabbedFiles.getSelectedComponent());
                ScriptEditor.this.updateToolbar();
            }
        });
        DropTarget dropTarget = new DropTarget(this.tabbedFiles, new DropTargetAdapter(){

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                try {
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (Object e : list) {
                        if (!(e instanceof File)) continue;
                        ScriptEditor.this.loadFile((File)File.class.cast(e), 0);
                    }
                }
                catch (Exception exception) {
                    ScriptEditor.this.core.logEvent(Level.WARNING, "DragAndDrop failure", (Throwable)exception);
                }
            }
        });
        this.tabbedFiles.setDropTarget(dropTarget);
        jPanel2.add((Component)this.toolBar, "North");
        jPanel2.add((Component)this.tabbedFiles, "Center");
        this.model = new ErrorTableModel();
        JTable jTable = new JTable((TableModel)((Object)this.model));
        jTable.getColumnModel().getColumn(ErrorTableColumns.LINE.ordinal()).setMaxWidth(60);
        jTable.getColumnModel().getColumn(ErrorTableColumns.FILE.ordinal()).setPreferredWidth(160);
        jTable.getColumnModel().getColumn(ErrorTableColumns.FILE.ordinal()).setMaxWidth(200);
        jTable.setDefaultRenderer(File.class, (TableCellRenderer)new DszTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JLabel && object instanceof File) {
                    JLabel jLabel = (JLabel)component;
                    File file = (File)object;
                    jLabel.setText(file.getName());
                }
                return component;
            }
        });
        jTable.addMouseListener(new LineFocusMouseListener(this, jTable));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setMinimumSize(new Dimension(0, 0));
        this.splitPane = new JSplitPane(0, jPanel2, jScrollPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.addComponentListener(new ComponentAdapter(){
            boolean shown = false;

            public void componentResized(ComponentEvent componentEvent) {
                if (!this.shown) {
                    ScriptEditor.this.splitPane.setDividerLocation(0.75);
                    ScriptEditor.this.splitPane.setLastDividerLocation(ScriptEditor.this.splitPane.getDividerLocation());
                    ScriptEditor.this.splitPane.setDividerLocation(1.0);
                    ScriptEditor.this.splitPane.removeComponentListener(this);
                    this.shown = true;
                }
            }
        });
        jPanel.add((Component)this.splitPane, "Center");
        super.setDisplay((JComponent)jPanel);
        this.loadStyle();
        this.loadKeywords();
        this.core.submit(new Runnable(){

            public void run() {
                ScriptEditor.this.loadFile(ScriptEditor.this.loadFile, ScriptEditor.this.line);
            }
        });
        this.mrulist.addAll(this.loadFileListFromDisk(MRU));
        List<FileEntry> list = this.loadFileListFromDisk(OPEN_FILES);
        for (FileEntry fileEntry : list) {
            this.LoadFileEntry(fileEntry);
        }
        return 0;
    }

    protected void commandEnded(CommandEvent commandEvent) {
        super.commandEnded(commandEvent);
        if (this.lastRun != null && this.lastRun.equals(this.core.getTaskById(commandEvent.getId()))) {
            this.compileRunning = false;
            if (this.lastRun.getState().equals((Object)TaskState.SUCCEEDED)) {
                this.model.setState(ErrorTableModel.EvaluationState.SUCCESS);
            } else {
                this.model.setState(ErrorTableModel.EvaluationState.FAILURE);
            }
            this.updateToolbar();
        }
    }

    void LoadFileEntry(FileEntry fileEntry) {
        JEditTextArea jEditTextArea;
        EditorPane editorPane = this.loadFile(new File(fileEntry.getName()), 0);
        if (editorPane != null && (jEditTextArea = editorPane.getTextArea()) != null) {
            jEditTextArea.setSelectionEnd(fileEntry.getSelectionStop());
            jEditTextArea.setSelectionStart(fileEntry.getSelectionStart());
        }
    }

    protected boolean parseArgument2(String string, String string2) {
        if (string.equalsIgnoreCase("-file") && string2 != null) {
            this.loadFile = new File(string2);
            return true;
        }
        if (string.equalsIgnoreCase("-line") && string2 != null) {
            try {
                this.line = Integer.parseInt(string2);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.core.logEvent(Level.WARNING, String.format("Invalid format: '%s'", string2), (Throwable)numberFormatException);
                return false;
            }
        }
        if (string.equalsIgnoreCase("-max") && string2 != null) {
            try {
                this.MRU_MAX = Integer.parseInt(string2);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.core.logEvent(Level.WARNING, String.format("Invalid format: '%s'", string2), (Throwable)numberFormatException);
                return false;
            }
        }
        return false;
    }

    private void setupActionMap() {
        for (final Commands commands : Commands.values()) {
            if (commands.stroke == null) continue;
            this.textAreaDefaults.inputHandler.addKeyBinding(commands.stroke, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ScriptEditor.this.validCommand(commands)) {
                        ScriptEditor.this.performCommand(commands);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EditorPane getEditorPaneByComponent(Component component) {
        if (component == null) {
            return null;
        }
        ScriptEditor scriptEditor = this;
        synchronized (scriptEditor) {
            for (EditorPane editorPane : this.fileList) {
                if (editorPane.getTextArea() != component) continue;
                return editorPane;
            }
        }
        return null;
    }

    private synchronized EditorPane makeNewEditorPane(File file) {
        EditorPane editorPane = new EditorPane(new JEditTextArea(this.textAreaDefaults), file, file == null ? (this.fileCounter = this.fileCounter + 1) : 0);
        this.tabbedFiles.add("NewFile", editorPane.getTextArea());
        this.fileList.add(editorPane);
        this.editorModified(editorPane);
        editorPane.getTextArea().addCaretListener(this.caretListener);
        return editorPane;
    }

    protected void fini2() {
        this.persistFiles = new Vector<FileEntry>();
        this.closeAll(false);
        this.commitFileListToDisk(this.mrulist, MRU);
        this.commitFileListToDisk(this.persistFiles, OPEN_FILES);
    }

    private List<FileEntry> loadFileListFromDisk(String string) {
        string = String.format("%s/%s", this.core.getUserConfigDirectory(), string);
        try {
            JAXBContext jAXBContext = JaxbCache.getContext(ddb.dsz.plugin.scripteditor.jaxb.filelist.ObjectFactory.class);
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            Object object = unmarshaller.unmarshal(new File(string));
            if (object instanceof JAXBElement) {
                object = ((JAXBElement)JAXBElement.class.cast(object)).getValue();
            }
            FileList fileList = null;
            if (object instanceof FileList) {
                fileList = (FileList)FileList.class.cast(object);
            }
            Vector<FileEntry> vector = new Vector<FileEntry>();
            for (Object object2 : fileList.getFileEntry()) {
                if (!(object2 instanceof FileEntry)) continue;
                vector.add((FileEntry)FileEntry.class.cast(object2));
            }
            return vector;
        }
        catch (Exception exception) {
            return new Vector<FileEntry>();
        }
    }

    private void commitFileListToDisk(List<FileEntry> list, String string) {
        string = String.format("%s/%s", this.core.getUserConfigDirectory(), string);
        FileList fileList = new FileList();
        for (FileEntry fileEntry : list) {
            fileList.getFileEntry().add(fileEntry);
        }
        try {
            FileEntry fileEntry;
            JAXBContext jAXBContext = JaxbCache.getContext(ddb.dsz.plugin.scripteditor.jaxb.filelist.ObjectFactory.class);
            fileEntry = jAXBContext.createMarshaller();
            ddb.dsz.plugin.scripteditor.jaxb.filelist.ObjectFactory objectFactory = new ddb.dsz.plugin.scripteditor.jaxb.filelist.ObjectFactory();
            fileEntry.setProperty("jaxb.formatted.output", Boolean.TRUE);
            FileWriter fileWriter = new FileWriter(string);
            fileEntry.marshal(objectFactory.createFileList(fileList), fileWriter);
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void buildMenu(Commands[][] commandsArray, String string) {
        if (commandsArray.length == 0) {
            return;
        }
        boolean bl = false;
        final JMenu jMenu = new JMenu(string);
        jMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuSelected(MenuEvent menuEvent) {
                Component[] componentArray = jMenu.getMenuComponents();
                if (componentArray == null) {
                    return;
                }
                for (Component component : componentArray) {
                    Commands commands = (Commands)((Object)ScriptEditor.this.buttonToCommand.get(component));
                    if (commands == null) continue;
                    component.setEnabled(ScriptEditor.this.validCommand(commands));
                }
            }
        });
        for (int i = 0; i < commandsArray.length; ++i) {
            if (bl) {
                jMenu.addSeparator();
                bl = false;
            }
            for (int j = 0; j < commandsArray[i].length; ++j) {
                JMenuItem jMenuItem;
                final Commands commands = commandsArray[i][j];
                if (commands.submenu) {
                    final JMenu jMenu2 = new JMenu(commands.text);
                    jMenuItem = jMenu2;
                    jMenu.addMenuListener(new MenuListener(){

                        public void menuCanceled(MenuEvent menuEvent) {
                        }

                        public void menuDeselected(MenuEvent menuEvent) {
                        }

                        public void menuSelected(MenuEvent menuEvent) {
                            ScriptEditor.this.setupMenu(commands, jMenu2);
                        }
                    });
                } else {
                    jMenuItem = new NoAcceleratorMenuItem(commands.text);
                    jMenuItem.addActionListener(this.buttonClicked);
                    jMenuItem.setAccelerator(commands.stroke);
                }
                this.buttonToCommand.put(jMenuItem, commands);
                if (commands.icon != null) {
                    jMenuItem.setIcon(ImageManager.getIcon((String)commands.icon, (Dimension)ImageManager.SIZE16));
                }
                jMenuItem.setMnemonic(commands.mnemonic);
                jMenuItem.setToolTipText(commands.description);
                jMenu.add(jMenuItem);
                bl = true;
            }
        }
        this.menuBar.add(jMenu);
    }

    void setupMenu(Commands commands, JMenu jMenu) {
        if (commands == Commands.RecentFiles) {
            jMenu.removeAll();
            jMenu.setEnabled(false);
            for (final FileEntry fileEntry : this.mrulist) {
                JMenuItem jMenuItem = new JMenuItem(fileEntry.getName());
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ScriptEditor.this.LoadFileEntry(fileEntry);
                    }
                });
                jMenu.add(jMenuItem);
            }
        }
    }

    private void buildToolBar(Commands[][] commandsArray) {
        boolean bl = false;
        for (int i = 0; i < commandsArray.length; ++i) {
            if (bl) {
                this.toolBar.addSeparator();
                bl = false;
            }
            for (int j = 0; j < commandsArray[i].length; ++j) {
                Commands commands = commandsArray[i][j];
                JButton jButton = new JButton();
                if (commands.icon == null) continue;
                jButton.setIcon(ImageManager.getIcon((String)commands.icon, (Dimension)ImageManager.SIZE22));
                jButton.setToolTipText(commands.description);
                jButton.addActionListener(this.buttonClicked);
                this.buttonToCommand.put(jButton, commands);
                this.toolBar.add(jButton);
                bl = true;
            }
        }
        this.updateToolbar();
    }

    public boolean closeAll(boolean bl) {
        while (this.fileList.size() > 0) {
            if (this.closeFile(bl)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeFileHelper(EditorPane editorPane, boolean bl) {
        if (editorPane == null) {
            return false;
        }
        if (editorPane.isModified()) {
            int n = JOptionPane.showConfirmDialog(this.parentDisplay, "Would you like to save the file?", String.format("%s Modified", editorPane.getFileName()), bl ? 1 : 0);
            switch (n) {
                case 0: {
                    if (this.saveHelper(editorPane)) break;
                    return false;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return false;
                }
            }
        }
        ScriptEditor scriptEditor = this;
        synchronized (scriptEditor) {
            FileEntry fileEntry = null;
            for (int i = 0; i < this.mrulist.size(); ++i) {
                if (!new File(this.mrulist.get(i).getName()).equals(editorPane.getFile())) continue;
                fileEntry = this.mrulist.get(i);
                this.mrulist.remove(i);
            }
            if (fileEntry == null) {
                fileEntry = new FileEntry();
                fileEntry.setName(editorPane.getFile().getAbsolutePath());
            }
            try {
                fileEntry.setName(new File(fileEntry.getName()).getCanonicalPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            fileEntry.setSelectionStart(editorPane.getTextArea().getSelectionStart());
            fileEntry.setSelectionStop(editorPane.getTextArea().getSelectionEnd());
            fileEntry.setTopLine(editorPane.getTextArea().getFirstLine());
            this.mrulist.add(0, fileEntry);
            if (this.persistFiles != null) {
                this.persistFiles.add(fileEntry);
            }
            while (this.mrulist.size() > this.MRU_MAX) {
                this.mrulist.remove(this.MRU_MAX);
            }
            int n = this.fileList.indexOf(editorPane);
            this.fileList.remove(editorPane);
            this.tabbedFiles.remove(editorPane.getTextArea());
            if (n >= this.fileList.size()) {
                n = this.fileList.size() - 1;
            }
            if (editorPane == this.currentPane) {
                if (n >= 0) {
                    this.currentPane = this.fileList.get(n);
                    this.setSelectedPane(this.currentPane);
                } else {
                    this.currentPane = null;
                }
            }
        }
        return true;
    }

    public boolean closeFile(boolean bl) {
        return this.closeFileHelper(this.currentPane, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileHelper(EditorPane editorPane) {
        if (editorPane == null) {
            return false;
        }
        Object object = this;
        synchronized (object) {
            if (this.compileRunning) {
                return false;
            }
            this.compileRunning = true;
        }
        this.model.setState(ErrorTableModel.EvaluationState.RUNNING);
        if (!this.save()) {
            this.compileRunning = false;
            this.model.setState(ErrorTableModel.EvaluationState.FAILURE);
            return false;
        }
        if (editorPane.getFile() == null) {
            this.compileRunning = false;
            this.model.setState(ErrorTableModel.EvaluationState.FAILURE);
            return false;
        }
        this.transformer.removeAllTasks();
        this.model.clear();
        this.pendingRun = null;
        this.listenFile = editorPane.getFile();
        object = String.format("script \"%s\" -verify", this.listenFile.getAbsolutePath());
        this.updateToolbar();
        try {
            this.core.startCommand((String)object, new IdCallback(){

                public void idAcquired(TaskId taskId, Object object) {
                    ScriptEditor.this.lastRun = ScriptEditor.this.core.getTaskById(taskId);
                    ScriptEditor.this.transformer.addTask(ScriptEditor.this.core.getTaskById(taskId));
                }
            }, null, this.core.getHostById("127.0.0.1"));
            this.splitPane.setDividerLocation(0.7);
        }
        catch (DispatcherException dispatcherException) {
            this.core.logEvent(Level.SEVERE, dispatcherException.getMessage(), (Throwable)dispatcherException);
            this.compileRunning = false;
            return false;
        }
        return true;
    }

    void maybeRun() {
        String string = this.pendingRun;
        this.pendingRun = null;
        if (string != null) {
            this.core.internalCommand(null, new String[]{"terminal-focus", string});
        }
        this.updateToolbar();
    }

    private boolean runHelper(EditorPane editorPane) {
        if (this.compileHelper(editorPane)) {
            this.pendingRun = String.format("script \"%s\"", editorPane.getFile().getAbsolutePath());
            return true;
        }
        return false;
    }

    public boolean compile() {
        return this.compileHelper(this.currentPane);
    }

    public boolean copy() {
        if (this.currentPane != null) {
            this.currentPane.copy();
        }
        return true;
    }

    public synchronized boolean cut() {
        if (this.currentPane != null) {
            this.currentPane.cut();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void focusOn(ErrorEntry errorEntry) {
        if (errorEntry.getFile() == null || errorEntry.getLine() == null) {
            return;
        }
        ScriptEditor scriptEditor = this;
        synchronized (scriptEditor) {
            for (EditorPane editorPane : this.fileList) {
                if (!errorEntry.getFile().equals(editorPane.getFile())) continue;
                this.setLine(editorPane, errorEntry.getLine().intValue());
                this.setSelectedPane(editorPane);
                return;
            }
            this.loadFile(errorEntry.getFile(), errorEntry.getLine().intValue());
        }
    }

    synchronized JFileChooser getChooser() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.setAcceptAllFileFilterUsed(true);
            this.chooser.setDragEnabled(true);
            this.chooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = file.getAbsolutePath();
                    return string.toLowerCase().matches("^.*\\.ds[si]$");
                }

                public String getDescription() {
                    return "DanderSpritz Scripts";
                }
            });
            this.chooser.setCurrentDirectory(new File(String.format("%s/%s/Scripts", this.core.getResourceDirectory(), this.core.getDefaultPackage())));
        }
        return this.chooser;
    }

    synchronized void setSelectedPane(EditorPane editorPane) {
        this.tabbedFiles.setSelectedComponent(editorPane.getTextArea());
        this.currentPane = editorPane;
        this.updateToolbar();
    }

    boolean loadInto(File file, EditorPane editorPane) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            FileReader fileReader = new FileReader(file);
            char[] cArray = new char[1028];
            int n = 0;
            while (n != -1) {
                n = fileReader.read(cArray);
                if (n <= 0) continue;
                stringBuilder.append(cArray, 0, n);
            }
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.core.logEvent(Level.WARNING, "Unable to find file", (Throwable)fileNotFoundException);
            return false;
        }
        catch (IOException iOException) {
            this.core.logEvent(Level.WARNING, "Unable to read file", (Throwable)iOException);
            return false;
        }
        if (file.getName().toLowerCase().endsWith(".dsi") || file.getName().toLowerCase().endsWith(".dss")) {
            editorPane.getTextArea().setTokenMarker(new DssTokenMarker());
        }
        editorPane.getTextArea().setText(stringBuilder.toString().replaceAll("\r\n", "\n"));
        editorPane.setModified(false);
        editorPane.getTextArea().requestFocusInWindow();
        this.setLine(editorPane, 0);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EditorPane loadFile(File file, int n) {
        EditorPane editorPane;
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        ScriptEditor scriptEditor = this;
        synchronized (scriptEditor) {
            for (EditorPane editorPane2 : this.fileList) {
                if (editorPane2.getFile() == null || !editorPane2.getFile().equals(file)) continue;
                this.setSelectedPane(editorPane2);
                return editorPane2;
            }
            editorPane = this.makeNewEditorPane(file);
            if (editorPane == null) {
                return null;
            }
        }
        this.loadInto(file, editorPane);
        for (FileEntry fileEntry : this.mrulist) {
            if (!editorPane.getFile().equals(new File(fileEntry.getName()))) continue;
            this.mrulist.remove(fileEntry);
            break;
        }
        this.setSelectedPane(editorPane);
        this.setLine(editorPane, n);
        EventQueue.invokeLater(new FocusOnTextArea(editorPane.getTextArea()));
        return editorPane;
    }

    protected void loadKeywords() {
        try {
            JAXBContext jAXBContext = JaxbCache.getContext(ObjectFactory.class);
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            Object object = unmarshaller.unmarshal(ScriptEditor.class.getResource(String.format(DssKeywords, new Object[0])));
            Keywords keywords = null;
            if (object instanceof JAXBElement) {
                JAXBElement jAXBElement = (JAXBElement)JAXBElement.class.cast(object);
                keywords = (Keywords)Keywords.class.cast(jAXBElement.getValue());
            } else {
                keywords = (Keywords)Keywords.class.cast(object);
            }
            if (keywords == null) {
                return;
            }
            for (Keyword keyword : keywords.getKeyword()) {
                DssTokenMarker.getKeywords().add(keyword.getValue(), Byte.decode(keyword.getType().toString()));
            }
        }
        catch (JAXBException jAXBException) {
            this.core.logEvent(Level.INFO, jAXBException.getMessage(), (Throwable)jAXBException);
        }
    }

    protected void loadStyle() {
        this.textAreaDefaults = TextAreaDefaults.getDefaults();
        this.setupActionMap();
        try {
            JAXBContext jAXBContext = JaxbCache.getContext(ddb.dsz.plugin.scripteditor.jaxb.styles.ObjectFactory.class);
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            Object object = unmarshaller.unmarshal(ScriptEditor.class.getResource(String.format(SyntaxStyle, new Object[0])));
            Styles styles = null;
            if (object instanceof JAXBElement) {
                JAXBElement jAXBElement = (JAXBElement)JAXBElement.class.cast(object);
                styles = (Styles)Styles.class.cast(jAXBElement.getValue());
            } else {
                styles = (Styles)Styles.class.cast(object);
            }
            if (styles == null) {
                return;
            }
            for (Style style : styles.getStyle()) {
                int n = style.getId().intValue();
                if (n <= 0 || n >= this.textAreaDefaults.styles.length) {
                    System.err.println(String.format("Invalid style id %d ", n));
                    continue;
                }
                Color color = Color.decode(Integer.decode(style.getForeground()).toString());
                if (color == null) {
                    System.err.println("Invalid style color");
                    continue;
                }
                this.textAreaDefaults.styles[n] = new SyntaxStyle(color, style.isItalics(), style.isBold());
            }
        }
        catch (JAXBException jAXBException) {
            this.core.logEvent(Level.INFO, jAXBException.getMessage(), (Throwable)jAXBException);
        }
    }

    public boolean newFile() {
        EditorPane editorPane = this.makeNewEditorPane(null);
        if (editorPane != null) {
            this.setSelectedPane(editorPane);
            EventQueue.invokeLater(new FocusOnTextArea(editorPane.getTextArea()));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        File file;
        JFileChooser jFileChooser;
        JFileChooser jFileChooser2 = jFileChooser = this.getChooser();
        synchronized (jFileChooser2) {
            if (jFileChooser.showOpenDialog(this.parentDisplay) != 0) {
                return false;
            }
            file = jFileChooser.getSelectedFile();
        }
        boolean bl = true;
        if (file != null && this.loadFile(file, 0) == null) {
            bl = false;
        }
        return bl;
    }

    public synchronized boolean paste() {
        if (this.currentPane != null) {
            this.currentPane.paste();
        }
        return true;
    }

    public synchronized boolean redo() {
        if (this.currentPane != null) {
            this.currentPane.redo();
        }
        return true;
    }

    private boolean reloadHelper(EditorPane editorPane) {
        if (editorPane == null) {
            return false;
        }
        if (editorPane.getFile() == null) {
            return false;
        }
        if (JOptionPane.showConfirmDialog(this.parentDisplay, "Are you sure you want to reload?") == 0) {
            this.loadInto(editorPane.getFile(), editorPane);
        }
        return true;
    }

    public synchronized boolean reload() {
        return this.reloadHelper(this.currentPane);
    }

    public synchronized boolean save() {
        return this.saveHelper(this.currentPane);
    }

    private boolean saveHelper(EditorPane editorPane) {
        if (editorPane == null) {
            return false;
        }
        if (editorPane.getFile() != null) {
            return this.saveTo(editorPane, editorPane.getFile());
        }
        return this.saveAsHelper(editorPane);
    }

    public synchronized boolean saveAll() {
        for (EditorPane editorPane : this.fileList) {
            if (this.saveHelper(editorPane)) continue;
            return false;
        }
        return true;
    }

    public boolean saveAs() {
        return this.saveAsHelper(this.currentPane);
    }

    private boolean saveAsHelper(EditorPane editorPane) {
        if (editorPane == null) {
            return false;
        }
        JFileChooser jFileChooser = this.getChooser();
        if (editorPane.getFile() != null) {
            jFileChooser.setSelectedFile(editorPane.getFile());
        }
        if (0 == jFileChooser.showSaveDialog(this.parentDisplay)) {
            return this.saveTo(editorPane, jFileChooser.getSelectedFile());
        }
        return false;
    }

    private boolean saveTo(EditorPane editorPane, File file) {
        try {
            PrintStream printStream = new PrintStream(file);
            for (int i = 0; i < editorPane.getTextArea().getLineCount(); ++i) {
                printStream.println(editorPane.getTextArea().getLineText(i).replaceAll("[\r\n]", ""));
            }
            printStream.close();
            editorPane.setFile(file);
            editorPane.setModified(false);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this.parentDisplay, String.format("Cannot create the %s file.\r\nMake sure that the path and filename are correct.", file.getName()), "Error saving file", 0);
            return this.saveAsHelper(editorPane);
        }
        catch (IOException iOException) {
            this.core.logEvent(Level.SEVERE, "Unable to save file", (Throwable)iOException);
            return false;
        }
    }

    private void setLine(EditorPane editorPane, int n) {
        int n2;
        if (editorPane == null) {
            return;
        }
        int n3 = 0;
        while (n > 1 && (n2 = editorPane.getTextArea().getText().indexOf("\n", n3)) != -1) {
            n3 = n2 + 1;
            --n;
        }
        if (n3 < editorPane.getTextArea().getText().length()) {
            editorPane.getTextArea().setCaretPosition(n3);
        } else {
            editorPane.getTextArea().setCaretPosition(editorPane.getTextArea().getText().length());
        }
    }

    public synchronized boolean undo() {
        if (this.currentPane != null) {
            this.currentPane.undo();
        }
        return true;
    }

    public synchronized void editorModified(EditorPane editorPane) {
        if (editorPane == null) {
            return;
        }
        int n = this.tabbedFiles.indexOfComponent(editorPane.getTextArea());
        if (n == -1) {
            System.err.println("Editor not found");
            return;
        }
        this.tabbedFiles.setTitleAt(n, editorPane.getTitle());
        this.updateToolbar();
    }

    protected boolean performCommand(Commands commands) {
        switch (commands) {
            case Close: {
                return this.closeFileHelper(this.currentPane, true);
            }
            case CloseAll: {
                return this.closeAll(true);
            }
            case Compile: {
                return this.compileHelper(this.currentPane);
            }
            case Copy: {
                return this.copy();
            }
            case Cut: {
                return this.cut();
            }
            case New: {
                return this.newFile();
            }
            case Open: {
                return this.open();
            }
            case Paste: {
                return this.paste();
            }
            case Redo: {
                return this.redo();
            }
            case Reload: {
                return this.reload();
            }
            case Save: {
                return this.save();
            }
            case SaveAll: {
                return this.saveAll();
            }
            case SaveAs: {
                return this.saveAs();
            }
            case Undo: {
                return this.undo();
            }
            case PreviousTab: {
                return this.tabAdjust(-1);
            }
            case NextTab: {
                return this.tabAdjust(1);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tabAdjust(int n) {
        ScriptEditor scriptEditor = this;
        synchronized (scriptEditor) {
            if (this.tabbedFiles.getTabCount() == 0) {
                return false;
            }
            int n2 = this.tabbedFiles.getSelectedIndex();
            int n3 = this.tabbedFiles.getTabCount();
            if ((n2 += n) >= n3) {
                n2 -= n3;
            }
            if (n2 < 0) {
                n2 += n3;
            }
            this.tabbedFiles.setSelectedIndex(n2);
        }
        return true;
    }

    protected synchronized boolean validCommand(Commands commands) {
        switch (commands) {
            case Close: 
            case Copy: 
            case Cut: 
            case Paste: 
            case Save: 
            case SaveAs: 
            case PreviousTab: 
            case NextTab: {
                return this.currentPane != null;
            }
            case Redo: {
                if (this.currentPane == null) {
                    return false;
                }
                return this.currentPane.isRedoAvailable();
            }
            case Undo: {
                if (this.currentPane == null) {
                    return false;
                }
                return this.currentPane.isUndoAvailable();
            }
            case Reload: {
                if (this.currentPane == null) {
                    return false;
                }
                return this.currentPane.isModified() && this.currentPane.getFile() != null;
            }
            case New: 
            case Open: {
                return true;
            }
            case RecentFiles: {
                return !this.mrulist.isEmpty();
            }
            case CloseAll: 
            case SaveAll: {
                return this.fileList.size() > 0;
            }
            case Compile: {
                if (this.currentPane == null) {
                    return false;
                }
                if (this.compileRunning) {
                    return false;
                }
                if (this.currentPane.getFile() == null) {
                    return true;
                }
                if (this.currentPane.getFile().getName().toLowerCase().endsWith(".dss")) {
                    return true;
                }
                return this.currentPane.getFile().getName().toLowerCase().endsWith(".dsi");
            }
        }
        return false;
    }

    protected void updateToolbar() {
        Component[] componentArray = this.toolBar.getComponents();
        if (componentArray == null) {
            return;
        }
        for (Component component : componentArray) {
            Commands commands = this.buttonToCommand.get(component);
            if (commands == null) continue;
            component.setEnabled(this.validCommand(commands));
        }
    }

    private final class EditorPane
    implements DocumentListener,
    UndoableEditListener {
        private static final int MAX_UNDO_SIZE = 200;
        JEditTextArea textArea;
        SyntaxDocument document;
        boolean modified;
        File file;
        int id;
        LinkedList<UndoableEdit> undos;
        LinkedList<UndoableEdit> redos;
        boolean undoEventHandle = false;

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public JEditTextArea getTextArea() {
            return this.textArea;
        }

        EditorPane(JEditTextArea jEditTextArea, File file, int n) {
            this.setTextArea(jEditTextArea);
            this.file = file;
            this.undos = new LinkedList();
            this.redos = new LinkedList();
            this.modified = false;
            this.id = n;
        }

        public synchronized void setTextArea(JEditTextArea jEditTextArea) {
            if (this.document != null) {
                this.document.removeDocumentListener(this);
                this.document.removeUndoableEditListener(this);
            }
            this.textArea = jEditTextArea;
            this.document = new DssDocument();
            this.textArea.setDocument(this.document);
            this.document.getDocumentProperties().put("tabSize", 4);
            this.document.addDocumentListener(this);
            this.document.addUndoableEditListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setModified(boolean bl) {
            EditorPane editorPane = this;
            synchronized (editorPane) {
                this.modified = bl;
                if (!bl) {
                    this.redos.clear();
                    this.undos.clear();
                }
            }
            ScriptEditor.this.editorModified(this);
        }

        boolean isModified() {
            return this.modified;
        }

        String getTitle() {
            return String.format("%s%s", this.getFileName(), this.modified ? "*" : "");
        }

        String getFileName() {
            if (this.file == null) {
                return String.format("NewFile%d", this.id);
            }
            return this.file.getName();
        }

        public String toString() {
            return this.getTitle();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.handleEvent(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.handleEvent(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.handleEvent(documentEvent);
        }

        public synchronized void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            UndoableEdit undoableEdit = undoableEditEvent.getEdit();
            if (undoableEdit.canUndo()) {
                this.undos.addLast(undoableEditEvent.getEdit());
                while (this.undos.size() > 200) {
                    this.undos.removeFirst();
                }
            } else {
                this.undos.clear();
            }
            ScriptEditor.this.updateToolbar();
        }

        private void handleEvent(DocumentEvent documentEvent) {
            if (documentEvent.getDocument().equals(this.document)) {
                this.setModified(true);
                if (!this.undoEventHandle) {
                    this.redos.clear();
                }
            }
        }

        public void cut() {
            this.textArea.cut();
        }

        public void copy() {
            this.textArea.copy();
        }

        public void paste() {
            this.textArea.paste();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undo() {
            EditorPane editorPane = this;
            synchronized (editorPane) {
                this.undoEventHandle = true;
                try {
                    if (this.undos.isEmpty()) {
                        return;
                    }
                    UndoableEdit undoableEdit = this.undos.removeLast();
                    if (undoableEdit.canUndo()) {
                        undoableEdit.undo();
                        this.redos.addLast(undoableEdit);
                    }
                }
                finally {
                    this.undoEventHandle = false;
                }
            }
            ScriptEditor.this.updateToolbar();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void redo() {
            EditorPane editorPane = this;
            synchronized (editorPane) {
                this.undoEventHandle = true;
                try {
                    if (this.redos.isEmpty()) {
                        return;
                    }
                    UndoableEdit undoableEdit = this.redos.removeLast();
                    if (undoableEdit.canRedo()) {
                        undoableEdit.redo();
                        this.undos.addLast(undoableEdit);
                    }
                }
                finally {
                    this.undoEventHandle = false;
                }
            }
            ScriptEditor.this.updateToolbar();
        }

        public synchronized boolean isRedoAvailable() {
            return this.redos.size() > 0;
        }

        public synchronized boolean isUndoAvailable() {
            return this.undos.size() > 0;
        }
    }
}

