/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.screenshot;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.screenshot.ImageData;
import ddb.dsz.plugin.screenshot.ImageDataRenderer;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.ImageObserver;
import java.io.File;
import java.util.Calendar;
import javax.imageio.ImageIO;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ScreenShotList
extends JPanel {
    public final ImageObserver observer = new ImageObserver(){

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            ScreenShotList.this.scale();
            return false;
        }
    };
    final DefaultListModel listOfFilesModel = new DefaultListModel();
    Image image;
    final CoreController core;
    boolean bDisabled;
    private JScrollPane jScrollPane1;
    private JList listOfFiles;
    private JLabel mainDisplay;

    public ScreenShotList(CoreController coreController) {
        this.initComponents();
        this.core = coreController;
        this.listOfFiles.setModel(this.listOfFilesModel);
        this.listOfFiles.setCellRenderer(ImageDataRenderer.Instance);
        this.mainDisplay.setBorder(null);
    }

    public synchronized void addFile(final File file, final Calendar calendar) {
        if (EventQueue.isDispatchThread()) {
            if (file.exists()) {
                ImageData imageData = new ImageData(file, calendar);
                for (int i = 0; i < this.listOfFilesModel.getSize(); ++i) {
                    if (imageData.time >= ((ImageData)ImageData.class.cast(this.listOfFilesModel.getElementAt((int)i))).time) continue;
                    this.listOfFilesModel.add(i, imageData);
                    return;
                }
                this.listOfFilesModel.addElement(imageData);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ScreenShotList.this.addFile(file, calendar);
                }
            });
        }
    }

    private void scale() {
        if (this.image == null) {
            this.bDisabled = false;
            this.mainDisplay.setIcon(null);
            return;
        }
        int n = this.image.getHeight(this.observer);
        int n2 = this.image.getWidth(this.observer);
        if (n == -1 || n2 == -1) {
            this.mainDisplay.setIcon(null);
            return;
        }
        Insets insets = new Insets(3, 3, 3, 3);
        int n3 = this.getWidth() - this.mainDisplay.getX();
        int n4 = this.getHeight() - this.mainDisplay.getY();
        double d = (double)(n3 -= insets.left + insets.right) / (double)n2;
        double d2 = (double)(n4 -= insets.top + insets.bottom) / (double)n;
        double d3 = Math.min(d, d2);
        if (d3 < 1.0) {
            n2 = (int)((double)n2 * d3);
            n = (int)((double)n * d3);
        }
        this.core.submit((Runnable)new ImageResizer(this.image, n, n2));
    }

    private void enableDisplay(boolean bl) {
        this.mainDisplay.setEnabled(bl);
        this.listOfFiles.setEnabled(bl);
    }

    private void initComponents() {
        this.mainDisplay = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.listOfFiles = new JList();
        this.mainDisplay.setBackground(new Color(204, 255, 204));
        this.mainDisplay.setHorizontalAlignment(0);
        this.mainDisplay.setText(" ");
        this.mainDisplay.setAlignmentX(0.5f);
        this.mainDisplay.setFocusable(false);
        this.mainDisplay.setHorizontalTextPosition(10);
        this.mainDisplay.setIconTextGap(0);
        this.mainDisplay.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ScreenShotList.this.mainDisplayComponentResized(componentEvent);
            }
        });
        this.listOfFiles.setModel(new AbstractListModel(){
            String[] strings = new String[]{"01:02:03", "99:00:11", "99:99:99"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.listOfFiles.setPrototypeCellValue("99:99:99");
        this.listOfFiles.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ScreenShotList.this.listOfFilesValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.listOfFiles);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 98, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainDisplay, -1, 475, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainDisplay, -1, 601, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 601, Short.MAX_VALUE));
    }

    private void mainDisplayComponentResized(ComponentEvent componentEvent) {
        if (this.bDisabled) {
            return;
        }
        if (this.image != null) {
            this.bDisabled = true;
            this.enableDisplay(false);
            this.scale();
        }
    }

    private void listOfFilesValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.enableDisplay(false);
        ImageData imageData = (ImageData)((JList)JList.class.cast(listSelectionEvent.getSource())).getSelectedValue();
        this.core.submit((Runnable)new ImageLoader(imageData.file));
        imageData.setViewed();
        this.bDisabled = true;
    }

    private class ImageResizer
    implements Runnable {
        final Image image;
        final int height;
        final int width;
        ImageIcon resized;

        public ImageResizer(Image image, int n, int n2) {
            this.image = image;
            this.height = n;
            this.width = n2;
        }

        public void run() {
            if (EventQueue.isDispatchThread()) {
                ScreenShotList.this.enableDisplay(true);
                ScreenShotList.this.bDisabled = false;
                ScreenShotList.this.mainDisplay.setIcon(this.resized);
            } else {
                this.resized = new ImageIcon(this.image.getScaledInstance(this.width, this.height, 4));
                EventQueue.invokeLater(this);
            }
        }
    }

    private class ImageLoader
    implements Runnable {
        final File file;
        Image localImage;

        public ImageLoader(File file) {
            this.file = file;
        }

        public void run() {
            if (EventQueue.isDispatchThread()) {
                ScreenShotList.this.image = this.localImage;
                ScreenShotList.this.scale();
            } else {
                try {
                    this.localImage = ImageIO.read(this.file);
                }
                catch (Exception exception) {
                    this.localImage = null;
                    exception.printStackTrace();
                }
                EventQueue.invokeLater(this);
            }
        }
    }
}

