/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.filemanager.ver3.search;

import ddb.dsz.core.contextmenu.CommandCallbackListener;
import ddb.dsz.core.contextmenu.ContextMenuAction;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.plugin.filemanager.ver3.FileManager;
import ddb.dsz.plugin.filemanager.ver3.FileManagerHost;
import ddb.dsz.plugin.filemanager.ver3.search.SearchParameters;
import ddb.dsz.plugin.filemanager.ver3.search.SearchResultColumns;
import ddb.dsz.plugin.filemanager.ver3.search.SearchResultModel;
import ddb.dsz.plugin.filemanager.ver3.search.Searcher;
import ddb.gui.swing.DszTableCellRenderer;
import ddb.targetmodel.TargetModel;
import ddb.targetmodel.TargetModelFactory;
import ddb.targetmodel.filemodel.FileObject;
import ddb.targetmodel.filemodel.FileSystemListener;
import ddb.util.tablefilter.sample.ColumnHidingModel;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.collections.Closure;

public class Search
extends FileManagerHost
implements FileSystemListener,
CommandCallbackListener,
ContextMenuAction {
    public static String SEARCH_ROOT = "-searchRoot";
    SearchParameters parameters;
    SearchResultModel resultsModel;
    JTable results = new JTable();
    Searcher searcher = null;
    ColumnHidingModel columnModel = new ColumnHidingModel(SearchResultColumns.class);
    Closure startSearching = new Closure(){

        public void execute(Object object) {
            if (Search.this.searcher != null) {
                if (Search.this.searcher.isRunning()) {
                    return;
                }
                Search.this.searcher = null;
            }
            Search.this.resultsModel.clear();
            Search.this.parameters.searchingStarted();
            SearchParameters searchParameters = (SearchParameters)object;
            Search.this.searcher = new Searcher(Search.this.model, Search.this, Search.this.onFinished, Search.this.addNode);
            if (!searchParameters.configure(Search.this.searcher)) {
                JOptionPane.showMessageDialog(searchParameters, "Unable to configure parser");
                Search.this.parameters.searchingStopped();
                return;
            }
            Thread thread = Search.this.core.newThread((Runnable)Search.this.searcher);
            thread.start();
            Search.this.status.setIndeterminate(true);
            Search.this.status.notifyObservers();
        }
    };
    Closure stopSearching = new Closure(){

        public void execute(Object object) {
            Searcher searcher = Search.this.searcher;
            if (searcher != null) {
                searcher.stop();
                return;
            }
        }
    };
    Closure onFinished = new Closure(){

        public void execute(Object object) {
            Search.this.parameters.searchingStopped();
            Search.this.status.setIndeterminate(false);
            Search.this.status.notifyObservers();
        }
    };
    Closure addNode = new Closure(){

        public void execute(Object object) {
            Search.this.resultsModel.addFile((FileObject)FileObject.class.cast(object));
        }
    };
    long searchRoot = -1L;
    JSplitPane searchDisplay2;

    public Search(HostInfo hostInfo, CoreController coreController, FileManager fileManager, long l) {
        super(hostInfo, coreController, fileManager);
        super.setName("Search");
        super.setShowButtons(false);
        this.results.setColumnModel((TableColumnModel)this.columnModel);
        this.columnModel.applyToTable(this.results);
        TargetModel targetModel = TargetModelFactory.getTargetModel((CoreController)coreController, (HostInfo)hostInfo);
        if (targetModel == null) {
            coreController.logEvent(Level.SEVERE, "Unable to get TargetModel");
            return;
        }
        this.model = targetModel.getFileSystemModel();
        if (this.model == null) {
            coreController.logEvent(Level.SEVERE, "Unable to get FileSystemModel");
            return;
        }
        this.setFileSystemModel(this.model);
        this.parameters = new SearchParameters(coreController.getHosts(), hostInfo);
        this.searchRoot = l;
        this.searchDisplay2 = new JSplitPane(1);
        super.setDisplay((JComponent)this.searchDisplay2);
        JScrollPane jScrollPane = new JScrollPane(this.parameters);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.searchDisplay2.setLeftComponent(jScrollPane);
        this.searchDisplay2.setRightComponent(new JScrollPane(this.results));
        this.searchDisplay2.setOneTouchExpandable(true);
        this.results.setDefaultRenderer(Calendar.class, (TableCellRenderer)new DszTableCellRenderer(){
            SimpleDateFormat format = new SimpleDateFormat("M/d/yyyy h:mm:ss a");

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JLabel && object instanceof Calendar) {
                    Calendar calendar = (Calendar)object;
                    JLabel jLabel = (JLabel)component;
                    jLabel.setText(this.format.format(calendar.getTime()));
                }
                return component;
            }
        });
        this.results.setDefaultRenderer(Integer.class, (TableCellRenderer)new DszTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JLabel && object instanceof Integer) {
                    Integer n3 = (Integer)object;
                    JLabel jLabel = (JLabel)component;
                    if (n3.equals(SearchResultModel.IS_DIR)) {
                        jLabel.setText("<DIR>");
                    }
                    jLabel.setHorizontalAlignment(4);
                }
                return component;
            }
        });
        this.results.setDefaultRenderer(FileObject.class, (TableCellRenderer)new DszTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JLabel && object instanceof FileObject) {
                    JLabel jLabel = (JLabel)component;
                    FileObject fileObject = (FileObject)object;
                    jLabel.setIcon(FileManagerHost.getIcon(fileObject.getIcon()));
                    jLabel.setText(fileObject.getName());
                }
                return component;
            }
        });
        this.results.setSelectionMode(2);
        this.results.addMouseListener(new MouseAdapter(){

            private boolean maybePopup(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    return false;
                }
                mouseEvent.consume();
                int n = mouseEvent.getY() / Search.this.results.getRowHeight();
                if (Search.this.results.getSelectionModel().isSelectedIndex(n)) {
                    ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                    for (int n2 : Search.this.results.getSelectedRows()) {
                        Object object = Search.this.resultsModel.getFileObjectAt(n2);
                        if (object instanceof FileObject) {
                            arrayList.add((FileObject)FileObject.class.cast(object));
                            continue;
                        }
                        if (!(object instanceof Integer)) continue;
                        arrayList2.add((Integer)Integer.class.cast(object));
                    }
                    Search.this.showPopup(mouseEvent, arrayList, arrayList2);
                } else if (n < Search.this.results.getRowCount()) {
                    Search.this.results.getSelectionModel().setSelectionInterval(n, n);
                    FileObject fileObject = (FileObject)Search.this.resultsModel.getValueAt(n, SearchResultColumns.Name);
                    Search.this.showPopup(mouseEvent, fileObject);
                }
                return true;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (this.maybePopup(mouseEvent)) {
                    return;
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }
        });
        if (this.model == null) {
            coreController.logEvent(Level.WARNING, "Unable to open search window");
            throw new RuntimeException("No model");
        }
        this.resultsModel = new SearchResultModel(this.model);
        this.results.setModel((TableModel)((Object)this.resultsModel));
        this.columnModel.hide((Enum)SearchResultColumns.Accessed);
        this.columnModel.hide((Enum)SearchResultColumns.Created);
        this.columnModel.hide((Enum)SearchResultColumns.Modified);
        for (FileObject fileObject : this.model.getDrives()) {
            this.parameters.addSearchRoot(fileObject, false);
        }
        if (this.searchRoot != -1L) {
            this.parameters.addSearchRoot(this.model.getSearchFile(Long.valueOf(this.searchRoot)), true);
        }
        this.parameters.setSearchActions(this.startSearching, this.stopSearching);
    }

    protected void modelChanged() {
    }

    public void setStatus(final String string) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Search.super.setStatus(string);
            }
        });
    }

    public boolean isVerifyClose() {
        return false;
    }
}

