/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertionOrderedSet<E>
implements Collection<E>,
Set<E>,
List<E> {
    private Class<? extends Set<E>> setImpl;
    private Class<? extends List<E>> listImpl;
    private Set<E> set = null;
    private List<E> list = null;

    public InsertionOrderedSet() {
        this(HashSet.class, ArrayList.class);
    }

    public InsertionOrderedSet(Class<? extends Set> clazz, Class<? extends List> clazz2) {
        this.setImpl = clazz;
        this.listImpl = clazz2;
        this.reset();
    }

    public boolean reset() {
        if (this.setImpl == null || this.listImpl == null) {
            return false;
        }
        try {
            this.set = this.setImpl.newInstance();
            this.list = this.listImpl.newInstance();
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return false;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            return false;
        }
    }

    public boolean isValid() {
        return this.set != null && this.list != null;
    }

    public void setSetClass(Class<? extends Set<E>> clazz) {
        this.setImpl = clazz;
    }

    public void setListClass(Class<? extends List<E>> clazz) {
        this.listImpl = clazz;
    }

    @Override
    public boolean add(E e) {
        if (this.set.add(e)) {
            if (this.list.add(e)) {
                return true;
            }
            this.set.remove(e);
        }
        return false;
    }

    @Override
    public void add(int n, E e) {
        if (this.set.add(e)) {
            this.list.add(n, e);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (E e : collection) {
            if (!this.set.add(e)) continue;
            arrayList.add(e);
        }
        this.list.addAll(arrayList);
        return !arrayList.isEmpty();
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (E e : collection) {
            if (!this.set.add(e)) continue;
            arrayList.add(e);
        }
        this.list.addAll(n, arrayList);
        return !arrayList.isEmpty();
    }

    @Override
    public void clear() {
        this.set.clear();
        this.list.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.set.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int n) {
        return this.list.get(n);
    }

    @Override
    public int indexOf(Object object) {
        if (!this.set.contains(object)) {
            return -1;
        }
        return this.list.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int lastIndexOf(Object object) {
        if (!this.set.contains(object)) {
            return -1;
        }
        return this.list.lastIndexOf(object);
    }

    @Override
    public boolean remove(Object object) {
        if (this.set.remove(object)) {
            return this.list.remove(object);
        }
        return false;
    }

    @Override
    public E remove(int n) {
        E e = this.list.remove(n);
        this.set.remove(e);
        return e;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            if (!this.remove(obj)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        int n = 0;
        while (n < this.list.size()) {
            E e = this.list.get(n);
            if (collection.contains(e)) {
                ++n;
                continue;
            }
            this.remove(e);
            bl = true;
        }
        return bl;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.list.toArray(TArray);
    }

    @Override
    public List<E> subList(int n, int n2) {
        return Collections.unmodifiableList(this.list.subList(n, n2));
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public E set(int n, E e) {
        if (n < 0 || n >= this.list.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.set.add(e)) {
            E e2 = this.list.get(n);
            this.set.remove(e2);
            this.list.set(n, e);
            return e2;
        }
        return null;
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return this.list.listIterator(n);
    }
}

