/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide;

import java.io.File;
import org.jvnet.flamingo.ide.FileReporter;

public class FileListener
extends Thread {
    private String filename;
    private boolean toStop;
    private FileReporter reporter;
    private long timestamp;

    public FileListener(String filename, FileReporter reporter) {
        this.filename = filename;
        this.reporter = reporter;
        this.toStop = false;
        this.timestamp = new File(filename).lastModified();
    }

    public synchronized void requestStop() {
        this.toStop = true;
    }

    private synchronized FileReporter.FileStatus iteration() {
        File file = new File(this.filename);
        if (file.exists()) {
            long currTimestamp = new File(this.filename).lastModified();
            if (this.timestamp != currTimestamp) {
                return FileReporter.FileStatus.MODIFIED;
            }
            return FileReporter.FileStatus.OK;
        }
        return FileReporter.FileStatus.DELETED;
    }

    public void run() {
        while (!this.toStop) {
            FileReporter.FileStatus status = this.iteration();
            if (status != FileReporter.FileStatus.OK) {
                this.toStop = false;
                this.reporter.contentsChanged(status);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

