/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide.gutter;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jvnet.flamingo.ide.BaseViewerPanel;
import org.jvnet.flamingo.ide.gutter.GutterPanel;
import org.jvnet.flamingo.ide.info.FileInfo;
import org.jvnet.flamingo.ide.util.IdeImageCreator;

public final class RelativeGutterPanel
extends GutterPanel {
    private final int scrollBarOffset;
    public static final BufferedImage ERROR_MARK = IdeImageCreator.getGutterMarker(Color.red, 10, 5);
    public static final BufferedImage WARNING_MARK = IdeImageCreator.getGutterMarker(Color.yellow, 10, 5);
    public static final BufferedImage INFO_MARK = IdeImageCreator.getGutterMarker(Color.blue, 10, 5);
    public static final BufferedImage STATUS_OK_IMAGE = IdeImageCreator.getGutterStatusImage(Color.green, 11);
    public static final BufferedImage STATUS_ERRORS_IMAGE = IdeImageCreator.getGutterStatusImage(Color.red, 11);
    public static final BufferedImage STATUS_WARNING_IMAGE = IdeImageCreator.getGutterStatusImage(Color.yellow, 11);

    public RelativeGutterPanel(BaseViewerPanel viewerPanel, int scrollBarOffset) {
        super(viewerPanel);
        this.scrollBarOffset = scrollBarOffset;
        this.addMouseListener(new GutterMouseListener(this));
    }

    protected final void paintComponent(Graphics g) {
        super.paintComponent(g);
        int height = this.getHeight();
        this.marks.clear();
        Collection<FileInfo.LineInfo> messageList = this.viewerPanel.getMessageList();
        if (messageList != null) {
            for (FileInfo.LineInfo line : messageList) {
                double relativePosition = this.viewerPanel.getTextPanel().getRelativeVerticalPosition(line.getLineNumber());
                int absolutePosition = this.scrollBarOffset + (int)(relativePosition * (double)(height - 2 * (this.scrollBarOffset - 1)));
                FileInfo.MessageKind highestSeverityKind = line.getHighestSeverity();
                BufferedImage marker = highestSeverityKind.getRelativeMarker();
                g.drawImage(marker, 0, absolutePosition, null);
                Rectangle markerRect = new Rectangle(1, absolutePosition, marker.getWidth(), marker.getHeight());
                this.marks.put(line, markerRect);
            }
        }
        HashSet<FileInfo.MessageKind> kinds = new HashSet<FileInfo.MessageKind>();
        if (messageList != null) {
            for (FileInfo.LineInfo info : messageList) {
                kinds.add(info.getHighestSeverity());
            }
        }
        BufferedImage statusImage = FileInfo.MessageKind.getHighestSeverity(kinds).getStatusMarker();
        g.drawImage(statusImage, 0, 1, null);
    }

    private static final class GutterMouseListener
    extends MouseAdapter {
        private final RelativeGutterPanel gutter;

        public GutterMouseListener(RelativeGutterPanel gutter) {
            this.gutter = gutter;
        }

        public final void mouseClicked(MouseEvent e) {
            Point mouseLocation = e.getPoint();
            for (Map.Entry marker : this.gutter.marks.entrySet()) {
                Rectangle rect = (Rectangle)marker.getValue();
                if (!rect.contains(mouseLocation)) continue;
                this.gutter.viewerPanel.scrollToLine(((FileInfo.LineInfo)marker.getKey()).getLineNumber());
                break;
            }
        }
    }
}

