/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide.info;

import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jvnet.flamingo.ide.gutter.RelativeGutterPanel;
import org.jvnet.flamingo.ide.util.IdeImageCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileInfo {
    private final String fileName;
    private final Map<Integer, LineInfo> messages;

    public FileInfo(String fileName) {
        this.fileName = fileName;
        this.messages = new HashMap<Integer, LineInfo>();
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final synchronized void addError(int line, String message) {
        if (!this.messages.containsKey(line)) {
            LineInfo newInfo = new LineInfo(line);
            this.messages.put(line, newInfo);
        }
        LineInfo ei = this.messages.get(line);
        ei.addMessage(MessageKind.ERROR, message);
    }

    public final synchronized void addWarning(int line, String message) {
        if (!this.messages.containsKey(line)) {
            LineInfo newInfo = new LineInfo(line);
            this.messages.put(line, newInfo);
        }
        LineInfo ei = this.messages.get(line);
        ei.addMessage(MessageKind.WARNING, message);
    }

    public final synchronized MessageInfo addMessage(int line, MessageKind kind, String message) {
        if (!this.messages.containsKey(line)) {
            LineInfo newInfo = new LineInfo(line);
            this.messages.put(line, newInfo);
        }
        LineInfo ei = this.messages.get(line);
        return ei.addMessage(kind, message);
    }

    public final synchronized Collection<LineInfo> getMessages() {
        return this.messages.values();
    }

    public final synchronized LineInfo getMessages(int lineNumber) {
        return this.messages.get(lineNumber);
    }

    public final MessageKind getHighestSeverity() {
        HashSet<MessageKind> kinds = new HashSet<MessageKind>();
        for (LineInfo info : this.messages.values()) {
            kinds.add(info.getHighestSeverity());
        }
        if (kinds.isEmpty()) {
            return MessageKind.SUCCESS;
        }
        return MessageKind.getHighestSeverity(kinds);
    }

    public final void remove(MessageInfo mInfo) {
        int lineNumber = mInfo.getLineNumber();
        LineInfo lInfo = this.messages.get(lineNumber);
        if (lInfo != null) {
            lInfo.messages.remove(mInfo);
            if (lInfo.messages.size() == 0) {
                this.messages.remove(lineNumber);
            }
        }
    }

    public void clearMessages(MessageKind kind) {
        if (kind == null) {
            this.messages.clear();
        } else {
            for (LineInfo lInfo : this.messages.values()) {
                Iterator it = lInfo.messages.iterator();
                while (it.hasNext()) {
                    MessageInfo mInfo = (MessageInfo)it.next();
                    if (mInfo.kind != kind) continue;
                    it.remove();
                }
            }
            Iterator<Map.Entry<Integer, LineInfo>> it = this.messages.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, LineInfo> eInfo = it.next();
                if (eInfo.getValue().messages.size() != 0) continue;
                it.remove();
            }
        }
    }

    public Map<Integer, MessageKind> getLineMap() {
        HashMap<Integer, MessageKind> result = new HashMap<Integer, MessageKind>();
        for (Map.Entry<Integer, LineInfo> entry : this.messages.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getHighestSeverity());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LineInfo {
        private final int lineNumber;
        private final List<MessageInfo> messages;

        public LineInfo(int lineNumber) {
            this.lineNumber = lineNumber;
            this.messages = new LinkedList<MessageInfo>();
        }

        public final List<MessageInfo> getMessages() {
            return this.messages;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        public final MessageInfo addMessage(MessageKind kind, String text) {
            MessageInfo newMessage = new MessageInfo(this.lineNumber, kind, text);
            this.messages.add(newMessage);
            return newMessage;
        }

        public final MessageKind getHighestSeverity() {
            HashSet<MessageKind> kinds = new HashSet<MessageKind>();
            for (MessageInfo info : this.messages) {
                kinds.add(info.getKind());
            }
            return MessageKind.getHighestSeverity(kinds);
        }
    }

    public static final class MessageInfo {
        private int lineNumber;
        private MessageKind kind;
        private String text;

        public MessageInfo(int lineNumber, MessageKind kind, String text) {
            this.lineNumber = lineNumber;
            this.kind = kind;
            this.text = text;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public MessageKind getKind() {
            return this.kind;
        }

        public String getText() {
            return this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageKind {
        ERROR(0){

            public BufferedImage getAbsoluteMarker(int dimension) {
                if (!absoluteErrorMarkers.containsKey(dimension)) {
                    BufferedImage newImage = IdeImageCreator.getErrorMarker(dimension);
                    absoluteErrorMarkers.put(dimension, newImage);
                }
                return (BufferedImage)absoluteErrorMarkers.get(dimension);
            }

            public BufferedImage getRelativeMarker() {
                return RelativeGutterPanel.ERROR_MARK;
            }

            public BufferedImage getStatusMarker() {
                return RelativeGutterPanel.STATUS_ERRORS_IMAGE;
            }
        }
        ,
        WARNING(1){

            public BufferedImage getAbsoluteMarker(int dimension) {
                if (!absoluteWarningMarkers.containsKey(dimension)) {
                    BufferedImage newImage = IdeImageCreator.getWarningMarker(dimension);
                    absoluteWarningMarkers.put(dimension, newImage);
                }
                return (BufferedImage)absoluteWarningMarkers.get(dimension);
            }

            public BufferedImage getRelativeMarker() {
                return RelativeGutterPanel.WARNING_MARK;
            }

            public BufferedImage getStatusMarker() {
                return RelativeGutterPanel.STATUS_WARNING_IMAGE;
            }
        }
        ,
        INFO(2){

            public BufferedImage getAbsoluteMarker(int dimension) {
                if (!absoluteInfoMarkers.containsKey(dimension)) {
                    BufferedImage newImage = IdeImageCreator.getInfoMarker(dimension);
                    absoluteInfoMarkers.put(dimension, newImage);
                }
                return (BufferedImage)absoluteInfoMarkers.get(dimension);
            }

            public BufferedImage getRelativeMarker() {
                return RelativeGutterPanel.INFO_MARK;
            }

            public BufferedImage getStatusMarker() {
                return RelativeGutterPanel.STATUS_OK_IMAGE;
            }
        }
        ,
        SUCCESS(3){

            public BufferedImage getAbsoluteMarker(int dimension) {
                if (!absoluteSuccessMarkers.containsKey(dimension)) {
                    BufferedImage newImage = IdeImageCreator.getSuccessMarker(dimension);
                    absoluteSuccessMarkers.put(dimension, newImage);
                }
                return (BufferedImage)absoluteSuccessMarkers.get(dimension);
            }

            public BufferedImage getRelativeMarker() {
                throw new UnsupportedOperationException();
            }

            public BufferedImage getStatusMarker() {
                return RelativeGutterPanel.STATUS_OK_IMAGE;
            }
        };

        private int severity;
        private static Map<Integer, BufferedImage> absoluteErrorMarkers;
        private static Map<Integer, BufferedImage> absoluteWarningMarkers;
        private static Map<Integer, BufferedImage> absoluteInfoMarkers;
        private static Map<Integer, BufferedImage> absoluteSuccessMarkers;

        private MessageKind(int severity) {
            this.severity = severity;
        }

        public abstract BufferedImage getAbsoluteMarker(int var1);

        public Icon getAbsoluteIconMarker(int dimension) {
            BufferedImage bi = this.getAbsoluteMarker(dimension);
            return new ImageIcon(bi);
        }

        public abstract BufferedImage getRelativeMarker();

        public abstract BufferedImage getStatusMarker();

        public static MessageKind getHighestSeverity(Set<MessageKind> kinds) {
            if (kinds.contains((Object)ERROR)) {
                return ERROR;
            }
            if (kinds.contains((Object)WARNING)) {
                return WARNING;
            }
            if (kinds.contains((Object)INFO)) {
                return INFO;
            }
            return SUCCESS;
        }

        public static int compare(MessageKind messageKind1, MessageKind messageKind2) {
            return messageKind1.severity - messageKind2.severity;
        }

        static {
            absoluteErrorMarkers = new HashMap<Integer, BufferedImage>();
            absoluteWarningMarkers = new HashMap<Integer, BufferedImage>();
            absoluteInfoMarkers = new HashMap<Integer, BufferedImage>();
            absoluteSuccessMarkers = new HashMap<Integer, BufferedImage>();
        }
    }
}

