/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide.java.jparser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jvnet.flamingo.ide.info.ElementLocation;
import org.jvnet.flamingo.ide.info.ElementLocationInfo;
import org.jvnet.flamingo.ide.info.ElementRange;
import org.jvnet.flamingo.ide.info.FileLocationInfo;
import org.jvnet.flamingo.ide.java.jparser.JavaElementLocationInfo;
import org.jvnet.flamingo.ide.link.LinkInfo;
import org.jvnet.flamingo.ide.link.LinkRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFileLocationInfo
extends FileLocationInfo {
    private Map<LinkInfo, List<ElementRange>> allSequences;
    private Map<Integer, Map<LinkInfo, List<ElementRange>>> sequencesMapping;
    private int prevTokenKind = -1;
    private StringBuffer currSequence = new StringBuffer();
    private ElementLocation currSequenceStart = null;
    private ElementLocation currSequenceEnd;
    private static Map<LinkInfo, List<ElementRange>> EMPTY_MAP = new HashMap<LinkInfo, List<ElementRange>>();

    public JavaFileLocationInfo() {
        this.allSequences = new HashMap<LinkInfo, List<ElementRange>>();
        this.sequencesMapping = new HashMap<Integer, Map<LinkInfo, List<ElementRange>>>();
    }

    private void clearBuffer() {
        this.currSequence.delete(0, this.currSequence.length());
    }

    private void checkSequence() {
        if (this.currSequence.length() > 0) {
            String seq = this.currSequence.toString();
            if (seq.endsWith(".")) {
                seq = seq.substring(0, seq.length() - 1);
                this.currSequenceEnd.decrementColumn();
            }
            ElementRange currSequenceRange = new ElementRange(this.currSequenceStart, this.currSequenceEnd);
            this.clearBuffer();
            LinkInfo linkInfo = LinkRepository.getHandle().getLinkInfo(seq);
            if (linkInfo == null) {
                return;
            }
            if (!this.allSequences.containsKey(linkInfo)) {
                this.allSequences.put(linkInfo, new LinkedList());
            }
            this.allSequences.get(linkInfo).add(currSequenceRange);
            if (currSequenceRange.getLineStart() != currSequenceRange.getLineEnd()) {
                throw new UnsupportedOperationException("Sequence range for " + seq + " is " + currSequenceRange.toString() + ", spans over multiple lines");
            }
            int lineNumber = currSequenceRange.getLineStart();
            if (!this.sequencesMapping.containsKey(lineNumber)) {
                this.sequencesMapping.put(lineNumber, new HashMap());
            }
            if (!this.sequencesMapping.get(lineNumber).containsKey(linkInfo)) {
                this.sequencesMapping.get(lineNumber).put(linkInfo, new LinkedList());
            }
            this.sequencesMapping.get(lineNumber).get(linkInfo).add(currSequenceRange);
        }
    }

    @Override
    public synchronized void addElementInfo(ElementLocationInfo info) {
        super.addElementInfo(info);
        JavaElementLocationInfo jinfo = (JavaElementLocationInfo)info;
        switch (jinfo.getElementKind()) {
            case 85: {
                if (this.prevTokenKind == 74) {
                    this.currSequence.append(jinfo.getElementImage());
                    this.currSequenceEnd = jinfo.getRange().getEnd();
                    break;
                }
                this.clearBuffer();
                break;
            }
            case 74: {
                if (this.prevTokenKind == 74) {
                    this.checkSequence();
                    this.clearBuffer();
                }
                if (this.currSequence.length() == 0) {
                    this.currSequenceStart = jinfo.getRange().getStart();
                }
                this.currSequence.append(jinfo.getElementImage());
                this.currSequenceEnd = jinfo.getRange().getEnd();
                break;
            }
            default: {
                this.checkSequence();
            }
        }
        this.prevTokenKind = jinfo.getElementKind();
    }

    public Map<LinkInfo, List<ElementRange>> getAllSequencesForLine(int lineNumber) {
        if (this.sequencesMapping.containsKey(lineNumber)) {
            return this.sequencesMapping.get(lineNumber);
        }
        return EMPTY_MAP;
    }
}

