/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jvnet.flamingo.ide.LocationParser;
import org.jvnet.flamingo.ide.info.ElementLocation;
import org.jvnet.flamingo.ide.info.ElementLocationInfo;
import org.jvnet.flamingo.ide.info.ElementRange;
import org.jvnet.flamingo.ide.info.FileLocationInfo;
import org.jvnet.flamingo.ide.xml.XmlElementKind;
import org.jvnet.flamingo.ide.xml.XmlElementLocationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlLocationParser
implements LocationParser {
    private static XMLInputFactory xmlif;
    private String[] xmlContents;
    private int prevLine;
    private int prevColumn;
    private int currLine;
    private int currColumn;
    private static final String LINE_SEPARATOR;
    private final Logger _logger = Logger.getLogger(XmlLocationParser.class.getName());

    private XmlLocationParser() {
    }

    public static synchronized XmlLocationParser newInstance() {
        if (xmlif == null) {
            if (System.getProperty("javax.xml.stream.XMLInputFactory") == null) {
                System.setProperty("javax.xml.stream.XMLInputFactory", "com.sun.xml.stream.ZephyrParserFactory");
            }
            xmlif = XMLInputFactory.newInstance();
            xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        }
        XmlLocationParser parser = new XmlLocationParser();
        return parser;
    }

    private List<ElementLocationInfo> getStartDocumentInfo() {
        LinkedList<ElementLocationInfo> result = new LinkedList<ElementLocationInfo>();
        if (this.currLine == 1 && this.currColumn == 1) {
            return result;
        }
        XmlElementLocationInfo info = new XmlElementLocationInfo(XmlElementKind.XML_HEADER, new ElementRange(0, 0, this.currLine - 1, this.currColumn - 1));
        result.add(info);
        return result;
    }

    private List<ElementLocationInfo> getCommentInfo(Comment cmEvent) {
        int startingColumn;
        LinkedList<ElementLocationInfo> result = new LinkedList<ElementLocationInfo>();
        if (this.currLine == 1 && this.currColumn == 1) {
            return result;
        }
        int startingLine = this.prevLine - 1;
        boolean isFound = false;
        for (startingColumn = this.prevColumn - 1; startingColumn > 0; --startingColumn) {
            if (this.xmlContents[startingLine].indexOf("<!--", startingColumn - 1) != startingColumn - 1) continue;
            isFound = true;
            break;
        }
        if (!isFound) {
            ++startingLine;
            while (startingLine <= this.currLine - 1) {
                int lastColumn;
                int n = lastColumn = startingLine == this.currLine - 1 ? this.xmlContents[startingLine].length() - 1 : this.currColumn - 1;
                for (startingColumn = 0; startingColumn < lastColumn; ++startingColumn) {
                    if (this.xmlContents[startingLine].indexOf("<!--", startingColumn - 1) != startingColumn - 1) continue;
                    isFound = true;
                    break;
                }
                if (!isFound) continue;
                break;
            }
        }
        if (!isFound) {
            throw new IllegalStateException("Unable to find the beginning of comment from [" + this.prevLine + ":" + this.prevColumn + "] to [" + this.currLine + ":" + this.currColumn + "]");
        }
        XmlElementLocationInfo info = new XmlElementLocationInfo(XmlElementKind.COMMENT, new ElementRange(startingLine - 1, startingColumn - 1, this.currLine - 1, this.currColumn - 1));
        result.add(info);
        return result;
    }

    private List<ElementLocationInfo> getCharactersInfo(LinkedList<Characters> chEventList) {
        LinkedList<ElementLocationInfo> result = new LinkedList<ElementLocationInfo>();
        if (this.currLine == 1 && this.currColumn == 1) {
            return result;
        }
        ElementConstructor ec = new ElementConstructor();
        ec.addLines(this.xmlContents, this.prevLine, this.prevColumn, this.currLine, this.currColumn);
        StringBuffer evStringBuffer = new StringBuffer();
        for (Characters chEvent : chEventList) {
            evStringBuffer.append(chEvent.getData());
        }
        String evString = evStringBuffer.toString();
        evString = evString.replace(LINE_SEPARATOR, " ");
        for (int i = 0; i < LINE_SEPARATOR.length(); ++i) {
            evString = evString.replace(LINE_SEPARATOR.charAt(i), ' ');
        }
        evString = evString.replace("&", "&amp;");
        evString = evString.replace("'", "&apos;");
        evString = evString.replace("\"", "&quot;");
        evString = evString.replace("<", "&lt;");
        if ((evString = evString.replace(">", "&gt;")).trim().length() == 0) {
            return result;
        }
        String ecString = ec.getElementString();
        int lineIndex = this.currLine;
        int columnIndex = this.currColumn;
        if (ecString.length() > evString.length()) {
            ElementLocation lastPosition;
            int indexOfLastNotNewline;
            for (indexOfLastNotNewline = evString.length() - 1; indexOfLastNotNewline >= 0 && (lastPosition = ec.getLocation(indexOfLastNotNewline)) == null; --indexOfLastNotNewline) {
            }
            if (indexOfLastNotNewline < 0) {
                throw new IllegalStateException("Can't find location for '" + evString + "'");
            }
            lastPosition = ec.getLocation(indexOfLastNotNewline);
            lineIndex = lastPosition.getLine() + 1;
            columnIndex = lastPosition.getColumn() + 1;
            if (this.xmlContents[this.currLine - 1].length() < columnIndex) {
                --columnIndex;
            }
        }
        if (ecString.endsWith("</")) {
            columnIndex -= 2;
        }
        XmlElementLocationInfo info = new XmlElementLocationInfo(XmlElementKind.CHARACTERS, new ElementRange(this.prevLine - 1, this.prevColumn - 1, lineIndex - 1, columnIndex - 1));
        result.add(info);
        return result;
    }

    private boolean isWhitespaceSequence(LinkedList<Characters> chEventList) {
        if (this.currLine == 1 && this.currColumn == 1) {
            return true;
        }
        ElementConstructor ec = new ElementConstructor();
        ec.addLines(this.xmlContents, this.prevLine, this.prevColumn, this.currLine, this.currColumn);
        StringBuffer evStringBuffer = new StringBuffer();
        for (Characters chEvent : chEventList) {
            evStringBuffer.append(chEvent.getData());
        }
        String evString = evStringBuffer.toString();
        evString = evString.replace(LINE_SEPARATOR, " ");
        for (int i = 0; i < LINE_SEPARATOR.length(); ++i) {
            evString = evString.replace(LINE_SEPARATOR.charAt(i), ' ');
        }
        return evString.trim().length() == 0;
    }

    private List<ElementLocationInfo> getStartElementInfo(StartElement seEvent) {
        String value;
        String key;
        QName aqName;
        LinkedList<ElementLocationInfo> result = new LinkedList<ElementLocationInfo>();
        ElementConstructor ec = new ElementConstructor();
        int currLineIndex = this.prevLine;
        int currColumnIndex = this.prevColumn;
        int endingColumn = this.currColumn - 1;
        while (this.xmlContents[this.currLine - 1].charAt(endingColumn - 1) != '>') {
            ++endingColumn;
        }
        ec.addLines(this.xmlContents, currLineIndex, currColumnIndex - 1, this.currLine, endingColumn);
        String ecString = ec.getElementString();
        int bracketLoc = ecString.indexOf(60);
        if (bracketLoc < 0) {
            throw new IllegalStateException("No opening bracket in '" + ecString + "'");
        }
        ElementLocation locStart = ec.getLocation(bracketLoc);
        XmlElementLocationInfo elStart = new XmlElementLocationInfo(XmlElementKind.BRACKET_START, new ElementRange(locStart, locStart));
        result.add(elStart);
        ElementLocation locEnd = ec.getLocation(ec.getElementString().length() - 1);
        XmlElementLocationInfo elEnd = new XmlElementLocationInfo(XmlElementKind.BRACKET_END, new ElementRange(locEnd, locEnd));
        result.add(elEnd);
        QName qName = seEvent.getName();
        String elemName = qName.getLocalPart();
        if (qName.getPrefix() != null && qName.getPrefix().length() > 0) {
            elemName = qName.getPrefix() + ":" + elemName;
        }
        if (!ec.getElementString().substring(bracketLoc + 1).startsWith(elemName)) {
            throw new IllegalStateException("Element '" + elemName + "' doesn't start with its name");
        }
        XmlElementLocationInfo elName = new XmlElementLocationInfo(XmlElementKind.ELEMENT_NAME, new ElementRange(ec.getLocation(bracketLoc + 1), ec.getLocation(bracketLoc + elemName.length())));
        result.add(elName);
        HashMap<String, String> allAttributes = new HashMap<String, String>();
        Iterator<Attribute> it = seEvent.getAttributes();
        while (it.hasNext()) {
            Attribute atEvent = it.next();
            aqName = atEvent.getName();
            key = aqName.getLocalPart();
            if (aqName.getPrefix().length() > 0) {
                key = aqName.getPrefix() + ":" + key;
            }
            value = atEvent.getValue();
            allAttributes.put(key, value);
        }
        it = seEvent.getNamespaces();
        while (it.hasNext()) {
            Namespace nsEvent = (Namespace)it.next();
            aqName = nsEvent.getName();
            key = aqName.getLocalPart();
            if (aqName.getPrefix().length() > 0) {
                key = key.length() > 0 ? aqName.getPrefix() + ":" + key : aqName.getPrefix();
            }
            value = nsEvent.getValue();
            allAttributes.put(key, value);
        }
        int startingIndex = bracketLoc + elemName.length() + 1;
        String attrString = ec.getElementString().substring(startingIndex, ec.getElementString().length() - 1);
        while (true) {
            int eqPos;
            if ((eqPos = attrString.indexOf(61)) < 0) {
                if (allAttributes.size() <= 0) break;
                throw new IllegalStateException("Unprocessed attributes left");
            }
            String attrName = attrString.substring(0, eqPos);
            String attrValue = (String)allAttributes.remove(attrName = attrName.trim());
            if (attrValue == null) {
                throw new IllegalStateException("No value for attribute '" + attrName + "'");
            }
            int openingQuotPos = attrString.indexOf(34, eqPos);
            if (openingQuotPos < 0) {
                throw new IllegalStateException("No opening quotation mark for  attribute '" + attrName + "' at line " + this.currLine);
            }
            int closingQuotPos = XmlLocationParser.getLocationAfter(attrValue, attrString, openingQuotPos + 1);
            if (closingQuotPos < 0) {
                throw new IllegalStateException("No attribute value '" + attrValue + "' found for '" + attrName + "' at line " + this.currLine);
            }
            int indAttrName = startingIndex + attrString.indexOf(attrName);
            XmlElementLocationInfo elAttrName = new XmlElementLocationInfo(XmlElementKind.ATTRIBUTE_NAME, new ElementRange(ec.getLocation(indAttrName), ec.getLocation(indAttrName + attrName.length() - 1)));
            result.add(elAttrName);
            XmlElementLocationInfo elEquals = new XmlElementLocationInfo(XmlElementKind.ATTRIBUTE_EQUAL, new ElementRange(ec.getLocation(startingIndex + eqPos), ec.getLocation(startingIndex + eqPos)));
            result.add(elEquals);
            XmlElementLocationInfo elQuotStart = new XmlElementLocationInfo(XmlElementKind.ATTRIBUTE_QUOTATION, new ElementRange(ec.getLocation(startingIndex + openingQuotPos), ec.getLocation(startingIndex + openingQuotPos)));
            result.add(elQuotStart);
            XmlElementLocationInfo elValue = new XmlElementLocationInfo(XmlElementKind.ATTRIBUTE_VALUE, new ElementRange(ec.getLocation(startingIndex + openingQuotPos + 1), ec.getLocation(startingIndex + closingQuotPos - 1)));
            result.add(elValue);
            XmlElementLocationInfo elQuotEnd = new XmlElementLocationInfo(XmlElementKind.ATTRIBUTE_QUOTATION, new ElementRange(ec.getLocation(startingIndex + closingQuotPos), ec.getLocation(startingIndex + closingQuotPos)));
            result.add(elQuotEnd);
            int totalLength = openingQuotPos + attrValue.length() + 2;
            startingIndex += totalLength;
            attrString = attrString.substring(totalLength);
        }
        return result;
    }

    private static int getLocationAfter(String strToSearchFor, String strToSearchIn, int startingIndex) {
        int currIndexInSearchIn = startingIndex;
        int currIndexInSearchFor = 0;
        block7: while (true) {
            if (currIndexInSearchFor == strToSearchFor.length()) {
                return currIndexInSearchIn;
            }
            char charToSearch = strToSearchFor.charAt(currIndexInSearchFor);
            if (charToSearch != '&' && charToSearch == strToSearchIn.charAt(currIndexInSearchIn)) {
                ++currIndexInSearchFor;
                ++currIndexInSearchIn;
                continue;
            }
            switch (charToSearch) {
                case '&': {
                    if (strToSearchIn.indexOf("&amp;", currIndexInSearchIn) != currIndexInSearchIn) break;
                    ++currIndexInSearchFor;
                    currIndexInSearchIn += 5;
                    continue block7;
                }
                case '<': {
                    if (strToSearchIn.indexOf("&lt;", currIndexInSearchIn) != currIndexInSearchIn) break;
                    ++currIndexInSearchFor;
                    currIndexInSearchIn += 4;
                    continue block7;
                }
                case '>': {
                    if (strToSearchIn.indexOf("&gt;", currIndexInSearchIn) != currIndexInSearchIn) break;
                    ++currIndexInSearchFor;
                    currIndexInSearchIn += 4;
                    continue block7;
                }
                case '\'': {
                    if (strToSearchIn.indexOf("&apos;", currIndexInSearchIn) != currIndexInSearchIn) break;
                    ++currIndexInSearchFor;
                    currIndexInSearchIn += 6;
                    continue block7;
                }
                case '\"': {
                    if (strToSearchIn.indexOf("&quot;", currIndexInSearchIn) != currIndexInSearchIn) break;
                    ++currIndexInSearchFor;
                    currIndexInSearchIn += 6;
                    continue block7;
                }
            }
            String hexa = XmlLocationParser.decimalToHex(charToSearch);
            if (strToSearchIn.indexOf("&#x", currIndexInSearchIn) == currIndexInSearchIn) {
                int endIndex = strToSearchIn.indexOf(";", currIndexInSearchIn);
                String hexaInSearchIn = strToSearchIn.substring(currIndexInSearchIn + 3, endIndex);
                while (hexaInSearchIn.startsWith("0")) {
                    hexaInSearchIn = hexaInSearchIn.substring(1);
                }
                if (hexa.equals(hexaInSearchIn)) {
                    ++currIndexInSearchFor;
                    currIndexInSearchIn = endIndex + 1;
                    continue;
                }
            }
            int unicode = Character.codePointAt(new char[]{strToSearchIn.charAt(currIndexInSearchIn)}, 0);
            String unicodeStr = "" + unicode;
            while (unicodeStr.length() < 4) {
                unicodeStr = "0" + unicodeStr;
            }
            unicodeStr = "\\u" + unicodeStr;
            if (strToSearchIn.indexOf(unicodeStr, currIndexInSearchIn) != currIndexInSearchIn) break;
            ++currIndexInSearchFor;
            currIndexInSearchIn += unicodeStr.length();
        }
        return -1;
    }

    private static String decimalToHex(int number) {
        String result = "";
        String hex = "0123456789ABCDEF";
        while (number > 0) {
            int lastDigit = number % 16;
            result = hex.charAt(lastDigit) + result;
            number /= 16;
        }
        return result;
    }

    private List<ElementLocationInfo> getEndElementInfo(EndElement eeEvent) {
        LinkedList<ElementLocationInfo> result = new LinkedList<ElementLocationInfo>();
        if (this.prevColumn == this.currColumn && this.prevLine == this.currLine) {
            int column = Math.min(this.xmlContents[this.currLine - 1].length() - 1, this.currColumn - 1);
            while (this.xmlContents[this.currLine - 1].charAt(column) != '/') {
                --column;
            }
            XmlElementLocationInfo elEnd = new XmlElementLocationInfo(XmlElementKind.BRACKET_END, new ElementRange(this.currLine - 1, column, this.currLine - 1, column));
            result.add(elEnd);
            return result;
        }
        ElementConstructor ec = new ElementConstructor();
        int currLineIndex = this.prevLine;
        int currColumnIndex = this.prevColumn;
        boolean isStartFound = true;
        String currLine = this.xmlContents[currLineIndex - 1];
        while (currLine.charAt(currColumnIndex - 1) != '<') {
            if (--currColumnIndex != 0) continue;
            isStartFound = false;
            break;
        }
        if (!isStartFound) {
            currColumnIndex = 1;
            while (currLine.charAt(currColumnIndex - 1) != '<') {
                if (++currColumnIndex != currLine.length()) continue;
                throw new IllegalStateException("Not found '<' anywhere in '" + currLine + "'");
            }
        }
        boolean isEndFound = true;
        int endingColumn = this.currColumn - 1;
        while (this.xmlContents[this.currLine - 1].charAt(endingColumn - 1) != '>') {
            if (++endingColumn <= currLine.length()) continue;
            isEndFound = false;
            break;
        }
        if (!isEndFound) {
            endingColumn = currLine.length();
            while (currLine.charAt(endingColumn - 1) != '>') {
                if (--endingColumn != 0) continue;
                throw new IllegalStateException("Not found '>' anywhere in '" + currLine + "'");
            }
        }
        if (endingColumn == 0) {
            throw new IllegalStateException("Ending column is 0");
        }
        this.currColumn = endingColumn;
        ec.addLines(this.xmlContents, currLineIndex, currColumnIndex, this.currLine, endingColumn);
        String ecString = ec.getElementString();
        int bracketLoc = ecString.indexOf("</");
        if (bracketLoc < 0) {
            throw new IllegalStateException("No opening bracket in '" + ecString + "'");
        }
        XmlElementLocationInfo elStart = new XmlElementLocationInfo(XmlElementKind.BRACKET_START, new ElementRange(ec.getLocation(bracketLoc), ec.getLocation(bracketLoc + 1)));
        result.add(elStart);
        ElementLocation locEnd = ec.getLocation(ec.getElementString().length() - 1);
        XmlElementLocationInfo elEnd = new XmlElementLocationInfo(XmlElementKind.BRACKET_END, new ElementRange(locEnd, locEnd));
        result.add(elEnd);
        QName qName = eeEvent.getName();
        String elemName = qName.getLocalPart();
        if (qName.getPrefix() != null && qName.getPrefix().length() > 0) {
            elemName = qName.getPrefix() + ":" + elemName;
        }
        if (!ec.getElementString().substring(bracketLoc + 2).startsWith(elemName)) {
            throw new IllegalStateException("Element doesn't start with its name");
        }
        XmlElementLocationInfo elName = new XmlElementLocationInfo(XmlElementKind.ELEMENT_NAME, new ElementRange(ec.getLocation(bracketLoc + 2), ec.getLocation(bracketLoc + 1 + elemName.length())));
        result.add(elName);
        return result;
    }

    @Override
    public FileLocationInfo getFileLocationInfo(InputStream stream) {
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                lines.addLast(line);
            }
            stream.reset();
            br.close();
        }
        catch (IOException ioe) {
            this._logger.info("Exception caught while trying to parse input file with StAX:");
            this._logger.info(ioe.getMessage());
            throw new IllegalArgumentException(ioe);
        }
        this.xmlContents = lines.toArray(new String[0]);
        this.prevColumn = -1;
        this.prevLine = -1;
        boolean isLastEventCharacters = false;
        try {
            XMLEventReader eventReader = xmlif.createXMLEventReader(stream);
            FileLocationInfo result = new FileLocationInfo();
            XMLEvent currEvent = null;
            boolean toMarkPreviousSpot = true;
            block13: while (eventReader.hasNext()) {
                currEvent = eventReader.nextEvent();
                toMarkPreviousSpot = true;
                Location loc = currEvent.getLocation();
                this.currLine = loc.getLineNumber();
                this.currColumn = loc.getColumnNumber();
                switch (currEvent.getEventType()) {
                    case 7: {
                        result.addElementInfo(this.getStartDocumentInfo());
                        break;
                    }
                    case 8: {
                        continue block13;
                    }
                    case 1: {
                        StartElement seEvent = (StartElement)currEvent;
                        result.addElementInfo(this.getStartElementInfo(seEvent));
                        break;
                    }
                    case 4: {
                        Characters chEvent = (Characters)currEvent;
                        --this.currColumn;
                        if (this.currColumn == 0) {
                            this.currColumn = 1;
                        }
                        LinkedList<Characters> charEvents = new LinkedList<Characters>();
                        charEvents.addFirst(chEvent);
                        result.addElementInfo(this.getCharactersInfo(charEvents));
                        break;
                    }
                    case 2: {
                        EndElement eeEvent = (EndElement)currEvent;
                        result.addElementInfo(this.getEndElementInfo(eeEvent));
                        break;
                    }
                    case 5: {
                        Comment cmEvent = (Comment)currEvent;
                        result.addElementInfo(this.getCommentInfo(cmEvent));
                    }
                }
                this.prevLine = this.currLine;
                this.prevColumn = this.currColumn;
            }
            return result;
        }
        catch (Exception e) {
            this._logger.info("Exception caught while trying to parse input file with StAX:");
            this._logger.info(e.getMessage());
            throw new IllegalArgumentException(e);
        }
    }

    public Map<Location, Integer> getElementLocations(Reader reader) {
        try {
            XMLEventReader eventReader = xmlif.createXMLEventReader(reader);
            HashMap<Location, Integer> result = new HashMap<Location, Integer>();
            int prevType = -1;
            while (eventReader.hasNext()) {
                XMLEvent currEvent = eventReader.nextEvent();
                int currType = currEvent.getEventType();
                boolean toAdd = true;
                result.put(new LocationImpl(currEvent), currType);
                prevType = currType;
            }
            return result;
        }
        catch (XMLStreamException xse) {
            this._logger.info("Exception caught while trying to parse input file with StAX:");
            this._logger.info(xse.getMessage());
            return null;
        }
    }

    public static String getEventAbbrev(int xmlEventType) {
        switch (xmlEventType) {
            case 4: {
                return "ch";
            }
            case 5: {
                return "cm";
            }
            case 8: {
                return "ed";
            }
            case 2: {
                return "ee";
            }
            case 7: {
                return "sd";
            }
            case 1: {
                return "se";
            }
        }
        return "";
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
    }

    public static class ElementConstructor {
        private StringBuffer element = new StringBuffer();
        private Map<Integer, ExtendedElementLocation> elementInfo = new HashMap<Integer, ExtendedElementLocation>();

        private void addNewLine() {
            this.element.append(' ');
            this.elementInfo.put(this.element.length() - 1, new ExtendedElementLocation(true, null));
        }

        private void addPart(String line, int lineIndex, int startColumn, int endColumn) {
            if (startColumn > endColumn) {
                if (this.element.length() != 0) {
                    throw new IllegalStateException("startColumn is " + startColumn + ", endColumn is " + endColumn + ", buffer should be empty");
                }
                this.element.append(' ');
                this.elementInfo.put(this.element.length() - 1, new ExtendedElementLocation(true, null));
                return;
            }
            if (!(this.element.length() <= 0 || this.element.length() == 1 && this.elementInfo.get(0).isLineBreak())) {
                this.element.append(' ');
                this.elementInfo.put(this.element.length() - 1, new ExtendedElementLocation(true, null));
            }
            for (int i = startColumn; i <= Math.min(endColumn, line.length() - 1); ++i) {
                this.element.append(line.charAt(i));
                this.elementInfo.put(this.element.length() - 1, new ExtendedElementLocation(false, new ElementLocation(lineIndex, i)));
            }
        }

        public void addLines(String[] lines, int startLine, int startColumn, int endLine, int endColumn) {
            if (--startLine < 0) {
                startLine = 0;
            }
            if (--startColumn < 0) {
                startColumn = 0;
            }
            if (--endLine < 0) {
                endLine = 0;
            }
            if (--endColumn < 0) {
                endColumn = 0;
            }
            if (startLine == endLine) {
                this.addPart(lines[startLine], startLine, startColumn, endColumn);
                return;
            }
            this.addPart(lines[startLine], startLine, startColumn, lines[startLine].length() - 1);
            for (int currentLine = startLine + 1; currentLine < endLine; ++currentLine) {
                if (lines[currentLine].length() == 0) {
                    this.addNewLine();
                    continue;
                }
                this.addPart(lines[currentLine], currentLine, 0, lines[currentLine].length() - 1);
            }
            this.addPart(lines[endLine], endLine, 0, endColumn);
        }

        public String getElementString() {
            return this.element.toString();
        }

        public ExtendedElementLocation getInfo(int elementColumnIndex) {
            return this.elementInfo.get(elementColumnIndex);
        }

        public ElementLocation getLocation(int elementColumnIndex) {
            return this.elementInfo.get(elementColumnIndex).getLocation();
        }
    }

    public static class ExtendedElementLocation {
        private boolean isLineBreak;
        private ElementLocation location;

        public ExtendedElementLocation(boolean lineBreak, ElementLocation location) {
            this.isLineBreak = lineBreak;
            this.location = location;
        }

        public boolean isLineBreak() {
            return this.isLineBreak;
        }

        public ElementLocation getLocation() {
            return this.location;
        }
    }

    public static class LocationImpl
    implements Location {
        private String publicId;
        private String systemId;
        private int lineNumber;
        private int columnNumber;
        private int characterOffset;

        public LocationImpl(XMLEvent event) {
            Location loc = event.getLocation();
            if (loc != null) {
                this.publicId = loc.getPublicId();
                this.systemId = loc.getSystemId();
                this.lineNumber = loc.getLineNumber();
                this.columnNumber = loc.getColumnNumber();
                this.characterOffset = loc.getCharacterOffset();
            }
        }

        public LocationImpl(String publicId, String systemId, int lineNumber, int columnNumber, int characterOffset) {
            this.publicId = publicId;
            this.systemId = systemId;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
            this.characterOffset = characterOffset;
        }

        public int getCharacterOffset() {
            return this.characterOffset;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }
    }
}

