/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.svg;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Icon;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.EventDispatcher;

public class SvgBatikIcon
extends UserAgentAdapter
implements Icon {
    protected BufferedImage bufferedImage;
    protected Map<String, BufferedImage> cachedImages = new HashMap<String, BufferedImage>();
    protected int width;
    protected int height;
    protected String uri;
    protected boolean needRender;
    protected Listener listener;
    protected List listeners;
    protected Renderer renderer;
    protected static ExecutorService executorService = Executors.newFixedThreadPool(10);
    static EventDispatcher.Dispatcher completedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((GVTTreeRendererListener)listener).gvtRenderingCompleted((GVTTreeRendererEvent)event);
        }
    };
    static EventDispatcher.Dispatcher startedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((GVTTreeRendererListener)listener).gvtRenderingStarted((GVTTreeRendererEvent)event);
        }
    };
    static EventDispatcher.Dispatcher failedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((GVTTreeRendererListener)listener).gvtRenderingFailed((GVTTreeRendererEvent)event);
        }
    };
    static EventDispatcher.Dispatcher cancelledDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((GVTTreeRendererListener)listener).gvtRenderingCancelled((GVTTreeRendererEvent)event);
        }
    };

    public SvgBatikIcon(String uri) {
        this(uri, 0, 0);
    }

    public SvgBatikIcon(String uri, int w, int h) {
        this.uri = uri;
        this.width = w;
        this.height = h;
        this.listeners = Collections.synchronizedList(new LinkedList());
        this.addGVTTreeRendererListener(new Listener());
        this.scheduleGVTRendering();
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.bufferedImage != null) {
            g.drawImage(this.bufferedImage, x, y, null);
        }
    }

    public Dimension2D getViewportSize() {
        return new Dimension(this.width, this.height);
    }

    public synchronized void setPreferredSize(Dimension dim) {
        this.width = dim.width;
        this.height = dim.height;
        this.scheduleGVTRendering();
    }

    public void fireEvent(EventDispatcher.Dispatcher dispatcher, Object event) {
        EventDispatcher.fireEvent((EventDispatcher.Dispatcher)dispatcher, (List)this.listeners, (Object)event, (boolean)true);
    }

    protected void scheduleGVTRendering() {
        if (this.renderer != null) {
            this.needRender = true;
        } else {
            this.renderGVTTree();
        }
    }

    protected boolean renderGVTTree() {
        String key = this.width + ":" + this.height;
        if (this.cachedImages.containsKey(key)) {
            this.bufferedImage = this.cachedImages.get(key);
            return true;
        }
        executorService.execute(new Renderer(new TranscoderInput(this.uri), this.width, this.height));
        return false;
    }

    public void addGVTTreeRendererListener(GVTTreeRendererListener l) {
        this.listeners.add(l);
    }

    public void removeGVTTreeRendererListener(GVTTreeRendererListener l) {
        this.listeners.remove(l);
    }

    protected class Listener
    implements GVTTreeRendererListener {
        protected Listener() {
        }

        public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
        }

        public void gvtRenderingStarted(GVTTreeRendererEvent e) {
        }

        public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
            SvgBatikIcon.this.renderer = null;
            if (SvgBatikIcon.this.needRender) {
                SvgBatikIcon.this.renderGVTTree();
                SvgBatikIcon.this.needRender = false;
            }
        }

        public void gvtRenderingCancelled(GVTTreeRendererEvent e) {
            this.renderingStopped();
        }

        public void gvtRenderingFailed(GVTTreeRendererEvent e) {
            this.renderingStopped();
        }

        private void renderingStopped() {
            SvgBatikIcon.this.renderer = null;
            if (SvgBatikIcon.this.needRender) {
                SvgBatikIcon.this.renderGVTTree();
                SvgBatikIcon.this.needRender = false;
            }
        }
    }

    protected class BufferedImageTranscoder
    extends ImageTranscoder {
        protected BufferedImage bufferedImage;

        protected BufferedImageTranscoder() {
        }

        public BufferedImage createImage(int width, int height) {
            return new BufferedImage(width, height, 2);
        }

        public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
            this.bufferedImage = img;
        }

        public BufferedImage getBufferedImage() {
            return this.bufferedImage;
        }

        public void setDimensions(int w, int h) {
            this.hints.put((Object)KEY_WIDTH, (Object)new Float(w));
            this.hints.put((Object)KEY_HEIGHT, (Object)new Float(h));
        }
    }

    protected class Renderer
    implements Runnable {
        TranscoderInput in;
        int width;
        int height;

        public Renderer(TranscoderInput in, int width, int height) {
            this.in = in;
            this.width = width;
            this.height = height;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            GVTTreeRendererEvent ev = new GVTTreeRendererEvent((Object)this, null);
            try {
                ev = new GVTTreeRendererEvent((Object)this, null);
                SvgBatikIcon.this.fireEvent(startedDispatcher, ev);
                BufferedImageTranscoder t = new BufferedImageTranscoder();
                if (this.width != 0 && this.height != 0) {
                    t.setDimensions(this.width, this.height);
                }
                t.transcode(this.in, null);
                SvgBatikIcon.this.bufferedImage = t.getBufferedImage();
                this.width = SvgBatikIcon.this.bufferedImage.getWidth();
                this.height = SvgBatikIcon.this.bufferedImage.getHeight();
                SvgBatikIcon svgBatikIcon = SvgBatikIcon.this;
                synchronized (svgBatikIcon) {
                    SvgBatikIcon.this.cachedImages.put(this.width + ":" + this.height, SvgBatikIcon.this.bufferedImage);
                }
                ev = new GVTTreeRendererEvent((Object)this, SvgBatikIcon.this.bufferedImage);
                SvgBatikIcon.this.fireEvent(completedDispatcher, ev);
            }
            catch (TranscoderException te) {
                SvgBatikIcon.this.fireEvent(failedDispatcher, ev);
            }
            catch (InterruptedBridgeException e) {
                SvgBatikIcon.this.fireEvent(cancelledDispatcher, ev);
            }
            catch (ThreadDeath td) {
                SvgBatikIcon.this.fireEvent(failedDispatcher, ev);
                throw td;
            }
            catch (Throwable t) {
                SvgBatikIcon.this.fireEvent(failedDispatcher, ev);
            }
        }
    }
}

