/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.svg;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.jvnet.flamingo.ribbon.JRibbonButton;
import org.jvnet.flamingo.svg.SvgBatikResizableIcon;
import org.jvnet.flamingo.svg.SvgTranscoder;
import org.jvnet.lafwidget.layout.TransitionLayoutManager;

public class SvgFileViewPanel
extends JPanel {
    protected ArrayList<JRibbonButton> allButtons;
    protected int currDimension;

    public SvgFileViewPanel(int startingDimension) {
        this.currDimension = startingDimension;
        this.allButtons = new ArrayList();
        this.setLayout(new SvgFileViewPanelLayout());
        TransitionLayoutManager.getInstance().track((Container)this, true);
    }

    public void setFolder(File folder) {
        File[] svgFiles;
        for (JRibbonButton rb : this.allButtons) {
            this.remove(rb);
        }
        this.allButtons.clear();
        for (final File svgFile : svgFiles = folder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".svg");
            }
        })) {
            try {
                JRibbonButton svgButton = new JRibbonButton(null, svgFile.getName().replace('-', ' '), new SvgBatikResizableIcon(svgFile.toURI().toURL(), new Dimension(this.currDimension, this.currDimension)), null);
                svgButton.setToolTipText("Click to generate Java2D class");
                svgButton.setActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            String svgClassName = svgFile.getName().substring(0, svgFile.getName().length() - 4);
                            svgClassName = svgClassName.replace('-', '_');
                            svgClassName = svgClassName.replace(' ', '_');
                            final String javaClassFilename = svgFile.getParent() + File.separator + svgClassName + ".java";
                            final PrintWriter pw = new PrintWriter(javaClassFilename);
                            SvgTranscoder transcoder = new SvgTranscoder(svgFile.toURI().toURL().toString(), svgClassName);
                            transcoder.setListener(new SvgTranscoder.TranscoderListener(){

                                public Writer getWriter() {
                                    return pw;
                                }

                                public void finished() {
                                    System.out.println("Finished with '" + javaClassFilename + "'");
                                }
                            });
                            transcoder.transcode();
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                        }
                    }
                });
                svgButton.updateCustomDimension(this.currDimension);
                this.allButtons.add(svgButton);
                this.add(svgButton);
            }
            catch (MalformedURLException murle) {
                // empty catch block
            }
        }
        this.doLayout();
        this.repaint();
    }

    public void setIconDimension(int dimension) {
        for (JRibbonButton rb : this.allButtons) {
            rb.updateCustomDimension(dimension);
            rb.revalidate();
            rb.doLayout();
        }
        this.revalidate();
        this.doLayout();
        this.repaint();
        this.currDimension = dimension;
    }

    protected class SvgFileViewPanelLayout
    implements LayoutManager {
        public static final int STRUT = 2;

        protected SvgFileViewPanelLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void layoutContainer(Container parent) {
            int top;
            Insets bInsets = SvgFileViewPanel.this.getInsets();
            int left = bInsets.left + 2;
            int right = bInsets.right + 2;
            int y = top = bInsets.top + 2;
            int maxButtonWidth = 0;
            int maxButtonHeight = 0;
            for (JRibbonButton gb : SvgFileViewPanel.this.allButtons) {
                maxButtonWidth = Math.max(maxButtonWidth, gb.getPreferredSize().width);
                maxButtonHeight = Math.max(maxButtonHeight, gb.getPreferredSize().height);
            }
            int currX = left;
            int maxWidth = parent.getWidth() - left - right;
            for (JRibbonButton gb : SvgFileViewPanel.this.allButtons) {
                int endX = currX + maxButtonWidth;
                if (endX > maxWidth - right) {
                    currX = left;
                    y += maxButtonHeight + 2;
                }
                gb.setBounds(currX, y, maxButtonWidth, maxButtonHeight);
                currX += maxButtonWidth;
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            if (SvgFileViewPanel.this.allButtons.size() == 0) {
                return new Dimension(0, 0);
            }
            Insets bInsets = SvgFileViewPanel.this.getInsets();
            int left = bInsets.left + 2;
            int right = bInsets.right + 2;
            int top = bInsets.top + 2;
            int bottom = bInsets.bottom + 2;
            int height = top + bottom;
            int maxButtonWidth = 0;
            int maxButtonHeight = 0;
            for (JRibbonButton gb : SvgFileViewPanel.this.allButtons) {
                maxButtonWidth = Math.max(maxButtonWidth, gb.getPreferredSize().width);
                maxButtonHeight = Math.max(maxButtonHeight, gb.getPreferredSize().height);
            }
            int maxWidth = parent.getWidth() - left - right;
            int buttonsInRow = maxWidth / maxButtonWidth;
            int iconRows = (int)Math.ceil((double)SvgFileViewPanel.this.allButtons.size() / (double)buttonsInRow);
            return new Dimension(maxWidth, height += iconRows * (maxButtonHeight + 2));
        }
    }
}

