/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.mirror;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.mirror.DirectoryScanner;
import ddb.dsz.plugin.mirror.FileInformation;
import ddb.dsz.plugin.mirror.TransferredFilesModel;
import ddb.dsz.plugin.mirror.jaxb.mirrorcomms.MirrorFileStatus;
import ddb.dsz.plugin.mirror.jaxb.mirrorcomms.ObjectFactory;
import ddb.util.JaxbCache;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class DirectoryStatus
extends DirectoryScanner {
    Marshaller marsh;
    ObjectFactory of;
    TransferredFilesModel model;

    public DirectoryStatus(CoreController coreController, TransferredFilesModel transferredFilesModel) throws JAXBException {
        super(coreController);
        JAXBContext jAXBContext = JaxbCache.getContext(ObjectFactory.class);
        this.marsh = jAXBContext.createMarshaller();
        this.of = new ObjectFactory();
        this.model = transferredFilesModel;
    }

    protected boolean handleFile(String string, File file) {
        MirrorFileStatus mirrorFileStatus = new MirrorFileStatus();
        mirrorFileStatus.setFile(string);
        mirrorFileStatus.setLength(BigInteger.valueOf(file.length()));
        StringWriter stringWriter = new StringWriter();
        try {
            this.marsh.marshal(this.of.createMirrorFileStatus(mirrorFileStatus), (Writer)stringWriter);
            this.core.sendMessageToPeer(stringWriter.toString());
            FileInformation fileInformation = this.model.getFileInformation(string);
            fileInformation.setSize(file.length());
            fileInformation.setSoFar(file.length());
            this.model.addOrUpdateRecord(fileInformation);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public void run() {
        try {
            this.scanDirectory(this.core.getLogDirectory(), "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

