/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.mirror;

import ddb.dsz.plugin.mirror.FileInformation;
import ddb.dsz.plugin.mirror.TransferredFiles;
import ddb.util.FrequentlyAppendedTableModel;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferredFilesModel
extends FrequentlyAppendedTableModel<TransferredFiles, FileInformation> {
    Map<String, FileInformation> pathToFileInfo = Collections.synchronizedMap(LazyMap.decorate(new Hashtable(), (Transformer)new Transformer(){

        public Object transform(Object object) {
            FileInformation fileInformation = new FileInformation();
            fileInformation.setName(object.toString());
            fileInformation.setSize(0L);
            fileInformation.setSoFar(0L);
            return fileInformation;
        }
    }));

    public TransferredFilesModel() {
        super(TransferredFiles.class);
    }

    public Object getValueAt(int n, TransferredFiles transferredFiles) {
        FileInformation fileInformation = (FileInformation)super.getRecord(n);
        if (fileInformation == null) {
            return null;
        }
        switch (transferredFiles) {
            case FILENAME: {
                return fileInformation.getName();
            }
            case SIZE: {
                return fileInformation.getSize();
            }
            case TODATE: {
                return fileInformation.getSoFar();
            }
        }
        return null;
    }

    public Class<?> getColumnClass(TransferredFiles transferredFiles) {
        return transferredFiles.getClazz();
    }

    public String getColumnName(TransferredFiles transferredFiles) {
        return transferredFiles.getCaption();
    }

    public FileInformation getFileInformation(String string) {
        return this.pathToFileInfo.get(string);
    }
}

