/*
 * Decompiled with CFR 0.152.
 */
package ddb.start;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import sun.misc.URLClassPath;

public class Start
extends JFrame {
    public static final String PATH_TOOLCHAIN = "java-j2se_1.6-sun";
    public static final String PATH_LIBRARY = "lib";
    public static final String OPERATION_DISK = "OpsDisk";
    public static final String RESOURCE_DIR = "ResourceDir";
    public static final String LOG_DIR = "LogDir";
    public static final String CONFIG_DIR = "ConfigDir";
    public static final String LOCAL_ADDRESS = "LocalAddress";
    public static final String BUILD_TYPE = "BuildType";
    public static final String GUI_TYPE = "GuiType";
    public static final String OPERATION_MODE = "OpMode";
    public static final String LOAD_PREVIOUS = "LoadPrevious";
    public static final String LOCAL_MODE = "LocalMode";
    public static final String JAVA_EXE = "java.exe";
    public static final String VMARGS = "vmargs";
    public static final String RES_DIR = "res.dir";
    public static final String DEBUGVMARGS = "vmargs.debug";
    public static final String CLASSPATH = "classpath.dirs";
    public static final String JAR_DIRS = "jar.dirs";
    public static final String LIVE_OPERATION = "live.operation";
    public static final String REPLAY_OPERATION = "replay.operation";
    public static final String WINDOWS_START = "windows.start";
    public static final String BUILD_RELEASE = "build.release";
    public static final String BUILD_DEBUG = "build.debug";
    public static final String BUILD_DEBUG_WINDOWS = "build.debug.windows";
    public static final String SHOW_OP_TYPE = "show.optype";
    public static final String SHOW_DEBUG_CORE = "show.debug.core";
    public static final String SHOW_DEBUG_GUI = "show.debug.gui";
    public static final String SHOW_LOCAL_MODE = "show.local.mode";
    public static final String SHOW_THREAD_DUMP = "show.thread.dump";
    public static final String WINDOWS = "windows";
    public static final String LINUX = "linux";
    public static final String PATH_VAR = "path.var";
    public static final String TOOL_CHAIN_STR = "tool.chain";
    public static final String PATH_SEP = "path.sep";
    public static final String THREAD_DUMP = "thread.dump";
    public static final String WAIT_FOR_OUTPUT = "wait.for.output";
    public static final String DSZ_KEYWORD = "DSZ_KEYWORD";
    public static final String LIVE_KEYWORD = String.format("live.%s", "DSZ_KEYWORD");
    public static final String REPLAY_KEYWORD = String.format("replay.%s", "DSZ_KEYWORD");
    public static final String DSZ_DEFAULT = "Default";
    static Properties prop = new Properties();
    static Properties userDefaults = new Properties();
    public static final String START_PROPERTIES = "start.properties";
    public static final String USER_DEFAULTS = "user.defaults";
    boolean guess = false;
    JFileChooser directoryFinder = null;
    private static char[] INVALIDCHARACTERS = new char[]{'\t', ' ', '\b', '\n', '\r'};
    File themeSearchRoot = null;
    DefaultComboBoxModel liveOperationThemes = new DefaultComboBoxModel();
    DefaultComboBoxModel replayOperationThemes = new DefaultComboBoxModel();
    JRadioButton buildDebug;
    JRadioButton buildRelease;
    JButton configurationBrowse;
    JTextField configurationField;
    JLabel configurationLabel;
    ButtonGroup coreBuild;
    JPanel corePanel;
    JButton goButton;
    ButtonGroup guiBuild;
    JRadioButton guiDebug;
    JPanel guiPanel;
    JRadioButton guiRelease;
    JPanel jPanel1;
    JPanel jPanel2;
    JRadioButton liveOption;
    JCheckBox loadPrevious;
    JTextField localCommsAddressField;
    JLabel localCommsAddressLabel;
    JCheckBox localMode;
    JButton logBrowse;
    JTextField logField;
    JLabel logLabel;
    JButton operationBrowse;
    JTextField operationField;
    JLabel operationLabel;
    JPanel operationPanel;
    ButtonGroup operationType;
    JPanel optionsPanel;
    JRadioButton replayOption;
    JButton resourceBrowse;
    JTextField resourceField;
    JLabel resourceLabel;
    JComboBox themeSelector;
    JCheckBox threadDump;
    JCheckBox waitFor;
    static final Pattern[] patterns = new Pattern[]{Pattern.compile("[0-9a-fA-F]{1,8}"), Pattern.compile("[Zz][0-2]{0,1}[0-9]{0,2}\\.[0-2]{0,1}[0-9]{0,2}\\.[0-2]{0,1}[0-9]{0,2}\\.[0-2]{0,1}[0-9]{0,2}")};
    private static FilenameFilter jars = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".jar");
        }
    };

    public Start() {
        try {
            this.directoryFinder = new JFileChooser();
            this.directoryFinder.setFileSelectionMode(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            prop.load(new FileInputStream(START_PROPERTIES));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.initComponents();
        try {
            userDefaults.load(new FileInputStream(USER_DEFAULTS));
            this.operationField.setText(Start.getStringDefault(OPERATION_DISK, ""));
            this.resourceField.setText(Start.getStringDefault(RESOURCE_DIR, ""));
            this.logField.setText(Start.getStringDefault(LOG_DIR, ""));
            this.configurationField.setText(Start.getStringDefault(CONFIG_DIR, ""));
            File file = new File(".");
            if (this.operationField.getText() == null || this.operationField.getText().length() == 0) {
                this.operationField.setText(file.getCanonicalPath());
            } else {
                file = new File(this.operationField.getText());
            }
            this.infer(file.getCanonicalFile());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.guess = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.guess = true;
        }
        if (this.guess) {
            this.infer(new File("."));
            this.examine();
        }
    }

    private void initComponents() {
        this.guiBuild = new ButtonGroup();
        this.operationType = new ButtonGroup();
        this.coreBuild = new ButtonGroup();
        this.resourceField = new JTextField();
        this.logField = new JTextField();
        this.configurationField = new JTextField();
        this.operationField = new JTextField();
        this.resourceLabel = new JLabel();
        this.logLabel = new JLabel();
        this.configurationLabel = new JLabel();
        this.operationLabel = new JLabel();
        this.resourceBrowse = new JButton();
        this.logBrowse = new JButton();
        this.configurationBrowse = new JButton();
        this.operationBrowse = new JButton();
        this.goButton = new JButton();
        this.localCommsAddressLabel = new JLabel();
        this.localCommsAddressField = new JTextField();
        this.jPanel1 = new JPanel();
        this.operationPanel = new JPanel();
        this.liveOption = new JRadioButton();
        this.replayOption = new JRadioButton();
        this.optionsPanel = new JPanel();
        this.loadPrevious = new JCheckBox();
        this.localMode = new JCheckBox();
        this.corePanel = new JPanel();
        this.buildDebug = new JRadioButton();
        this.buildRelease = new JRadioButton();
        this.guiPanel = new JPanel();
        this.guiRelease = new JRadioButton();
        this.guiDebug = new JRadioButton();
        this.waitFor = new JCheckBox();
        this.threadDump = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.themeSelector = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("DanderSpritz Operation Center");
        this.setCursor(new Cursor(0));
        this.setLocationByPlatform(true);
        this.setName("startFrame");
        this.setResizable(false);
        this.resourceField.setToolTipText(prop.getProperty("tooltip.resource"));
        this.resourceField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Start.this.enterPressed(keyEvent);
            }
        });
        this.logField.setToolTipText(prop.getProperty("tooltip.log"));
        this.logField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Start.this.enterPressed(keyEvent);
            }
        });
        this.configurationField.setToolTipText(prop.getProperty("tooltip.config"));
        this.configurationField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Start.this.enterPressed(keyEvent);
            }
        });
        this.operationField.setToolTipText(prop.getProperty("tooltip.disk"));
        this.operationField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Start.this.enterPressed(keyEvent);
            }
        });
        this.resourceLabel.setText(prop.getProperty("label.resource"));
        this.logLabel.setText(prop.getProperty("label.log"));
        this.configurationLabel.setText(prop.getProperty("label.config"));
        this.operationLabel.setText(prop.getProperty("label.disk"));
        this.resourceBrowse.setText(prop.getProperty("label.browse"));
        this.resourceBrowse.setToolTipText(prop.getProperty("tooltip.resource.browse"));
        this.resourceBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Start.this.resourceBrowseActionPerformed(actionEvent);
            }
        });
        this.logBrowse.setText(prop.getProperty("label.browse"));
        this.logBrowse.setToolTipText(prop.getProperty("tooltip.log.browse"));
        this.logBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Start.this.logBrowseActionPerformed(actionEvent);
            }
        });
        this.configurationBrowse.setText(prop.getProperty("label.browse"));
        this.configurationBrowse.setToolTipText(prop.getProperty("tooltip.config.browse"));
        this.configurationBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Start.this.configurationBrowseActionPerformed(actionEvent);
            }
        });
        this.operationBrowse.setText(prop.getProperty("label.browse"));
        this.operationBrowse.setToolTipText(prop.getProperty("tooltip.disk.browse"));
        this.operationBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Start.this.operationBrowseActionPerformed(actionEvent);
            }
        });
        this.goButton.setText(prop.getProperty("label.start"));
        this.goButton.setToolTipText(prop.getProperty("tooltip.start"));
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Start.this.goButtonActionPerformed(actionEvent);
            }
        });
        this.localCommsAddressLabel.setText(prop.getProperty("label.comms"));
        this.localCommsAddressField.setText("z0.0.0.1");
        this.localCommsAddressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Start.this.enterPressed(keyEvent);
            }
        });
        this.operationPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), prop.getProperty("label.opMode")));
        this.operationType.add(this.liveOption);
        this.liveOption.setSelected(true);
        this.liveOption.setText(prop.getProperty("label.live"));
        this.liveOption.setToolTipText(prop.getProperty("tooltip.live"));
        this.liveOption.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.liveOption.setMargin(new Insets(0, 0, 0, 0));
        this.liveOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Start.this.liveOptionActionPerformed(actionEvent);
            }
        });
        this.operationType.add(this.replayOption);
        this.replayOption.setText(prop.getProperty("label.replay"));
        this.replayOption.setToolTipText(prop.getProperty("tooltip.replay"));
        this.replayOption.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.replayOption.setMargin(new Insets(0, 0, 0, 0));
        this.replayOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Start.this.replayOptionActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.operationPanel);
        this.operationPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(1).add(groupLayout.createSequentialGroup().add(groupLayout.createParallelGroup(1).add(this.liveOption).add(this.replayOption)).addContainerGap(45, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(1).add(groupLayout.createSequentialGroup().add(this.liveOption).addPreferredGap(0).add(this.replayOption).addContainerGap(-1, Short.MAX_VALUE)));
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), prop.getProperty("label.options")));
        this.loadPrevious.setText(prop.getProperty("label.loadPrevious"));
        this.loadPrevious.setToolTipText(prop.getProperty("tooltip.loadPrevious"));
        this.loadPrevious.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.loadPrevious.setMargin(new Insets(0, 0, 0, 0));
        this.localMode.setText(prop.getProperty("label.localMode"));
        this.localMode.setToolTipText(prop.getProperty("tooltip.localMode"));
        this.localMode.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.localMode.setMargin(new Insets(0, 0, 0, 0));
        this.localMode.setVisible(this.isShowLocal());
        GroupLayout groupLayout2 = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(1).add(groupLayout2.createSequentialGroup().addContainerGap().add(groupLayout2.createParallelGroup(1).add(this.loadPrevious).add(this.localMode)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(1).add(groupLayout2.createSequentialGroup().add(this.loadPrevious).addPreferredGap(0).add(this.localMode).addContainerGap(-1, Short.MAX_VALUE)));
        this.corePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), prop.getProperty("label.core")));
        this.corePanel.setVisible(this.isShowDebugCore());
        this.coreBuild.add(this.buildDebug);
        this.buildDebug.setText(prop.getProperty("label.debug"));
        this.buildDebug.setToolTipText(prop.getProperty("tooltip.debug"));
        this.buildDebug.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buildDebug.setMargin(new Insets(0, 0, 0, 0));
        this.coreBuild.add(this.buildRelease);
        this.buildRelease.setSelected(true);
        this.buildRelease.setText(prop.getProperty("label.release"));
        this.buildRelease.setToolTipText(prop.getProperty("tooltip.release"));
        this.buildRelease.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buildRelease.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout3 = new GroupLayout(this.corePanel);
        this.corePanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(1).add(groupLayout3.createSequentialGroup().addContainerGap().add(groupLayout3.createParallelGroup(1).add(this.buildRelease).add(this.buildDebug)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(1).add(groupLayout3.createSequentialGroup().add(this.buildRelease).addPreferredGap(0).add(this.buildDebug).addContainerGap(-1, Short.MAX_VALUE)));
        this.guiPanel.setBorder(BorderFactory.createTitledBorder(prop.getProperty("label.gui")));
        this.guiPanel.setVisible(this.isShowDebugGui());
        this.guiBuild.add(this.guiRelease);
        this.guiRelease.setText(prop.getProperty("label.release"));
        this.guiRelease.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.guiRelease.setMargin(new Insets(0, 0, 0, 0));
        this.guiBuild.add(this.guiDebug);
        this.guiDebug.setText(prop.getProperty("label.debug"));
        this.guiDebug.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.guiDebug.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout4 = new GroupLayout(this.guiPanel);
        this.guiPanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(1).add(groupLayout4.createSequentialGroup().addContainerGap().add(groupLayout4.createParallelGroup(1).add(this.guiRelease).add(this.guiDebug)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(1).add(groupLayout4.createSequentialGroup().add(this.guiRelease).addPreferredGap(0).add(this.guiDebug).addContainerGap(-1, Short.MAX_VALUE)));
        this.waitFor.setText("Wait For Output");
        this.waitFor.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.waitFor.setMargin(new Insets(0, 0, 0, 0));
        this.waitFor.setVisible(false);
        this.threadDump.setText("Thread Dump");
        this.threadDump.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.threadDump.setMargin(new Insets(0, 0, 0, 0));
        this.threadDump.setVisible(this.isShowThreadDump());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Theme"));
        this.themeSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout groupLayout5 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(1).add(groupLayout5.createSequentialGroup().addContainerGap().add(this.themeSelector, 0, 179, Short.MAX_VALUE).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(1).add(groupLayout5.createSequentialGroup().add(this.themeSelector, -2, -1, -2).addContainerGap(25, Short.MAX_VALUE)));
        GroupLayout groupLayout6 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(1).add(groupLayout6.createSequentialGroup().addContainerGap().add(this.operationPanel, -2, -1, -2).addPreferredGap(0).add(this.optionsPanel, -2, -1, -2).addPreferredGap(0).add(this.corePanel, -2, -1, -2).addPreferredGap(0).add(this.guiPanel, -2, -1, -2).addPreferredGap(0).add(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(groupLayout6.createParallelGroup(1, false).add(this.threadDump, -1, -1, Short.MAX_VALUE).add(this.waitFor)).addContainerGap()));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(1).add(groupLayout6.createSequentialGroup().addContainerGap().add(groupLayout6.createParallelGroup(1).add(groupLayout6.createSequentialGroup().add(this.threadDump).addPreferredGap(0).add(this.waitFor)).add(2, this.jPanel2, -1, -1, Short.MAX_VALUE).add(this.operationPanel, -1, -1, Short.MAX_VALUE).add(this.optionsPanel, -1, -1, Short.MAX_VALUE).add(this.corePanel, -1, -1, Short.MAX_VALUE).add(this.guiPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout groupLayout7 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(1).add(groupLayout7.createSequentialGroup().addContainerGap().add(groupLayout7.createParallelGroup(1).add(groupLayout7.createSequentialGroup().add(groupLayout7.createParallelGroup(1).add(groupLayout7.createSequentialGroup().add(groupLayout7.createParallelGroup(1).add(this.resourceLabel).add(this.logLabel).add(this.configurationLabel)).addPreferredGap(0).add(groupLayout7.createParallelGroup(1).add(this.configurationField, -1, 771, Short.MAX_VALUE).add(this.operationField, -1, 771, Short.MAX_VALUE).add(this.logField, -1, 771, Short.MAX_VALUE).add(2, this.resourceField, -1, 771, Short.MAX_VALUE).add(this.localCommsAddressField, -1, 771, Short.MAX_VALUE)).add(6, 6, 6)).add(groupLayout7.createSequentialGroup().add(this.operationLabel).addPreferredGap(0, 775, Short.MAX_VALUE))).addPreferredGap(0).add(groupLayout7.createParallelGroup(2).add(groupLayout7.createParallelGroup(1).add(this.resourceBrowse).add(this.logBrowse).add(this.configurationBrowse)).add(this.operationBrowse))).add(this.localCommsAddressLabel).add(groupLayout7.createSequentialGroup().add(this.jPanel1, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.goButton))).addContainerGap()));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(1).add(groupLayout7.createSequentialGroup().addContainerGap().add(groupLayout7.createParallelGroup(3).add(this.operationLabel).add(this.operationBrowse).add(this.operationField, -2, -1, -2)).addPreferredGap(0).add(groupLayout7.createParallelGroup(1).add(groupLayout7.createParallelGroup(3).add(this.resourceLabel).add(this.resourceBrowse)).add(groupLayout7.createSequentialGroup().add(3, 3, 3).add(this.resourceField, -2, -1, -2))).addPreferredGap(0).add(groupLayout7.createParallelGroup(3).add(this.logLabel).add(this.logBrowse).add(this.logField, -2, -1, -2)).addPreferredGap(0).add(groupLayout7.createParallelGroup(3).add(this.configurationLabel).add(this.configurationBrowse).add(this.configurationField, -2, -1, -2)).addPreferredGap(0).add(groupLayout7.createParallelGroup(2).add(groupLayout7.createSequentialGroup().add(groupLayout7.createParallelGroup(3).add(this.localCommsAddressLabel).add(this.localCommsAddressField, -2, -1, -2)).addPreferredGap(0).add(this.jPanel1, -2, -1, -2)).add(this.goButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void replayOptionActionPerformed(ActionEvent actionEvent) {
        if (this.replayOption.isSelected()) {
            this.loadPrevious.setSelected(true);
        }
        if (this.replayOption.isSelected()) {
            this.themeSelector.setModel(this.replayOperationThemes);
        } else {
            this.themeSelector.setModel(this.liveOperationThemes);
        }
    }

    private void liveOptionActionPerformed(ActionEvent actionEvent) {
        if (this.liveOption.isSelected()) {
            this.loadPrevious.setSelected(false);
        }
        if (this.replayOption.isSelected()) {
            this.themeSelector.setModel(this.replayOperationThemes);
        } else {
            this.themeSelector.setModel(this.liveOperationThemes);
        }
    }

    private void operationBrowseActionPerformed(ActionEvent actionEvent) {
        if (this.setDirectory(this.operationField, "Select the operations disk")) {
            this.infer(new File(this.operationField.getText()));
        }
    }

    private void goButtonActionPerformed(ActionEvent actionEvent) {
        this.DanderSpritzBegin();
    }

    private void configurationBrowseActionPerformed(ActionEvent actionEvent) {
        if (this.setDirectory(this.configurationField, "Select the configuration directory")) {
            this.infer(new File(this.configurationField.getText() + "/../"));
        }
    }

    private void logBrowseActionPerformed(ActionEvent actionEvent) {
        if (this.setDirectory(this.logField, "Select the log directory")) {
            this.infer(new File(this.logField.getText() + "/../"));
        }
    }

    private void resourceBrowseActionPerformed(ActionEvent actionEvent) {
        if (this.setDirectory(this.resourceField, "Select the resource directory")) {
            this.infer(new File(this.resourceField.getText() + "/../"));
        }
    }

    private void enterPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.DanderSpritzBegin();
        } else {
            this.examine();
        }
    }

    boolean setDirectory(JTextField jTextField, String string) {
        if (this.directoryFinder == null) {
            JOptionPane.showMessageDialog(this, "The File Selector dialog did not initialize.  You must enter your paths manually.", "File Selector not available", 2);
            return false;
        }
        this.directoryFinder.setDialogTitle(string);
        if (jTextField.getText().trim().length() > 0) {
            File file = new File(jTextField.getText().trim());
            this.directoryFinder.setSelectedFile(file);
            this.directoryFinder.setCurrentDirectory(file.getParentFile());
        }
        if (this.directoryFinder.showDialog(this, "Select") == 0) {
            jTextField.setText(this.directoryFinder.getSelectedFile().getAbsolutePath());
            return true;
        }
        return false;
    }

    void infer(File file) {
        if (file == null) {
            return;
        }
        try {
            if (this.operationField.getText().trim().length() == 0) {
                this.operationField.setText(new File(file.getAbsolutePath()).getCanonicalPath());
            }
            if (this.resourceField.getText().trim().length() == 0) {
                File file2 = new File(file.getAbsolutePath(), "/Resources/");
                this.resourceField.setText(file2.getCanonicalPath());
                this.searchOutThemes(file2);
            }
            if (this.logField.getText().trim().length() == 0) {
                this.logField.setText(new File(file.getAbsolutePath(), "/Logs/").getCanonicalPath());
            }
            if (this.configurationField.getText().trim().length() == 0) {
                this.configurationField.setText(new File(file.getAbsolutePath(), "/UserConfiguration/").getCanonicalPath());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.examine();
    }

    void searchOutThemes(File file) {
        if (file == this.themeSearchRoot) {
            return;
        }
        if (file == null) {
            this.themeSelector.setEnabled(false);
            this.themeSelector.setSelectedItem(null);
            return;
        }
        if (file.equals(this.themeSearchRoot)) {
            return;
        }
        this.themeSearchRoot = file;
        this.liveOperationThemes.removeAllElements();
        this.replayOperationThemes.removeAllElements();
        String string = "Gui/Config/";
        Vector<String> vector = new Vector<String>();
        vector.add(".");
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File serializable2 : fileArray) {
                if (!serializable2.isDirectory()) continue;
                vector.add(serializable2.getName());
            }
        }
        Pattern pattern = Pattern.compile("systemStartup_([^.]+).xml");
        Pattern pattern2 = Pattern.compile("replay_([^.]+).xml");
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (String string2 : vector) {
            File file2 = new File(this.themeSearchRoot, String.format("%s/%s", string2, string));
            fileArray = file2.listFiles();
            if (fileArray == null) continue;
            for (File file3 : fileArray) {
                if (!file3.isFile()) continue;
                Matcher matcher = pattern.matcher(file3.getName());
                if (matcher.matches()) {
                    treeSet.add(matcher.group(1));
                }
                if (!(matcher = pattern2.matcher(file3.getName())).matches()) continue;
                treeSet2.add(matcher.group(1));
            }
        }
        this.liveOperationThemes.addElement(DSZ_DEFAULT);
        for (String string2 : treeSet) {
            this.liveOperationThemes.addElement(string2);
        }
        this.replayOperationThemes.addElement(DSZ_DEFAULT);
        for (String string2 : treeSet2) {
            this.replayOperationThemes.addElement(string2);
        }
    }

    public static void main(String[] stringArray) {
        String string = "com.birosoft.liquid.LiquidLookAndFeel";
        System.setProperty("swing.defaultlaf", string);
        try {
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            int n;
            Start start = new Start();
            String string2 = Start.getStringDefault(LIVE_KEYWORD);
            start.liveOperationThemes.setSelectedItem(DSZ_DEFAULT);
            if (string2 != null) {
                for (n = 0; n < start.liveOperationThemes.getSize(); ++n) {
                    if (!string2.equals(start.liveOperationThemes.getElementAt(n))) continue;
                    start.liveOperationThemes.setSelectedItem(string2);
                    break;
                }
            }
            string2 = Start.getStringDefault(REPLAY_KEYWORD);
            start.replayOperationThemes.setSelectedItem(DSZ_DEFAULT);
            if (string2 != null) {
                for (n = 0; n < start.replayOperationThemes.getSize(); ++n) {
                    if (!string2.equals(start.replayOperationThemes.getElementAt(n))) continue;
                    start.replayOperationThemes.setSelectedItem(string2);
                    break;
                }
            }
            if (Start.getBooleanDefault(OPERATION_MODE, true).booleanValue()) {
                start.liveOption.setSelected(true);
                start.themeSelector.setModel(start.liveOperationThemes);
            } else {
                start.replayOption.setSelected(true);
                start.themeSelector.setModel(start.replayOperationThemes);
            }
            String string3 = start.resourceField.getText();
            if (string3.endsWith(prop.getProperty(RES_DIR, "Dsz"))) {
                string3 = string3.substring(0, string3.lastIndexOf(prop.getProperty(RES_DIR, "Dsz")));
                start.resourceField.setText(string3);
            }
            start.operationPanel.setVisible(start.isShowOpType());
            if (start.isShowDebugCore()) {
                start.buildRelease.setSelected(Start.getBooleanDefault(BUILD_TYPE, true));
                start.buildDebug.setSelected(Start.getBooleanDefault(BUILD_TYPE, true) == false);
            } else {
                start.buildRelease.setSelected(true);
                start.buildDebug.setSelected(false);
            }
            if (start.isShowDebugGui()) {
                start.guiRelease.setSelected(Start.getBooleanDefault(GUI_TYPE, true));
                start.guiDebug.setSelected(Start.getBooleanDefault(GUI_TYPE, true) == false);
            } else {
                start.guiRelease.setSelected(true);
                start.guiDebug.setSelected(false);
            }
            if (start.isShowLocal()) {
                start.localMode.setSelected(Start.getBooleanDefault(LOCAL_MODE, false));
            } else {
                start.localMode.setSelected(false);
            }
            start.loadPrevious.setSelected(Start.getBooleanDefault(LOAD_PREVIOUS, false));
            if (start.isShowThreadDump()) {
                start.threadDump.setSelected(Start.getBooleanDefault(THREAD_DUMP, false));
            }
            start.waitFor.setSelected(Start.getBooleanDefault(WAIT_FOR_OUTPUT, false));
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string4;
                String string5 = stringArray[i];
                String[] stringArray2 = string5.split("=", 2);
                if (stringArray2.length == 0) {
                    Start.doHelp(start);
                    System.exit(0);
                }
                if ((string4 = stringArray2[0].toLowerCase()).equals("-core")) {
                    if (stringArray2.length == 2) {
                        stringArray2[1] = stringArray2[1].toLowerCase();
                        if (stringArray2[1].equals("debug")) {
                            start.buildDebug.setSelected(true);
                            continue;
                        }
                        if (stringArray2[1].equals("release")) {
                            start.buildRelease.setSelected(true);
                            continue;
                        }
                        Start.doHelp(start);
                        return;
                    }
                    Start.doHelp(start);
                    return;
                }
                if (string4.equals("-gui")) {
                    if (stringArray2.length == 2) {
                        stringArray2[1] = stringArray2[1].toLowerCase();
                        if (stringArray2[1].equals("debug")) {
                            start.guiDebug.setSelected(true);
                            continue;
                        }
                        if (stringArray2[1].equals("release")) {
                            start.guiRelease.setSelected(true);
                            continue;
                        }
                        Start.doHelp(start);
                        return;
                    }
                    Start.doHelp(start);
                    return;
                }
                if (string4.equals("-debug")) {
                    start.buildDebug.setSelected(true);
                    continue;
                }
                if (string4.equals("-release")) {
                    start.buildRelease.setSelected(true);
                    continue;
                }
                if (string4.equals("-local")) {
                    start.localMode.setSelected(true);
                    continue;
                }
                if (string4.equals("-previous")) {
                    start.loadPrevious.setSelected(true);
                    continue;
                }
                if (string4.equals("-live")) {
                    start.liveOption.setSelected(true);
                    continue;
                }
                if (string4.equals("-replay")) {
                    start.replayOption.setSelected(true);
                    continue;
                }
                if (string4.equals("-opsdisk") && stringArray2.length == 2) {
                    start.operationField.setText(stringArray2[1]);
                    continue;
                }
                if (string4.equals("-resource") && stringArray2.length == 2) {
                    start.resourceField.setText(stringArray2[1]);
                    continue;
                }
                if (string4.equals("-log") && stringArray2.length == 2) {
                    start.logField.setText(stringArray2[1]);
                    continue;
                }
                if (string4.equals("-config") && stringArray2.length == 2) {
                    start.configurationField.setText(stringArray2[1]);
                    continue;
                }
                if (string4.equals("-load")) {
                    bl = true;
                    continue;
                }
                Start.doHelp(start);
                System.exit(0);
            }
            if (bl && start.isReady()) {
                start.DanderSpritzBegin();
            } else {
                start.setVisible(true);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            JOptionPane.showMessageDialog(null, "Start.jar requires Java SE6", "Incorrect Runtime", 0);
        }
    }

    public static String getStringDefault(String string) {
        return Start.getStringDefault(string, "");
    }

    public static String getStringDefault(String string, String string2) {
        try {
            return userDefaults.getProperty(string, string2);
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public static Boolean getBooleanDefault(String string) {
        return Start.getBooleanDefault(string, Boolean.TRUE);
    }

    public static Boolean getBooleanDefault(String string, Boolean bl) {
        try {
            return Boolean.parseBoolean(userDefaults.getProperty(string, bl.toString()));
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public static void setStringDefault(String string, String string2) {
        if (string2 == null) {
            userDefaults.remove(string);
        } else {
            userDefaults.setProperty(string, string2);
        }
    }

    public static void setBooleanDefault(String string, Boolean bl) {
        if (bl == null) {
            Start.setStringDefault(string, null);
        } else {
            Start.setStringDefault(string, bl.toString());
        }
    }

    public static void doHelp(Start start) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringBuilder stringBuilder = new StringBuilder();
        printWriter.println("Help for Start.jar");
        printWriter.println("Start.jar [-previous] [-live|-replay] [-opsdisk=DIR] [-resource=DIR] [-log=DIR] [-config=DIR] [-load]");
        printWriter.println("\t[-previous]:  Automatically load previous operations");
        printWriter.println("\t[-live]:  A live operation");
        printWriter.println("\t[-replay]:  A replay operation");
        printWriter.println("\t[-opsdisk=DIR]:  Set the operations disk value to the given DIR");
        printWriter.println("\t[-resource=DIR]:  Set the resource directory to the given DIR");
        printWriter.println("\t[-log=DIR]:  Set the log directory to the given DIR");
        printWriter.println("\t[-config=DIR]:  Set the user configuration directory to the given DIR");
        if (start.isShowDebugCore() || start.isShowLocal() || start.isShowDebugGui()) {
            printWriter.println("\nExtra Parameters:");
            if (start.isShowDebugCore()) {
                printWriter.println("\t[-core=<debug|release>]");
                printWriter.println("\t\t[debug]: Tells DanderSpritz to load the debug version of the core");
                printWriter.println("\t\t[release]: Tells DanderSpritz to load the release version of the core");
            }
            if (start.isShowDebugGui()) {
                printWriter.println("\t[-gui=<debug|release>]");
                printWriter.println("\t\t[-debug]: Tells DanderSpritz to load the debug version of the gui");
                printWriter.println("\t\t[-release]: Tells DanderSpritz to load the release version of the gui");
            }
            if (start.isShowLocal()) {
                printWriter.println("\t[-local]:  Turns on local mode");
            }
        }
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Monospaced", 0, 14));
        jTextArea.setTabSize(4);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        Dimension dimension = new Dimension(900, 350);
        jScrollPane.setMinimumSize(dimension);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setSize(dimension);
        jScrollPane.setMaximumSize(dimension);
        jTextArea.setText(stringWriter.toString());
        JOptionPane.showMessageDialog(null, jScrollPane, "Start Help", 1);
    }

    private boolean evaluatePath(String string, boolean bl) {
        for (char c : INVALIDCHARACTERS) {
            if (string.indexOf(c) < 0) continue;
            return false;
        }
        Object object = new File(string);
        if (((File)object).exists() && ((File)object).isDirectory()) {
            return true;
        }
        if (!((File)object).exists()) {
            if (bl) {
                return false;
            }
            return ((File)object).mkdirs();
        }
        return false;
    }

    public boolean evaluate() {
        if (!this.evaluatePath(this.operationField.getText(), true)) {
            return this.error("Operation Disk location '" + this.operationField.getText() + "' does not exist or is not a directory");
        }
        if (!this.evaluatePath(this.resourceField.getText(), true)) {
            return this.error("Resource location '" + this.resourceField.getText() + "' does not exist or is not a directory");
        }
        if (!this.evaluatePath(this.logField.getText(), false)) {
            return this.error("Log directory '" + this.logField.getText() + "' is not a directory");
        }
        if (!this.evaluatePath(this.configurationField.getText(), false)) {
            return this.error("Configuration directory '" + this.configurationField.getText() + "' is not a directory");
        }
        if (!this.isValidId(this.localCommsAddressField.getText())) {
            return this.error(String.format("Comms Address '%s' is invalid", this.localCommsAddressField.getText()));
        }
        return true;
    }

    private boolean isValidId(String string) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean error(String string) {
        JOptionPane.showMessageDialog(this, string, "Invalid parameters", 0);
        return false;
    }

    public boolean isReady() {
        return !this.guess && this.evaluate() && this.examine();
    }

    public boolean isDir(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        File file = new File(string);
        if (file.exists()) {
            return file.isDirectory();
        }
        return file.mkdirs();
    }

    public void DanderSpritzBegin() {
        if (!this.evaluate()) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Start.this.beginImpl();
            }
        }, "Start DanderSpritz").start();
    }

    private void beginImpl() {
        Object object;
        AnnotatedElement annotatedElement;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        File file = new File(this.configurationField.getText(), "testfile.dsz");
        File file2 = file.getParentFile();
        boolean bl = false;
        file2.mkdirs();
        if (file.exists()) {
            if (file.delete()) {
                bl = true;
            }
        } else {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(90);
                fileOutputStream.close();
                file.delete();
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            int n = JOptionPane.showConfirmDialog(null, "Danderspritz is unable to write to the user configuration area.\nWithout the ability to write there, several plugins will not work.\nDanderspritz will now change the user configuration area to your temp directory,\nand you will lose any existing customization you have performed.\nSelect 'No' to ignore this problem, or 'Cancel' to change the directory.", "User Configuration is Read-Only", 1, 2, null);
            switch (n) {
                case 0: {
                    file2 = new File(System.getProperty("java.io.tmpdir"), "UserConfiguration");
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Start.this.setVisible(false);
                Start.this.dispose();
            }
        });
        String string = System.getProperty("com.sun.management.jmxremote.port");
        if (string != null && !((File)(object5 = new File(this.logField.getText(), String.format("Dump-%s.txt", string)))).exists()) {
            try {
                object4 = new FileOutputStream((File)object5);
                ((FileOutputStream)object4).close();
            }
            catch (Exception exception) {
                Logger.getLogger(Start.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
        Start.setStringDefault(OPERATION_DISK, this.operationField.getText());
        Start.setStringDefault(RESOURCE_DIR, this.resourceField.getText());
        Start.setStringDefault(LOG_DIR, this.logField.getText());
        Start.setStringDefault(CONFIG_DIR, this.configurationField.getText());
        Start.setStringDefault(LOCAL_ADDRESS, this.localCommsAddressField.getText());
        if (this.liveOperationThemes.getSelectedItem() != null && !this.liveOperationThemes.getSelectedItem().equals(DSZ_DEFAULT)) {
            Start.setStringDefault(LIVE_KEYWORD, this.liveOperationThemes.getSelectedItem().toString());
        } else {
            Start.setStringDefault(LIVE_KEYWORD, null);
        }
        if (this.replayOperationThemes.getSelectedItem() != null && !this.replayOperationThemes.getSelectedItem().equals(DSZ_DEFAULT)) {
            Start.setStringDefault(REPLAY_KEYWORD, this.replayOperationThemes.getSelectedItem().toString());
        } else {
            Start.setStringDefault(REPLAY_KEYWORD, null);
        }
        Start.setBooleanDefault(OPERATION_MODE, this.liveOption.isSelected());
        Start.setBooleanDefault(BUILD_TYPE, this.buildRelease.isSelected());
        Start.setBooleanDefault(GUI_TYPE, this.guiRelease.isSelected());
        Start.setBooleanDefault(LOCAL_MODE, this.localMode.isSelected());
        Start.setBooleanDefault(LOAD_PREVIOUS, this.loadPrevious.isSelected());
        Start.setBooleanDefault(THREAD_DUMP, this.threadDump.isSelected());
        Start.setBooleanDefault(WAIT_FOR_OUTPUT, this.waitFor.isSelected());
        try {
            userDefaults.store(new FileOutputStream(USER_DEFAULTS), "Autogenerated DanderSpritz configuration.  Do not edit manually");
        }
        catch (Exception exception) {
            // empty catch block
        }
        object5 = new ProcessBuilder(new String[0]);
        object4 = new Vector();
        ((ProcessBuilder)object5).command((List<String>)object4);
        String string2 = this.resourceField.getText();
        object4.add(prop.getProperty(JAVA_EXE, "java"));
        for (String string3 : prop.getProperty(VMARGS, "").split("\\s")) {
            if (string3.length() <= 0) continue;
            object4.add(string3);
        }
        if (this.guiDebug.isSelected()) {
            for (String string3 : prop.getProperty(DEBUGVMARGS, "").split("\\s")) {
                if (string3.length() <= 0) continue;
                object4.add(string3);
            }
        }
        object4.add(String.format("-Djava.endorsed.dirs=%s/ExternalLibraries/%s/endorsed", string2, PATH_TOOLCHAIN));
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        this.addJars(vector, new File(String.format("%s/ExternalLibraries/%s", string2, PATH_TOOLCHAIN)));
        vector2.add("Ops");
        vector2.add(".");
        vector2.add(prop.getProperty(RES_DIR, "Dsz"));
        for (File file3 : new File(string2).listFiles()) {
            if (!file3.isDirectory() || vector2.contains(file3.getName())) continue;
            vector2.add(file3.getName());
        }
        for (String string4 : vector2) {
            File file3;
            File file4 = new File(String.format("%s/%s/Gui", string2, string4));
            if (!file4.exists()) continue;
            file3 = new File(file4, "Config");
            if (file3.exists()) {
                vector.add(file3.getAbsolutePath());
            }
            if (!((File)(object3 = new File(file4, String.format("%s/%s", PATH_LIBRARY, PATH_TOOLCHAIN)))).exists()) continue;
            this.addJars(vector, (File)object3);
        }
        boolean bl2 = false;
        if (System.getProperty("os.name").toLowerCase().startsWith(prop.getProperty(WINDOWS_START, "win"))) {
            bl2 = true;
        }
        URL[] uRLArray = new URL[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            try {
                uRLArray[i] = new File((String)vector.get(i)).toURI().toURL();
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        boolean bl3 = false;
        if (classLoader instanceof URLClassLoader) {
            try {
                object3 = (URLClassLoader)classLoader;
                object2 = URLClassLoader.class;
                annotatedElement = ((Class)object2).getDeclaredField("ucp");
                ((Field)annotatedElement).setAccessible(true);
                object = (URLClassPath)((Field)annotatedElement).get(object3);
                for (URL uRL : uRLArray) {
                    object.addURL(uRL);
                }
                bl3 = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl3) {
            classLoader = new URLClassLoader(uRLArray, ClassLoader.getSystemClassLoader());
        }
        object3 = new Vector();
        object3.add(String.format("-logDir=%s", this.logField.getText()));
        object3.add(String.format("-resourceDir=%s", string2));
        object3.add(String.format("-comms=%s", this.localCommsAddressField.getText()));
        object3.add(String.format("-build=%s", prop.getProperty(String.format("%s.%s", bl2 ? WINDOWS : LINUX, this.buildRelease.isSelected() ? BUILD_RELEASE : BUILD_DEBUG))));
        object3.add(String.format("-local=%s", this.localMode.isSelected() ? "true" : "false"));
        object3.add(String.format("-config=%s", file2.getAbsolutePath()));
        object3.add(String.format("-loadPrevious=%s", this.loadPrevious.isSelected() ? "true" : "false"));
        object3.add(String.format("-threadDump=%s", this.threadDump.isSelected() ? "true" : "false"));
        object2 = null;
        object2 = this.liveOption.isSelected() ? prop.getProperty(LIVE_OPERATION) : prop.getProperty(REPLAY_OPERATION);
        if (bl2) {
            Start.addLibraryPath(String.format("%s\\ExternalLibraries\\%s", string2, prop.getProperty(String.format("%s.%s", WINDOWS, TOOL_CHAIN_STR))));
        } else {
            Start.addLibraryPath(String.format("%s/ExternalLibraries/%s", string2, prop.getProperty(String.format("%s.%s", LINUX, TOOL_CHAIN_STR))));
        }
        System.setProperty("windows.tool.chain", prop.getProperty(String.format("%s.%s", WINDOWS, TOOL_CHAIN_STR)));
        System.setProperty("linux.tool.chain", prop.getProperty(String.format("%s.%s", LINUX, TOOL_CHAIN_STR)));
        if (this.themeSelector.getSelectedItem() != null && !this.themeSelector.getSelectedItem().equals(DSZ_DEFAULT)) {
            System.setProperty(DSZ_KEYWORD, this.themeSelector.getSelectedItem().toString());
        }
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            annotatedElement = Class.forName((String)object2, true, classLoader);
            object = ((Class)annotatedElement).getMethod("main", String[].class);
            Class<?> clazz = Class.forName("ds.core.DSConstants", true, classLoader);
            Method method = clazz.getMethod("setLoader", ClassLoader.class);
            method.invoke(null, classLoader);
            String[] stringArray = new String[object3.size()];
            stringArray = object3.toArray(stringArray);
            ((Method)object).invoke(null, new Object[]{stringArray});
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(null, "Unable to start DanderSpritz.  The OpsDisk appears incomplete.", "Invalid OpsDisk", 0);
            this.examine();
            this.setVisible(true);
        }
    }

    private void addJars(List<String> list, File file) {
        if (!file.isDirectory()) {
            return;
        }
        for (File file2 : file.listFiles(jars)) {
            list.add(file2.getAbsolutePath());
        }
    }

    private void addJarsRecursively(List<String> list, File file) {
        if (!file.isDirectory()) {
            return;
        }
        this.addJars(list, file);
        for (File file2 : file.listFiles()) {
            if (!file2.isDirectory() || file2.getName().equals(".svn")) continue;
            this.addJarsRecursively(list, file2);
        }
    }

    public boolean isShowOpType() {
        return this.getBooleanProperty(SHOW_OP_TYPE, true);
    }

    public boolean isShowDebugCore() {
        return this.getBooleanProperty(SHOW_DEBUG_CORE, false);
    }

    public boolean isShowDebugGui() {
        return this.getBooleanProperty(SHOW_DEBUG_GUI, false);
    }

    public boolean isShowLocal() {
        return this.getBooleanProperty(SHOW_LOCAL_MODE, false);
    }

    public boolean isShowThreadDump() {
        return this.getBooleanProperty(SHOW_THREAD_DUMP, false);
    }

    public boolean getBooleanProperty(String string, Boolean bl) {
        try {
            return Boolean.parseBoolean(prop.getProperty(string, bl.toString()));
        }
        catch (Throwable throwable) {
            return bl;
        }
    }

    public static void addLibraryPath(String string) {
        String string2 = null;
        try {
            string2 = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        try {
            String[] stringArray;
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            for (String string3 : stringArray = (String[])field.get(null)) {
                if (!string3.equals(string2)) continue;
                return;
            }
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string2;
            field.set(null, stringArray2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private boolean examine() {
        Vector<File> vector = new Vector<File>();
        Vector<File> vector2 = new Vector<File>();
        Vector<File> vector3 = new Vector<File>();
        Vector<File> vector4 = new Vector<File>();
        vector.add(new File(String.format("%s", this.operationField.getText())));
        vector.add(new File(String.format("%s%s%s", this.operationField.getText(), File.separator, "Bin")));
        vector2.add(new File(String.format("%s", this.resourceField.getText())));
        vector2.add(new File(String.format("%s/%s/%s/%s/%s", this.resourceField.getText(), File.separator, "Dsz/Gui/lib", PATH_TOOLCHAIN, "Core.jar")));
        boolean bl = true;
        if (!this.examine(vector, this.operationField)) {
            bl = false;
        }
        if (!this.examine(vector2, this.resourceField)) {
            bl = false;
        } else {
            this.searchOutThemes(new File(this.resourceField.getText()));
        }
        if (!this.examine(vector3, this.configurationField)) {
            bl = false;
        }
        if (!this.examine(vector4, this.logField)) {
            bl = false;
        }
        if (!this.isValidId(this.localCommsAddressField.getText())) {
            this.setConfig(this.localCommsAddressField, false);
            bl = false;
        } else {
            this.setConfig(this.localCommsAddressField, true);
        }
        this.goButton.setEnabled(bl);
        return bl;
    }

    private void setConfig(JTextField jTextField, boolean bl) {
        if (bl) {
            jTextField.setBackground(Color.WHITE);
            jTextField.setForeground(Color.BLACK);
        } else {
            jTextField.setBackground(Color.GRAY);
            jTextField.setForeground(Color.WHITE);
        }
    }

    private boolean examine(List<File> list, JTextField jTextField) {
        boolean bl = true;
        for (char c : INVALIDCHARACTERS) {
            if (jTextField.getText().indexOf(c) < 0) continue;
            bl = false;
            break;
        }
        Object object = list.iterator();
        while (object.hasNext()) {
            File file = (File)object.next();
            bl = bl && file.exists();
        }
        this.setConfig(jTextField, bl);
        return bl;
    }
}

