/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;

public class BlockingInputStream
extends InputStream {
    static boolean ENDED = false;
    private static ReopenStream NOOP = new ReopenStream(){

        public InputStream reopen() {
            return null;
        }
    };
    protected InputStream child = null;
    long amtRead = 0L;
    long markPosition = 0L;
    boolean stop = false;
    protected int dozeTime;
    private ReopenStream reopenMethod = null;
    private static int DEFAULT_DOZE_TIME = 500;
    long location = 0L;

    public static void setEnded() {
        ENDED = true;
    }

    public BlockingInputStream(InputStream child) {
        this(child, DEFAULT_DOZE_TIME);
    }

    public BlockingInputStream(InputStream child, int millis) {
        this(child, millis, NOOP);
    }

    public BlockingInputStream(InputStream child, ReopenStream reopen) {
        this(child, DEFAULT_DOZE_TIME, reopen);
    }

    public BlockingInputStream(InputStream child, int millis, ReopenStream reopen) {
        this.child = child;
        if (this.child == null) {
            throw new NullPointerException("InputStream cannot be null");
        }
        if (millis < 0) {
            millis = DEFAULT_DOZE_TIME;
        }
        this.dozeTime = millis;
        this.reopenMethod = reopen;
        if (this.reopenMethod == null) {
            this.reopenMethod = NOOP;
        }
    }

    public BlockingInputStream(File inputFile) throws FileNotFoundException {
        this(inputFile, DEFAULT_DOZE_TIME);
    }

    public BlockingInputStream(final File inputFile, int millis) throws FileNotFoundException {
        this.child = new FileInputStream(inputFile);
        if (millis < 0) {
            millis = DEFAULT_DOZE_TIME;
        }
        this.dozeTime = millis;
        this.reopenMethod = new ReopenStream(){
            long lastSize = 0L;

            public InputStream reopen() {
                if (inputFile.length() == this.lastSize) {
                    return null;
                }
                try {
                    FileInputStream is = new FileInputStream(inputFile);
                    this.lastSize = inputFile.length();
                    return is;
                }
                catch (IOException e) {
                    return null;
                }
            }
        };
    }

    public synchronized int read() throws IOException {
        int res = this.child.read();
        while (res < 1 && !this.stop) {
            if (ENDED) {
                return -1;
            }
            BlockingInputStream.sleep(this.dozeTime);
            this.reopen();
            res = this.child.read();
        }
        ++this.amtRead;
        return res;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int res = this.child.read(b, off, len);
        while (res < 1 && !this.stop) {
            if (ENDED) {
                return 0;
            }
            BlockingInputStream.sleep(this.dozeTime);
            this.reopen();
            res = this.child.read(b, off, len);
        }
        this.amtRead += (long)res;
        return res;
    }

    public synchronized int read(byte[] b) throws IOException {
        int res = this.child.read(b);
        while (res == -1 && !this.stop) {
            if (ENDED) {
                return 0;
            }
            BlockingInputStream.sleep(this.dozeTime);
            this.reopen();
            res = this.child.read(b);
        }
        this.amtRead += (long)res;
        return res;
    }

    public synchronized int available() throws IOException {
        if (ENDED) {
            return 0;
        }
        return this.child.available();
    }

    public synchronized void close() throws IOException {
        this.child.close();
    }

    public synchronized boolean equals(Object obj) {
        return this.child.equals(obj);
    }

    public synchronized int hashCode() {
        return this.child.hashCode();
    }

    public synchronized void mark(int readlimit) {
        this.child.mark(readlimit);
        this.markPosition = this.amtRead;
    }

    public synchronized boolean markSupported() {
        return this.child.markSupported();
    }

    public synchronized void reset() throws IOException {
        this.child.reset();
        this.amtRead = this.markPosition;
    }

    public synchronized long skip(long n) throws IOException {
        long res = this.child.skip(n);
        this.amtRead += res;
        return res;
    }

    public synchronized String toString() {
        return this.child.toString();
    }

    private void reopen() {
    }

    private static void sleep(int time) {
        try {
            TimeUnit.MILLISECONDS.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static interface ReopenStream {
        public InputStream reopen();
    }
}

