/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import java.awt.Toolkit;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class History {
    private List<String> items = new Vector<String>(60, 60);
    private int currentIndex = 0;
    private int maxSize;
    public static final int UNLIMITED = 0;

    public History() {
        this(0);
    }

    public History(int limit) {
        this.maxSize = limit;
    }

    public void setSizeLimit(int limit) {
        this.maxSize = limit;
        this.trim();
    }

    public void add(String item) {
        boolean trim = !this.items.remove(item);
        this.items.add(item);
        if (trim) {
            this.trim();
        }
        this.currentIndex = this.items.size();
    }

    public String prev() {
        if (this.currentIndex > 0) {
            --this.currentIndex;
        }
        if (this.items.size() > 0) {
            return this.items.get(this.currentIndex);
        }
        return "";
    }

    public String next() {
        if (this.currentIndex < this.items.size()) {
            ++this.currentIndex;
        }
        if (this.currentIndex < this.items.size()) {
            return this.items.get(this.currentIndex);
        }
        return "";
    }

    public String first() {
        this.currentIndex = 0;
        Toolkit.getDefaultToolkit().beep();
        if (this.items.size() > 0) {
            return this.items.get(0);
        }
        return "";
    }

    public String last() {
        this.currentIndex = this.items.size() - 1;
        if (this.items.size() > 0) {
            return this.items.get(this.currentIndex);
        }
        return "";
    }

    public int getSize() {
        return this.items.size();
    }

    public String elementAt(int index) {
        return this.items.get(index);
    }

    public void clear() {
        this.items.clear();
        this.currentIndex = 0;
    }

    public List<String> toList() {
        return new Vector<String>(this.items);
    }

    private void trim() {
        if (this.maxSize == 0) {
            return;
        }
        if (this.items.size() > this.maxSize) {
            int clear = this.items.size() - this.maxSize;
            this.items.subList(0, clear).clear();
            this.currentIndex -= clear;
        }
    }
}

