/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.Queue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlCache {
    private static final XmlCache CACHE = new XmlCache();
    private final Object DocumentFactoryLock = new Object();
    private Reference<DocumentBuilderFactory> FactoryRef = new WeakReference<Object>(null);
    private final Queue<Reference<DocumentBuilder>> BUILDERS_REF = new LinkedList<Reference<DocumentBuilder>>();
    private final int MAXIMUM_BUILDERS = 5;
    private final Object ParserFactoryLock = new Object();
    private final Queue<Reference<SAXParser>> PARSERS = new LinkedList<Reference<SAXParser>>();
    private Reference<SAXParserFactory> FACTORY = new WeakReference<Object>(null);
    private Reference<ErrorHandler> ERRORS = new WeakReference<Object>(null);
    private final int MAX_PARSERS = 5;

    public static SAXParser getSAXParser() {
        return CACHE.getSAXParserImpl();
    }

    public static final void releaseParser(SAXParser parser) {
        CACHE.releaseParserImpl(parser);
    }

    public static DocumentBuilder getBuilder() {
        return CACHE.getBuilderImpl();
    }

    public static void releaseBuilder(DocumentBuilder builder) {
        CACHE.releaseBuilderImpl(builder);
    }

    private XmlCache() {
    }

    private synchronized ErrorHandler getHandler() {
        ErrorHandler err = this.ERRORS.get();
        if (err != null) {
            return err;
        }
        err = new ErrorHandler(){

            public void warning(SAXParseException exception) throws SAXException {
            }

            public void error(SAXParseException exception) throws SAXException {
            }

            public void fatalError(SAXParseException exception) throws SAXException {
            }
        };
        this.ERRORS = new WeakReference<ErrorHandler>(err);
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBuilderImpl(DocumentBuilder builder) {
        if (builder == null) {
            return;
        }
        Queue<Reference<DocumentBuilder>> queue = this.BUILDERS_REF;
        synchronized (queue) {
            if (this.BUILDERS_REF.size() < 5) {
                this.BUILDERS_REF.offer(new SoftReference<DocumentBuilder>(builder));
            } else {
                this.BUILDERS_REF.offer(new WeakReference<DocumentBuilder>(builder));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentBuilder getBuilderImpl() {
        for (int i = 0; i < 10; ++i) {
            Object object = this.BUILDERS_REF;
            synchronized (object) {
                while (this.BUILDERS_REF.size() > 0) {
                    Reference<DocumentBuilder> ref = this.BUILDERS_REF.poll();
                    DocumentBuilder builder = ref.get();
                    if (builder == null) continue;
                    return builder;
                }
            }
            object = this.DocumentFactoryLock;
            synchronized (object) {
                DocumentBuilderFactory factory = this.FactoryRef.get();
                if (factory == null) {
                    factory = DocumentBuilderFactory.newInstance();
                    this.FactoryRef = new SoftReference<DocumentBuilderFactory>(factory);
                }
                try {
                    DocumentBuilder docBuild = factory.newDocumentBuilder();
                    docBuild.setErrorHandler(this.getHandler());
                    return docBuild;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseParserImpl(SAXParser parser) {
        if (parser == null) {
            return;
        }
        Queue<Reference<SAXParser>> queue = this.PARSERS;
        synchronized (queue) {
            if (this.PARSERS.size() < 5) {
                this.PARSERS.offer(new SoftReference<SAXParser>(parser));
            } else {
                this.PARSERS.offer(new WeakReference<SAXParser>(parser));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SAXParser getSAXParserImpl() {
        SAXParser parser;
        Object object = this.PARSERS;
        synchronized (object) {
            while (!this.PARSERS.isEmpty()) {
                Reference<SAXParser> parserRef = this.PARSERS.poll();
                if (parserRef == null || (parser = parserRef.get()) == null) continue;
                parser.reset();
                return parser;
            }
        }
        object = this.ParserFactoryLock;
        synchronized (object) {
            try {
                SAXParserFactory factory = this.FACTORY.get();
                if (factory == null) {
                    factory = SAXParserFactory.newInstance();
                    if (factory == null) {
                        return null;
                    }
                    this.FACTORY = new SoftReference<SAXParserFactory>(factory);
                }
                parser = factory.newSAXParser();
                return parser;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

