/*
 * Decompiled with CFR 0.152.
 */
package ddb.util.jar;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.misc.URLClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileClassInspector {
    File jarFile;

    public static final List<JarFileClassInspector> getInspectors(ClassLoader loader) {
        ArrayList<JarFileClassInspector> retVal = new ArrayList<JarFileClassInspector>();
        if (loader == null) {
            return retVal;
        }
        if (loader.getParent() != null) {
            retVal.addAll(JarFileClassInspector.getInspectors(loader.getParent()));
        }
        try {
            if (loader instanceof URLClassLoader) {
                Field f = URLClassLoader.class.getDeclaredField("ucp");
                f.setAccessible(true);
                URLClassPath path = (URLClassPath)f.get(loader);
                for (URL url : path.getURLs()) {
                    try {
                        File file = new File(url.toURI());
                        if (!file.exists() || !file.isFile()) continue;
                        retVal.add(new JarFileClassInspector(file));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                System.out.println("Unexpected: " + loader.getClass());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public String toString() {
        String path = this.jarFile.getAbsolutePath();
        try {
            path = this.jarFile.getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "Jar Inspector: " + path;
    }

    public JarFileClassInspector(String filename) {
        this(new File(filename));
    }

    public JarFileClassInspector(File jarFile) {
        this.jarFile = jarFile;
    }

    public List<Class<?>> getAllClasses() throws IOException, ClassNotFoundException {
        Vector v = new Vector();
        JarFile jf = new JarFile(this.jarFile);
        Enumeration<JarEntry> e = jf.entries();
        while (e.hasMoreElements()) {
            JarEntry jarEntry = e.nextElement();
            if (!jarEntry.getName().endsWith(".class")) continue;
            String className = jarEntry.getName();
            className = className.replaceAll(".class", "");
            className = className.replaceAll("/", ".");
            try {
                Class<?> c = Class.forName(className, false, this.getClass().getClassLoader());
                v.add(c);
            }
            catch (Throwable e1) {}
        }
        return v;
    }

    public <U> List<Class<? extends U>> getAllClassesExtendingClass(Class<U> c) throws IOException, ClassNotFoundException {
        return this.getAllClassesExtendingClass(c, false);
    }

    public <U> List<Class<? extends U>> getAllClassesExtendingClass(Class<U> c, boolean strict) throws IOException, ClassNotFoundException {
        return this.getAllClassesExtendingClass(c, strict, new Vector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> List<Class<? extends U>> getAllClassesExtendingClass(Class<U> c, boolean strict, List<Class<?>> exclusions) throws IOException, ClassNotFoundException {
        List<Class<?>> v = this.getAllClasses();
        Vector<Class<U>> matches = new Vector<Class<U>>();
        List<Class<?>> list = v;
        synchronized (list) {
            for (Class<?> jarClass : v) {
                if (!c.isAssignableFrom(jarClass) || exclusions.contains(jarClass) || strict && jarClass.equals(c)) continue;
                matches.add(jarClass);
            }
        }
        return matches;
    }
}

