/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.transfermonitor;

import ddb.GuiConstants;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.transfermonitor.TransferMonitorColumns;
import ddb.dsz.plugin.transfermonitor.model.TransferState;
import ddb.gui.swing.DszTableCellRenderer;
import ddb.imagemanager.ImageManager;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;

public class TransferMonitorCellRenderer
extends DszTableCellRenderer {
    ImageIcon errorIcon;
    ImageIcon runningIcon;
    ImageIcon completedIcon;

    public TransferMonitorCellRenderer(CoreController coreController) {
        this.errorIcon = ImageManager.getIcon((String)"images/tm_fatal.png", (Dimension)coreController.getLabelImageSize());
        this.runningIcon = ImageManager.getIcon((String)"images/exec.png", (Dimension)coreController.getLabelImageSize());
        this.completedIcon = ImageManager.getIcon((String)"images/tm_completed.png", (Dimension)coreController.getLabelImageSize());
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JLabel jLabel = null;
        if (TransferMonitorColumns.values()[n2].equals((Object)TransferMonitorColumns.STATE)) {
            JLabel jLabel2 = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel2.setIcon(this.runningIcon);
            jLabel2.setText("");
            jLabel2.setAlignmentX(0.5f);
            switch ((TransferState)((Object)TransferState.class.cast(object))) {
                case FAILURE: {
                    jLabel2.setIcon(this.errorIcon);
                    break;
                }
                case SUCCESS: {
                    jLabel2.setIcon(this.completedIcon);
                    break;
                }
                case STARTED: {
                    jLabel2.setIcon(this.runningIcon);
                }
            }
            jLabel = jLabel2;
        } else {
            JLabel jLabel3 = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel3.setIcon(null);
            jLabel = jLabel3;
            if (TransferMonitorColumns.values()[n2].equals((Object)TransferMonitorColumns.ID)) {
                jLabel3.setAlignmentX(1.0f);
                jLabel3.setHorizontalAlignment(4);
            }
        }
        ((Component)jLabel).setFont(GuiConstants.FIXED_WIDTH_FONT.Basic);
        return jLabel;
    }
}

