/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.transfermonitor;

import ddb.detach.Workbench;
import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.ClosureFactory;
import ddb.dsz.core.data.DataTransformer;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.task.Task;
import ddb.dsz.plugin.multitarget.SingleTargetImpl;
import ddb.dsz.plugin.transfermonitor.TransferWorkbench;
import ddb.dsz.plugin.transfermonitor.listeners.GetClosure;
import ddb.dsz.plugin.transfermonitor.listeners.PapercutClosure;
import ddb.dsz.plugin.transfermonitor.listeners.PutClosure;
import ddb.dsz.plugin.transfermonitor.model.TransferRecord;
import ddb.dsz.plugin.transfermonitor.tabs.TransferDetails;
import ddb.dsz.plugin.transfermonitor.tabs.TransferMainTab;
import ddb.util.FileManips;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.map.ReferenceMap;

@DszLive(live=true, replay=true)
@DszLogo(value="images/download_manager.png")
@DszName(value="Transfer Monitor")
@DszDescription(value="Lists all 'GET' requests")
public class TransferMonitorHost
extends SingleTargetImpl {
    private static final Collection<String> INTERESTING_COMMANDS;
    public static final String MAGICFILE = "TransferMonitor/magic.xml";
    Map<TransferRecord, TransferDetails> recordDetails = new ReferenceMap();
    public static final String TM_LOGO = "images/tm_logo.png";
    public static final String ERROR_ICON = "images/tm_fatal.png";
    public static final String RUNNING_ICON = "images/exec.png";
    public static final String COMPLETED_ICON = "images/tm_completed.png";
    String transform;
    private DataTransformer dataTranslator = DataTransformer.newInstance();
    final Object WORKBENCH_LOCK = new Object();
    TransferWorkbench transferWorkbench;
    TransferMainTab mainTab;
    JFileChooser chooser = null;

    public TransferMonitorHost(HostInfo hostInfo, CoreController coreController) {
        super(hostInfo, coreController);
        super.setName(hostInfo.getId());
        coreController.logEvent(Level.FINE, "Initializing TransferMonitor");
        this.transferWorkbench = new TransferWorkbench();
        this.mainTab = new TransferMainTab(this, coreController);
        this.transferWorkbench.enqueAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{this.mainTab});
        super.setDisplay((JComponent)((Object)this.transferWorkbench));
        if (this.dataTranslator != null) {
            this.dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"get", (String)"Dsz", (Closure)this.wrapClosure(new GetClosure(this, coreController))));
            this.dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"papercut", (String)"Dsz", (Closure)this.wrapClosure(new PapercutClosure(this, coreController))));
            this.dataTranslator.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"put", (String)"Dsz", (Closure)this.wrapClosure(new PutClosure(this, coreController))));
        }
    }

    private Closure wrapClosure(final Closure closure) {
        final Predicate predicate = super.getDataPredicate();
        return new Closure(){

            public void execute(Object object) {
                if (predicate.evaluate(object)) {
                    closure.execute(object);
                }
            }
        };
    }

    public int getNext() {
        return this.mainTab.getNext();
    }

    public void addRecord(TransferRecord transferRecord) {
        this.mainTab.addRecord(transferRecord);
    }

    public void recordChanged(TransferRecord transferRecord) {
        this.mainTab.recordChanged(transferRecord);
    }

    public void commandEventReceived(CommandEvent commandEvent) {
        Task task = this.core.getTaskById(commandEvent.getId());
        if (task == null) {
            return;
        }
        this.addCommand(task);
        switch (task.getState()) {
            case FAILED: 
            case KILLED: 
            case SUCCEEDED: {
                this.commandEnded(task);
                break;
            }
        }
    }

    private void commandEnded(Task task) {
        this.mainTab.commandEnded(task);
    }

    private void addCommand(Task task) {
        if (task.getCommandName() == null) {
            return;
        }
        if (INTERESTING_COMMANDS.contains(task.getCommandName().toLowerCase()) && this.dataTranslator != null) {
            this.dataTranslator.addTask(task);
        }
    }

    public synchronized void saveAll(final TransferRecord[] transferRecordArray) {
        if (transferRecordArray.length == 0) {
            return;
        }
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setFileSelectionMode(1);
        int n = this.chooser.showSaveDialog((Component)((Object)this.transferWorkbench));
        if (n == 1) {
            return;
        }
        final File file = this.chooser.getSelectedFile();
        if (!file.isDirectory()) {
            return;
        }
        this.core.submit(new Runnable(){

            private void save(File file3, File file2) {
                try {
                    FileManips.CopyFile((File)file3, (File)file2);
                }
                catch (IOException iOException) {
                    TransferMonitorHost.this.core.logEvent(Level.SEVERE, iOException.getMessage(), (Throwable)iOException);
                }
            }

            public void run() {
                int n;
                ArrayList<TransferRecord> arrayList = new ArrayList<TransferRecord>();
                TransferRecord[] transferRecordArray2 = transferRecordArray;
                int n2 = transferRecordArray2.length;
                for (n = 0; n < n2; ++n) {
                    TransferRecord transferRecord = transferRecordArray2[n];
                    File file3 = TransferMonitorHost.this.getFileFromRecord(transferRecord);
                    boolean bl = false;
                    for (int i = 0; i < 1000; ++i) {
                        File file2 = new File(file, String.format("%s.%03d", TransferMonitorHost.this.getRemoteName(transferRecord), i));
                        if (file2.exists()) continue;
                        try {
                            FileManips.CopyFile((File)file3, (File)file2);
                            bl = true;
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bl) continue;
                    arrayList.add(transferRecord);
                }
                if (arrayList.size() > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (n = 0; n < arrayList.size() && n < 10; ++n) {
                        stringBuilder.append(String.format("   %s\n", TransferMonitorHost.this.getRemoteName((TransferRecord)arrayList.get(n))));
                    }
                    if (arrayList.size() > 10) {
                        stringBuilder.append(String.format("   and %d others\n", arrayList.size() - 10));
                    }
                    JOptionPane.showMessageDialog((Component)((Object)TransferMonitorHost.this.transferWorkbench), String.format("Unable to save:\n%s", stringBuilder.toString()), "Error Saving File", 0);
                }
            }
        });
    }

    public synchronized boolean save(TransferRecord transferRecord) {
        File file;
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        if (transferRecord.getLocal().length() == 0) {
            return true;
        }
        final File file2 = this.getFileFromRecord(transferRecord);
        if (file2 == null || !file2.exists() || file2.isDirectory()) {
            return true;
        }
        this.chooser.setFileSelectionMode(0);
        this.chooser.setSelectedFile(new File(String.format("%s.000", this.getRemoteName(transferRecord))));
        while (true) {
            int n;
            if ((n = this.chooser.showSaveDialog((Component)((Object)this.transferWorkbench))) == 1) {
                return false;
            }
            if (n != 0) continue;
            file = this.chooser.getSelectedFile();
            if (!file.exists()) break;
            n = JOptionPane.showConfirmDialog((Component)((Object)this.transferWorkbench), "File already exists.  Are you sure you with to overwrite it?", "File Alrady Exists", 1, 3);
            if (n == 1) {
                return false;
            }
            if (n != 1) break;
        }
        this.core.submit(new Runnable(){

            public void run() {
                try {
                    FileManips.CopyFile((File)file2, (File)file);
                }
                catch (IOException iOException) {
                    TransferMonitorHost.this.core.logEvent(Level.SEVERE, iOException.getMessage(), (Throwable)iOException);
                    JOptionPane.showMessageDialog((Component)((Object)TransferMonitorHost.this.transferWorkbench), String.format("Unable to save %s:  %s", file.getAbsolutePath(), iOException.getMessage()), "Error Saving File", 0);
                }
            }
        });
        return true;
    }

    private String getRemoteName(TransferRecord transferRecord) {
        return transferRecord.getRemote().replaceAll(".*[\\\\\\/]", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(TransferRecord transferRecord) {
        TransferDetails transferDetails = null;
        File file = this.getFileFromRecord(transferRecord);
        if (file == null) {
            return;
        }
        transferDetails = this.recordDetails.get(transferRecord);
        if (transferDetails == null) {
            try {
                transferDetails = new TransferDetails(transferRecord, file);
            }
            catch (IOException iOException) {
                return;
            }
            this.recordDetails.put(transferRecord, transferDetails);
            this.transferWorkbench.enqueAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{transferDetails});
        } else {
            Object object = this.WORKBENCH_LOCK;
            synchronized (object) {
                boolean bl = false;
                for (Component component : this.transferWorkbench.getComponents()) {
                    if (!component.equals(transferDetails.getDisplay())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    if (transferDetails.getFrame() != null && transferDetails.getFrame().isVisible()) {
                        transferDetails.getFrame().toFront();
                        return;
                    }
                    this.transferWorkbench.enqueAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{transferDetails});
                }
            }
        }
        this.transferWorkbench.enqueAction((Enum)Workbench.WorkbenchAction.SETSELECTEDTAB, new Object[]{transferDetails});
    }

    public File getFileFromRecord(TransferRecord transferRecord) {
        return new File(String.format("%s/%s/%s", this.core.getLogDirectory(), transferRecord.getSubDir(), transferRecord.getLocal()));
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("get");
        hashSet.add("put");
        hashSet.add("papercut");
        INTERESTING_COMMANDS = Collections.unmodifiableSet(hashSet);
    }
}

