/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.transfermonitor.displays;

import ddb.GuiConstants;
import ddb.dsz.plugin.transfermonitor.TransferTabbable;
import ddb.dsz.plugin.transfermonitor.displays.HexTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HexDisplay
extends TransferTabbable {
    byte[] data = null;
    HexTableModel model = new HexTableModel(8);
    JTable table = new JTable(this.model);
    int row = 0;
    int column = 0;

    public HexDisplay() {
        super("Binary");
        this.display.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.display.add((Component)jScrollPane, "Center");
        this.table.setRowSelectionAllowed(false);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setTableHeader(null);
        this.recalc();
        this.display.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                HexDisplay.this.recalc();
            }

            public void componentShown(ComponentEvent componentEvent) {
                HexDisplay.this.recalc();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void highlightMatchingCell() {
        HexDisplay hexDisplay = this;
        synchronized (hexDisplay) {
            if (this.column == 0) {
                return;
            }
            if (this.column < this.model.getColumns() + 1) {
                int n = this.column + this.model.getColumns();
                this.table.changeSelection(this.row, n, false, true);
                return;
            }
            if (this.column < this.model.getColumns() * 2 + 1) {
                int n = this.column - this.model.getColumns();
                this.table.changeSelection(this.row, n, false, true);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData() {
        HexDisplay hexDisplay = this;
        synchronized (hexDisplay) {
            return this.data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(byte[] byArray) {
        HexDisplay hexDisplay = this;
        synchronized (hexDisplay) {
            this.data = byArray;
            this.model.setData(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recalc() {
        HexDisplay hexDisplay = this;
        synchronized (hexDisplay) {
            JLabel jLabel = new JLabel();
            jLabel.setFont(GuiConstants.FIXED_WIDTH_FONT.Basic);
            Dimension dimension = null;
            int n = 100;
            int n2 = 100;
            int n3 = 100;
            int n4 = this.display.getWidth();
            jLabel.setText("AAAAAAAA");
            dimension = jLabel.getMinimumSize();
            if (dimension != null) {
                n = dimension.width;
            }
            jLabel.setText("AA");
            dimension = jLabel.getMinimumSize();
            if (dimension != null) {
                n2 = dimension.width * 35 / 20;
            }
            jLabel.setText("W");
            dimension = jLabel.getMinimumSize();
            if (dimension != null) {
                n3 = dimension.width * 35 / 20;
            }
            int n5 = (n4 -= n) / (n3 + n2);
            this.model.setColumns(n5);
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                if (i == 0) {
                    tableColumnModel.getColumn(0).setResizable(false);
                    tableColumnModel.getColumn(0).setMinWidth(n);
                    tableColumnModel.getColumn(0).setMaxWidth(n);
                    continue;
                }
                if (i < n5 + 1) {
                    tableColumnModel.getColumn(i).setResizable(false);
                    tableColumnModel.getColumn(i).setMinWidth(n2);
                    tableColumnModel.getColumn(i).setMaxWidth(n2);
                    continue;
                }
                tableColumnModel.getColumn(i).setResizable(false);
                tableColumnModel.getColumn(i).setMinWidth(n3);
                tableColumnModel.getColumn(i).setMaxWidth(n3);
            }
        }
    }

    @Override
    public boolean allowNewInstance(Class<?> clazz) {
        return true;
    }

    public boolean isClosable() {
        return false;
    }
}

