/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.transfermonitor.listeners.closure;

import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.task.Task;
import ddb.dsz.plugin.transfermonitor.listeners.RetrieveClosureInterface;
import ddb.dsz.plugin.transfermonitor.listeners.closure.ObjectValueClosure;
import ddb.dsz.plugin.transfermonitor.model.TransferRecord;
import ddb.util.GeneralUtilities;

public class FileStartClosure
extends ObjectValueClosure {
    private final RetrieveClosureInterface listener;

    public FileStartClosure(RetrieveClosureInterface retrieveClosureInterface) {
        this.listener = retrieveClosureInterface;
    }

    public void execute(ObjectValue objectValue, Task task) {
        String string = objectValue.getString("FileName");
        Long l = objectValue.getInteger("Size");
        String string2 = objectValue.getString("id");
        TransferRecord transferRecord = this.listener.getRecord(task.getId(), string2, true, false);
        if (transferRecord == null) {
            System.out.println("FileStart:  ABORT");
            return;
        }
        transferRecord.setResumable(this.listener.isResumable());
        transferRecord.setSize(l);
        transferRecord.setRemote(string);
        transferRecord.setAccessed(GeneralUtilities.stringToCalendar((String)objectValue.getString("FileTimes::Accessed::Time"), null));
        transferRecord.setCreated(GeneralUtilities.stringToCalendar((String)objectValue.getString("FileTimes::Created::Time"), null));
        transferRecord.setModified(GeneralUtilities.stringToCalendar((String)objectValue.getString("FileTimes::Modified::Time"), null));
        this.listener.recordChanged(transferRecord);
    }
}

