/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.library.console.builtins;

import ddb.dsz.library.console.Console;
import ddb.dsz.library.console.builtins.BuiltinCommand;
import ddb.dsz.library.console.builtins.BuiltinHandlerAdapter;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpHandler
extends BuiltinHandlerAdapter {
    Map<String, BuiltinCommand> commands;

    public HelpHandler(Console console, Map<String, BuiltinCommand> map) {
        super(console);
        this.commands = map;
    }

    @Override
    public boolean executeBuiltinCommand(String string, String string2) {
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                this.console.printBuiltinCommandHelp(stringTokenizer.nextToken());
            }
            return true;
        }
        this.printAllCommands(string);
        return true;
    }

    private void printAllCommands(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Available commands:\n");
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        for (String object : this.commands.keySet()) {
            treeSet.add(object);
            if (object.length() <= n) continue;
            n = object.length();
        }
        int n2 = 0;
        for (String string2 : treeSet) {
            stringBuilder.append(String.format(String.format("%%-%ds   ", n), string2));
            if (++n2 % 3 != 0) continue;
            stringBuilder.append("\n");
        }
        this.console.printString(stringBuilder.toString());
    }
}

