/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import ddb.util.AbstractEnumeratedTableModel;
import ddb.util.UtilityConstants;
import java.awt.EventQueue;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FrequentlyAppendedTableModel<Columns extends Enum<?>, DataObject>
extends AbstractEnumeratedTableModel<Columns> {
    private final ScheduledExecutorService exec = UtilityConstants.createScheduledExecutorService("FrequentlyAppendedTableModel");
    private static final int MAXIMUM = Integer.MAX_VALUE;
    private List<DataObject> data;
    private List<DataObject> pendingAdds;
    private List<DataObject> pendingDeletes;
    private int maximum;
    private long wait;
    private TimeUnit units;
    private RecordState state = RecordState.SHOW;
    private boolean stop = false;
    private Comparator<DataObject> Compare = null;
    private boolean bSort = false;
    private final ReadWriteLock dataLock = UtilityConstants.createReadWriteLock();
    private final Object PENDING_LOCK = new Object();
    Runnable update = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final List<DataObject> getTempAddList() {
            Vector vector = new Vector();
            Object object = FrequentlyAppendedTableModel.this.PENDING_LOCK;
            synchronized (object) {
                if (FrequentlyAppendedTableModel.this.pendingAdds.size() == 0 && FrequentlyAppendedTableModel.this.pendingDeletes.size() == 0) {
                    try {
                        FrequentlyAppendedTableModel.this.PENDING_LOCK.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                switch (FrequentlyAppendedTableModel.this.state) {
                    case DISCARD: {
                        FrequentlyAppendedTableModel.this.pendingAdds.clear();
                        FrequentlyAppendedTableModel.this.pendingDeletes.clear();
                        return vector;
                    }
                    case HOLD: {
                        try {
                            FrequentlyAppendedTableModel.this.PENDING_LOCK.wait();
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                List list = FrequentlyAppendedTableModel.this.pendingAdds.subList(0, Math.min(FrequentlyAppendedTableModel.this.pendingAdds.size(), Integer.MAX_VALUE));
                vector.addAll(list);
                list.clear();
                return vector;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                block36: {
                    int n;
                    Comparator comparator;
                    List list;
                    RecordState recordState;
                    List list2 = this.getTempAddList();
                    Vector vector = new Vector();
                    Vector<AbstractEnumeratedTableModel.FireTableModification> vector2 = FrequentlyAppendedTableModel.this.PENDING_LOCK;
                    synchronized (vector2) {
                        vector.addAll(FrequentlyAppendedTableModel.this.pendingDeletes);
                        FrequentlyAppendedTableModel.this.pendingDeletes.clear();
                    }
                    if (list2.size() == 0 && vector.size() == 0) {
                        return;
                    }
                    vector2 = new Vector<AbstractEnumeratedTableModel.FireTableModification>();
                    Vector vector3 = new Vector();
                    boolean bl = false;
                    FrequentlyAppendedTableModel.this.readLock();
                    try {
                        recordState = FrequentlyAppendedTableModel.this.state;
                        vector3.addAll(FrequentlyAppendedTableModel.this.data);
                        list = FrequentlyAppendedTableModel.this.data;
                        comparator = FrequentlyAppendedTableModel.this.Compare;
                    }
                    finally {
                        FrequentlyAppendedTableModel.this.readUnlock();
                    }
                    if (FrequentlyAppendedTableModel.this.bSort && comparator != null) {
                        FrequentlyAppendedTableModel.this.bSort = false;
                        FrequentlyAppendedTableModel.this.insertObservable.setChanged();
                        FrequentlyAppendedTableModel.this.updateObservable.setChanged();
                        vector3.addAll(list2);
                        Collections.sort(vector3, comparator);
                        if (FrequentlyAppendedTableModel.this.maximum != -1 && vector3.size() > FrequentlyAppendedTableModel.this.maximum) {
                            n = vector3.size() - FrequentlyAppendedTableModel.this.maximum + FrequentlyAppendedTableModel.this.maximum * 4 / 10;
                            vector3.subList(0, n).clear();
                        }
                        vector2.add(new AbstractEnumeratedTableModel.FireTableDataChanged());
                        bl = true;
                    } else {
                        for (Object object : list2) {
                            int n2 = FrequentlyAppendedTableModel.this.findIndex(vector3, object, comparator);
                            if (n2 < 0) {
                                ++n2;
                                n2 = -n2;
                                vector3.add(n2, object);
                                vector2.add((AbstractEnumeratedTableModel)FrequentlyAppendedTableModel.this.new AbstractEnumeratedTableModel.FireTableRowsInserted(n2, n2));
                                FrequentlyAppendedTableModel.this.insertObservable.setChanged();
                                continue;
                            }
                            vector2.add((AbstractEnumeratedTableModel)FrequentlyAppendedTableModel.this.new AbstractEnumeratedTableModel.FireTableRowsUpdated(n2, n2));
                            FrequentlyAppendedTableModel.this.updateObservable.setChanged();
                        }
                        if (vector2.size() * 10 >= vector3.size()) {
                            vector2.clear();
                            vector2.add(new AbstractEnumeratedTableModel.FireTableDataChanged());
                            bl = true;
                        }
                        for (n = 0; n < vector2.size() - 1; ++n) {
                            AbstractEnumeratedTableModel.FireTableModification fireTableModification;
                            if (((AbstractEnumeratedTableModel.FireTableModification)vector2.get(n)).getType() == AbstractEnumeratedTableModel.TableModificationType.Updated && ((AbstractEnumeratedTableModel.FireTableModification)vector2.get(n + 1)).getType() == AbstractEnumeratedTableModel.TableModificationType.Updated) {
                                AbstractEnumeratedTableModel.FireTableRowsUpdated fireTableRowsUpdated = (AbstractEnumeratedTableModel.FireTableRowsUpdated)vector2.get(n);
                                fireTableModification = (AbstractEnumeratedTableModel.FireTableRowsUpdated)vector2.get(n + 1);
                                if (fireTableRowsUpdated.lastRow + 1 == fireTableModification.firstRow) {
                                    fireTableRowsUpdated.lastRow = fireTableModification.lastRow;
                                    vector2.remove(n + 1);
                                    --n;
                                    continue;
                                }
                                if (fireTableRowsUpdated.lastRow > fireTableModification.firstRow) {
                                    fireTableRowsUpdated.lastRow = Math.max(fireTableRowsUpdated.lastRow, fireTableModification.lastRow);
                                }
                            }
                            if (((AbstractEnumeratedTableModel.FireTableModification)vector2.get(n)).getType() != AbstractEnumeratedTableModel.TableModificationType.Inserted || ((AbstractEnumeratedTableModel.FireTableModification)vector2.get(n + 1)).getType() != AbstractEnumeratedTableModel.TableModificationType.Inserted) continue;
                            AbstractEnumeratedTableModel.FireTableRowsInserted fireTableRowsInserted = (AbstractEnumeratedTableModel.FireTableRowsInserted)vector2.get(n);
                            fireTableModification = (AbstractEnumeratedTableModel.FireTableRowsInserted)vector2.get(n + 1);
                            if (fireTableRowsInserted.lastRow + 1 == ((AbstractEnumeratedTableModel.FireTableRowsInserted)fireTableModification).firstRow) {
                                fireTableRowsInserted.lastRow = ((AbstractEnumeratedTableModel.FireTableRowsInserted)fireTableModification).lastRow;
                                vector2.remove(n + 1);
                                --n;
                                continue;
                            }
                            if (fireTableRowsInserted.lastRow <= ((AbstractEnumeratedTableModel.FireTableRowsInserted)fireTableModification).firstRow) continue;
                            fireTableRowsInserted.lastRow = Math.max(fireTableRowsInserted.lastRow, ((AbstractEnumeratedTableModel.FireTableRowsInserted)fireTableModification).lastRow);
                        }
                        FrequentlyAppendedTableModel.this.writeLock();
                        try {
                            if (recordState == RecordState.SHOW && FrequentlyAppendedTableModel.this.maximum != -1 && vector3.size() > FrequentlyAppendedTableModel.this.maximum) {
                                n = vector3.size() - FrequentlyAppendedTableModel.this.maximum + FrequentlyAppendedTableModel.this.maximum * 4 / 10;
                                vector3.subList(0, n).clear();
                                vector2.clear();
                                vector2.add(new AbstractEnumeratedTableModel.FireTableDataChanged());
                                bl = true;
                            }
                        }
                        finally {
                            FrequentlyAppendedTableModel.this.writeUnlock();
                        }
                    }
                    for (Object e : vector) {
                        int n3 = FrequentlyAppendedTableModel.this.findIndex(vector3, e, comparator);
                        if (n3 < 0) continue;
                        vector3.remove(n3);
                        if (bl) continue;
                        vector2.add((AbstractEnumeratedTableModel)FrequentlyAppendedTableModel.this.new AbstractEnumeratedTableModel.FireTableRowsDeleted(n3, n3));
                    }
                    FrequentlyAppendedTableModel.this.writeLock();
                    try {
                        if (list == FrequentlyAppendedTableModel.this.data) {
                            FrequentlyAppendedTableModel.this.data = vector3;
                            for (AbstractEnumeratedTableModel.FireTableModification fireTableModification : vector2) {
                                EventQueue.invokeLater(fireTableModification);
                            }
                            break block36;
                        }
                        return;
                    }
                    finally {
                        FrequentlyAppendedTableModel.this.writeUnlock();
                    }
                }
                FrequentlyAppendedTableModel.this.updateObservable.notifyObservers();
                FrequentlyAppendedTableModel.this.insertObservable.notifyObservers();
            }
            finally {
                if (!FrequentlyAppendedTableModel.this.stop) {
                    FrequentlyAppendedTableModel.this.exec.schedule(this, FrequentlyAppendedTableModel.this.wait, FrequentlyAppendedTableModel.this.units);
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComparator(Comparator<DataObject> comparator) {
        this.writeLock();
        try {
            this.Compare = comparator;
            if (this.Compare != null) {
                this.bSort = true;
            }
        }
        finally {
            this.writeUnlock();
        }
        if (comparator != null) {
            Object object = this.PENDING_LOCK;
            synchronized (object) {
                Collections.sort(this.pendingAdds, comparator);
            }
        }
    }

    private int findIndex(List<DataObject> list, DataObject DataObject, Comparator<DataObject> comparator) {
        if (comparator != null) {
            return Collections.binarySearch(list, DataObject, comparator);
        }
        if (DataObject instanceof Comparable) {
            return Collections.binarySearch(list, DataObject);
        }
        int n = list.indexOf(DataObject);
        if (n < 0) {
            return -list.size() - 1;
        }
        return n;
    }

    public void readLock() {
        this.dataLock.readLock().lock();
    }

    public void readUnlock() {
        this.dataLock.readLock().unlock();
    }

    public void writeLock() {
        this.dataLock.writeLock().lock();
    }

    public void writeUnlock() {
        this.dataLock.writeLock().unlock();
    }

    public FrequentlyAppendedTableModel(Class<Columns> clazz) {
        this(clazz, 250L, TimeUnit.MILLISECONDS);
    }

    public FrequentlyAppendedTableModel(Class<Columns> clazz, long l, TimeUnit timeUnit) {
        this(clazz, l, timeUnit, -1);
    }

    public FrequentlyAppendedTableModel(Class<Columns> clazz, long l, TimeUnit timeUnit, int n) {
        super(clazz);
        this.wait = l;
        this.units = timeUnit;
        this.maximum = n;
        this.data = new Vector<DataObject>();
        this.pendingAdds = new Vector<DataObject>();
        this.pendingDeletes = new Vector<DataObject>();
        this.exec.submit(this.update);
    }

    public void stop() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject getRecord(int n) {
        this.readLock();
        try {
            if (n < 0 || n >= this.data.size()) {
                DataObject DataObject = null;
                return DataObject;
            }
            DataObject DataObject = this.data.get(n);
            return DataObject;
        }
        finally {
            this.readUnlock();
        }
    }

    public final void addRecord(DataObject DataObject) {
        this.addOrUpdateRecord(DataObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateRecord(DataObject DataObject) {
        Object object = this.PENDING_LOCK;
        synchronized (object) {
            if (this.state == RecordState.DISCARD) {
                return;
            }
            int n = this.findIndex(this.pendingAdds, DataObject, this.Compare);
            if (n >= 0) {
                return;
            }
            ++n;
            n = -n;
            this.pendingAdds.add(n, DataObject);
            this.PENDING_LOCK.notify();
        }
    }

    public final void updateRecord(DataObject DataObject) {
        this.addOrUpdateRecord(DataObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteRecord(DataObject DataObject) {
        Object object = this.PENDING_LOCK;
        synchronized (object) {
            if (this.state == RecordState.DISCARD) {
                return;
            }
            this.pendingDeletes.add(DataObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecordState(RecordState recordState) {
        this.writeLock();
        try {
            this.state = recordState;
        }
        finally {
            this.writeUnlock();
        }
        Object object = this.PENDING_LOCK;
        synchronized (object) {
            try {
                this.PENDING_LOCK.notify();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        this.readLock();
        try {
            int n = this.data.size();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    public void setMaximum(int n) {
        this.maximum = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock();
        try {
            Object object = this.PENDING_LOCK;
            synchronized (object) {
                this.pendingAdds = new Vector<DataObject>();
            }
            this.data = new Vector<DataObject>();
            EventQueue.invokeLater(new AbstractEnumeratedTableModel.FireTableDataChanged());
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void updated(DataObject DataObject) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeObject(DataObject DataObject) {
        int n = -1;
        this.writeLock();
        try {
            Object object = this.PENDING_LOCK;
            synchronized (object) {
                this.pendingAdds.remove(DataObject);
            }
            n = this.data.indexOf(DataObject);
            if (n > 0) {
                this.data.remove(n);
                EventQueue.invokeLater((AbstractEnumeratedTableModel)this.new AbstractEnumeratedTableModel.FireTableRowsDeleted(n, n));
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecordState {
        SHOW,
        HOLD,
        DISCARD,
        KEEP;

    }
}

