/*
 * Decompiled with CFR 0.152.
 */
package ddb.util.checkedtablemodel;

import ddb.util.checkedtablemodel.CheckBoxEditor;
import ddb.util.checkedtablemodel.CheckBoxRenderer;
import ddb.util.checkedtablemodel.CheckedTableColumns;
import ddb.util.checkedtablemodel.CheckedTableModel;
import ddb.util.checkedtablemodel.CheckedTableSelection;
import ddb.util.checkedtablemodel.DataEntry;
import ddb.util.checkedtablemodel.listeners.HideAllListener;
import ddb.util.checkedtablemodel.listeners.HideThisListener;
import ddb.util.checkedtablemodel.listeners.ShowAllListener;
import ddb.util.checkedtablemodel.listeners.ShowOnlyThisListener;
import ddb.util.tablefilter.sample.ColumnHidingModel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckableFilterList<T>
extends JPanel {
    JTable table;
    JPopupMenu menu = new JPopupMenu();
    Object menuSelection = null;
    CheckedTableModel<T> model;
    Comparator<Object> comp;

    public CheckableFilterList(String string, CheckedTableSelection<T> checkedTableSelection, Comparator<T> comparator) {
        super(new BorderLayout());
        this.table = new JTable();
        this.setPreferredSize(new Dimension(250, 0));
        this.model = new CheckedTableModel<T>(checkedTableSelection, comparator);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string));
        ColumnHidingModel columnHidingModel = new ColumnHidingModel(CheckedTableColumns.class);
        this.table.setColumnModel(columnHidingModel);
        this.table.setModel(this.model);
        this.table.setShowGrid(false);
        this.table.setTableHeader(null);
        this.table.setDefaultEditor(Boolean.class, new CheckBoxEditor(this.model));
        this.table.setDefaultRenderer(Boolean.class, new CheckBoxRenderer(this.model));
        this.table.setAutoResizeMode(3);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.addMenuItem("Show All", new ShowAllListener(this), false);
        this.addMenuItem("Hide All", new HideAllListener(this), false);
        this.menu.addSeparator();
        this.addMenuItem("Show Only This", new ShowOnlyThisListener(this), true);
        this.addMenuItem("Hide This", new HideThisListener(this), true);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    return;
                }
                int n = mouseEvent.getY() / CheckableFilterList.this.table.getRowHeight();
                CheckableFilterList.this.menuSelection = CheckableFilterList.this.table.getRowCount() > n && n > -1 ? CheckableFilterList.this.model.getValueAt(n, CheckedTableColumns.TAG.ordinal()) : null;
                CheckableFilterList.this.menu.show(CheckableFilterList.this.table, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                this.update(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                this.update(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                this.update(mouseEvent);
            }

            private void update(MouseEvent mouseEvent) {
                int n = mouseEvent.getY() / CheckableFilterList.this.table.getRowHeight();
                if (n >= 0 && n < CheckableFilterList.this.table.getRowCount()) {
                    DataEntry dataEntry = (DataEntry)CheckableFilterList.this.model.getValueAt(n, CheckedTableColumns.OBJECT.ordinal());
                    CheckableFilterList.this.table.setToolTipText(dataEntry.getTooltip());
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.add(jScrollPane);
        columnHidingModel.hide(CheckedTableColumns.CAPTION);
        columnHidingModel.hide(CheckedTableColumns.TAG);
        columnHidingModel.hide(CheckedTableColumns.OBJECT);
    }

    private void addMenuItem(String string, ActionListener actionListener, boolean bl) {
        final JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        this.menu.add(jMenuItem);
        if (bl) {
            this.menu.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent componentEvent) {
                    jMenuItem.setEnabled(CheckableFilterList.this.menuSelection != null);
                }
            });
        }
    }

    public void showAll() {
        this.model.showAll();
    }

    public void hideAll() {
        this.model.hideAll();
    }

    public void hideThis() {
        this.model.hide(this.menuSelection);
    }

    public void showOnlyThis() {
        this.model.showOnly(this.menuSelection);
    }

    public boolean addElement(T t, boolean bl) {
        return this.addElement(null, t, bl);
    }

    public boolean addElement(String string, T t, boolean bl) {
        return this.addElement(string, string, t, bl);
    }

    public boolean addElement(String string, String string2, T t, boolean bl) {
        return this.model.addElement(string, string2, t, bl);
    }

    public void deleteElement(T t) {
        this.model.deleteElement(t);
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public Object getItem(int n) {
        return this.model.getValueAt(n, CheckedTableColumns.TAG);
    }
}

