/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.core.task.impl;

import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskDataAccess;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.io.StringReader;

public class StringAccess
implements TaskDataAccess {
    private static final String MEMORY = "Memory";
    private final String xml;
    private final String relativeLocation;
    private final Task task;
    private final TaskDataAccess.DataType type;

    public StringAccess(TaskDataAccess taskDataAccess, String string) {
        this.xml = string;
        this.relativeLocation = taskDataAccess.getRelativeLocation();
        this.task = taskDataAccess.getTask();
        this.type = taskDataAccess.getType();
    }

    public final Task getTask() {
        return this.task;
    }

    public final TaskDataAccess.DataType getType() {
        return this.type;
    }

    public int getOrdinal() {
        return -1;
    }

    public boolean isGenerated() {
        return true;
    }

    public StringReader getReader() {
        return new StringReader(this.xml);
    }

    @Deprecated
    public InputStream getStream() {
        return new StringBufferInputStream(this.xml);
    }

    public long getSize() {
        return this.xml.length();
    }

    public String getLocation() {
        return MEMORY;
    }

    public String getLocationType() {
        return MEMORY;
    }

    public String getRelativeLocation() {
        return this.relativeLocation;
    }

    public String toString() {
        return String.format("String:  %s", this.xml.substring(0, Math.min(300, this.xml.length())));
    }
}

