/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.verifier;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskDataAccess;
import ddb.dsz.plugin.verifier.SchemaResource;
import ddb.util.UtilityConstants;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class VerificationDelegate {
    static final ScheduledExecutorService exec = UtilityConstants.createScheduledExecutorService((int)10, (String)"VerificationDelegate");
    final Task task;
    final TaskDataAccess access;
    final CoreController core;
    boolean issueOccurred = false;
    boolean shouldRepeat = false;
    StringBuilder log = new StringBuilder();

    public VerificationDelegate(Task task, TaskDataAccess taskDataAccess, CoreController coreController) {
        this.task = task;
        this.access = taskDataAccess;
        this.core = coreController;
    }

    public void verify() {
        String string = "Commands//Schemas";
        File file = new File(String.format("%s/%sTest/%s/%s.xsd", this.core.getResourceDirectory(), this.task.getResourceDirectory(), string, this.task.getCommandName()));
        if (!file.exists()) {
            this.log.append(String.format("File (%s) does not exist", file.getAbsolutePath()));
            this.issueOccurred = true;
            return;
        }
        ErrorHandlerImpl errorHandlerImpl = new ErrorHandlerImpl("Schema");
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setErrorHandler(errorHandlerImpl);
            schemaFactory.setResourceResolver(new LSResourceResolverImpl(this.core.getResourceDirectory(), string, this.task.getResourceDirectory(), String.format("%sTest", this.core.getDefaultPackage())));
            Schema schema = schemaFactory.newSchema(file);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setSchema(schema);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new InputSource(this.access.getReader()), (DefaultHandler)new ErrorHandlerImpl(this.access.toString()));
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            this.log.append(string2 + "\n");
            if (string2.equals("XML document structures must start and end within the same entity.")) {
                this.log.append("*******************************************************************\nThis error has been known to occur in rare occasions where the data\nfile has not been flushed to disk.  If it is the first time you are\nseeing it, reverify the command (right-click on the command, select\n'Reverify'; or click the Revefify button on the bottom right).  If\nthe command still has the issue, you have a problem.  Otherwise,\nyou are fine.\n*******************************************************************\n");
                this.shouldRepeat = true;
            }
            this.issueOccurred = true;
        }
    }

    public boolean isValid() {
        return !this.issueOccurred;
    }

    public String getDetails() {
        return this.log.toString();
    }

    public boolean shouldRepeat() {
        return this.shouldRepeat;
    }

    private class ErrorHandlerImpl
    extends DefaultHandler2
    implements ErrorHandler {
        String obj;

        private ErrorHandlerImpl(String string) {
            this.obj = string;
        }

        private void printMessage(String string, SAXParseException sAXParseException) {
            VerificationDelegate.this.issueOccurred = true;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append(":  ");
            stringBuilder.append(sAXParseException.getLocalizedMessage());
            stringBuilder.append("\n");
            stringBuilder.append("\t");
            stringBuilder.append(this.obj);
            stringBuilder.append(" (line ");
            stringBuilder.append(sAXParseException.getLineNumber());
            stringBuilder.append(", column ");
            stringBuilder.append(sAXParseException.getColumnNumber());
            stringBuilder.append(")\n\n");
            this.append(stringBuilder.toString());
        }

        private void append(String string) {
            VerificationDelegate.this.log.append(string);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.printMessage("Warning", sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.printMessage("Error", sAXParseException);
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.printMessage("Fatal Error", sAXParseException);
            throw sAXParseException;
        }
    }

    private static class LSResourceResolverImpl
    implements LSResourceResolver {
        String resourceDir;
        String suffix;
        String[] paths;

        public LSResourceResolverImpl(String string, String string2, String ... stringArray) {
            this.resourceDir = string;
            this.suffix = string2;
            this.paths = stringArray;
        }

        public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
            for (String string6 : this.paths) {
                File file = new File(String.format("%s/%s/%s/%s", this.resourceDir, string6, this.suffix, string4));
                if (!file.exists()) continue;
                return new SchemaResource(file);
            }
            return null;
        }
    }
}

