/*
 * Decompiled with CFR 0.152.
 */
package ds.core;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class ConfirmExit
extends JDialog {
    int count = 5;
    ScheduledExecutorService exec;
    String exitText = "Exit Operation";
    boolean m_quit = false;
    private JButton exit;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JButton resume;

    public ConfirmExit(Frame frame, boolean bl, ScheduledExecutorService scheduledExecutorService) {
        super(frame, bl);
        this.exec = scheduledExecutorService;
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.resume = new JButton();
        this.exit = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Confirm Exit");
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setResizable(false);
        this.jLabel1.setText("You are still connected to at least one target.");
        this.jLabel2.setText("Are you certain you wish to exit?");
        this.resume.setText("Resume Operation");
        this.resume.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfirmExit.this.resumeActionPerformed(actionEvent);
            }
        });
        this.exit.setText("Exit Operation (5 seconds)");
        this.exit.setEnabled(false);
        this.exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfirmExit.this.exitActionPerformed(actionEvent);
            }
        });
        this.jLabel3.setText(" ");
        this.jLabel4.setText(" ");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1, -1, 295, Short.MAX_VALUE).addGap(14, 14, 14)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel2, -1, 235, Short.MAX_VALUE).addGap(74, 74, 74)).addGroup(groupLayout.createSequentialGroup().addComponent(this.resume).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exit, -2, 163, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addGap(10, 10, 10))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resume).addComponent(this.exit).addComponent(this.jLabel4).addComponent(this.jLabel3)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void exitActionPerformed(ActionEvent actionEvent) {
        this.m_quit = true;
        this.setVisible(false);
        this.dispose();
    }

    private void resumeActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ConfirmExit confirmExit = new ConfirmExit((Frame)new JFrame(), true, new ScheduledThreadPoolExecutor(1));
                confirmExit.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                confirmExit.setVisible(true);
            }
        });
    }

    public boolean query() {
        this.exit.setText(String.format("(%d seconds)", this.count));
        this.exec.schedule(new Runnable(){

            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeLater(this);
                } else {
                    --ConfirmExit.this.count;
                    if (ConfirmExit.this.count == 0) {
                        ConfirmExit.this.exit.setText(ConfirmExit.this.exitText);
                        ConfirmExit.this.exit.setEnabled(true);
                    } else {
                        ConfirmExit.this.exit.setText(String.format("(%d seconds)", ConfirmExit.this.count));
                        ConfirmExit.this.exec.schedule(this, 1L, TimeUnit.SECONDS);
                    }
                }
            }
        }, 1L, TimeUnit.SECONDS);
        Point point = this.getParent().getLocation();
        point.x += (this.getParent().getWidth() - this.getWidth()) / 2;
        point.y += (this.getParent().getHeight() - this.getHeight()) / 2;
        this.setLocation(point);
        this.setVisible(true);
        return this.m_quit;
    }
}

