/*
 * Decompiled with CFR 0.152.
 */
package ds.core;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.command.CommandEventAdapter;
import ddb.dsz.core.command.CommandEventListener;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.ClosureFactory;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.DataTransformer;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ds.core.controller.MutableCoreController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManager {
    private static final Collection<String> INTERESTING_COMMANDS;
    private final MutableCoreController mutableCore;
    private final DataTransformer transformer = DataTransformer.newInstance((String)"UserManager");
    private final List<UserInstance> ValidInstances = new ArrayList<UserInstance>();

    public UserManager(MutableCoreController mutableCoreController) {
        this.mutableCore = mutableCoreController;
        this.transformer.addClosure(ClosureFactory.newVariableClosure((CoreController)mutableCoreController, (String)"logonasuser", (String)"ZBng", (Closure)new Closure(){

            public void execute(Object object) {
                if (object == null || !(object instanceof DataEvent)) {
                    return;
                }
                DataEvent dataEvent = (DataEvent)object;
                if (!dataEvent.getDataType().equals((Object)DataEvent.DataEventType.DATA)) {
                    return;
                }
                UserManager.this.add(new UserInstance(dataEvent.getTaskId(), dataEvent.getData().getString("logon::alias")));
            }
        }));
        this.transformer.addClosure(ClosureFactory.newVariableClosure((CoreController)mutableCoreController, (String)"duplicatetoken", (String)"ZBng", (Closure)new Closure(){

            public void execute(Object object) {
                if (object == null || !(object instanceof DataEvent)) {
                    return;
                }
                DataEvent dataEvent = (DataEvent)object;
                if (!dataEvent.getDataType().equals((Object)DataEvent.DataEventType.DATA)) {
                    return;
                }
                UserManager.this.add(new UserInstance(dataEvent.getTaskId(), dataEvent.getData().getString("token::alias")));
            }
        }));
        mutableCoreController.addCommandEventListener((CommandEventListener)new CommandEventAdapter(){

            public boolean caresAboutLocalEvents() {
                return true;
            }

            public boolean caresAboutRepeatedEvents() {
                return true;
            }

            public void commandEventReceived(CommandEvent commandEvent) {
                Task task = UserManager.this.mutableCore.getTaskById(commandEvent.getId());
                if (task == null) {
                    return;
                }
                if (INTERESTING_COMMANDS.contains(task.getCommandName().toLowerCase())) {
                    UserManager.this.transformer.addTask(task);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(UserInstance userInstance) {
        if (userInstance == null || userInstance.alias == null || userInstance.task == null) {
            return;
        }
        List<UserInstance> list = this.ValidInstances;
        synchronized (list) {
            for (UserInstance userInstance2 : this.ValidInstances) {
                if (!userInstance2.task.equals((Object)userInstance.task)) continue;
                return;
            }
            this.ValidInstances.add(userInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> usersByHost(HostInfo hostInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<UserInstance> list = this.ValidInstances;
        synchronized (list) {
            Iterator<UserInstance> iterator = this.ValidInstances.iterator();
            while (iterator.hasNext()) {
                UserInstance userInstance = iterator.next();
                if (userInstance == null) continue;
                Task task = this.mutableCore.getTaskById(userInstance.task);
                if (!task.isAlive()) {
                    iterator.remove();
                    continue;
                }
                if (!task.getHost().sameHost(hostInfo)) continue;
                arrayList.add(userInstance.alias);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("logonasuser");
        hashSet.add("duplicatetoken");
        INTERESTING_COMMANDS = Collections.unmodifiableSet(hashSet);
    }

    private class UserInstance {
        public final TaskId task;
        public final String alias;

        public UserInstance(TaskId taskId, String string) {
            this.task = taskId;
            this.alias = string;
        }

        public String toString() {
            return String.format("%d: %s", this.task.getId(), this.alias);
        }
    }
}

