/*
 * Decompiled with CFR 0.152.
 */
package ds.core.commanddispatcher;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.operation.MutableOperation;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.MutableTask;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskDataAccess;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.core.task.TaskState;
import ddb.predicate.PredicateClosure;
import ddb.predicate.PredicateClosureImpl;
import ddb.util.DszDefaultHandler;
import ddb.util.FinishedProcessingException;
import ddb.util.GeneralUtilities;
import ddb.util.Guid;
import ds.core.commanddispatcher.AbstractCommandDispatcher;
import ds.core.commanddispatcher.CommandDispatcher;
import ds.core.commanddispatcher.EventPublisher;
import ds.core.commandevents.CommandEventImpl;
import ds.core.controller.MutableCoreController;
import ds.core.impl.HostInfoImpl;
import ds.core.impl.OperationImpl;
import ds.core.impl.task.FileAccess;
import ds.core.impl.task.TaskImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.ClosureUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.SwitchClosure;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReplayCommandDispatcher
extends AbstractCommandDispatcher
implements CommandDispatcher {
    public static ReplayCommandDispatcher REF = null;
    PredicateClosure[] elementHandlerList = new PredicateClosure[]{new PredicateClosureImpl((Predicate)new ElementNameMatches("DataLog"), ClosureUtils.nopClosure()), new PredicateClosureImpl((Predicate)new ElementNameMatches("Instance"), new Closure(){

        public void execute(Object object) {
            DszDefaultHandler.Element element = (DszDefaultHandler.Element)object;
            OperationImpl operationImpl = OperationImpl.GenerateOperation(Guid.GenerateGuid((String)element.getAttribute("id")), GeneralUtilities.stringToCalendar((String)element.getAttribute("lptimestamp"), null));
            ReplayCommandDispatcher.super.setOperation(operationImpl);
            ReplayCommandDispatcher.this.setFinished(ReplayCommandDispatcher.this.guidOnly);
            ReplayCommandDispatcher.this.stop = ReplayCommandDispatcher.this.guidOnly;
        }
    }), new PredicateClosureImpl((Predicate)new ElementNameMatches("Target"), new Closure(){

        public void execute(Object object) {
            if (ReplayCommandDispatcher.this.guidOnly) {
                return;
            }
            DszDefaultHandler.Element element = (DszDefaultHandler.Element)object;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(element.getAttribute("majorVersion"));
            stringBuilder.append(".");
            stringBuilder.append(element.getAttribute("minorVersion"));
            stringBuilder.append(".");
            stringBuilder.append(element.getAttribute("otherVersion"));
            ReplayCommandDispatcher.this.mutableCore.addHostInfo((HostInfo)new HostInfoImpl(element.getAttribute("addr"), "unknown", stringBuilder.toString(), element.getAttribute("arch"), element.getAttribute("platform"), "unknown", true, false));
        }
    }), new PredicateClosureImpl((Predicate)new ElementNameMatches("Alias"), new Closure(){

        public void execute(Object object) {
            if (ReplayCommandDispatcher.this.guidOnly) {
                return;
            }
            DszDefaultHandler.Element element = (DszDefaultHandler.Element)object;
            Operation operation = ReplayCommandDispatcher.this.getOperation();
            if (operation instanceof MutableOperation) {
                ((MutableOperation)MutableOperation.class.cast(operation)).setLastTime(GeneralUtilities.stringToCalendar((String)element.getAttribute("lptimestamp"), null));
            }
        }
    }), new PredicateClosureImpl((Predicate)new ElementNameMatches("Connect"), new Closure(){

        public void execute(Object object) {
            if (ReplayCommandDispatcher.this.guidOnly) {
                return;
            }
            DszDefaultHandler.Element element = (DszDefaultHandler.Element)object;
            Operation operation = ReplayCommandDispatcher.this.getOperation();
            if (operation instanceof MutableOperation) {
                ((MutableOperation)MutableOperation.class.cast(operation)).setLastTime(GeneralUtilities.stringToCalendar((String)element.getAttribute("lptimestamp"), null));
            }
            String string = element.getAttribute("targetAddr", "z0.0.0.0");
            String string2 = String.format("%s.%s.%s", element.getAttribute("versionMajor", "0"), element.getAttribute("versionMinor", "0"), element.getAttribute("versionRevision", "0"));
            String string3 = element.getAttribute("hostname", "unknown");
            String string4 = element.getAttribute("arch", "unknown arch");
            String string5 = element.getAttribute("os", "unknown os");
            String string6 = "unknown";
            boolean bl = false;
            boolean bl2 = true;
            HostInfoImpl hostInfoImpl = new HostInfoImpl(string, string3, string2, string4, string5, string6, bl, bl2);
            ReplayCommandDispatcher.this.mutableCore.addHostInfo((HostInfo)hostInfoImpl);
        }
    }), new PredicateClosureImpl((Predicate)new ElementNameMatches("Disconnect"), new Closure(){

        public void execute(Object object) {
            if (ReplayCommandDispatcher.this.guidOnly) {
                return;
            }
            DszDefaultHandler.Element element = (DszDefaultHandler.Element)object;
            Operation operation = ReplayCommandDispatcher.this.getOperation();
            if (operation instanceof MutableOperation) {
                ((MutableOperation)MutableOperation.class.cast(operation)).setLastTime(GeneralUtilities.stringToCalendar((String)element.getAttribute("lptimestamp"), null));
            }
            String string = element.getAttribute("targetAddr", "z0.0.0.0");
            ReplayCommandDispatcher.this.mutableCore.disconnected(string);
        }
    }), new PredicateClosureImpl((Predicate)new ElementNameMatches("CommandInput"), new Closure(){

        public void execute(Object object) {
            int n;
            if (ReplayCommandDispatcher.this.guidOnly) {
                return;
            }
            DszDefaultHandler.Element element = (DszDefaultHandler.Element)object;
            Operation operation = ReplayCommandDispatcher.this.getOperation();
            if (operation instanceof MutableOperation) {
                ((MutableOperation)MutableOperation.class.cast(operation)).setLastTime(GeneralUtilities.stringToCalendar((String)element.getAttribute("lptimestamp"), null));
            }
            String string = element.getAttribute("defaultTarget", "0.0.0.1");
            String string2 = element.getAttribute("id");
            String string3 = element.getAttribute("lptimestamp");
            String string4 = element.getAttribute("pid");
            String string5 = element.getText();
            TaskImpl taskImpl = new TaskImpl(string5, null);
            taskImpl.setHost(ReplayCommandDispatcher.this.core.getHostById(string));
            taskImpl.setId(ReplayCommandDispatcher.this.createTaskId(Integer.parseInt(string2)));
            if (string4 != null && (n = Integer.parseInt(string4)) > 0) {
                TaskId taskId = ReplayCommandDispatcher.this.createTaskId(n);
                Task task = ReplayCommandDispatcher.this.core.getTaskById(taskId);
                if (task == null) {
                    System.out.println("break");
                }
                taskImpl.setParent(task);
            }
            taskImpl.setCreated(GeneralUtilities.stringToCalendar((String)string3, null));
            taskImpl.setState(TaskState.TASKED);
        }
    }), new PredicateClosureImpl((Predicate)new ElementNameMatches("CommandStart"), new Closure(){

        public void execute(Object object) {
            if (ReplayCommandDispatcher.this.guidOnly) {
                return;
            }
            DszDefaultHandler.Element element = (DszDefaultHandler.Element)object;
            Operation operation = ReplayCommandDispatcher.this.getOperation();
            if (operation instanceof MutableOperation) {
                ((MutableOperation)MutableOperation.class.cast(operation)).setLastTime(GeneralUtilities.stringToCalendar((String)element.getAttribute("lptimestamp"), null));
            }
            String string = element.getAttribute("id");
            Guid guid = Guid.GenerateGuid((String)element.getAttribute("taskId"));
            String string2 = element.getText();
            MutableTask mutableTask = (MutableTask)MutableTask.class.cast(ReplayCommandDispatcher.this.core.getTaskById(ReplayCommandDispatcher.this.createTaskId(Integer.parseInt(string))));
            if (mutableTask != null) {
                mutableTask.setState(TaskState.RUNNING);
                mutableTask.setFullCommandLine(string2);
                mutableTask.setTaskId(guid);
            }
            mutableTask.setResourceDirectory(null);
            ReplayCommandDispatcher.this.mutableCore.addNewTask(mutableTask);
        }
    }), new PredicateClosureImpl((Predicate)new ElementNameMatches("CommandXml"), new Closure(){

        public void execute(Object object) {
            if (ReplayCommandDispatcher.this.guidOnly) {
                return;
            }
            DszDefaultHandler.Element element = (DszDefaultHandler.Element)object;
            Operation operation = ReplayCommandDispatcher.this.getOperation();
            if (operation instanceof MutableOperation) {
                ((MutableOperation)MutableOperation.class.cast(operation)).setLastTime(GeneralUtilities.stringToCalendar((String)element.getAttribute("lptimestamp"), null));
            }
            String string = element.getAttribute("id");
            String string2 = element.getAttribute("name");
            String string3 = element.getAttribute("storageTransform");
            String string4 = element.getAttribute("displayTransform");
            String string5 = element.getAttribute("targetAddr");
            String string6 = element.getAttribute("taskId");
            String string7 = element.getText();
            MutableTask mutableTask = (MutableTask)MutableTask.class.cast(ReplayCommandDispatcher.this.core.getTaskById(ReplayCommandDispatcher.this.createTaskId(Integer.parseInt(string))));
            if (mutableTask == null) {
                return;
            }
            mutableTask.setHost(ReplayCommandDispatcher.this.core.getHostById(string5));
            mutableTask.setTaskingInformation((TaskDataAccess)new FileAccess((Task)mutableTask, TaskDataAccess.DataType.TASKING, new File(String.format("%s/%s", ReplayCommandDispatcher.this.core.getLogDirectory(), string7)), string7, mutableTask.getNextOrdinal()));
            mutableTask.setCommandName(string2);
            mutableTask.setStorageTransform(string3);
            mutableTask.setDisplayTransform(string4);
            if (string6 != null) {
                mutableTask.setTaskId(Guid.GenerateGuid((String)string6));
            }
            CommandEventImpl commandEventImpl = new CommandEventImpl(ReplayCommandDispatcher.this, CommandEvent.CommandEventType.STARTED, (Task)mutableTask);
            commandEventImpl.setCurrentOperation(false);
            commandEventImpl.setTimestamp(mutableTask.getCreated());
            commandEventImpl.setTargetAddress(mutableTask.getTargetId());
            ReplayCommandDispatcher.this.publishEvent(commandEventImpl);
        }
    }), new PredicateClosureImpl((Predicate)new ElementNameMatches("CommandInterrupt"), ClosureUtils.nopClosure()), new PredicateClosureImpl((Predicate)new ElementNameMatches("DataXml"), new Closure(){

        public void execute(Object object) {
            if (ReplayCommandDispatcher.this.guidOnly) {
                return;
            }
            DszDefaultHandler.Element element = (DszDefaultHandler.Element)object;
            Operation operation = ReplayCommandDispatcher.this.getOperation();
            if (operation instanceof MutableOperation) {
                ((MutableOperation)MutableOperation.class.cast(operation)).setLastTime(GeneralUtilities.stringToCalendar((String)element.getAttribute("lptimestamp"), null));
            }
            try {
                TaskId taskId;
                Object object2;
                Task task = null;
                String string = element.getAttribute("id");
                if (string == null) {
                    object2 = Guid.GenerateGuid((String)element.getAttribute("taskId"));
                    task = ReplayCommandDispatcher.this.core.getTaskByTaskId(object2);
                } else {
                    int n = Integer.parseInt(element.getAttribute("id"));
                    taskId = ReplayCommandDispatcher.this.createTaskId(n);
                    task = ReplayCommandDispatcher.this.core.getTaskById(taskId);
                }
                if (task == null) {
                    return;
                }
                object2 = element.getText();
                taskId = (MutableTask)MutableTask.class.cast(task);
                taskId.addDataInformation((TaskDataAccess)new FileAccess(task, TaskDataAccess.DataType.DATA, new File(ReplayCommandDispatcher.this.core.getLogDirectory(), (String)object2), (String)object2, task.getNextOrdinal()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }), new PredicateClosureImpl((Predicate)new ElementNameMatches("CommandLog"), new Closure(){

        public void execute(Object object) {
            if (ReplayCommandDispatcher.this.guidOnly) {
                return;
            }
            DszDefaultHandler.Element element = (DszDefaultHandler.Element)object;
            Operation operation = ReplayCommandDispatcher.this.getOperation();
            if (operation instanceof MutableOperation) {
                ((MutableOperation)MutableOperation.class.cast(operation)).setLastTime(GeneralUtilities.stringToCalendar((String)element.getAttribute("lptimestamp"), null));
            }
            String string = element.getAttribute("id");
            String string2 = element.getText();
            MutableTask mutableTask = (MutableTask)MutableTask.class.cast(ReplayCommandDispatcher.this.core.getTaskById(ReplayCommandDispatcher.this.createTaskId(Integer.parseInt(string))));
            if (mutableTask == null) {
                return;
            }
            mutableTask.setTaskLog((TaskDataAccess)new FileAccess((Task)mutableTask, TaskDataAccess.DataType.LOG, new File(ReplayCommandDispatcher.this.core.getLogDirectory(), string2), string2, -1));
        }
    }), new PredicateClosureImpl((Predicate)new ElementNameMatches("CommandEnd"), new Closure(){

        public void execute(Object object) {
            if (ReplayCommandDispatcher.this.guidOnly) {
                return;
            }
            DszDefaultHandler.Element element = (DszDefaultHandler.Element)object;
            Operation operation = ReplayCommandDispatcher.this.getOperation();
            if (operation instanceof MutableOperation) {
                ((MutableOperation)MutableOperation.class.cast(operation)).setLastTime(GeneralUtilities.stringToCalendar((String)element.getAttribute("lptimestamp"), null));
            }
            String string = element.getAttribute("id");
            String string2 = element.getAttribute("status");
            MutableTask mutableTask = (MutableTask)MutableTask.class.cast(ReplayCommandDispatcher.this.core.getTaskById(ReplayCommandDispatcher.this.createTaskId(Integer.parseInt(string))));
            if (mutableTask == null) {
                return;
            }
            mutableTask.setState(TaskState.parseResult((String)string2));
            CommandEventImpl commandEventImpl = new CommandEventImpl(this, CommandEvent.CommandEventType.ENDED, (Task)mutableTask);
            commandEventImpl.setCurrentOperation(false);
            commandEventImpl.setTimestamp(mutableTask.getCreated());
            commandEventImpl.setTargetAddress(mutableTask.getTargetId());
            ReplayCommandDispatcher.this.publishEvent(commandEventImpl);
        }
    }), new PredicateClosureImpl((Predicate)new ElementNameMatches("Shutdown"), new Closure(){

        public void execute(Object object) {
            DszDefaultHandler.Element element = (DszDefaultHandler.Element)object;
            ReplayCommandDispatcher.this.stop = true;
            Operation operation = ReplayCommandDispatcher.this.getOperation();
            if (operation instanceof MutableOperation) {
                ((MutableOperation)MutableOperation.class.cast(operation)).setLastTime(GeneralUtilities.stringToCalendar((String)element.getAttribute("lptimestamp"), null));
            }
        }
    }), new PredicateClosureImpl((Predicate)new ElementNameMatches("ErrorString"), ClosureUtils.nopClosure())};
    Closure elementHandler = SwitchClosure.getInstance((Predicate[])this.elementHandlerList, (Closure[])this.elementHandlerList, (Closure)new Closure(){

        public void execute(Object object) {
            DszDefaultHandler.Element element = (DszDefaultHandler.Element)object;
            System.out.println("Unhandled element: " + element.name);
        }
    });
    File logFile;
    MutableCoreController mutableCore;
    boolean guidOnly = true;

    public ReplayCommandDispatcher(EventPublisher eventPublisher, MutableCoreController mutableCoreController, File file) {
        super(eventPublisher, mutableCoreController);
        REF = this;
        this.mutableCore = mutableCoreController;
        this.logFile = file;
        this.parseFile();
        this.guidOnly = false;
        this.setFinished(false);
        this.stop = false;
    }

    protected InputStream getFileStream(String string) throws FileNotFoundException {
        return new FileInputStream(new File(string));
    }

    public void parseFile() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(this.getFileStream(this.logFile.getAbsolutePath()), (DefaultHandler)new DszDefaultHandler(){

                protected void handleElement(DszDefaultHandler.Element element) throws SAXException {
                    ReplayCommandDispatcher.this.elementHandler.execute((Object)element);
                    if (ReplayCommandDispatcher.this.stop) {
                        throw FinishedProcessingException.FINISHED;
                    }
                }
            });
            this.setFinished(true);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof FinishedProcessingException) {
                this.setFinished(true);
                return;
            }
            sAXException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public long getFileSize() {
        return this.logFile.length();
    }

    public File getLogFile() {
        return this.logFile;
    }

    protected boolean noWaiting() {
        return false;
    }

    private class ElementNameMatches
    implements Predicate {
        String name;

        public ElementNameMatches(String string) {
            this.name = string;
        }

        public boolean evaluate(Object object) {
            if (object instanceof DszDefaultHandler.Element) {
                return this.name.equals(((DszDefaultHandler.Element)DszDefaultHandler.Element.class.cast((Object)object)).name);
            }
            return false;
        }
    }
}

