/*
 * Decompiled with CFR 0.152.
 */
package ds.core.commanddispatcher.live;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.task.MutableTask;
import ddb.dsz.core.task.TaskId;
import ds.core.commanddispatcher.LiveCommandDispatcher;
import ds.core.commanddispatcher.live.MessageClosure;
import ds.core.commandevents.CommandEventImpl;
import ds.jaxb.ipc.InfoType;
import ds.jaxb.ipc.Message;
import ds.jaxb.ipc.OutputType;
import ds.jaxb.ipc.XmlOutputType;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;

public class CommandOutputClosure
extends MessageClosure {
    public CommandOutputClosure(LiveCommandDispatcher liveCommandDispatcher) {
        super(liveCommandDispatcher);
    }

    protected boolean evaluateMessage(Message message) {
        if (message.getInfo() == null) {
            return false;
        }
        return message.getInfo().getOutput() != null;
    }

    protected void handleMessage(Message message) {
        TaskId taskId;
        String string;
        TaskId taskId2;
        MutableTask mutableTask;
        InfoType infoType = message.getInfo();
        OutputType outputType = infoType.getOutput();
        if (this.live.getMainSystem().isDebugMode()) {
            this.live.getMainSystem().logEvent(Level.FINEST, "Recieved command output message");
        }
        if ((mutableTask = this.getTaskById(taskId2 = this.createTaskId(infoType.getCmdId()))) == null && taskId2.isValid()) {
            try {
                this.live.getMainSystem().logEvent(Level.WARNING, "Output received for unknown command\n" + this.live.getFormatter().formatMessageAsString(message));
            }
            catch (JAXBException jAXBException) {
                this.live.getMainSystem().logEvent(Level.WARNING, "Output received for unknown commandUnable to format IPC message as string", jAXBException);
            }
            return;
        }
        String string2 = null;
        if (!taskId2.isValid()) {
            string = "";
            taskId = TaskId.NULL;
        } else {
            string = mutableTask.getCommandName();
            taskId = mutableTask.getParentId();
            string2 = mutableTask.getTargetId();
        }
        String string3 = outputType.getText();
        String string4 = outputType.getColor();
        CommandEventImpl commandEventImpl = new CommandEventImpl((Object)this, CommandEvent.CommandEventType.OUTPUT, string, string3, this.lookup(string4), taskId2, taskId, mutableTask != null ? mutableTask.getTargetId() : "127.0.0.1");
        commandEventImpl.setCurrentOperation(true);
        commandEventImpl.setTargetAddress(string2);
        if (string3 == null) {
            for (XmlOutputType.Node node : outputType.getXml().getNode()) {
                commandEventImpl = new CommandEventImpl(this, CommandEvent.CommandEventType.OUTPUT, string, node.getValue(), taskId2, taskId, mutableTask != null ? mutableTask.getTargetId() : "127.0.0.1");
                commandEventImpl.setCurrentOperation(true);
                commandEventImpl.setTargetAddress(string2);
                if (node.getType() == null) {
                    commandEventImpl.setXmlOutput(CommandEvent.XmlOutput.DEFAULT);
                } else {
                    switch (node.getType()) {
                        case ERROR: {
                            commandEventImpl.setXmlOutput(CommandEvent.XmlOutput.ERROR);
                            break;
                        }
                        case GOOD: {
                            commandEventImpl.setXmlOutput(CommandEvent.XmlOutput.GOOD);
                            break;
                        }
                        case WARNING: {
                            commandEventImpl.setXmlOutput(CommandEvent.XmlOutput.WARNING);
                            break;
                        }
                        default: {
                            commandEventImpl.setXmlOutput(CommandEvent.XmlOutput.DEFAULT);
                        }
                    }
                }
                this.live.publishEvent(commandEventImpl);
            }
            return;
        }
        this.live.publishEvent(commandEventImpl);
    }
}

