/*
 * Decompiled with CFR 0.152.
 */
package ds.core.impl.task;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.TaskDataAccess;
import ddb.dsz.core.task.TaskId;
import ddb.util.GeneralUtilities;
import ddb.util.Guid;
import ddb.util.UtilityConstants;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDatabase {
    CoreController core;
    private static final String LOG_TABLE = "CREATE TABLE Log ( \tTaskId INTEGER NOT NULL,\tOperation INTEGER NOT NULL,\tType INTEGER NOT NULL,\tLogIndex INTEGER NOT NULL,\tPath STRING NOT NULL,\tPRIMARY KEY (TaskId, Operation, Type, LogIndex) ON CONFLICT REPLACE)";
    private static final String[] SCHEMA = new String[]{"CREATE TABLE Log ( \tTaskId INTEGER NOT NULL,\tOperation INTEGER NOT NULL,\tType INTEGER NOT NULL,\tLogIndex INTEGER NOT NULL,\tPath STRING NOT NULL,\tPRIMARY KEY (TaskId, Operation, Type, LogIndex) ON CONFLICT REPLACE)"};
    private PreparedStatement GetLogs;
    private PreparedStatement GetAllLogs;
    private PreparedStatement GetLogByIndex;
    private PreparedStatement AddLog;
    private PreparedStatement Dump;
    private Connection connection;
    private boolean bInitialized = false;
    private Map<Guid, Integer> OperationMap = new HashMap<Guid, Integer>();
    private ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor(UtilityConstants.createThreadFactory((String)"TaskDatabase"));
    private final Runnable Dumper = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ResultSet resultSet = TaskDatabase.this.Dump.executeQuery();
                try {
                    int n;
                    System.out.println("------------------------------------------------");
                    System.out.println("-----------------SQL DUMP-----------------------");
                    System.out.println("------------------------------------------------");
                    for (n = 1; n <= resultSet.getMetaData().getColumnCount(); ++n) {
                        System.out.printf("%10s", resultSet.getMetaData().getColumnName(n));
                        System.out.print("\t");
                    }
                    System.out.println();
                    System.out.println("------------------------------------------------");
                    while (resultSet.next()) {
                        for (n = 1; n <= resultSet.getMetaData().getColumnCount(); ++n) {
                            System.out.printf("%10s", resultSet.getString(n));
                            System.out.print("\t");
                        }
                        System.out.println();
                    }
                    System.out.println("------------------------------------------------");
                }
                finally {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskDatabase(CoreController coreController) {
        this.core = coreController;
        try {
            File file = new File(coreController.getUserConfigDirectory(), "Tasks");
            file.mkdirs();
            File file2 = null;
            for (int i = 0; i < 10 && (file2 = new File(file, String.format("Tasks_%s.db", GeneralUtilities.CalendarToStringFile((Calendar)Calendar.getInstance())))).exists(); ++i) {
                try {
                    TimeUnit.MILLISECONDS.sleep(50L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            file2.deleteOnExit();
            Class<?> clazz = Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection(String.format("jdbc:sqlite:/%s", file2.getAbsolutePath()));
            String string = String.format("Connecting to %s with %s %s (%d.%d)", file2.getAbsolutePath(), this.connection.getMetaData().getDatabaseProductName(), this.connection.getMetaData().getDatabaseProductVersion(), this.connection.getMetaData().getDatabaseMajorVersion(), this.connection.getMetaData().getDatabaseMinorVersion());
            coreController.logEvent(Level.INFO, "TaskDatabase", string);
            String[] stringArray = new String[]{"PRAGMA synchronous=OFF", "PRAGMA cache_size=20000", "PRAGMA foreign_keys = ON", "PRAGMA ignore_check_constraints=true", "PRAGMA journal_mode=MEMORY"};
            Statement statement = this.connection.createStatement();
            for (String string2 : stringArray) {
                statement.execute(string2);
            }
            for (String string2 : SCHEMA) {
                statement.execute(string2);
            }
            this.GetLogs = this.connection.prepareStatement("Select Path From Log where \tTaskId = ? AND \tOperation = ? AND \tType = ?    ORDER BY LogIndex ASC", 1003, 1007);
            this.GetAllLogs = this.connection.prepareStatement("Select Path, Type From Log where \tTaskId = ? AND \tOperation = ?    ORDER BY Type ASC, LogIndex ASC", 1003, 1007);
            this.GetLogByIndex = this.connection.prepareStatement("Select Path From Log where \tTaskId = ? AND \tOperation = ? AND \tType = ? AND \tLogIndex = ?", 1003, 1007);
            this.AddLog = this.connection.prepareStatement("Insert into Log \t(TaskId, Operation, Type, LogIndex, Path) \tVALUES \t(?, ?, ?, ?, ?)");
            this.Dump = this.connection.prepareStatement("Select * From Log ORDER BY TaskId, Operation, Type, LogIndex", 1003, 1007);
            this.bInitialized = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isInitialize() {
        return this.bInitialized;
    }

    public void addLog(TaskId taskId, TaskDataAccess.DataType dataType, String string) {
        this.addLog(taskId, dataType, 0, string);
    }

    public void addLog(TaskId taskId, TaskDataAccess.DataType dataType, int n, String string) {
        this.exec.execute(new AddLog(taskId, dataType, n, string));
    }

    public String getLog(TaskId taskId, TaskDataAccess.DataType dataType) {
        return this.getLog(taskId, dataType, 0);
    }

    public String getLog(TaskId taskId, TaskDataAccess.DataType dataType, int n) {
        Future<String> future = this.exec.submit(new GetLogByIndex(taskId, dataType, n));
        try {
            return future.get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public List<String> getLogs(TaskId taskId, TaskDataAccess.DataType dataType) {
        Future<List<String>> future = this.exec.submit(new GetLogs(taskId, dataType));
        try {
            return future.get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Collections.emptyList();
        }
    }

    public List<LogInformation> getAllLogs(TaskId taskId) {
        Future<List<LogInformation>> future = this.exec.submit(new GetAllLogs(taskId));
        try {
            return future.get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Collections.emptyList();
        }
    }

    private int getOperationId(TaskId taskId) {
        return this.getOperationId(taskId.getOperation());
    }

    private int getOperationId(Operation operation) {
        return this.getOperationId(operation.getGuid());
    }

    private int getOperationId(Guid guid) {
        Integer n = this.OperationMap.get(guid);
        if (n == null) {
            n = this.OperationMap.keySet().size();
            this.OperationMap.put(guid, n);
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetAllLogs
    extends DatabaseTransaction<List<LogInformation>> {
        private final TaskId id;

        public GetAllLogs(TaskId taskId) {
            super(TaskDatabase.this.GetAllLogs);
            this.id = taskId;
        }

        @Override
        protected void prepare() throws Exception {
            TaskDatabase.this.GetAllLogs.setInt(1, this.id.getId());
            TaskDatabase.this.GetAllLogs.setInt(2, TaskDatabase.this.getOperationId(this.id));
        }

        @Override
        protected List<LogInformation> handle(ResultSet resultSet) throws Exception {
            Vector<LogInformation> vector = new Vector<LogInformation>();
            while (resultSet.next()) {
                vector.add(new LogInformation(TaskDataAccess.DataType.values()[resultSet.getInt(2)], resultSet.getString(1)));
            }
            return vector;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetLogByIndex
    extends DatabaseTransaction<String> {
        private final TaskId id;
        private final TaskDataAccess.DataType type;
        private final int index;

        public GetLogByIndex(TaskId taskId, TaskDataAccess.DataType dataType, int n) {
            super(TaskDatabase.this.GetLogByIndex);
            this.id = taskId;
            this.type = dataType;
            this.index = n;
        }

        @Override
        protected void prepare() throws Exception {
            TaskDatabase.this.GetLogByIndex.setInt(1, this.id.getId());
            TaskDatabase.this.GetLogByIndex.setInt(2, TaskDatabase.this.getOperationId(this.id));
            TaskDatabase.this.GetLogByIndex.setInt(3, this.type.ordinal());
            TaskDatabase.this.GetLogByIndex.setInt(4, this.index);
        }

        @Override
        protected String handle(ResultSet resultSet) throws Exception {
            if (resultSet.next()) {
                return resultSet.getString(1);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetLogs
    extends DatabaseTransaction<List<String>> {
        private final TaskId id;
        private final TaskDataAccess.DataType type;

        public GetLogs(TaskId taskId, TaskDataAccess.DataType dataType) {
            super(TaskDatabase.this.GetLogs);
            this.id = taskId;
            this.type = dataType;
        }

        @Override
        protected void prepare() throws Exception {
            TaskDatabase.this.GetLogs.setInt(1, this.id.getId());
            TaskDatabase.this.GetLogs.setInt(2, TaskDatabase.this.getOperationId(this.id));
            TaskDatabase.this.GetLogs.setInt(3, this.type.ordinal());
        }

        @Override
        protected List<String> handle(ResultSet resultSet) throws Exception {
            Vector<String> vector = new Vector<String>();
            while (resultSet.next()) {
                vector.add(resultSet.getString(1));
            }
            return vector;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class DatabaseTransaction<T>
    implements Callable<T> {
        PreparedStatement stmt;

        protected DatabaseTransaction(PreparedStatement preparedStatement) {
            this.stmt = preparedStatement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T call() throws Exception {
            this.prepare();
            ResultSet resultSet = this.stmt.executeQuery();
            try {
                T t = this.handle(resultSet);
                return t;
            }
            finally {
                resultSet.close();
            }
        }

        protected abstract void prepare() throws Exception;

        protected abstract T handle(ResultSet var1) throws Exception;
    }

    private class AddLog
    implements Runnable {
        private final TaskId id;
        private final TaskDataAccess.DataType type;
        private final int index;
        private final String path;

        public AddLog(TaskId taskId, TaskDataAccess.DataType dataType, int n, String string) {
            this.id = taskId;
            this.type = dataType;
            this.index = n;
            this.path = string;
        }

        public void run() {
            try {
                TaskDatabase.this.AddLog.setInt(1, this.id.getId());
                TaskDatabase.this.AddLog.setInt(2, TaskDatabase.this.getOperationId(this.id));
                TaskDatabase.this.AddLog.setInt(3, this.type.ordinal());
                TaskDatabase.this.AddLog.setInt(4, this.index);
                TaskDatabase.this.AddLog.setString(5, this.path);
                if (TaskDatabase.this.AddLog.executeUpdate() != 1) {
                    System.err.println("Writing to database fail");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public class LogInformation {
        public final TaskDataAccess.DataType type;
        public final String file;

        LogInformation(TaskDataAccess.DataType dataType, String string) {
            this.type = dataType;
            this.file = string;
        }
    }
}

