/*
 * Decompiled with CFR 0.152.
 */
package ds.core.impl.task;

import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.task.MutableTask;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskDataAccess;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.core.task.TaskState;
import ddb.util.FileManips;
import ddb.util.Guid;
import ddb.util.Pair;
import ddb.util.UtilityConstants;
import ds.core.impl.task.FileAccess;
import ds.core.impl.task.TaskDatabase;
import ds.core.impl.task.TaskStateAccess;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskImpl
extends Observable
implements Task,
MutableTask {
    public static TaskDatabase DATABASE = null;
    static final TimeZone GMT;
    private static final String RESOURCE_DIR = "ResourceDir";
    private static final Executor EXEC;
    private static ReentrantReadWriteLock[] LOCKS;
    private static int LOCK_COUNT;
    static final SAXParserFactory RetrieveResourceDirectoryFactory;
    private TaskId id;
    private Guid taskId;
    private int tempId;
    private static int nextLocalId;
    public static final int RESERVED_ID = 0;
    private HostInfo host;
    private HostInfo prospectiveHost;
    private Task parent;
    private String commandName;
    private String[] prefixes;
    private String[] arguments;
    private final List<Pair<String, String>> guiFlags;
    private long creationTime;
    private String typedCommand;
    private String fullCommand;
    private TaskState state;
    private String resultString;
    private boolean internallyGenerated;
    private String displayTransform;
    private String storageTransform;
    private String resourceDirectory;
    private boolean inPromptMode;
    private long created;
    private ReentrantReadWriteLock logLock = TaskImpl.getLock();
    private int dataCount = 0;
    private boolean hasTaskingInformation = false;
    private RetrieveResourceDirectory retriever = null;

    private static synchronized ReentrantReadWriteLock getLock() {
        int n;
        if (LOCKS == null) {
            LOCKS = new ReentrantReadWriteLock[256];
        }
        if (LOCKS[n = LOCK_COUNT % LOCKS.length] == null) {
            TaskImpl.LOCKS[n] = new ReentrantReadWriteLock();
        }
        ++LOCK_COUNT;
        return LOCKS[n];
    }

    public TaskImpl(String string, HostInfo hostInfo) {
        this.typedCommand = string;
        this.fullCommand = string;
        this.id = TaskId.UNINITIALIZED_ID;
        this.tempId = nextLocalId++;
        this.host = null;
        this.prospectiveHost = hostInfo;
        this.parent = null;
        this.commandName = null;
        this.prefixes = new String[0];
        this.arguments = new String[0];
        this.state = TaskState.INITIALIZED;
        this.creationTime = System.currentTimeMillis();
        this.internallyGenerated = false;
        this.displayTransform = null;
        this.storageTransform = null;
        this.guiFlags = new ArrayList<Pair<String, String>>(1);
        this.inPromptMode = false;
        this.created = Calendar.getInstance(GMT).getTimeInMillis();
        this.resourceDirectory = "Dsz";
    }

    public Task getParentTask() {
        return this.parent;
    }

    public void setParent(Task task) {
        this.parent = task;
        this.notifyObservers(this.GetStateAccess());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskId getParentId() {
        TaskImpl taskImpl = this;
        synchronized (taskImpl) {
            if (this.parent == null) {
                return TaskId.UNINITIALIZED_ID;
            }
            return this.parent.getId();
        }
    }

    public List<String> getArguments() {
        return Collections.unmodifiableList(Arrays.asList(this.arguments));
    }

    public void addArguments(List<String> list) {
        int n;
        String[] stringArray = this.arguments;
        String[] stringArray2 = new String[stringArray.length + list.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = stringArray[n];
        }
        for (n = 0; n < list.size(); ++n) {
            stringArray2[n + stringArray.length] = list.get(n);
        }
        this.arguments = stringArray2;
    }

    public List<String> getPrefixes() {
        return Collections.unmodifiableList(Arrays.asList(this.prefixes));
    }

    public void addPrefixes(List<String> list) {
        int n;
        String[] stringArray = this.prefixes;
        String[] stringArray2 = new String[stringArray.length + list.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = stringArray[n];
        }
        for (n = 0; n < list.size(); ++n) {
            stringArray2[n + stringArray.length] = list.get(n);
        }
        this.prefixes = stringArray2;
        String string = "guiflag=";
        for (String string2 : list) {
            if (!string2.toLowerCase().startsWith(string)) continue;
            this.addGuiFlag(string2.substring(string.length()));
        }
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String string) {
        this.commandName = string;
        this.notifyObservers(this.GetStateAccess());
    }

    public TaskId getId() {
        return this.id;
    }

    public int getTempId() {
        return this.tempId;
    }

    public void setId(TaskId taskId) {
        this.id = taskId;
        this.id.setTask((Task)this);
        this.notifyObservers(this.GetStateAccess());
    }

    public void addGuiFlag(String string) {
        int n = string.indexOf(61);
        if (n == -1) {
            this.addGuiFlag(string, "");
        } else {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            this.addGuiFlag(string2, string3);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addGuiFlag(String string, String string2) {
        List<Pair<String, String>> list = this.guiFlags;
        synchronized (list) {
            for (Pair<String, String> pair : this.guiFlags) {
                if (!((String)pair.getFirst()).equalsIgnoreCase(string)) continue;
                pair.setSecond((Object)string2);
                return;
            }
            this.guiFlags.add((Pair<String, String>)new Pair((Object)string, (Object)string2));
        }
    }

    public String getDataName() {
        String string = this.getGuiFlagValue("dataas");
        return string != null ? string : this.commandName;
    }

    public void addGuiFlags(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            this.addGuiFlag(stringTokenizer.nextToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGuiFlagValue(String string) {
        List<Pair<String, String>> list = this.guiFlags;
        synchronized (list) {
            for (Pair<String, String> pair : this.guiFlags) {
                if (!((String)pair.getFirst()).equalsIgnoreCase(string)) continue;
                return (String)pair.getSecond();
            }
        }
        return null;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public TaskState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(TaskState taskState) {
        this.state = taskState;
        switch (taskState) {
            case FAILED: 
            case KILLED: 
            case SUCCEEDED: {
                ReentrantReadWriteLock reentrantReadWriteLock = this.logLock;
                reentrantReadWriteLock.writeLock().lock();
                try {
                    this.logLock = TaskImpl.getLock();
                    break;
                }
                finally {
                    reentrantReadWriteLock.writeLock().unlock();
                }
            }
        }
        this.notifyObservers(this.GetStateAccess());
    }

    public String getStateString() {
        return this.state.toString();
    }

    public String getTypedCommand() {
        return this.typedCommand;
    }

    public boolean getInternallyGenerated() {
        return this.internallyGenerated;
    }

    public void setInternallyGenerated(boolean bl) {
        this.internallyGenerated = bl;
        this.notifyObservers(this.GetStateAccess());
    }

    public String getDisplayTransform() {
        return this.displayTransform;
    }

    public void setDisplayTransform(String string) {
        this.displayTransform = string;
        this.notifyObservers(this.GetStateAccess());
    }

    public String getStorageTransform() {
        return this.storageTransform;
    }

    public void setStorageTransform(String string) {
        this.storageTransform = string;
        this.notifyObservers(this.GetStateAccess());
    }

    public String toString() {
        return this.typedCommand;
    }

    public String getTargetId() {
        if (this.host != null) {
            return this.host.getId();
        }
        return null;
    }

    public void setResultString(String string) {
        this.resultString = string;
        this.notifyObservers(this.GetStateAccess());
    }

    public String getResultString() {
        return this.resultString;
    }

    public boolean isInPromptMode() {
        return this.inPromptMode;
    }

    public void setInPromptMode(boolean bl) {
        this.inPromptMode = bl;
        this.notifyObservers(this.GetStateAccess());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TaskImpl taskImpl = (TaskImpl)object;
        return !(this.id == null ? taskImpl.id != null : !this.id.equals((Object)taskImpl.id));
    }

    public Calendar getCreated() {
        Calendar calendar = Calendar.getInstance(GMT);
        calendar.setTimeInMillis(this.created);
        return calendar;
    }

    public void setCreated(Calendar calendar) {
        if (calendar != null) {
            this.created = calendar.getTimeInMillis();
            this.notifyObservers(this.GetStateAccess());
        }
    }

    public String getResourceDirectory() {
        if (this.resourceDirectory == null) {
            if (this.retriever != null && !this.retriever.hasRun()) {
                return null;
            }
            this.retriever = new RetrieveResourceDirectory(this);
            EXEC.execute(this.retriever);
            return null;
        }
        return this.resourceDirectory;
    }

    public void setResourceDirectory(String string) {
        this.resourceDirectory = string;
        this.notifyObservers(this.GetStateAccess());
    }

    public HostInfo getHost() {
        return this.host;
    }

    public void setHost(HostInfo hostInfo) {
        this.host = hostInfo;
        this.notifyObservers(this.GetStateAccess());
    }

    public HostInfo getProspectiveHost() {
        return this.prospectiveHost;
    }

    public int getDataCount() {
        return this.dataCount;
    }

    public Reader getTaskingInformation() {
        String string = DATABASE.getLog(this.id, TaskDataAccess.DataType.TASKING);
        if (string == null) {
            return null;
        }
        try {
            return FileManips.createFileReader((File)new File(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public boolean hasTaskingInformation() {
        return this.hasTaskingInformation;
    }

    public Reader getDataInformation(int n) {
        String string = DATABASE.getLog(this.id, TaskDataAccess.DataType.DATA, n);
        if (string == null) {
            return null;
        }
        try {
            return FileManips.createFileReader((File)new File(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public TaskDataAccess getDataAccess(int n) {
        String string = DATABASE.getLog(this.id, TaskDataAccess.DataType.DATA, n);
        if (string == null) {
            return null;
        }
        return new FileAccess(this, TaskDataAccess.DataType.DATA, new File(string), string, n);
    }

    private TaskDataAccess[] getDataAccesses() {
        List<String> list = DATABASE.getLogs(this.id, TaskDataAccess.DataType.DATA);
        TaskDataAccess[] taskDataAccessArray = new TaskDataAccess[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            taskDataAccessArray[i] = new FileAccess(this, TaskDataAccess.DataType.DATA, new File(list.get(i)), list.get(i), i);
        }
        return taskDataAccessArray;
    }

    private TaskDataAccess[] getAllAccesses() {
        List<TaskDatabase.LogInformation> list = DATABASE.getAllLogs(this.id);
        TaskDataAccess[] taskDataAccessArray = new TaskDataAccess[list.size()];
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            TaskDatabase.LogInformation logInformation = list.get(i);
            if (logInformation == null) continue;
            taskDataAccessArray[i] = new FileAccess(this, logInformation.type, new File(logInformation.file), logInformation.file, n);
            if (logInformation.type != TaskDataAccess.DataType.DATA) continue;
            ++n;
        }
        return taskDataAccessArray;
    }

    public void setTaskingInformation(TaskDataAccess taskDataAccess) {
        DATABASE.addLog(this.id, TaskDataAccess.DataType.TASKING, taskDataAccess.getLocation());
        this.hasTaskingInformation = true;
        this.notifyObservers(taskDataAccess);
    }

    public TaskDataAccess getTaskLogAccess() {
        String string = DATABASE.getLog(this.id, TaskDataAccess.DataType.LOG);
        if (string == null) {
            return null;
        }
        return new FileAccess(this, TaskDataAccess.DataType.LOG, new File(string), string, 1);
    }

    public TaskDataAccess getTaskingAccess() {
        String string = DATABASE.getLog(this.id, TaskDataAccess.DataType.TASKING);
        if (string == null) {
            return null;
        }
        return new FileAccess(this, TaskDataAccess.DataType.TASKING, new File(string), string, 1);
    }

    public Reader getTaskLog() {
        String string = DATABASE.getLog(this.id, TaskDataAccess.DataType.LOG);
        if (string == null) {
            return null;
        }
        try {
            return FileManips.createFileReader((File)new File(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void setTaskLog(TaskDataAccess taskDataAccess) {
        DATABASE.addLog(this.id, TaskDataAccess.DataType.LOG, taskDataAccess.getLocation());
        this.hasTaskingInformation = true;
        this.notifyObservers(taskDataAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataInformation(TaskDataAccess taskDataAccess) {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.logLock;
        reentrantReadWriteLock.writeLock().lock();
        try {
            n = this.dataCount++;
        }
        finally {
            reentrantReadWriteLock.writeLock().unlock();
        }
        DATABASE.addLog(this.id, TaskDataAccess.DataType.DATA, n, taskDataAccess.getLocation());
        this.notifyObservers(taskDataAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Observer observer, boolean bl) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.logLock;
        reentrantReadWriteLock.readLock().lock();
        try {
            this.addObserver(observer);
            for (TaskDataAccess taskDataAccess : this.getAllAccesses()) {
                observer.update(this, taskDataAccess);
            }
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Observer observer) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.logLock;
        reentrantReadWriteLock.readLock().lock();
        try {
            this.deleteObserver(observer);
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadyForParsing() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.logLock;
        reentrantReadWriteLock.readLock().lock();
        try {
            boolean bl = this.hasTaskingInformation;
            return bl;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    public Guid getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Guid guid) {
        this.taskId = guid;
        this.notifyObservers(this.GetStateAccess());
    }

    public void setFullCommandLine(String string) {
        this.fullCommand = string.equals(this.typedCommand) ? this.typedCommand : string;
        this.notifyObservers(this.GetStateAccess());
    }

    public String getFullCommandLine() {
        return this.fullCommand;
    }

    @Override
    public void notifyObservers(Object object) {
        super.setChanged();
        super.notifyObservers(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextOrdinal() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.logLock;
        reentrantReadWriteLock.readLock().lock();
        try {
            if (!this.hasTaskingInformation) {
                int n = 0;
                return n;
            }
            int n = this.dataCount + 1;
            return n;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    public boolean isAlive() {
        switch (this.state) {
            case FAILED: 
            case KILLED: 
            case SUCCEEDED: {
                return false;
            }
        }
        return true;
    }

    private TaskStateAccess GetStateAccess() {
        return new TaskStateAccess(this);
    }

    static {
        EXEC = Executors.newSingleThreadExecutor(UtilityConstants.createThreadFactory((String)"TaskImpl"));
        LOCKS = null;
        LOCK_COUNT = 0;
        RetrieveResourceDirectoryFactory = SAXParserFactory.newInstance();
        GMT = TimeZone.getTimeZone("GMT+00");
        nextLocalId = 1;
    }

    private static class RetrieveResourceDirectory
    implements Runnable {
        TaskImpl task;
        boolean ran = false;

        public RetrieveResourceDirectory(TaskImpl taskImpl) {
            this.task = taskImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Reader reader = this.task.getTaskingAccess().getReader();
                if (reader == null) {
                    this.ran = true;
                    return;
                }
                DefaultHandler defaultHandler = new DefaultHandler(){
                    boolean record = false;
                    StringBuilder sb = new StringBuilder();

                    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                        super.startElement(string, string2, string3, attributes);
                        if (TaskImpl.RESOURCE_DIR.equals(string3)) {
                            this.record = true;
                        }
                    }

                    public void endElement(String string, String string2, String string3) throws SAXException {
                        super.endElement(string, string2, string3);
                        if (this.record) {
                            throw new FoundResourceDirectory(this.sb.toString());
                        }
                    }

                    public void characters(char[] cArray, int n, int n2) throws SAXException {
                        super.characters(cArray, n, n2);
                        if (this.record) {
                            this.sb.append(new String(cArray, n, n2));
                        }
                    }
                };
                SAXParser sAXParser = RetrieveResourceDirectoryFactory.newSAXParser();
                try {
                    sAXParser.parse(new InputSource(reader), defaultHandler);
                }
                catch (FoundResourceDirectory foundResourceDirectory) {
                    this.task.setResourceDirectory(foundResourceDirectory.getString());
                }
                reader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.task.retriever = null;
                return;
            }
            finally {
                this.ran = true;
            }
        }

        public boolean hasRun() {
            return this.ran;
        }
    }

    private static class FoundResourceDirectory
    extends RuntimeException {
        private final String str;

        public FoundResourceDirectory(String string) {
            this.str = string;
        }

        public String getString() {
            return this.str;
        }
    }
}

