/*
 * Decompiled with CFR 0.152.
 */
package ds.plugin;

import ddb.detach.Alignment;
import ddb.detach.Tabbable;
import ddb.detach.TabbableStatus;
import ddb.detach.Workbench;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.internalcommand.InternalCommandHandler;
import ddb.dsz.plugin.NoHostAbstractPlugin;
import ddb.dsz.plugin.Plugin;
import ddb.util.PluginInitInfo;
import ddb.util.StartupConfigParser;
import ds.core.controller.MutableCoreController;
import ds.gui.PluginWorkbench;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluginContainer
extends NoHostAbstractPlugin
implements InternalCommandHandler,
InvocationHandler {
    static final Map<Method, Method> redirectAction = new HashMap<Method, Method>();
    private MutableCoreController mcc = null;
    private PluginWorkbench parentBench;
    EventListenerList listeners = new EventListenerList();

    private static final void addRedirect(String string, Class<?>[] classArray, Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            Method method2 = PluginContainer.class.getDeclaredMethod(string, classArray);
            if (method != null && method2 != null) {
                redirectAction.put(method, method2);
            } else {
                System.out.printf("Couldn't find %s in %s\n", string, clazz.toString());
            }
        }
        catch (Throwable throwable) {
            LogRecord logRecord = new LogRecord(Level.SEVERE, throwable.getMessage());
            logRecord.setSourceClassName("PluginContainer");
            logRecord.setSourceMethodName("addRedirect");
            logRecord.setThrown(throwable);
            Logger.getLogger("dsz.core").log(logRecord);
        }
    }

    public abstract PluginWorkbench getChildWorkbench();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        try {
            Method method2 = redirectAction.get(method);
            if (method2 == null) return method.invoke((Object)this.mcc, objectArray);
            return method2.invoke((Object)this, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.core.logEvent(Level.SEVERE, invocationTargetException.getMessage(), invocationTargetException.getTargetException());
            return null;
        }
        catch (Exception exception) {
            this.core.logEvent(Level.SEVERE, exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    protected final int init2() {
        if (this.core instanceof MutableCoreController) {
            this.mcc = (MutableCoreController)MutableCoreController.class.cast(this.core);
        }
        int n = this.init3();
        PluginWorkbench pluginWorkbench = this.getChildWorkbench();
        if (pluginWorkbench != null) {
            pluginWorkbench.addPropertyChangeListener("WORKBENCH_CONTENTS_CHANGED", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PluginContainer.this.contentsChanged();
                }
            });
        }
        return n;
    }

    protected abstract int init3();

    protected final void fini2() {
        this.fini3();
    }

    protected void fini3() {
    }

    protected CoreController decorate(CoreController coreController) {
        if (coreController instanceof MutableCoreController) {
            return (MutableCoreController)Proxy.newProxyInstance(CoreController.class.getClassLoader(), new Class[]{MutableCoreController.class}, (InvocationHandler)this);
        }
        return (CoreController)Proxy.newProxyInstance(CoreController.class.getClassLoader(), new Class[]{CoreController.class}, (InvocationHandler)this);
    }

    protected final boolean parseArgument2(String string, String string2) {
        if (string.equals("-load")) {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string2);
            if (inputStream == null) {
                this.core.logEvent(Level.SEVERE, "Invalid configuration file");
                return false;
            }
            List<PluginInitInfo> list = null;
            try {
                list = StartupConfigParser.parse(inputStream, this.core.getLogDirectory(), String.format("%s/%s", this.core.getResourceDirectory(), this.core.getDefaultPackage()), this.core.getBuildType());
            }
            catch (Exception exception) {
                this.core.logEvent(Level.SEVERE, exception.getMessage(), (Throwable)exception);
                return false;
            }
            for (PluginInitInfo pluginInitInfo : list) {
                this.addSubPlugin(pluginInitInfo.getClassName(), pluginInitInfo.getInitArgs(), pluginInitInfo.getInstanceName(), pluginInitInfo.getAlign());
            }
            if (this.getChildWorkbench().getTabCount() > 0) {
                this.getChildWorkbench().enqueAction((Enum)Workbench.WorkbenchAction.SETSELECTEDINDEX, new Object[]{0});
            }
            return true;
        }
        if (string.equals("-align") && string2 != null) {
            if (string2.equalsIgnoreCase("top")) {
                this.getChildWorkbench().setTabPlacement(1);
            } else if (string2.equalsIgnoreCase("bottom")) {
                this.getChildWorkbench().setTabPlacement(3);
            } else if (string2.equalsIgnoreCase("left")) {
                this.getChildWorkbench().setTabPlacement(2);
            } else if (string2.equalsIgnoreCase("right")) {
                this.getChildWorkbench().setTabPlacement(4);
            } else {
                this.core.logEvent(Level.WARNING, String.format("%s is not valid for %s:  'top, bottom, left, right' are valid values", string2, string));
            }
        } else if (string.equals("-layout") && string2 != null) {
            if (string2.equalsIgnoreCase("scroll")) {
                this.getChildWorkbench().setTabLayoutPolicy(1);
            } else if (string2.equalsIgnoreCase("wrap")) {
                this.getChildWorkbench().setTabLayoutPolicy(0);
            } else {
                this.core.logEvent(Level.WARNING, String.format("%s is not valid for %s:  'scroll, wrap' are valid values", string2, string));
            }
        }
        return this.parseArgument3(string, string2);
    }

    protected boolean parseArgument3(String string, String string2) {
        return false;
    }

    public PluginWorkbench getParentWorkbench() {
        return this.parentBench;
    }

    public TabbableStatus getStatus() {
        return this.getChildWorkbench().getStatus();
    }

    public JComponent getDefaultElement() {
        Tabbable tabbable;
        Tabbable tabbable2 = this.getChildWorkbench().getCurrentTab();
        if (tabbable2 != null) {
            return tabbable2.getDefaultElement();
        }
        Component component = this.getChildWorkbench().getSelectedComponent();
        if (component != null && (tabbable = this.getChildWorkbench().getTabbableForDisplay(component)) != null) {
            return tabbable.getDefaultElement();
        }
        return null;
    }

    public boolean allowNewInstance(Class<?> clazz) {
        for (Tabbable tabbable : this.getChildWorkbench().getTabs()) {
            if (tabbable.allowNewInstance(clazz)) continue;
            return false;
        }
        return true;
    }

    public Plugin getPluginForDisplay(Component component) {
        return (Plugin)this.getChildWorkbench().getTabbableForDisplay(component);
    }

    public void receivedFocus() {
        super.receivedFocus();
        Plugin plugin = this.getPluginForDisplay(this.getChildWorkbench().getSelectedComponent());
        if (plugin != null) {
            plugin.receivedFocus();
        }
    }

    private Plugin addSubPlugin(String string, List<String> list, String string2, String string3) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string, false, this.getClass().getClassLoader());
        }
        catch (Throwable throwable) {
            System.err.println("Unable to instantiate " + string);
            this.core.logEvent(Level.WARNING, "Unable to find plugin", throwable);
            return null;
        }
        if (clazz == null) {
            return null;
        }
        try {
            Plugin plugin = this.getChildWorkbench().startPlugin(clazz, string2, list, Alignment.getAlignment((String)string3), null, true);
            return plugin;
        }
        catch (Throwable throwable) {
            System.err.println("Unable to instantiate " + string);
            this.core.logEvent(Level.WARNING, "Unable to find plugin", throwable);
            return null;
        }
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        this.getChildWorkbench().setSelected(bl);
    }

    public HostInfo getTarget() {
        Tabbable tabbable;
        Component component = this.getChildWorkbench().getSelectedComponent();
        if (component != null && (tabbable = this.getChildWorkbench().getTabbableForDisplay(component)) instanceof Plugin) {
            return ((Plugin)Plugin.class.cast(tabbable)).getTarget();
        }
        return null;
    }

    public void unhidePlugin(Plugin plugin) {
        this.core.unhidePlugin((Plugin)this);
        this.getChildWorkbench().enqueAction((Enum)Workbench.WorkbenchAction.UNHIDETAB, new Object[]{plugin});
    }

    public void hidePlugin(Plugin plugin) {
        this.getChildWorkbench().enqueAction((Enum)Workbench.WorkbenchAction.HIDETAB, new Object[]{plugin});
    }

    public void detachPlugin(Plugin plugin, Dimension dimension, Point point) {
        this.getChildWorkbench().enqueAction(PluginWorkbench.PluginWorkbenchAction.DETACHPLUGIN, new Object[]{plugin, dimension, point});
    }

    public boolean isUserClosable() {
        return this.isClosable();
    }

    public boolean isClosable() {
        for (Tabbable tabbable : this.getChildWorkbench().getTabs()) {
            if (tabbable.isClosable()) continue;
            return false;
        }
        return super.isClosable();
    }

    public boolean startNewPlugin(Class<?> clazz, String string, List<String> list, boolean bl, boolean bl2) {
        return this.startNewPlugin(clazz, string, list, this.detached, bl2, Alignment.DEFAULT);
    }

    public boolean startNewPlugin(Class<?> clazz, String string, List<String> list, boolean bl, boolean bl2, Alignment alignment) {
        if (alignment == Alignment.DEFAULT) {
            alignment = Alignment.CENTER;
        }
        Plugin plugin = null;
        try {
            plugin = this.getChildWorkbench().startPlugin(clazz, string, list, alignment, null, bl2);
        }
        catch (Exception exception) {
            this.core.logEvent(Level.SEVERE, exception.getMessage(), (Throwable)exception);
            return false;
        }
        if (plugin == null) {
            this.core.logEvent(Level.WARNING, "Failed to add plugin of class" + clazz);
            return false;
        }
        if (bl) {
            this.getChildWorkbench().enqueAction((Enum)Workbench.WorkbenchAction.DETACHTAB, new Object[]{plugin, null, null});
        }
        return true;
    }

    public void closePlugin(Plugin plugin) {
        this.getChildWorkbench().enqueAction((Enum)Workbench.WorkbenchAction.CLOSETAB, new Object[]{plugin});
    }

    public boolean isHideable() {
        for (Tabbable tabbable : this.getChildWorkbench().getTabs()) {
            if (tabbable.isHideable()) continue;
            return false;
        }
        return true;
    }

    public void setWorkbench(Workbench workbench) {
        super.setWorkbench(workbench);
        if (workbench instanceof PluginWorkbench) {
            this.parentBench = (PluginWorkbench)PluginWorkbench.class.cast(workbench);
            PluginWorkbench pluginWorkbench = this.getChildWorkbench();
            if (pluginWorkbench != null) {
                pluginWorkbench.setParent((PluginWorkbench)PluginWorkbench.class.cast(workbench));
            }
        }
    }

    public void StealFocus(Plugin plugin) {
        this.core.StealFocus((Plugin)this);
        this.getChildWorkbench().enqueAction((Enum)Workbench.WorkbenchAction.STEALFOCUS, new Object[]{plugin});
    }

    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.awaitTermination(l, timeUnit);
    }

    public boolean isTerminated() {
        return this.isTerminated();
    }

    public boolean isShutdown() {
        return this.isShutdown();
    }

    static {
        PluginContainer.addRedirect("unhidePlugin", new Class[]{Plugin.class}, CoreController.class);
        PluginContainer.addRedirect("hidePlugin", new Class[]{Plugin.class}, CoreController.class);
        PluginContainer.addRedirect("detachPlugin", new Class[]{Plugin.class, Dimension.class, Point.class}, CoreController.class);
        PluginContainer.addRedirect("startNewPlugin", new Class[]{Class.class, String.class, List.class, Boolean.TYPE, Boolean.TYPE}, CoreController.class);
        PluginContainer.addRedirect("startNewPlugin", new Class[]{Class.class, String.class, List.class, Boolean.TYPE, Boolean.TYPE, Alignment.class}, CoreController.class);
        PluginContainer.addRedirect("closePlugin", new Class[]{Plugin.class}, CoreController.class);
        PluginContainer.addRedirect("StealFocus", new Class[]{Plugin.class}, CoreController.class);
    }
}

