/*
 * Decompiled with CFR 0.152.
 */
package ds.plugin.options;

import ddb.detach.TabbableOption;
import ddb.detach.Workbench;
import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.annotations.DszUserStartable;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.NoHostAbstractPlugin;
import ddb.dsz.plugin.Plugin;
import ddb.util.proxy.DszProxyHandler;
import ds.core.controller.MutableCoreController;
import ds.core.pluginevents.PluginEvent;
import ds.core.pluginevents.PluginEventListener;
import ds.gui.PluginWorkbench;
import ds.plugin.PluginContainer;
import ds.plugin.options.OptionWorkbench;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;

@DszLive(live=false, replay=false)
@DszLogo(value="images/advanced-directory.png")
@DszName(value="Options")
@DszDescription(value="Configures DanderSpritz Options")
@DszUserStartable(value=false)
public class DszOptions
extends NoHostAbstractPlugin
implements Plugin,
PluginEventListener {
    MutableCoreController client;
    OptionWorkbench pages;
    List<Plugin> plugins;
    private Map<Class<? extends Plugin>, TabbableOption> staticPluginToComponent;
    private Map<Plugin, TabbableOption> regularPluginToComponent;

    public DszOptions() {
        super.setCanClose(false);
        super.setName("Options");
        super.setShowButtons(false);
    }

    protected final int init2() {
        this.plugins = new Vector<Plugin>();
        this.staticPluginToComponent = new Hashtable<Class<? extends Plugin>, TabbableOption>();
        this.regularPluginToComponent = new Hashtable<Plugin, TabbableOption>();
        this.pages = new OptionWorkbench(this.core);
        super.setDisplay((JComponent)((Object)this.pages));
        if (this.core instanceof MutableCoreController) {
            this.client = (MutableCoreController)this.core;
            this.client.addPluginEventListener(this);
        }
        this.setClient(this.core);
        return this.init3();
    }

    protected int init3() {
        return 0;
    }

    protected final void fini2() {
        this.fini3();
        if (this.client != null) {
            this.client.removePluginEventListener(this);
        }
    }

    protected void fini3() {
    }

    public void setClient(CoreController coreController) {
        if (coreController instanceof MutableCoreController) {
            this.client = (MutableCoreController)coreController;
            this.subscribe(this.client.getWorkbench());
            this.client.addPluginEventListener(this);
        }
    }

    private void subscribe(PluginWorkbench pluginWorkbench) {
        for (int i = 0; i < pluginWorkbench.getChildPlugins().size(); ++i) {
            this.addPlugin((Plugin)pluginWorkbench.getChildPlugins().get(i));
        }
    }

    private void addPlugin(Plugin plugin) {
        plugin = (Plugin)DszProxyHandler.Unwrap((Object)plugin);
        DszName dszName = plugin.getClass().getAnnotation(DszName.class);
        if (plugin.getStaticOptions() != null && this.staticPluginToComponent.get(plugin.getClass()) == null && dszName != null) {
            this.staticPluginToComponent.put(plugin.getClass(), plugin.getStaticOptions());
            this.pages.enqueAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{plugin.getStaticOptions()});
        }
        if (plugin.getRegularOptions() != null && this.regularPluginToComponent.get(plugin) == null && plugin.getName() != null) {
            this.regularPluginToComponent.put(plugin, plugin.getRegularOptions());
            this.pages.enqueAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{plugin.getRegularOptions()});
        }
        if (plugin instanceof PluginContainer) {
            PluginContainer pluginContainer = (PluginContainer)plugin;
            this.subscribe(pluginContainer.getChildWorkbench());
        }
    }

    private void removePlugin(Plugin plugin) {
        TabbableOption tabbableOption = this.regularPluginToComponent.get(plugin);
        if (tabbableOption == null) {
            return;
        }
        this.pages.enqueAction((Enum)Workbench.WorkbenchAction.CLOSETAB, new Object[]{tabbableOption});
        this.pages.enqueAction((Enum)Workbench.WorkbenchAction.REMOVETAB, new Object[]{tabbableOption});
        this.regularPluginToComponent.remove(plugin);
    }

    public void pluginEvent(PluginEvent pluginEvent) {
        switch (pluginEvent.getState()) {
            case START: {
                this.addPlugin(pluginEvent.getPlugin());
                break;
            }
            case STOP: {
                this.removePlugin(pluginEvent.getPlugin());
            }
        }
    }

    public void setSelectedOption(Plugin plugin) {
        if (plugin.getStaticOptions() != null) {
            this.pages.enqueAction((Enum)Workbench.WorkbenchAction.SETSELECTEDTAB, new Object[]{plugin.getStaticOptions()});
        }
        if (plugin.getRegularOptions() != null) {
            this.pages.enqueAction((Enum)Workbench.WorkbenchAction.SETSELECTEDTAB, new Object[]{plugin.getRegularOptions()});
        }
    }

    public void setShowStatus(boolean bl) {
    }

    public boolean isShowStatus() {
        return true;
    }
}

