/*
 * Decompiled with CFR 0.152.
 */
package ds.plugin.peer;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.plugin.peer.PeerTag;
import ddb.dsz.plugin.peer.PeerTransferStatus;
import ddb.util.ClientSocketHandler;
import ds.jaxb.external.ObjectFactory;
import ds.jaxb.external.RemoteIdentification;
import ds.jaxb.external.RemoteMessage;
import ds.jaxb.external.RemotePing;
import ds.jaxb.external.RemotePong;
import ds.plugin.peer.Peer;
import java.net.Socket;
import java.util.logging.Level;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.ClosureUtils;

public class PeerSocketHandler
extends ClientSocketHandler
implements Closure,
PeerTag {
    Peer peer;
    CoreController core;
    ObjectFactory of = new ObjectFactory();
    String peerName;
    boolean sentPause;

    public PeerSocketHandler(CoreController coreController, Socket socket, Peer peer) throws JAXBException {
        super(coreController, socket, ObjectFactory.class, ClosureUtils.nopClosure());
        this.core = coreController;
        super.setClosure(this);
        this.peer = peer;
        this.peerName = "Unknown";
    }

    public String getName() {
        return "PeerSocketHandler";
    }

    public void begin(String string) {
        super.start();
        RemoteIdentification remoteIdentification = new RemoteIdentification();
        remoteIdentification.setValue(string);
        super.publish(this.of.createRemoteIdentification(remoteIdentification));
    }

    public String getPeerName() {
        return this.peerName;
    }

    public String toString() {
        return String.format("%s (%s)", this.peerName, super.getSocket().getInetAddress().getHostAddress());
    }

    public void execute(Object object) {
        try {
            if (object instanceof JAXBElement) {
                object = ((JAXBElement)JAXBElement.class.cast(object)).getValue();
            }
            if (object instanceof RemoteMessage) {
                this.peer.receivedMessage((RemoteMessage)RemoteMessage.class.cast(object), this);
            }
            if (object instanceof RemotePing) {
                this.sendPong();
            }
            if (object instanceof RemoteIdentification) {
                this.peerName = ((RemoteIdentification)RemoteIdentification.class.cast(object)).getValue();
                this.peer.connectionUpdated(this);
            }
        }
        catch (Exception exception) {
            this.core.logEvent(Level.SEVERE, exception.getMessage(), (Throwable)exception);
        }
    }

    public PeerTransferStatus sendMessage(String string) {
        this.core.logEvent(Level.FINEST, "PeerSocketHandler", string);
        try {
            RemoteMessage remoteMessage = new RemoteMessage();
            remoteMessage.setMessage(string);
            super.publish(this.of.createRemoteMessage(remoteMessage));
            return PeerTransferStatus.SENT;
        }
        catch (Exception exception) {
            this.core.logEvent(Level.SEVERE, exception.getMessage(), (Throwable)exception);
            return PeerTransferStatus.DISCONNECTED;
        }
    }

    public PeerTransferStatus sendPing() {
        if (this.isConnected()) {
            this.publish(this.of.createRemotePing(new RemotePing()));
            return PeerTransferStatus.SENT;
        }
        return PeerTransferStatus.DISCONNECTED;
    }

    public PeerTransferStatus sendPong() {
        if (this.isConnected()) {
            this.publish(this.of.createRemotePong(new RemotePong()));
            return PeerTransferStatus.SENT;
        }
        return PeerTransferStatus.DISCONNECTED;
    }

    public void stop() {
        this.peer.connectionStopping(this);
        super.stop();
    }

    public int compareTo(PeerTag peerTag) {
        if (peerTag == null) {
            return -1;
        }
        return String.CASE_INSENSITIVE_ORDER.compare(this.peerName, peerTag.getPeerName());
    }
}

