/*
 * Decompiled with CFR 0.152.
 */
package ds.plugin.pluginmanagement;

import ddb.detach.Alignment;
import ddb.detach.Tabbable;
import ddb.detach.Workbench;
import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszDetachable;
import ddb.dsz.annotations.DszHideable;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.annotations.DszUserStartable;
import ddb.dsz.plugin.AbstractPlugin;
import ddb.dsz.plugin.Plugin;
import ddb.imagemanager.ImageManager;
import ddb.listeners.DoubleClickListener;
import ds.core.DSConstants;
import ds.gui.PluginWorkbench;
import ds.plugin.PluginContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

@DszLive(live=false, replay=false)
@DszLogo(value="images/plugin_manager.png")
@DszName(value="Running Plugins")
@DszDescription(value="List of currently running plugins")
@DszUserStartable(value=false)
@DszHideable(hide=false, unhide=false)
@DszDetachable(value=false)
public class PluginManager
extends AbstractPlugin {
    PluginWorkbench pluginWorkbench;
    private JPanel mainFrame;
    DefaultTreeModel runningModel;
    JTree runningPlugins;
    PluginTreeNode root;
    private JLabel messageLabel;
    private ImageIcon errorIcon;
    Dimension imageToUse;

    public PluginManager() {
        super.setVerifyClose(false);
    }

    public void setWorkbench(PluginWorkbench pluginWorkbench) {
        super.setWorkbench((Workbench)pluginWorkbench);
        this.pluginWorkbench = pluginWorkbench;
    }

    protected int init2() {
        this.mainFrame = new JPanel();
        super.setDisplay((JComponent)this.mainFrame);
        this.imageToUse = ImageManager.SIZE32;
        this.mainFrame.setLayout(new BorderLayout());
        this.root = new PluginTreeNode(this.pluginWorkbench, null);
        this.runningModel = new DefaultTreeModel(this.root);
        this.runningModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                TreePath treePath = treeModelEvent.getTreePath();
                PluginTreeNode pluginTreeNode = (PluginTreeNode)treePath.getLastPathComponent();
                TreePath treePath2 = treePath.pathByAddingChild(pluginTreeNode.getChildAt(treeModelEvent.getChildIndices()[0]));
                PluginManager.this.runningPlugins.expandPath(treePath2);
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
        this.runningPlugins = new JTree(this.runningModel);
        this.runningPlugins.setRootVisible(false);
        this.runningPlugins.setCellRenderer(new PluginTreeCellRenderer());
        this.runningPlugins.setRowHeight(this.imageToUse.height);
        this.runningPlugins.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                throw new ExpandVetoException(treeExpansionEvent);
            }
        });
        this.expandPath(this.root);
        this.mainFrame.add(new JScrollPane(this.runningPlugins));
        this.messageLabel = new JLabel();
        this.mainFrame.add((Component)this.messageLabel, "South");
        this.errorIcon = ImageManager.getIcon((String)DSConstants.Icon.ERROR.getPath(), (Dimension)ImageManager.SIZE16);
        final JPopupMenu jPopupMenu = new JPopupMenu();
        final JMenuItem jMenuItem = new JMenuItem("Tabbify plugin");
        jPopupMenu.add(jMenuItem);
        final JMenuItem jMenuItem2 = new JMenuItem("Hide plugin");
        jPopupMenu.add(jMenuItem2);
        final JMenuItem jMenuItem3 = new JMenuItem("Unhide plugin");
        jPopupMenu.add(jMenuItem3);
        final JMenuItem jMenuItem4 = new JMenuItem("Detach plugin");
        jPopupMenu.add(jMenuItem4);
        final JMenuItem jMenuItem5 = new JMenuItem("Shutdown plugin");
        jPopupMenu.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("Rename plugin");
        jPopupMenu.add(jMenuItem6);
        final JMenuItem jMenuItem7 = new JMenuItem("Duplicate plugin");
        jPopupMenu.add(jMenuItem7);
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                TreePath[] treePathArray = PluginManager.this.runningPlugins.getSelectionPaths();
                if (treePathArray == null) {
                    return;
                }
                for (int i = 0; i < treePathArray.length; ++i) {
                    TreePath treePath = treePathArray[i];
                    PluginTreeNode pluginTreeNode = (PluginTreeNode)treePath.getLastPathComponent();
                    Plugin plugin = pluginTreeNode.getPlugin();
                    jMenuItem.setEnabled(pluginTreeNode.getWorkbench().pluginIsDetached((Tabbable)plugin));
                    jMenuItem4.setEnabled(!pluginTreeNode.getWorkbench().pluginIsDetached((Tabbable)plugin));
                    if (!plugin.isDetachable()) {
                        jMenuItem4.setEnabled(false);
                    }
                    jMenuItem2.setEnabled(plugin.isHideable() && pluginTreeNode.getWorkbench().pluginIsVisible(plugin));
                    jMenuItem3.setEnabled(plugin.isUnhideable() && pluginTreeNode.getWorkbench().pluginIsHidden(plugin));
                    jMenuItem5.setEnabled(plugin.isClosable());
                    jMenuItem7.setEnabled(PluginManager.this.pluginWorkbench.allowNewInstance(plugin.getClass()));
                }
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        jMenuItem.addActionListener(new MenuAction(){

            protected Workbench.WorkbenchAction getWorkbenchAction() {
                return Workbench.WorkbenchAction.TABBIFYTAB;
            }

            protected Object[] getParams() {
                return new Object[0];
            }
        });
        jMenuItem2.addActionListener(new MenuAction(){

            protected Workbench.WorkbenchAction getWorkbenchAction() {
                return Workbench.WorkbenchAction.HIDETAB;
            }

            protected Object[] getParams() {
                return new Object[0];
            }
        });
        jMenuItem3.addActionListener(new MenuAction(){

            protected Workbench.WorkbenchAction getWorkbenchAction() {
                return Workbench.WorkbenchAction.UNHIDETAB;
            }

            protected Object[] getParams() {
                return new Object[0];
            }
        });
        jMenuItem4.addActionListener(new MenuAction(){

            protected Workbench.WorkbenchAction getWorkbenchAction() {
                return Workbench.WorkbenchAction.DETACHTAB;
            }

            protected Object[] getParams() {
                return new Object[]{null, null};
            }
        });
        jMenuItem5.addActionListener(new MenuAction(){

            protected boolean veto(Plugin plugin) {
                return !plugin.isClosable();
            }

            protected PluginWorkbench.PluginWorkbenchAction getPluginWorkbenchAction() {
                return PluginWorkbench.PluginWorkbenchAction.STOPPLUGIN;
            }

            protected Object[] getParams() {
                return new Object[0];
            }
        });
        jMenuItem6.addActionListener(new MenuAction(){

            protected Workbench.WorkbenchAction getWorkbenchAction() {
                return Workbench.WorkbenchAction.RENAMETAB;
            }

            protected Object[] getParams() {
                return new Object[]{JOptionPane.showInputDialog(PluginManager.this.parentDisplay, "Enter new plugin name", "Rename", 3)};
            }
        });
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray = PluginManager.this.runningPlugins.getSelectionPaths();
                if (treePathArray == null) {
                    return;
                }
                for (int i = 0; i < treePathArray.length; ++i) {
                    Plugin plugin;
                    TreePath treePath = treePathArray[i];
                    PluginTreeNode pluginTreeNode = (PluginTreeNode)treePath.getLastPathComponent();
                    Plugin plugin2 = pluginTreeNode.getPlugin();
                    PluginWorkbench pluginWorkbench = pluginTreeNode.getWorkbench();
                    Class<?> clazz = plugin2.getClass();
                    Alignment alignment = plugin2.getAlignment();
                    try {
                        plugin = pluginWorkbench.startPlugin(clazz, null, null, alignment, null);
                    }
                    catch (Exception exception) {
                        PluginManager.this.showErrorMessage(exception.getMessage());
                        continue;
                    }
                    if (plugin == null) {
                        PluginManager.this.showErrorMessage("Failed to load plugin of class " + clazz);
                        continue;
                    }
                    PluginManager.this.clearMessageLabel();
                }
            }
        });
        this.runningPlugins.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    int n = PluginManager.this.runningPlugins.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n >= 0) {
                        PluginManager.this.runningPlugins.setSelectionRow(n);
                    }
                    jPopupMenu.show(PluginManager.this.runningPlugins, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.runningPlugins.addMouseListener((MouseListener)new DoubleClickListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginManager.this.focusOnPath(PluginManager.this.runningPlugins.getSelectionPath());
                PluginManager.this.clearMessageLabel();
            }
        }));
        return 0;
    }

    void focusOnPath(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        if (treePath.getPathCount() == 0) {
            return;
        }
        PluginTreeNode pluginTreeNode = (PluginTreeNode)treePath.getLastPathComponent();
        if (pluginTreeNode == null) {
            return;
        }
        Plugin plugin = pluginTreeNode.getPlugin();
        PluginWorkbench pluginWorkbench = pluginTreeNode.getWorkbench();
        if (plugin == null || pluginWorkbench == null) {
            return;
        }
        pluginWorkbench.enqueAction((Enum)Workbench.WorkbenchAction.UNHIDETAB, new Object[]{plugin});
        pluginWorkbench.enqueAction((Enum)Workbench.WorkbenchAction.SETSELECTEDTAB, new Object[]{plugin});
        this.focusOnPath(treePath.getParentPath());
    }

    private void expandPath(TreeNode treeNode) {
        this.runningPlugins.expandPath(new TreePath(this.runningModel.getPathToRoot(treeNode)));
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            this.expandPath(treeNode.getChildAt(i));
        }
    }

    public void showErrorMessage(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.messageLabel.setText(string);
            this.messageLabel.setIcon(this.errorIcon);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    PluginManager.this.showErrorMessage(string);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void clearMessageLabel() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.messageLabel.setText("");
            this.messageLabel.setIcon(null);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    PluginManager.this.clearMessageLabel();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setWorkbench(Workbench workbench) {
        super.setWorkbench(workbench);
        if (workbench instanceof PluginWorkbench) {
            this.pluginWorkbench = ((PluginWorkbench)PluginWorkbench.class.cast(workbench)).getHighestWorkbench();
            this.root.setModel(this.pluginWorkbench);
        }
    }

    private abstract class MenuAction
    implements ActionListener {
        private MenuAction() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray = PluginManager.this.runningPlugins.getSelectionPaths();
            if (treePathArray == null) {
                return;
            }
            for (int i = 0; i < treePathArray.length; ++i) {
                TreePath treePath = treePathArray[i];
                PluginTreeNode pluginTreeNode = (PluginTreeNode)treePath.getLastPathComponent();
                Plugin plugin = pluginTreeNode.getPlugin();
                PluginWorkbench pluginWorkbench = pluginTreeNode.getWorkbench();
                if (this.veto(plugin)) continue;
                if (this.getPluginWorkbenchAction() != null) {
                    pluginWorkbench.enqueAction(this.getPluginWorkbenchAction(), this.addParams(plugin, this.getParams()));
                }
                if (this.getWorkbenchAction() != null) {
                    pluginWorkbench.enqueAction((Enum)this.getWorkbenchAction(), this.addParams(plugin, this.getParams()));
                }
                PluginManager.this.clearMessageLabel();
            }
        }

        private final Object[] addParams(Object object, Object[] objectArray) {
            Object[] objectArray2 = new Object[objectArray.length + 1];
            objectArray2[0] = object;
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i + 1] = objectArray[i];
            }
            return objectArray2;
        }

        protected boolean veto(Plugin plugin) {
            return false;
        }

        protected PluginWorkbench.PluginWorkbenchAction getPluginWorkbenchAction() {
            return null;
        }

        protected Workbench.WorkbenchAction getWorkbenchAction() {
            return null;
        }

        protected abstract Object[] getParams();
    }

    private class PluginTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        private PluginTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (component instanceof JLabel && object instanceof PluginTreeNode) {
                JLabel jLabel = (JLabel)component;
                Plugin plugin = ((PluginTreeNode)object).getPlugin();
                if (plugin != null) {
                    jLabel.setText(plugin.getName());
                    jLabel.setIcon(ImageManager.getIcon((String)plugin.getLogo(), (Dimension)PluginManager.this.imageToUse));
                }
            }
            return component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PluginTreeNode
    implements TreeNode,
    ListDataListener {
        PluginTreeNode parent1;
        PluginWorkbench bench;
        ListModel model = null;
        Plugin plugin = null;
        Vector<PluginTreeNode> children = null;

        public Plugin getPlugin() {
            return this.plugin;
        }

        public PluginWorkbench getWorkbench() {
            return this.bench;
        }

        PluginTreeNode(PluginWorkbench pluginWorkbench, PluginTreeNode pluginTreeNode) {
            this.children = new Vector();
            this.parent1 = pluginTreeNode;
            this.bench = pluginWorkbench;
            this.setModel(pluginWorkbench);
        }

        PluginTreeNode(Plugin plugin, PluginWorkbench pluginWorkbench, PluginTreeNode pluginTreeNode) {
            this.plugin = plugin;
            this.parent1 = pluginTreeNode;
            this.children = new Vector();
            if (plugin instanceof PluginContainer) {
                PluginContainer pluginContainer = (PluginContainer)plugin;
                this.setModel(pluginContainer.getChildWorkbench());
            }
            this.bench = pluginWorkbench;
        }

        void setModel(PluginWorkbench pluginWorkbench) {
            if (pluginWorkbench == null) {
                return;
            }
            this.bench = pluginWorkbench;
            if (this.model != null) {
                this.model.removeListDataListener(this);
            }
            this.model = pluginWorkbench.getChildPlugins();
            if (this.model != null) {
                this.model.addListDataListener(this);
                this.addAll();
            }
        }

        private void addAll() {
            for (int i = 0; i < this.model.getSize(); ++i) {
                PluginContainer pluginContainer = (PluginContainer)this.plugin;
                PluginWorkbench pluginWorkbench = this.bench;
                if (pluginContainer != null) {
                    pluginWorkbench = pluginContainer.getChildWorkbench();
                }
                this.children.add(new PluginTreeNode((Plugin)this.model.getElementAt(i), pluginWorkbench, this));
                if (PluginManager.this.runningModel == null) continue;
                PluginManager.this.runningModel.nodesWereInserted(this, new int[]{i});
            }
        }

        @Override
        public TreeNode getChildAt(int n) {
            return this.children.get(n);
        }

        @Override
        public int getChildCount() {
            return this.children.size();
        }

        @Override
        public TreeNode getParent() {
            return this.parent1;
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            return this.children.indexOf(treeNode);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return this.children.size() == 0;
        }

        public Enumeration<?> children() {
            return this.children.elements();
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                PluginContainer pluginContainer = (PluginContainer)this.plugin;
                PluginWorkbench pluginWorkbench = PluginManager.this.pluginWorkbench;
                if (pluginContainer != null) {
                    pluginWorkbench = pluginContainer.getChildWorkbench();
                }
                this.children.add(i, new PluginTreeNode((Plugin)this.model.getElementAt(i), pluginWorkbench, this));
                if (PluginManager.this.runningModel == null) continue;
                PluginManager.this.runningModel.nodesWereInserted(this, new int[]{i});
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            for (int i = listDataEvent.getIndex1(); i >= listDataEvent.getIndex0(); --i) {
                PluginTreeNode pluginTreeNode = this.children.remove(i);
                if (PluginManager.this.runningModel == null) continue;
                PluginManager.this.runningModel.nodesWereRemoved(this, new int[]{i}, new Object[]{pluginTreeNode});
            }
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            this.intervalRemoved(listDataEvent);
            this.intervalAdded(listDataEvent);
        }
    }
}

